/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.editors;

import com.intellij.codeWithMe.ClientId;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.CoroutinesKt;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.components.ServicesKt;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.rd.LifetimeDisposableExKt;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.platform.backend.workspace.WorkspaceModel;
import com.intellij.platform.backend.workspace.WorkspaceModelChangeListener;
import com.intellij.platform.workspace.storage.EntityChange;
import com.intellij.platform.workspace.storage.VersionedStorageChange;
import com.intellij.util.concurrency.ThreadingAssertions;
import com.intellij.util.concurrency.annotations.RequiresEdt;
import com.intellij.util.ui.update.MergingUpdateQueue;
import com.intellij.util.ui.update.Update;
import com.jetbrains.rd.ide.editor.EditorSynchronizer;
import com.jetbrains.rd.ide.model.RdDocumentId;
import com.jetbrains.rd.util.lifetime.Lifetime;
import com.jetbrains.rd.util.reactive.ISource;
import com.jetbrains.rd.util.reactive.Property;
import com.jetbrains.rd.util.reactive.SourceExKt;
import com.jetbrains.rdclient.document.DocumentExKt;
import com.jetbrains.rdclient.editors.FrontendTextControlHost;
import com.jetbrains.rdclient.util.idea.LifetimedProjectComponent;
import com.jetbrains.rider.document.RiderDocumentBindingService;
import com.jetbrains.rider.editors.EditorsSynchronizerKt;
import com.jetbrains.rider.model.RdFrontendDocumentId;
import com.jetbrains.rider.projectView.workspace.ProjectModelEntity;
import com.jetbrains.rider.projectView.workspace.ProjectModelEntityExtensionsKt;
import com.jetbrains.rider.projectView.workspace.WorkspaceModelExtensionsKt;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.Dispatchers;
import org.jetbrains.annotations.NotNull;

@Service(value={Service.Level.PROJECT})
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0007\u0018\u00002\u00020\u0001:\u0001\u0018B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\r\u001a\u00020\u000eH\u0002J\u0014\u0010\u000f\u001a\u00020\u000e2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u000e0\u0011J\b\u0010\u0012\u001a\u00020\u000eH\u0003J\u0018\u0010\u0013\u001a\u00020\u000e2\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0017H\u0002R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lcom/jetbrains/rider/editors/EditorsSynchronizer;", "Lcom/jetbrains/rdclient/util/idea/LifetimedProjectComponent;", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/openapi/project/Project;)V", "disposable", "Lcom/intellij/openapi/Disposable;", "syncWithProjectModelQueue", "Lcom/intellij/util/ui/update/MergingUpdateQueue;", "isProjectModelUpdated", "Lcom/jetbrains/rd/util/reactive/Property;", "", "queueReloadModelEditors", "", "runAfterProjectModelSync", "block", "Lkotlin/Function0;", "syncWithProjectModel", "syncWithProjectModelForNewBinding", "documentId", "Lcom/jetbrains/rider/model/RdFrontendDocumentId;", "virtualFile", "Lcom/intellij/openapi/vfs/VirtualFile;", "WorkspaceModelEventsListener", "intellij.rider.rdclient.dotnet"})
@SourceDebugExtension(value={"SMAP\nEditorsSynchronizer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 EditorsSynchronizer.kt\ncom/jetbrains/rider/editors/EditorsSynchronizer\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 5 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n*L\n1#1,183:1\n1#2:184\n1#2:199\n67#3,4:185\n67#3,4:216\n1617#4,9:189\n1869#4:198\n1870#4:200\n1626#4:201\n1504#4:202\n1534#4,3:203\n1537#4,3:213\n1563#4:220\n1634#4,3:221\n1761#4,3:224\n382#5,7:206\n*S KotlinDebug\n*F\n+ 1 EditorsSynchronizer.kt\ncom/jetbrains/rider/editors/EditorsSynchronizer\n*L\n104#1:199\n65#1:185,4\n107#1:216,4\n104#1:189,9\n104#1:198\n104#1:200\n104#1:201\n106#1:202\n106#1:203,3\n106#1:213,3\n112#1:220\n112#1:221,3\n136#1:224,3\n106#1:206,7\n*E\n"})
public final class EditorsSynchronizer
extends LifetimedProjectComponent {
    @NotNull
    private final Disposable disposable;
    @NotNull
    private final MergingUpdateQueue syncWithProjectModelQueue;
    @NotNull
    private final Property<Boolean> isProjectModelUpdated;

    /*
     * WARNING - void declaration
     */
    public EditorsSynchronizer(@NotNull Project project) {
        void $this$syncWithProjectModelQueue_u24lambda_u240;
        MergingUpdateQueue mergingUpdateQueue;
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        super(project);
        this.disposable = LifetimeDisposableExKt.createNestedDisposable$default((Lifetime)((Lifetime)this.getComponentLifetime()), null, (int)1, null);
        MergingUpdateQueue mergingUpdateQueue2 = mergingUpdateQueue = new MergingUpdateQueue("syncEditorsQueue", 1000, true, MergingUpdateQueue.ANY_COMPONENT, this.disposable, null, true).setRestartTimerOnAdd(false);
        EditorsSynchronizer editorsSynchronizer = this;
        boolean bl = false;
        $this$syncWithProjectModelQueue_u24lambda_u240.setPassThrough(false);
        editorsSynchronizer.syncWithProjectModelQueue = mergingUpdateQueue;
        this.isProjectModelUpdated = new Property((Object)true);
    }

    private final void queueReloadModelEditors() {
        Logger $this$trace$iv = EditorsSynchronizerKt.getLogger();
        boolean $i$f$trace = false;
        if ($this$trace$iv.isTraceEnabled()) {
            Logger logger = $this$trace$iv;
            boolean bl = false;
            logger.trace("queueReloadModelEditors under " + ClientId.Companion.getCurrent());
        }
        this.isProjectModelUpdated.set((Object)false);
        this.syncWithProjectModelQueue.queue(new Update(this){
            final /* synthetic */ EditorsSynchronizer this$0;
            {
                this.this$0 = $receiver;
                super((Object)"QueueSyncEditors", false, 0, 6, null);
            }

            public void run() {
                CommandProcessor commandProcessor = CommandProcessor.getInstance();
                if (commandProcessor.isCommandInProgress()) {
                    EditorsSynchronizerKt.getLogger().trace("we are currently under command " + commandProcessor.getCurrentCommandName() + " so postpone the sync");
                    EditorsSynchronizer.access$isProjectModelUpdated$p(this.this$0).set((Object)true);
                    EditorsSynchronizer.access$queueReloadModelEditors(this.this$0);
                    return;
                }
                Logger $this$trace$iv = EditorsSynchronizerKt.getLogger();
                boolean $i$f$trace = false;
                if ($this$trace$iv.isTraceEnabled()) {
                    Logger logger = $this$trace$iv;
                    boolean bl = false;
                    logger.trace("Calling syncWithProjectModel under " + ClientId.Companion.getCurrent());
                }
                EditorsSynchronizer.access$syncWithProjectModel(this.this$0);
            }
        });
    }

    public final void runAfterProjectModelSync(@NotNull Function0<Unit> block) {
        Intrinsics.checkNotNullParameter(block, (String)"block");
        if (((Boolean)this.isProjectModelUpdated.getValue()).booleanValue()) {
            EditorsSynchronizerKt.getLogger().trace("Execute block right away");
            block.invoke();
            return;
        }
        EditorsSynchronizerKt.getLogger().trace("PM in sync. Postpone block execution.");
        SourceExKt.adviseUntil((ISource)this.isProjectModelUpdated.getChange(), (Lifetime)((Lifetime)this.getComponentLifetime()), arg_0 -> EditorsSynchronizer.runAfterProjectModelSync$lambda$0(block, arg_0));
    }

    /*
     * WARNING - void declaration
     */
    @RequiresEdt
    private final void syncWithProjectModel() {
        Iterable it;
        Object object;
        Object value$iv$iv$iv;
        void $this$groupByTo$iv$iv;
        Iterable $this$mapNotNullTo$iv$iv;
        EditorsSynchronizerKt.getLogger().trace("start syncing model editors...");
        FrontendTextControlHost textControlHost = FrontendTextControlHost.Companion.getInstance(this.getProject());
        Iterable $this$mapNotNull$iv = textControlHost.getEditors();
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Object destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        Iterator $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator2 = $this$forEach$iv$iv$iv.iterator();
        while (iterator2.hasNext()) {
            EditorSynchronizer it$iv$iv;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator2.next();
            boolean bl = false;
            Editor it2 = (Editor)element$iv$iv;
            boolean bl2 = false;
            if (DocumentExKt.getEditorSynchronizer(it2) == null) continue;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        Iterable $this$groupBy$iv = CollectionsKt.toList((Iterable)((List)destination$iv$iv));
        boolean $i$f$groupBy = false;
        $this$mapNotNullTo$iv$iv = $this$groupBy$iv;
        destination$iv$iv = new LinkedHashMap();
        boolean $i$f$groupByTo = false;
        for (Object element$iv$iv : $this$groupByTo$iv$iv) {
            Object object2;
            void $this$getOrPut$iv$iv$iv;
            EditorSynchronizer it3 = (EditorSynchronizer)element$iv$iv;
            boolean $i$a$-groupBy-EditorsSynchronizer$syncWithProjectModel$openedEditorsByDocument$42 = false;
            RdDocumentId key$iv$iv = it3.getTextControlId().getDocumentId();
            Object bl = destination$iv$iv;
            RdDocumentId key$iv$iv$iv = key$iv$iv;
            boolean $i$f$getOrPut = false;
            value$iv$iv$iv = $this$getOrPut$iv$iv$iv.get(key$iv$iv$iv);
            if (value$iv$iv$iv == null) {
                boolean bl4 = false;
                List answer$iv$iv$iv = new ArrayList();
                $this$getOrPut$iv$iv$iv.put(key$iv$iv$iv, answer$iv$iv$iv);
                object2 = answer$iv$iv$iv;
            } else {
                object2 = value$iv$iv$iv;
            }
            List list$iv$iv = (List)object2;
            EditorSynchronizer $i$a$-groupBy-EditorsSynchronizer$syncWithProjectModel$openedEditorsByDocument$42 = (EditorSynchronizer)element$iv$iv;
            object = list$iv$iv;
            boolean bl5 = false;
            object.add(it.getEditor());
        }
        Object openedEditorsByDocument = destination$iv$iv;
        Logger $this$trace$iv = EditorsSynchronizerKt.getLogger();
        boolean $i$f$trace = false;
        if ($this$trace$iv.isTraceEnabled()) {
            object = $this$trace$iv;
            boolean bl = false;
            int totalEditors = FileEditorManager.getInstance((Project)this.getProject()).getAllEditors().length;
            object.trace("All open editors count: " + totalEditors + ", opened backend editors: " + openedEditorsByDocument.size());
        }
        for (Map.Entry entry2 : openedEditorsByDocument.entrySet()) {
            VirtualFile virtualFile;
            Document document;
            void $this$mapTo$iv$iv;
            RdDocumentId documentId = (RdDocumentId)entry2.getKey();
            List ideaEditors = (List)entry2.getValue();
            Iterable $this$map$iv = ideaEditors;
            boolean $i$f$map = false;
            it = $this$map$iv;
            Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it4;
                value$iv$iv$iv = (Editor)item$iv$iv;
                object = destination$iv$iv2;
                boolean bl = false;
                object.add(it4.getDocument());
            }
            if ((Document)CollectionsKt.singleOrNull((List)CollectionsKt.distinct((Iterable)((List)destination$iv$iv2))) == null || FileDocumentManager.getInstance().getFile(document) == null || !(documentId instanceof RdFrontendDocumentId)) continue;
            this.syncWithProjectModelForNewBinding((RdFrontendDocumentId)documentId, virtualFile);
        }
        EditorsSynchronizerKt.getLogger().trace("Syncing model editors has been finished");
        this.isProjectModelUpdated.set((Object)true);
    }

    /*
     * Unable to fully structure code
     */
    private final void syncWithProjectModelForNewBinding(RdFrontendDocumentId documentId, VirtualFile virtualFile) {
        block7: {
            upToDateEntities = WorkspaceModelExtensionsKt.getProjectModelEntities(WorkspaceModel.Companion.getInstance(this.getProject()), virtualFile, this.getProject());
            if (upToDateEntities.isEmpty()) {
                EditorsSynchronizerKt.getLogger().trace("Can't find project model entity for " + virtualFile + ", documentId: " + documentId);
                return;
            }
            riderDocumentIdFactory = RiderDocumentBindingService.Companion.getInstance(this.getProject());
            oldProjectModelId = riderDocumentIdFactory.getProjectModelId(documentId);
            if (oldProjectModelId == null || oldProjectModelId <= 0) ** GOTO lbl-1000
            $this$any$iv = upToDateEntities;
            $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                v0 = false;
            } else {
                for (T element$iv : $this$any$iv) {
                    it = (ProjectModelEntity)element$iv;
                    $i$a$-any-EditorsSynchronizer$syncWithProjectModelForNewBinding$actualProjectModelId$1 = false;
                    v1 = ProjectModelEntityExtensionsKt.getId(it, this.getProject());
                    var13_12 = oldProjectModelId;
                    if (!(v1 != null && v1 == var13_12)) continue;
                    v0 = true;
                    break block7;
                }
                v0 = false;
            }
        }
        if (v0) {
            v2 = oldProjectModelId;
        } else lbl-1000:
        // 2 sources

        {
            v2 = actualProjectModelId = Integer.valueOf(com.jetbrains.rider.document.DocumentExKt.findBestProjectModelIdForDocument(upToDateEntities, this.getProject()));
        }
        if (actualProjectModelId == 0) {
            actualProjectModelId = null;
        }
        v3 = virtualFile.getPath();
        Intrinsics.checkNotNullExpressionValue((Object)v3, (String)"getPath(...)");
        riderDocumentIdFactory.updatePath(documentId, v3);
        riderDocumentIdFactory.updateProjectModelId(documentId, actualProjectModelId);
    }

    private static final boolean runAfterProjectModelSync$lambda$0(Function0 $block, boolean isUpdated) {
        if (!isUpdated) {
            return false;
        }
        ThreadingAssertions.assertEventDispatchThread();
        $block.invoke();
        return true;
    }

    public static final /* synthetic */ Property access$isProjectModelUpdated$p(EditorsSynchronizer $this) {
        return $this.isProjectModelUpdated;
    }

    public static final /* synthetic */ void access$syncWithProjectModel(EditorsSynchronizer $this) {
        $this.syncWithProjectModel();
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0010"}, d2={"Lcom/jetbrains/rider/editors/EditorsSynchronizer$WorkspaceModelEventsListener;", "Lcom/intellij/platform/backend/workspace/WorkspaceModelChangeListener;", "project", "Lcom/intellij/openapi/project/Project;", "cs", "Lkotlinx/coroutines/CoroutineScope;", "<init>", "(Lcom/intellij/openapi/project/Project;Lkotlinx/coroutines/CoroutineScope;)V", "getProject", "()Lcom/intellij/openapi/project/Project;", "getCs", "()Lkotlinx/coroutines/CoroutineScope;", "changed", "", "event", "Lcom/intellij/platform/workspace/storage/VersionedStorageChange;", "intellij.rider.rdclient.dotnet"})
    @SourceDebugExtension(value={"SMAP\nEditorsSynchronizer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 EditorsSynchronizer.kt\ncom/jetbrains/rider/editors/EditorsSynchronizer$WorkspaceModelEventsListener\n+ 2 services.kt\ncom/intellij/openapi/components/ServicesKt\n*L\n1#1,183:1\n30#2,2:184\n*S KotlinDebug\n*F\n+ 1 EditorsSynchronizer.kt\ncom/jetbrains/rider/editors/EditorsSynchronizer$WorkspaceModelEventsListener\n*L\n179#1:184,2\n*E\n"})
    public static final class WorkspaceModelEventsListener
    implements WorkspaceModelChangeListener {
        @NotNull
        private final Project project;
        @NotNull
        private final CoroutineScope cs;

        public WorkspaceModelEventsListener(@NotNull Project project, @NotNull CoroutineScope cs) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter((Object)cs, (String)"cs");
            this.project = project;
            this.cs = cs;
        }

        @NotNull
        public final Project getProject() {
            return this.project;
        }

        @NotNull
        public final CoroutineScope getCs() {
            return this.cs;
        }

        public void changed(@NotNull VersionedStorageChange event) {
            Intrinsics.checkNotNullParameter((Object)event, (String)"event");
            List changes = event.getChanges(ProjectModelEntity.class);
            if (changes.isEmpty()) {
                return;
            }
            if (Registry.Companion.is("rider.filter.rebind.triggers.enabled")) {
                BuildersKt.launch$default((CoroutineScope)this.cs, (CoroutineContext)((CoroutineContext)Dispatchers.getDefault()), null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>((List<? extends EntityChange<ProjectModelEntity>>)changes, this, null){
                    int I$0;
                    int label;
                    final /* synthetic */ List<EntityChange<ProjectModelEntity>> $changes;
                    final /* synthetic */ WorkspaceModelEventsListener this$0;
                    {
                        this.$changes = $changes;
                        this.this$0 = $receiver;
                        super(2, $completion);
                    }

                    /*
                     * WARNING - void declaration
                     * Enabled force condition propagation
                     * Lifted jumps to return sites
                     */
                    public final Object invokeSuspend(Object $result) {
                        Object object = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                        switch (this.label) {
                            case 0: {
                                void $this$trace$iv;
                                ResultKt.throwOnFailure((Object)$result);
                                int shouldReloadModelEditors = 0;
                                for (EntityChange<ProjectModelEntity> change : this.$changes) {
                                    if (!EditorsSynchronizerKt.access$isPotentialDocumentRebindTrigger(change)) continue;
                                    shouldReloadModelEditors = 1;
                                    break;
                                }
                                if (shouldReloadModelEditors == 0) return Unit.INSTANCE;
                                Logger logger = EditorsSynchronizerKt.getLogger();
                                List<EntityChange<ProjectModelEntity>> list2 = this.$changes;
                                boolean $i$f$trace = false;
                                if ($this$trace$iv.isTraceEnabled()) {
                                    StringBuilder stringBuilder;
                                    void var14_8 = $this$trace$iv;
                                    boolean bl = false;
                                    StringBuilder $this$invokeSuspend_u24lambda_u240_u240 = stringBuilder = new StringBuilder();
                                    boolean bl2 = false;
                                    $this$invokeSuspend_u24lambda_u240_u240.append("Queueing reloading of bound documents due to " + list2.size() + " changes from WorkspaceModel").append('\n');
                                    Iterator<T> iterator2 = ((Iterable)list2).iterator();
                                    int n = 0;
                                    while (iterator2.hasNext()) {
                                        int idx = n++;
                                        EntityChange change = (EntityChange)iterator2.next();
                                        if (!EditorsSynchronizerKt.access$isPotentialDocumentRebindTrigger(change)) continue;
                                        ProjectModelEntity projectModelEntity = (ProjectModelEntity)change.getOldEntity();
                                        ProjectModelEntity projectModelEntity2 = (ProjectModelEntity)change.getNewEntity();
                                        $this$invokeSuspend_u24lambda_u240_u240.append("real non analyser non source generator change: " + (projectModelEntity != null ? projectModelEntity.getDescriptor() : null) + " -> " + (projectModelEntity2 != null ? projectModelEntity2.getDescriptor() : null));
                                        if (idx >= list2.size() - 1) continue;
                                        $this$invokeSuspend_u24lambda_u240_u240.append("\n");
                                    }
                                    var14_8.trace(stringBuilder.toString());
                                }
                                this.I$0 = shouldReloadModelEditors;
                                this.label = 1;
                                Object object2 = BuildersKt.withContext((CoroutineContext)CoroutinesKt.getEDT((Dispatchers)Dispatchers.INSTANCE), (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this.this$0, null){
                                    int label;
                                    final /* synthetic */ WorkspaceModelEventsListener this$0;
                                    {
                                        this.this$0 = $receiver;
                                        super(2, $completion);
                                    }

                                    public final Object invokeSuspend(Object $result) {
                                        IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                        switch (this.label) {
                                            case 0: {
                                                ResultKt.throwOnFailure((Object)$result);
                                                ComponentManager $this$service$iv = (ComponentManager)this.this$0.getProject();
                                                boolean $i$f$service = false;
                                                Class<EditorsSynchronizer> serviceClass$iv = EditorsSynchronizer.class;
                                                Object object = $this$service$iv.getService(serviceClass$iv);
                                                if (object == null) {
                                                    throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
                                                }
                                                EditorsSynchronizer.access$queueReloadModelEditors((EditorsSynchronizer)object);
                                                return Unit.INSTANCE;
                                            }
                                        }
                                        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                                    }

                                    public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                                        return (Continuation)new /* invalid duplicate definition of identical inner class */;
                                    }

                                    public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                                        return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                                    }
                                }), (Continuation)((Continuation)this));
                                if (object2 != object) return Unit.INSTANCE;
                                return object;
                            }
                            case 1: {
                                int shouldReloadModelEditors = this.I$0;
                                ResultKt.throwOnFailure((Object)$result);
                                Object object2 = $result;
                                return Unit.INSTANCE;
                            }
                        }
                        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                    }

                    public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                        return (Continuation)new /* invalid duplicate definition of identical inner class */;
                    }

                    public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                        return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                    }
                }), (int)2, null);
            } else {
                ComponentManager $this$service$iv = (ComponentManager)this.project;
                boolean $i$f$service = false;
                Class<EditorsSynchronizer> serviceClass$iv = EditorsSynchronizer.class;
                Object object = $this$service$iv.getService(serviceClass$iv);
                if (object == null) {
                    throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
                }
                ((EditorsSynchronizer)object).queueReloadModelEditors();
            }
        }
    }
}

