/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.editors;

import com.intellij.codeInsight.daemon.SyntheticPsiFileSupport;
import com.intellij.lang.Language;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.LanguageFileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.util.ThreeState;
import com.jetbrains.rd.ide.model.AbstractSandboxInfo;
import com.jetbrains.rd.ide.model.RdDocumentId;
import com.jetbrains.rd.ide.model.RdLanguage;
import com.jetbrains.rd.lang.ProtocolLanguageManagerKt;
import com.jetbrains.rdclient.document.DocumentExKt;
import com.jetbrains.rdclient.editors.FrontendTextControlBindingPolicy;
import com.jetbrains.rider.editors.PlatformTextControlUtilsKt;
import com.jetbrains.rider.editors.sandboxes.SandboxManager;
import com.jetbrains.rider.model.SandboxInfo;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\"\u0010\b\u001a\u0004\u0018\u00010\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J\u0012\u0010\u0010\u001a\u0004\u0018\u00010\t2\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J\u0012\u0010\u0013\u001a\u0004\u0018\u00010\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0002\u00a8\u0006\u0017"}, d2={"Lcom/jetbrains/rider/editors/DiffTextControlBindingPolicy;", "Lcom/jetbrains/rdclient/editors/FrontendTextControlBindingPolicy;", "<init>", "()V", "shouldBind", "Lcom/intellij/util/ThreeState;", "editor", "Lcom/intellij/openapi/editor/Editor;", "createSandboxForExistingOriginalFile", "Lcom/jetbrains/rider/model/SandboxInfo;", "originalFilePath", "", "document", "Lcom/intellij/openapi/editor/Document;", "project", "Lcom/intellij/openapi/project/Project;", "createGenericSandbox", "currentPsiFile", "Lcom/intellij/psi/PsiFile;", "toLanguage", "Lcom/jetbrains/rd/ide/model/RdLanguage;", "languageFileType", "Lcom/intellij/openapi/fileTypes/LanguageFileType;", "intellij.rider.rdclient.dotnet"})
public final class DiffTextControlBindingPolicy
implements FrontendTextControlBindingPolicy {
    @Override
    @NotNull
    public ThreeState shouldBind(@NotNull Editor editor) {
        SandboxInfo sandBoxInfo;
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Project project = editor.getProject();
        if (project == null) {
            return ThreeState.UNSURE;
        }
        Project project2 = project;
        PsiFile psiFile = PlatformTextControlUtilsKt.getPsiFile(editor);
        if (psiFile == null) {
            return ThreeState.UNSURE;
        }
        PsiFile psiFile2 = psiFile;
        if (!SyntheticPsiFileSupport.isOutsiderFile((PsiFile)psiFile2)) {
            return ThreeState.UNSURE;
        }
        String originalFilePath = SyntheticPsiFileSupport.getOriginalFilePath((VirtualFile)psiFile2.getVirtualFile());
        if (originalFilePath != null) {
            Document document = editor.getDocument();
            Intrinsics.checkNotNullExpressionValue((Object)document, (String)"getDocument(...)");
            v3 = this.createSandboxForExistingOriginalFile(originalFilePath, document, project2);
        } else {
            v3 = sandBoxInfo = this.createGenericSandbox(psiFile2);
        }
        if (sandBoxInfo != null) {
            SandboxManager.Companion.getInstance().markAsSandbox(editor, (AbstractSandboxInfo)sandBoxInfo);
            return ThreeState.YES;
        }
        return ThreeState.UNSURE;
    }

    private final SandboxInfo createSandboxForExistingOriginalFile(String originalFilePath, Document document, Project project) {
        VirtualFile virtualFile = LocalFileSystem.getInstance().findFileByPath(originalFilePath);
        if (virtualFile == null) {
            return null;
        }
        VirtualFile originalFile = virtualFile;
        FileType fileType = originalFile.getFileType();
        LanguageFileType languageFileType = fileType instanceof LanguageFileType ? (LanguageFileType)fileType : null;
        if (languageFileType == null) {
            return null;
        }
        LanguageFileType languageFileType2 = languageFileType;
        RdLanguage rdLanguage = this.toLanguage(languageFileType2);
        if (rdLanguage == null) {
            return null;
        }
        RdLanguage rdLanguage2 = rdLanguage;
        Document document2 = FileDocumentManager.getInstance().getDocument(originalFile);
        if (document2 == null || (document2 = DocumentExKt.getDocumentId(document2, project)) == null) {
            document2 = (RdDocumentId)com.jetbrains.rd.ide.document.DocumentExKt.createDocumentId$default((String)originalFilePath, null, (int)2, null);
        }
        Document entityId = document2;
        String string = document.getText();
        List list2 = CollectionsKt.emptyList();
        List list3 = CollectionsKt.emptyList();
        List list4 = CollectionsKt.emptyList();
        return new SandboxInfo("Vcs Diff", (RdDocumentId)entityId, string, null, true, null, list2, true, list3, rdLanguage2, false, null, false, true, list4, 4096, null);
    }

    private final SandboxInfo createGenericSandbox(PsiFile currentPsiFile) {
        Object object = currentPsiFile.getFileType();
        LanguageFileType languageFileType = object instanceof LanguageFileType ? (LanguageFileType)object : null;
        if (languageFileType == null) {
            return null;
        }
        LanguageFileType languageFileType2 = languageFileType;
        RdLanguage rdLanguage = this.toLanguage(languageFileType2);
        if (rdLanguage == null) {
            return null;
        }
        RdLanguage language = rdLanguage;
        object = CollectionsKt.emptyList();
        List list2 = CollectionsKt.emptyList();
        List list3 = CollectionsKt.emptyList();
        return new SandboxInfo("Vcs Diff Without Original Context", null, null, null, true, null, (List)object, true, list2, language, false, null, false, true, list3, 4096, null);
    }

    private final RdLanguage toLanguage(LanguageFileType languageFileType) {
        Language language = languageFileType.getLanguage();
        Intrinsics.checkNotNullExpressionValue((Object)language, (String)"getLanguage(...)");
        return ProtocolLanguageManagerKt.toRdLanguage((Language)language);
    }
}

