/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.editorActions;

import com.intellij.codeInsight.editorActions.TypedHandlerDelegate;
import com.intellij.codeInsight.lookup.LookupManager;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.ex.AnActionListener;
import com.intellij.openapi.client.ClientAppSession;
import com.intellij.openapi.client.ClientProjectSession;
import com.intellij.openapi.client.ClientSession;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.event.CaretListener;
import com.intellij.openapi.editor.event.DocumentListener;
import com.intellij.openapi.editor.event.EditorFactoryListener;
import com.intellij.openapi.editor.event.SelectionListener;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.rd.LifetimeDisposableExKt;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.util.ApplicationKt;
import com.intellij.util.messages.MessageBusConnection;
import com.intellij.util.messages.Topic;
import com.jetbrains.rd.actions.RdDataContextManager;
import com.jetbrains.rd.ide.Suppressor;
import com.jetbrains.rd.ide.document.DocumentSynchronizer;
import com.jetbrains.rd.ide.editor.EditorSynchronizer;
import com.jetbrains.rd.ide.model.Operation;
import com.jetbrains.rd.ide.model.RiderProjectDocumentOperationModel_PregeneratedKt;
import com.jetbrains.rd.ide.model.TextControlId;
import com.jetbrains.rd.ide.model.TextControlModel;
import com.jetbrains.rd.ide.model.TypedAction;
import com.jetbrains.rd.ide.model.TypedKey;
import com.jetbrains.rd.ide.model.TypingSessionState;
import com.jetbrains.rd.platform.protocol.IRdDispatcher;
import com.jetbrains.rd.platform.protocol.IRdDispatcherKt;
import com.jetbrains.rd.platform.util.idea.LifetimedService;
import com.jetbrains.rd.util.lifetime.Lifetime;
import com.jetbrains.rd.util.reactive.IOptProperty;
import com.jetbrains.rd.util.reactive.IScheduler;
import com.jetbrains.rd.util.reactive.OptProperty;
import com.jetbrains.rdclient.RiderOnly;
import com.jetbrains.rdclient.client.FrontendSessionsUtilKt;
import com.jetbrains.rdclient.document.DocumentExKt;
import com.jetbrains.rdclient.editorActions.cwm.FrontendTypeKeyRequest;
import com.jetbrains.rdclient.editors.FrontendTextControlHostListener;
import com.jetbrains.rdclient.patches.PatchEngineRegistryKt;
import com.jetbrains.rdclient.services.AppLevelIdeBackend;
import com.jetbrains.rdclient.services.IdeBackend;
import com.jetbrains.rdclient.util.idea.EditorUtilKt;
import com.jetbrains.rider.document.FrontendCommandsHost;
import com.jetbrains.rider.document.TextBufferDocumentSynchronizer;
import com.jetbrains.rider.editorActions.CommitResult;
import com.jetbrains.rider.editorActions.CustomTypingSessionPolicy;
import com.jetbrains.rider.editorActions.FrontendTypedHandler;
import com.jetbrains.rider.editorActions.FrontendTypedHandlerManager;
import com.jetbrains.rider.editorActions.IFrontendTypingListener;
import com.jetbrains.rider.editorActions.ITypingSessions;
import com.jetbrains.rider.editorActions.SynchronousFrontendTypedHandlerStrategy;
import com.jetbrains.rider.editorActions.TerminationOnModificationAfterMoveCaret;
import com.jetbrains.rider.editorActions.TypingSessionMediator;
import com.jetbrains.rider.editorActions.TypingSessions;
import com.jetbrains.rider.editors.EditorSynchronizerWithTypingSession;
import com.jetbrains.rider.editors.ILastFocusedEditorSuppressor;
import com.jetbrains.rider.editors.LastFocusedEditorSuppressor;
import java.util.List;
import java.util.Set;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

@RiderOnly(reason="Replaced with requests system", see=FrontendTypeKeyRequest.class)
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u00a6\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\f\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\b\u0017\u0018\u0000 Q2\u00020\u00012\u00020\u00022\u00020\u0003:\u0001QB\u000f\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\b\u0010\u001f\u001a\u00020\u0014H\u0016J&\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020#2\u0006\u0010$\u001a\u00020%2\f\u0010&\u001a\b\u0012\u0004\u0012\u00020!0'H\u0016J\u0006\u0010\u0013\u001a\u00020\u0014J\u0006\u0010\u0015\u001a\u00020\u0014J\u0010\u0010(\u001a\u00020!2\u0006\u0010)\u001a\u00020\u0012H\u0014J\u0010\u0010*\u001a\u00020\u00122\u0006\u0010+\u001a\u00020,H\u0002J\u001a\u0010-\u001a\u00020!2\b\u0010.\u001a\u0004\u0018\u00010\u00122\u0006\u0010/\u001a\u00020,H\u0014JB\u00100\u001a\u0002012\u0006\u00102\u001a\u0002032\u0006\u00104\u001a\u0002052\u0006\u0010+\u001a\u00020,2\u0006\u00106\u001a\u0002072\u0018\u00108\u001a\u0014\u0012\u0004\u0012\u000203\u0012\u0004\u0012\u00020,\u0012\u0004\u0012\u00020!09H\u0016JB\u00100\u001a\u0002012\u0006\u00102\u001a\u0002032\u0006\u0010:\u001a\u00020\u00142\u0006\u0010;\u001a\u00020\u00142\u0006\u0010+\u001a\u00020,2\u0018\u00108\u001a\u0014\u0012\u0004\u0012\u000203\u0012\u0004\u0012\u00020,\u0012\u0004\u0012\u00020!09H\u0002J(\u0010<\u001a\u00020!2\u0006\u00102\u001a\u0002032\u0006\u0010:\u001a\u00020\u00142\u0006\u0010+\u001a\u00020,2\u0006\u0010)\u001a\u00020\u0012H\u0002J.\u0010=\u001a\u00020!2\u0006\u0010>\u001a\u00020#2\u0006\u0010+\u001a\u00020,2\u0006\u0010?\u001a\u00020@2\f\u0010A\u001a\b\u0012\u0004\u0012\u00020!0'H\u0016J\u0010\u0010B\u001a\u00020!2\u0006\u0010C\u001a\u00020#H\u0002J\u0010\u0010B\u001a\u00020!2\u0006\u00102\u001a\u000203H\u0002J$\u0010D\u001a\u00020!2\u0006\u0010+\u001a\u00020,2\u0012\u0010E\u001a\u000e\u0012\u0004\u0012\u00020G\u0012\u0004\u0012\u00020!0FH\u0016J \u0010H\u001a\u00020I2\u0006\u0010J\u001a\u0002032\u0006\u0010+\u001a\u00020,2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u0018\u0010K\u001a\u00020!2\u0006\u00102\u001a\u0002032\u0006\u0010+\u001a\u00020,H\u0002J\u0010\u0010L\u001a\u00020!2\u0006\u00102\u001a\u000203H\u0002J\u0010\u0010M\u001a\u00020!2\u0006\u0010N\u001a\u00020#H\u0016J\u0010\u0010O\u001a\u00020!2\u0006\u0010N\u001a\u00020#H\u0016J\b\u0010P\u001a\u00020\u0014H\u0017R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\n\u001a\u00020\u000b8F\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\rR\u0014\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0011\u001a\u0004\u0018\u00010\u0012X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0014X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u0014X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00140\u0017X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0018R\u001b\u0010\u0019\u001a\u00020\u001a8VX\u0096\u0084\u0002\u00a2\u0006\f\n\u0004\b\u001d\u0010\u001e\u001a\u0004\b\u001b\u0010\u001c\u00a8\u0006R"}, d2={"Lcom/jetbrains/rider/editorActions/TypingSessions;", "Lcom/jetbrains/rd/platform/util/idea/LifetimedService;", "Lcom/intellij/openapi/editor/event/EditorFactoryListener;", "Lcom/jetbrains/rider/editorActions/ITypingSessions;", "session", "Lcom/intellij/openapi/client/ClientProjectSession;", "<init>", "(Lcom/intellij/openapi/client/ClientProjectSession;)V", "getSession", "()Lcom/intellij/openapi/client/ClientProjectSession;", "project", "Lcom/intellij/openapi/project/Project;", "getProject", "()Lcom/intellij/openapi/project/Project;", "terminationRules", "", "Lcom/jetbrains/rider/editorActions/TerminationOnModificationAfterMoveCaret;", "activeSessionMediator", "Lcom/jetbrains/rider/editorActions/TypingSessionMediator;", "isUnderTypingContextCalculation", "", "isUnderOptimisticTyping", "isSessionActive", "Lcom/jetbrains/rd/util/reactive/IOptProperty;", "()Lcom/jetbrains/rd/util/reactive/IOptProperty;", "suppressor", "Lcom/jetbrains/rd/ide/Suppressor;", "getSuppressor", "()Lcom/jetbrains/rd/ide/Suppressor;", "suppressor$delegate", "Lkotlin/Lazy;", "isTypingSessionSynced", "adviseBackendTypingsSynced", "", "id", "", "lifetime", "Lcom/jetbrains/rd/util/lifetime/Lifetime;", "action", "Lkotlin/Function0;", "beforeFirstWritableOperation", "mediator", "openNewTypingSession", "editor", "Lcom/intellij/openapi/editor/Editor;", "beforeNewTypingSessionCreated", "currentSessionMediator", "newTypingSessionSource", "type", "Lcom/intellij/codeInsight/editorActions/TypedHandlerDelegate$Result;", "c", "", "typedHandler", "Lcom/jetbrains/rider/editorActions/FrontendTypedHandler;", "backend", "Lcom/jetbrains/rdclient/services/IdeBackend;", "optimisticTypedHandler", "Lkotlin/Function2;", "isCompletionTerminator", "isWritableTypingAssist", "sendTypedKey", "executeTypedAction", "actionId", "dataContext", "Lcom/intellij/openapi/actionSystem/DataContext;", "optimisticTypedAction", "reopenSessionIfNeeded", "frontendId", "executeUnderSessionWithNextTimestamp", "block", "Lkotlin/Function1;", "", "typeCharCookie", "Lcom/intellij/openapi/Disposable;", "ch", "beforeAppend", "afterAppend", "forceCloseActiveSession", "reason", "waitForSessionTermination", "hasActiveSession", "Companion", "intellij.rider.rdclient.dotnet"})
@SourceDebugExtension(value={"SMAP\nTypingSessions.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TypingSessions.kt\ncom/jetbrains/rider/editorActions/TypingSessions\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n+ 3 extensions.kt\ncom/intellij/openapi/util/ExtensionsKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,427:1\n67#2,4:428\n67#2,4:432\n67#2,4:436\n67#2,4:440\n67#2,4:444\n67#2,4:460\n67#2,4:464\n67#2,4:474\n67#2,4:478\n67#2,4:484\n13#2:488\n22#3,6:448\n22#3,6:454\n22#3,6:468\n1869#4,2:482\n*S KotlinDebug\n*F\n+ 1 TypingSessions.kt\ncom/jetbrains/rider/editorActions/TypingSessions\n*L\n107#1:428,4\n141#1:432,4\n239#1:436,4\n243#1:440,4\n250#1:444,4\n339#1:460,4\n349#1:464,4\n117#1:474,4\n121#1:478,4\n196#1:484,4\n54#1:488\n261#1:448,6\n317#1:454,6\n366#1:468,6\n195#1:482,2\n*E\n"})
public class TypingSessions
extends LifetimedService
implements EditorFactoryListener,
ITypingSessions {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final ClientProjectSession session;
    @NotNull
    private final List<TerminationOnModificationAfterMoveCaret> terminationRules;
    @Nullable
    private TypingSessionMediator activeSessionMediator;
    private boolean isUnderTypingContextCalculation;
    private boolean isUnderOptimisticTyping;
    @NotNull
    private final IOptProperty<Boolean> isSessionActive;
    @NotNull
    private final Lazy suppressor$delegate;
    private static int sessionId;
    @NotNull
    private static final String asyncTypingKey = "rider.typing.async";
    @NotNull
    private static final Logger logger;
    @NotNull
    private static final Set<String> allowedActions;
    @NotNull
    private static final Set<String> allowedActionsWithActiveLookup;

    public TypingSessions(@NotNull ClientProjectSession session2) {
        Intrinsics.checkNotNullParameter((Object)session2, (String)"session");
        this.session = session2;
        this.terminationRules = CollectionsKt.listOf((Object)new TerminationOnModificationAfterMoveCaret());
        this.isSessionActive = (IOptProperty)new OptProperty((Object)false);
        this.suppressor$delegate = LazyKt.lazy(TypingSessions::suppressor_delegate$lambda$0);
    }

    @NotNull
    public final ClientProjectSession getSession() {
        return this.session;
    }

    @NotNull
    public final Project getProject() {
        return this.session.getProject();
    }

    @Override
    @NotNull
    public IOptProperty<Boolean> isSessionActive() {
        return this.isSessionActive;
    }

    @Override
    @NotNull
    public Suppressor getSuppressor() {
        Lazy lazy = this.suppressor$delegate;
        return (Suppressor)lazy.getValue();
    }

    @Override
    public boolean isTypingSessionSynced() {
        TypingSessionMediator mediator = this.activeSessionMediator;
        return mediator == null || !mediator.getHasWritableTypingAssist();
    }

    @Override
    public void adviseBackendTypingsSynced(@NotNull String id, @NotNull Lifetime lifetime, @NotNull Function0<Unit> action2) {
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        Intrinsics.checkNotNullParameter((Object)lifetime, (String)"lifetime");
        Intrinsics.checkNotNullParameter(action2, (String)"action");
        TypingSessionMediator mediator = this.activeSessionMediator;
        if (mediator == null) {
            Logger $this$trace$iv = logger;
            boolean $i$f$trace = false;
            if ($this$trace$iv.isTraceEnabled()) {
                Logger logger = $this$trace$iv;
                boolean bl = false;
                logger.trace("Document is synced, execute '" + id + "' right away");
            }
            action2.invoke();
        } else if (!mediator.getHasWritableTypingAssist()) {
            logger.trace("Only readonly typing assists are suppressed on the frontend, execute right away");
            action2.invoke();
        } else {
            mediator.getSessionFinishedSignal$intellij_rider_rdclient_dotnet().advise(lifetime, arg_0 -> TypingSessions.adviseBackendTypingsSynced$lambda$1(action2, id, arg_0));
        }
    }

    public final boolean isUnderTypingContextCalculation() {
        return this.isUnderTypingContextCalculation;
    }

    public final boolean isUnderOptimisticTyping() {
        return this.isUnderOptimisticTyping;
    }

    protected void beforeFirstWritableOperation(@NotNull TypingSessionMediator mediator) {
        Intrinsics.checkNotNullParameter((Object)mediator, (String)"mediator");
        mediator.beforeWritableOperation();
    }

    private final TypingSessionMediator openNewTypingSession(Editor editor) {
        int n = sessionId;
        sessionId = n + 1;
        int id = n;
        Logger $this$trace$iv = logger;
        boolean $i$f$trace = false;
        if ($this$trace$iv.isTraceEnabled()) {
            Logger logger = $this$trace$iv;
            boolean bl = false;
            logger.trace(">> Open typing session " + id);
        }
        Document document = editor.getDocument();
        Intrinsics.checkNotNullExpressionValue((Object)document, (String)"getDocument(...)");
        Document document2 = document;
        DocumentSynchronizer documentSynchronizer = DocumentExKt.getDocumentSynchronizer(document2, this.session.getAppSession());
        TextBufferDocumentSynchronizer textBufferDocumentSynchronizer = documentSynchronizer instanceof TextBufferDocumentSynchronizer ? (TextBufferDocumentSynchronizer)documentSynchronizer : null;
        if (textBufferDocumentSynchronizer == null) {
            throw new IllegalStateException("documentSynchronizer is null".toString());
        }
        TextBufferDocumentSynchronizer documentSynchronizer2 = textBufferDocumentSynchronizer;
        EditorSynchronizer editorSynchronizer = DocumentExKt.getEditorSynchronizer(editor);
        EditorSynchronizerWithTypingSession editorSynchronizerWithTypingSession = editorSynchronizer instanceof EditorSynchronizerWithTypingSession ? (EditorSynchronizerWithTypingSession)editorSynchronizer : null;
        if (editorSynchronizerWithTypingSession == null) {
            throw new IllegalStateException("editorSynchronizer is null".toString());
        }
        EditorSynchronizerWithTypingSession editorSynchronizer2 = editorSynchronizerWithTypingSession;
        TextControlId typingSessionTextControlId = editorSynchronizer2.getTextControlId();
        this.beforeNewTypingSessionCreated(this.activeSessionMediator, editor);
        TypingSessionState typingSession = new TypingSessionState(typingSessionTextControlId, id);
        TypingSessionMediator mediator = new TypingSessionMediator(logger, typingSession, editor, editorSynchronizer2, documentSynchronizer2, this.getSuppressor(), this.session.getAppSession());
        Lifetime sessionLifetime = mediator.getLifetime();
        FrontendCommandsHost.Companion.getInstance(this.session.getAppSession()).suppress(sessionLifetime);
        this.getSuppressor().onRelease(sessionLifetime, () -> TypingSessions.openNewTypingSession$lambda$1(mediator));
        Disposable disposable = LifetimeDisposableExKt.createNestedDisposable((Lifetime)sessionLifetime, (String)"TypingSessionMediator");
        editor.getCaretModel().addCaretListener((CaretListener)mediator, disposable);
        editor.getSelectionModel().addSelectionListener((SelectionListener)mediator, disposable);
        document2.addDocumentListener((DocumentListener)mediator, disposable);
        MessageBusConnection messageBusConnection = this.getProject().getMessageBus().connect(disposable);
        Project myProject = this.getProject();
        ApplicationKt.getApplication().getMessageBus().connect((Disposable)myProject).subscribe(FrontendTextControlHostListener.Companion.getTOPIC(), (Object)new FrontendTextControlHostListener(myProject, typingSessionTextControlId, mediator){
            final /* synthetic */ Project $myProject;
            final /* synthetic */ TextControlId $typingSessionTextControlId;
            final /* synthetic */ TypingSessionMediator $mediator;
            {
                this.$myProject = $myProject;
                this.$typingSessionTextControlId = $typingSessionTextControlId;
                this.$mediator = $mediator;
            }

            public void editorBound(Lifetime lifetime, ClientAppSession appSession, TextControlId textControlId, TextControlModel editorModel, Editor editor) {
                Intrinsics.checkNotNullParameter((Object)lifetime, (String)"lifetime");
                Intrinsics.checkNotNullParameter((Object)appSession, (String)"appSession");
                Intrinsics.checkNotNullParameter((Object)textControlId, (String)"textControlId");
                Intrinsics.checkNotNullParameter((Object)editorModel, (String)"editorModel");
                Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
                if (!Intrinsics.areEqual((Object)editor.getProject(), (Object)this.$myProject)) {
                    return;
                }
                if (Intrinsics.areEqual((Object)this.$typingSessionTextControlId, (Object)textControlId)) {
                    lifetime.onTerminationIfAlive(() -> openNewTypingSession.3.editorBound$lambda$0(this.$mediator));
                }
            }

            private static final Unit editorBound$lambda$0(TypingSessionMediator $mediator) {
                $mediator.close("editor was closed");
                return Unit.INSTANCE;
            }
        });
        Topic topic = AnActionListener.TOPIC;
        Intrinsics.checkNotNullExpressionValue((Object)topic, (String)"TOPIC");
        messageBusConnection.subscribe(topic, (Object)new AnActionListener(mediator){
            final /* synthetic */ TypingSessionMediator $mediator;
            {
                this.$mediator = $mediator;
            }

            public void beforeActionPerformed(AnAction action2, AnActionEvent event) {
                Intrinsics.checkNotNullParameter((Object)action2, (String)"action");
                Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                String actionId = ActionManager.getInstance().getId(action2);
                if (!CollectionsKt.contains((Iterable)TypingSessions.access$getAllowedActions$cp(), (Object)actionId) && !CollectionsKt.contains((Iterable)TypingSessions.access$getAllowedActionsWithActiveLookup$cp(), (Object)actionId)) {
                    this.$mediator.close("Executing action with id: " + actionId);
                }
            }
        });
        sessionLifetime.bracket(() -> TypingSessions.openNewTypingSession$lambda$2(this, mediator, typingSession), () -> TypingSessions.openNewTypingSession$lambda$3(this, id));
        return mediator;
    }

    protected void beforeNewTypingSessionCreated(@Nullable TypingSessionMediator currentSessionMediator, @NotNull Editor newTypingSessionSource) {
        Intrinsics.checkNotNullParameter((Object)newTypingSessionSource, (String)"newTypingSessionSource");
    }

    @Override
    @NotNull
    public TypedHandlerDelegate.Result type(char c, @NotNull FrontendTypedHandler typedHandler, @NotNull Editor editor, @NotNull IdeBackend backend, @NotNull Function2<? super Character, ? super Editor, Unit> optimisticTypedHandler) {
        boolean hasMultipleEditPoints;
        Intrinsics.checkNotNullParameter((Object)typedHandler, (String)"typedHandler");
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)((Object)backend), (String)"backend");
        Intrinsics.checkNotNullParameter(optimisticTypedHandler, (String)"optimisticTypedHandler");
        boolean isCompletionTerminator = typedHandler.isCompletionTerminator(editor, c);
        boolean isWritableTypingAssist = typedHandler.isWritableTypingAssist(editor, c);
        ILastFocusedEditorSuppressor editorSuppressor = LastFocusedEditorSuppressor.Companion.getInstance(this.getProject());
        if (isCompletionTerminator) {
            editorSuppressor.forceReleaseSuppressionForLastFocusedEditor("typed completion terminator character '" + c + "'");
        }
        if (hasMultipleEditPoints = EditorUtilKt.hasMultipleEditPoints(editor)) {
            return SynchronousFrontendTypedHandlerStrategy.INSTANCE.typeChar(c, typedHandler, editor, backend);
        }
        return this.type(c, isCompletionTerminator, isWritableTypingAssist, editor, optimisticTypedHandler);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final TypedHandlerDelegate.Result type(char c, boolean isCompletionTerminator, boolean isWritableTypingAssist, Editor editor, Function2<? super Character, ? super Editor, Unit> optimisticTypedHandler) {
        try {
            TypingSessionMediator mediator;
            this.reopenSessionIfNeeded(c);
            TypingSessionMediator currentTypingSession = this.activeSessionMediator;
            if (currentTypingSession != null) {
                if (Intrinsics.areEqual((Object)currentTypingSession.getEditor(), (Object)editor)) {
                    $this$trace$iv = logger;
                    $i$f$trace = false;
                    if ($this$trace$iv.isTraceEnabled()) {
                        var14_9 = $this$trace$iv;
                        boolean bl = false;
                        var14_9.trace("Editors match. Using current sessions for " + DocumentExKt.getTextControlId(editor));
                    }
                    v0 = currentTypingSession;
                } else {
                    $this$trace$iv = logger;
                    $i$f$trace = false;
                    if ($this$trace$iv.isTraceEnabled()) {
                        var14_9 = $this$trace$iv;
                        boolean bl = false;
                        var14_9.trace("Current session is for " + DocumentExKt.getTextControlId(currentTypingSession.getEditor()) + " but typing is requested for " + DocumentExKt.getTextControlId(editor) + ". Replacing the session with a new one.");
                    }
                    currentTypingSession.close("Editors don't match: current session editor is " + DocumentExKt.getTextControlId(currentTypingSession.getEditor()) + ", typing requested for " + DocumentExKt.getTextControlId(editor));
                    v0 = this.openNewTypingSession(editor);
                }
            } else {
                $this$trace$iv = logger;
                $i$f$trace = false;
                if ($this$trace$iv.isTraceEnabled()) {
                    var14_9 = $this$trace$iv;
                    boolean bl = false;
                    var14_9.trace("Current session is null. Opening a new one for editor " + DocumentExKt.getTextControlId(editor));
                }
                v0 = mediator = this.openNewTypingSession(editor);
            }
            if (!mediator.getHasWritableTypingAssist() && isWritableTypingAssist) {
                this.beforeFirstWritableOperation(mediator);
            }
            this.sendTypedKey(c, isCompletionTerminator, editor, mediator);
            Disposable $this$use$iv = mediator.allowModifications();
            boolean $i$f$use = false;
            try {
                Disposable it = $this$use$iv;
                boolean bl = false;
                optimisticTypedHandler.invoke((Object)Character.valueOf(c), (Object)editor);
                Unit unit = Unit.INSTANCE;
            }
            finally {
                if ($this$use$iv != null) {
                    Disposer.dispose((Disposable)$this$use$iv);
                }
            }
            return TypedHandlerDelegate.Result.STOP;
        }
        catch (Throwable t) {
            block15: {
                logger.error(t);
                TypingSessionMediator typingSessionMediator = this.activeSessionMediator;
                if (typingSessionMediator == null) break block15;
                typingSessionMediator.close("exception while '" + c + "' is typing");
            }
            return TypedHandlerDelegate.Result.CONTINUE;
        }
    }

    private final void sendTypedKey(char c, boolean isCompletionTerminator, Editor editor, TypingSessionMediator mediator) {
        long typedTime = System.nanoTime();
        int timestamp = mediator.getNextOperationTimestamp();
        TypedKey typedKey = new TypedKey(c, isCompletionTerminator, typedTime, timestamp);
        ((IFrontendTypingListener)this.getProject().getMessageBus().syncPublisher(FrontendTypedHandlerManager.Companion.getBEFORE_TYPING_SENT())).beforeSendType(editor, timestamp, isCompletionTerminator);
        if (this.getSuppressor().shouldSuppress()) {
            mediator.sendReadonlyTypedKey(typedKey);
        }
        mediator.sendOperation((Operation)typedKey);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void executeTypedAction(@NotNull String actionId, @NotNull Editor editor, @NotNull DataContext dataContext, @NotNull Function0<Unit> optimisticTypedAction) {
        Intrinsics.checkNotNullParameter((Object)actionId, (String)"actionId");
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)dataContext, (String)"dataContext");
        Intrinsics.checkNotNullParameter(optimisticTypedAction, (String)"optimisticTypedAction");
        try {
            List list2;
            TypingSessionMediator mediator;
            this.reopenSessionIfNeeded(actionId);
            TypingSessionMediator typingSessionMediator = this.activeSessionMediator;
            if (typingSessionMediator == null) {
                typingSessionMediator = this.openNewTypingSession(editor);
            }
            if (!(mediator = typingSessionMediator).getHasWritableTypingAssist()) {
                this.beforeFirstWritableOperation(mediator);
            }
            try {
                this.isUnderTypingContextCalculation = true;
                list2 = RdDataContextManager.Companion.createDataContextModel(dataContext);
            }
            finally {
                this.isUnderTypingContextCalculation = false;
            }
            List modelDataContext = list2;
            String backendId = AppLevelIdeBackend.Companion.getInstance().getBackendActionId(actionId);
            mediator.sendOperation((Operation)new TypedAction(backendId, modelDataContext, mediator.getNextOperationTimestamp()));
            Disposable $this$use$iv = mediator.allowModifications();
            boolean $i$f$use = false;
            try {
                Disposable it = $this$use$iv;
                boolean bl = false;
                this.isUnderOptimisticTyping = true;
                try {
                    optimisticTypedAction.invoke();
                }
                finally {
                    this.isUnderOptimisticTyping = false;
                }
                Unit unit = Unit.INSTANCE;
            }
            finally {
                if ($this$use$iv != null) {
                    Disposer.dispose((Disposable)$this$use$iv);
                }
            }
        }
        catch (Throwable t) {
            logger.error(t);
            TypingSessionMediator typingSessionMediator = this.activeSessionMediator;
            if (typingSessionMediator != null) {
                typingSessionMediator.close("exception while '" + actionId + "' action is executing");
            }
            optimisticTypedAction.invoke();
        }
    }

    private final void reopenSessionIfNeeded(String frontendId) {
        for (TerminationOnModificationAfterMoveCaret rule : this.terminationRules) {
            if (!rule.shouldTerminateBeforeAction(frontendId)) continue;
            Logger $this$trace$iv = logger;
            boolean $i$f$trace = false;
            if ($this$trace$iv.isTraceEnabled()) {
                Logger logger = $this$trace$iv;
                boolean bl = false;
                logger.trace("Before execute action '" + frontendId + "' ");
            }
            this.forceCloseActiveSession("Terminate by '" + rule.getClass().getSimpleName() + "' rule");
            break;
        }
    }

    private final void reopenSessionIfNeeded(char c) {
        for (TerminationOnModificationAfterMoveCaret rule : this.terminationRules) {
            if (!rule.shouldTerminateBeforeType(c)) continue;
            Logger $this$trace$iv = logger;
            boolean $i$f$trace = false;
            if ($this$trace$iv.isTraceEnabled()) {
                Logger logger = $this$trace$iv;
                boolean bl = false;
                logger.trace("Before type '" + c + "' char");
            }
            this.forceCloseActiveSession("Terminate by '" + rule.getClass().getSimpleName() + "' rule");
            break;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void executeUnderSessionWithNextTimestamp(@NotNull Editor editor, @NotNull Function1<? super Integer, Unit> block) {
        block8: {
            Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
            Intrinsics.checkNotNullParameter(block, (String)"block");
            try {
                TypingSessionMediator mediator;
                TypingSessionMediator typingSessionMediator = this.activeSessionMediator;
                if (typingSessionMediator == null) {
                    typingSessionMediator = this.openNewTypingSession(editor);
                }
                if (!(mediator = typingSessionMediator).getHasWritableTypingAssist()) {
                    this.beforeFirstWritableOperation(mediator);
                }
                Disposable $this$use$iv = mediator.allowModifications();
                boolean $i$f$use = false;
                try {
                    Disposable it = $this$use$iv;
                    boolean bl = false;
                    block.invoke((Object)mediator.getNextOperationTimestamp());
                    Unit unit = Unit.INSTANCE;
                }
                finally {
                    if ($this$use$iv != null) {
                        Disposer.dispose((Disposable)$this$use$iv);
                    }
                }
            }
            catch (Throwable t) {
                logger.error(t);
                TypingSessionMediator typingSessionMediator = this.activeSessionMediator;
                if (typingSessionMediator == null) break block8;
                typingSessionMediator.close("exception while async operation is executing");
            }
        }
    }

    @Override
    @NotNull
    public Disposable typeCharCookie(char ch, @NotNull Editor editor, @NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.beforeAppend(ch, editor);
        return new Disposable(this, ch){
            final /* synthetic */ TypingSessions this$0;
            final /* synthetic */ char $ch;
            {
                this.this$0 = $receiver;
                this.$ch = $ch;
            }

            public void dispose() {
                TypingSessions.access$afterAppend(this.this$0, this.$ch);
            }
        };
    }

    private final void beforeAppend(char c, Editor editor) {
        block3: {
            try {
                this.reopenSessionIfNeeded(c);
                TypingSessionMediator typingSessionMediator = this.activeSessionMediator;
                if (typingSessionMediator == null) {
                    typingSessionMediator = this.openNewTypingSession(editor);
                }
                TypingSessionMediator mediator = typingSessionMediator;
                this.sendTypedKey(c, false, editor, mediator);
                mediator.startAllowModifications();
            }
            catch (Throwable t) {
                logger.error(t);
                TypingSessionMediator typingSessionMediator = this.activeSessionMediator;
                if (typingSessionMediator == null) break block3;
                typingSessionMediator.close("exception while '" + c + "' is typing");
            }
        }
    }

    private final void afterAppend(char c) {
        TypingSessionMediator mediator = this.activeSessionMediator;
        if (mediator == null) {
            logger.error("activeSessionMediator == null");
            return;
        }
        mediator.endAllowModifications();
    }

    @Override
    public void forceCloseActiveSession(@NotNull String reason) {
        Intrinsics.checkNotNullParameter((Object)reason, (String)"reason");
        TypingSessionMediator typingSessionMediator = this.activeSessionMediator;
        if (typingSessionMediator == null) {
            return;
        }
        TypingSessionMediator mediator = typingSessionMediator;
        mediator.close(reason);
    }

    @Override
    public void waitForSessionTermination(@NotNull String reason) {
        Intrinsics.checkNotNullParameter((Object)reason, (String)"reason");
        TypingSessionMediator typingSessionMediator = this.activeSessionMediator;
        if (typingSessionMediator == null) {
            return;
        }
        TypingSessionMediator sessionMediator = typingSessionMediator;
        LastFocusedEditorSuppressor.Companion.getInstance(this.getProject()).forceReleaseSuppressionForLastFocusedEditor(reason);
        IRdDispatcher rdDispatcher = IRdDispatcherKt.getAsRdDispatcher((IScheduler)FrontendSessionsUtilKt.getProtocol(sessionMediator.getSession()).getScheduler());
        rdDispatcher.pumpProtocolQueue(() -> TypingSessions.waitForSessionTermination$lambda$0(this));
    }

    @Override
    @TestOnly
    public boolean hasActiveSession() {
        return this.activeSessionMediator != null;
    }

    private static final Suppressor suppressor_delegate$lambda$0() {
        return new Suppressor();
    }

    private static final Unit adviseBackendTypingsSynced$lambda$1(Function0 $action, String $id, CommitResult result2) {
        Intrinsics.checkNotNullParameter((Object)((Object)result2), (String)"result");
        if (result2 == CommitResult.Commited) {
            Logger $this$trace$iv = logger;
            boolean $i$f$trace = false;
            if ($this$trace$iv.isTraceEnabled()) {
                Logger logger = $this$trace$iv;
                boolean bl = false;
                logger.trace("executing action " + $id + " after successful document sync");
            }
            $action.invoke();
        } else {
            Logger $this$trace$iv = logger;
            boolean $i$f$trace = false;
            if ($this$trace$iv.isTraceEnabled()) {
                Logger logger = $this$trace$iv;
                boolean bl = false;
                logger.trace("Action '" + $id + "' was not executed, cause the document was rolled back");
            }
        }
        return Unit.INSTANCE;
    }

    private static final Unit openNewTypingSession$lambda$1(TypingSessionMediator $mediator) {
        $mediator.flushQueuedOperations();
        return Unit.INSTANCE;
    }

    private static final Unit openNewTypingSession$lambda$2(TypingSessions this$0, TypingSessionMediator $mediator, TypingSessionState $typingSession) {
        this$0.isSessionActive().set((Object)true);
        this$0.activeSessionMediator = $mediator;
        RiderProjectDocumentOperationModel_PregeneratedKt.getRiderProjectDocumentOperationModel(FrontendSessionsUtilKt.getProtocolModel(this$0.session)).getTypingSession().setValue((Object)$typingSession);
        return Unit.INSTANCE;
    }

    private static final Unit openNewTypingSession$lambda$3(TypingSessions this$0, int $id) {
        this$0.activeSessionMediator = null;
        RiderProjectDocumentOperationModel_PregeneratedKt.getRiderProjectDocumentOperationModel(FrontendSessionsUtilKt.getProtocolModel(this$0.session)).getTypingSession().setValue(null);
        Iterable $this$forEach$iv = this$0.terminationRules;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            TerminationOnModificationAfterMoveCaret it = (TerminationOnModificationAfterMoveCaret)element$iv;
            boolean bl = false;
            it.clearState();
        }
        Logger $this$trace$iv = logger;
        boolean $i$f$trace = false;
        if ($this$trace$iv.isTraceEnabled()) {
            Logger logger = $this$trace$iv;
            boolean bl = false;
            logger.trace(">> Close typing session " + $id);
        }
        this$0.isSessionActive().set((Object)false);
        return Unit.INSTANCE;
    }

    private static final boolean waitForSessionTermination$lambda$0(TypingSessions this$0) {
        return this$0.hasActiveSession();
    }

    public static final /* synthetic */ void access$afterAppend(TypingSessions $this, char c) {
        $this.afterAppend(c);
    }

    static {
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(TypingSessions.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        TypingSessions.logger = logger;
        Object[] objectArray = new String[]{"EditorEnter", "EditorTab", "EditorUnindentSelection", "EditorDelete", "EditorBackSpace", "EditorLeft", "EditorRight", "EditorEscape", "EditorChooseLookupItem", "EditorChooseLookupItemReplace", "EditorChooseLookupItemCompleteStatement"};
        allowedActions = SetsKt.setOf((Object[])objectArray);
        objectArray = new String[]{"EditorDown", "EditorUp"};
        allowedActionsWithActiveLookup = SetsKt.setOf((Object[])objectArray);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rJ\u000e\u0010\n\u001a\u00020\u000b2\u0006\u0010\u000e\u001a\u00020\u000fJ\u000e\u0010\n\u001a\u00020\u000b2\u0006\u0010\u000e\u001a\u00020\u0010J\u000e\u0010\u0011\u001a\u00020\u00122\u0006\u0010\f\u001a\u00020\rJ\u000e\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u000e\u001a\u00020\u000fJ\u0018\u0010\u0016\u001a\u00020\u000b2\u0006\u0010\u0017\u001a\u00020\u00072\u0006\u0010\u0018\u001a\u00020\u0019H\u0007R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00070\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00070\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lcom/jetbrains/rider/editorActions/TypingSessions$Companion;", "", "<init>", "()V", "sessionId", "", "asyncTypingKey", "", "logger", "Lcom/intellij/openapi/diagnostic/Logger;", "isEnabled", "", "project", "Lcom/intellij/openapi/project/Project;", "session", "Lcom/intellij/openapi/client/ClientProjectSession;", "Lcom/intellij/openapi/client/ClientAppSession;", "getInstance", "Lcom/jetbrains/rider/editorActions/ITypingSessions;", "allowedActions", "", "allowedActionsWithActiveLookup", "isAllowedActions", "actionId", "editor", "Lcom/intellij/openapi/editor/Editor;", "intellij.rider.rdclient.dotnet"})
    @SourceDebugExtension(value={"SMAP\nTypingSessions.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TypingSessions.kt\ncom/jetbrains/rider/editorActions/TypingSessions$Companion\n+ 2 Components.kt\ncom/jetbrains/rd/platform/util/ComponentsKt\n*L\n1#1,427:1\n23#2:428\n*S KotlinDebug\n*F\n+ 1 TypingSessions.kt\ncom/jetbrains/rider/editorActions/TypingSessions$Companion\n*L\n61#1:428\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        public final boolean isEnabled(@NotNull Project project) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            return this.isEnabled(FrontendSessionsUtilKt.getFrontendProjectSession(project));
        }

        public final boolean isEnabled(@NotNull ClientProjectSession session2) {
            Intrinsics.checkNotNullParameter((Object)session2, (String)"session");
            return this.isEnabled(session2.getAppSession());
        }

        public final boolean isEnabled(@NotNull ClientAppSession session2) {
            Intrinsics.checkNotNullParameter((Object)session2, (String)"session");
            return PatchEngineRegistryKt.isTypingSessionEnabled() && !CustomTypingSessionPolicy.Companion.forceDisableAsyncTyping(session2) && Registry.Companion.is(TypingSessions.asyncTypingKey);
        }

        @NotNull
        public final ITypingSessions getInstance(@NotNull Project project) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            return this.getInstance(FrontendSessionsUtilKt.getFrontendProjectSession(project));
        }

        @NotNull
        public final ITypingSessions getInstance(@NotNull ClientProjectSession session2) {
            Intrinsics.checkNotNullParameter((Object)session2, (String)"session");
            ClientSession $this$service$iv = (ClientSession)session2;
            boolean $i$f$service = false;
            Object object = $this$service$iv.getService(ITypingSessions.class);
            if (object == null) {
                throw new IllegalStateException(("Can't find service for " + $this$service$iv).toString());
            }
            return (ITypingSessions)object;
        }

        @TestOnly
        public final boolean isAllowedActions(@NotNull String actionId, @NotNull Editor editor) {
            Intrinsics.checkNotNullParameter((Object)actionId, (String)"actionId");
            Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
            return allowedActions.contains(actionId) || LookupManager.getActiveLookup((Editor)editor) != null && allowedActionsWithActiveLookup.contains(actionId);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

