/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.editorActions;

import com.intellij.openapi.util.TextRange;
import com.intellij.util.text.CharArrayUtil;
import com.intellij.util.text.ImmutableCharSequence;
import com.jetbrains.rdclient.RiderOnly;
import com.jetbrains.rdclient.util.StringUtilKt;
import com.jetbrains.rider.editorActions.RangePair;
import com.jetbrains.rider.editorActions.TextModificationMap;
import com.jetbrains.rider.editorActions.TextModificationSide;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

@RiderOnly
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010!\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u000b\n\u0002\u0010\u0002\n\u0002\b\t\n\u0002\u0010\r\n\u0002\b\u0003\b\u0007\u0018\u0000 '2\u00020\u0001:\u0002'(B-\b\u0002\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\u000e\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H\u0002J\u0018\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0010H\u0002J\u0018\u0010\u0012\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0010H\u0002J \u0010\u0013\u001a\u00020\u00102\u0006\u0010\u0014\u001a\u00020\u00042\u0006\u0010\u0015\u001a\u00020\u00102\u0006\u0010\u0016\u001a\u00020\u0010H\u0002J \u0010\u0017\u001a\u00020\u00102\u0006\u0010\u0018\u001a\u00020\u00042\u0006\u0010\u0015\u001a\u00020\u00102\u0006\u0010\u0016\u001a\u00020\u0010H\u0002J \u0010\u0019\u001a\u00020\u00102\u0006\u0010\u0014\u001a\u00020\u00042\u0006\u0010\u0015\u001a\u00020\u00102\u0006\u0010\u0016\u001a\u00020\u0010H\u0002J \u0010\u001a\u001a\u00020\u00102\u0006\u0010\u0014\u001a\u00020\u00042\u0006\u0010\u0015\u001a\u00020\u00102\u0006\u0010\u0016\u001a\u00020\u0010H\u0002J\u0018\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u0015\u001a\u00020\u00102\u0006\u0010\u0014\u001a\u00020\u0004H\u0002J\u0018\u0010\u001d\u001a\u00020\u001c2\u0006\u0010\u001e\u001a\u00020\u00102\u0006\u0010\u001f\u001a\u00020\u0010H\u0002J\u0010\u0010 \u001a\u00020\u00042\u0006\u0010!\u001a\u00020\u0004H\u0002J\"\u0010\"\u001a\u0004\u0018\u00010\u00042\u0006\u0010#\u001a\u00020\u00102\u0006\u0010$\u001a\u00020\u00072\u0006\u0010%\u001a\u00020&H\u0002R\u0014\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00040\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006)"}, d2={"Lcom/jetbrains/rider/editorActions/TextModificationMapsDiff;", "", "changes1", "", "Lcom/jetbrains/rider/editorActions/RangePair;", "changes2", "initialText", "Lcom/intellij/util/text/ImmutableCharSequence;", "<init>", "(Ljava/util/List;Ljava/util/List;Lcom/intellij/util/text/ImmutableCharSequence;)V", "diff", "", "build", "findStartIntersectedSegment", "Lcom/jetbrains/rider/editorActions/TextModificationMapsDiff$FindResult;", "offset", "", "startIdx2", "findEndIntersectedSegment", "diffInIn", "change1", "seg1", "seg2", "diffOutOut", "change", "diffOutIn", "diffInOut", "shiftAndAddChange", "", "revertChanges", "start", "end", "revert", "ch", "createDiffChange", "startOffset", "newText1", "newText2", "", "Companion", "FindResult", "intellij.rider.rdclient.dotnet"})
public final class TextModificationMapsDiff {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final List<RangePair> changes1;
    @NotNull
    private final List<RangePair> changes2;
    @NotNull
    private final ImmutableCharSequence initialText;
    @NotNull
    private List<RangePair> diff;

    private TextModificationMapsDiff(List<RangePair> changes1, List<RangePair> changes2, ImmutableCharSequence initialText) {
        this.changes1 = changes1;
        this.changes2 = changes2;
        this.initialText = initialText;
        this.diff = new ArrayList();
    }

    private final List<RangePair> build() {
        int idx1;
        if (this.changes2.isEmpty()) {
            return this.changes1;
        }
        int idx2 = 0;
        for (idx1 = 0; idx1 < this.changes1.size() && idx2 < this.changes2.size(); ++idx1) {
            RangePair change1 = this.changes1.get(idx1);
            int oldStartOffset = change1.getOldRange().getStartOffset();
            int oldEndOffset = change1.getOldRange().getEndOffset();
            FindResult findResult = this.findStartIntersectedSegment(oldStartOffset, idx2);
            boolean hasStartIntersection = findResult.component1();
            int seg1 = findResult.component2();
            FindResult findResult2 = this.findEndIntersectedSegment(oldEndOffset, seg1);
            boolean hasEndIntersection = findResult2.component1();
            int seg2 = findResult2.component2();
            this.revertChanges(idx2, seg1);
            idx2 = hasStartIntersection ? (hasEndIntersection ? this.diffInIn(change1, seg1, seg2) : this.diffInOut(change1, seg1, seg2)) : (hasEndIntersection ? this.diffOutIn(change1, seg1, seg2) : this.diffOutOut(change1, seg1, seg2));
        }
        while (idx1 < this.changes1.size()) {
            RangePair ch = this.changes1.get(idx1);
            this.shiftAndAddChange(this.changes2.size() - 1, ch);
            ++idx1;
        }
        this.revertChanges(idx2, this.changes2.size());
        return this.diff;
    }

    private final FindResult findStartIntersectedSegment(int offset, int startIdx2) {
        for (int i = startIdx2; i < this.changes2.size(); ++i) {
            RangePair change = this.changes2.get(i);
            TextRange oldRange = change.getOldRange();
            if (oldRange.getStartOffset() > offset) {
                return new FindResult(false, i);
            }
            if (!oldRange.contains(offset) && oldRange.getStartOffset() != offset) continue;
            return new FindResult(true, i);
        }
        return new FindResult(false, this.changes2.size());
    }

    private final FindResult findEndIntersectedSegment(int offset, int startIdx2) {
        for (int i = startIdx2; i < this.changes2.size(); ++i) {
            RangePair change = this.changes2.get(i);
            TextRange oldRange = change.getOldRange();
            if (oldRange.getStartOffset() > offset) {
                return new FindResult(false, i);
            }
            if (!oldRange.contains(offset) && oldRange.getEndOffset() != offset) continue;
            return new FindResult(true, i);
        }
        return new FindResult(false, this.changes2.size());
    }

    private final int diffInIn(RangePair change1, int seg1, int seg2) {
        if (seg1 == seg2) {
            RangePair change2 = this.changes2.get(seg1);
            TextRange oldRange1 = change1.getOldRange();
            TextRange oldRange2 = change2.getOldRange();
            if (Intrinsics.areEqual((Object)oldRange2, (Object)oldRange1)) {
                ImmutableCharSequence newText1 = change1.getNewText();
                ImmutableCharSequence newText2 = change2.getNewText();
                int startOffset = change2.getNewRange().getStartOffset();
                RangePair diffChange = this.createDiffChange(startOffset, newText1, (CharSequence)newText2);
                if (diffChange != null) {
                    this.diff.add(diffChange);
                }
                return seg2 + 1;
            }
        }
        this.shiftAndAddChange(seg1, change1);
        this.revertChanges(seg1, seg2);
        return seg2;
    }

    private final int diffOutOut(RangePair change, int seg1, int seg2) {
        this.shiftAndAddChange(seg1 == this.changes2.size() ? this.changes2.size() - 1 : seg1, change);
        if (seg1 != seg2) {
            this.revertChanges(seg1, seg2);
        }
        return seg2;
    }

    private final int diffOutIn(RangePair change1, int seg1, int seg2) {
        this.shiftAndAddChange(seg1, change1);
        this.revertChanges(seg1, seg2);
        return seg2;
    }

    private final int diffInOut(RangePair change1, int seg1, int seg2) {
        this.shiftAndAddChange(seg1, change1);
        this.revertChanges(seg1, seg2);
        return seg2;
    }

    private final void shiftAndAddChange(int seg1, RangePair change1) {
        RangePair fstSeg = this.changes2.get(seg1);
        boolean isChange1Last = fstSeg.getOldRange().getStartOffset() < change1.getOldRange().getStartOffset() && fstSeg.getOldRange().getEndOffset() <= change1.getOldRange().getStartOffset();
        int startShift = isChange1Last ? change1.getOldRange().getStartOffset() - fstSeg.getOldRange().getEndOffset() : change1.getOldRange().getStartOffset() - fstSeg.getOldRange().getStartOffset();
        int startOffset = isChange1Last ? fstSeg.getNewRange().getEndOffset() + startShift : fstSeg.getNewRange().getStartOffset() + startShift;
        TextRange textRange = TextRange.from((int)startOffset, (int)change1.getOldRange().getLength());
        Intrinsics.checkNotNullExpressionValue((Object)textRange, (String)"from(...)");
        TextRange oldRange = textRange;
        TextRange textRange2 = TextRange.from((int)startOffset, (int)change1.getNewRange().getLength());
        Intrinsics.checkNotNullExpressionValue((Object)textRange2, (String)"from(...)");
        TextRange newRange = textRange2;
        boolean areIntersected = fstSeg.getOldRange().intersects(change1.getOldRange());
        RangePair shiftedChange1 = new RangePair(oldRange, newRange, change1.getNewText(), areIntersected ? TextModificationSide.NotSpecified : change1.getModificationSide());
        this.diff.add(shiftedChange1);
    }

    private final void revertChanges(int start2, int end) {
        for (int i = start2; i < end; ++i) {
            RangePair ch = this.changes2.get(i);
            RangePair revertedCh = this.revert(ch);
            this.diff.add(revertedCh);
        }
    }

    private final RangePair revert(RangePair ch) {
        TextRange oldRange = ch.getNewRange();
        TextRange textRange = TextRange.from((int)oldRange.getStartOffset(), (int)ch.getOldRange().getLength());
        Intrinsics.checkNotNullExpressionValue((Object)textRange, (String)"from(...)");
        TextRange newRange = textRange;
        ImmutableCharSequence immutableCharSequence = this.initialText.subtext(ch.getOldRange().getStartOffset(), ch.getOldRange().getEndOffset());
        Intrinsics.checkNotNullExpressionValue((Object)immutableCharSequence, (String)"subtext(...)");
        ImmutableCharSequence newText = immutableCharSequence;
        ImmutableCharSequence immutableCharSequence2 = CharArrayUtil.createImmutableCharSequence((CharSequence)((CharSequence)newText));
        Intrinsics.checkNotNullExpressionValue((Object)immutableCharSequence2, (String)"createImmutableCharSequence(...)");
        return new RangePair(oldRange, newRange, immutableCharSequence2, TextModificationSide.NotSpecified);
    }

    private final RangePair createDiffChange(int startOffset, ImmutableCharSequence newText1, CharSequence newText2) {
        int startShift = StringUtilKt.getCommonPrefixLength((CharSequence)newText1, newText2);
        int endCut = StringUtilKt.getCommonSuffixLength((CharSequence)newText1, newText2, startShift);
        int trimmedLength1 = newText1.length() - startShift - endCut;
        int trimmedLength2 = newText2.length() - startShift - endCut;
        int shiftedOldStart = startOffset + startShift;
        TextRange textRange = TextRange.from((int)shiftedOldStart, (int)trimmedLength2);
        Intrinsics.checkNotNullExpressionValue((Object)textRange, (String)"from(...)");
        TextRange oldRange = textRange;
        TextRange textRange2 = TextRange.from((int)shiftedOldStart, (int)trimmedLength1);
        Intrinsics.checkNotNullExpressionValue((Object)textRange2, (String)"from(...)");
        TextRange newRange = textRange2;
        if (oldRange.isEmpty() && newRange.isEmpty()) {
            return null;
        }
        ImmutableCharSequence immutableCharSequence = newText1.subtext(startShift, newText1.length() - endCut);
        Intrinsics.checkNotNullExpressionValue((Object)immutableCharSequence, (String)"subtext(...)");
        ImmutableCharSequence newText = immutableCharSequence;
        ImmutableCharSequence immutableCharSequence2 = CharArrayUtil.createImmutableCharSequence((CharSequence)((CharSequence)newText));
        Intrinsics.checkNotNullExpressionValue((Object)immutableCharSequence2, (String)"createImmutableCharSequence(...)");
        return new RangePair(oldRange, newRange, immutableCharSequence2, TextModificationSide.NotSpecified);
    }

    public /* synthetic */ TextModificationMapsDiff(List changes1, List changes2, ImmutableCharSequence initialText, DefaultConstructorMarker $constructor_marker) {
        this(changes1, changes2, initialText);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J$\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\b2\u0006\u0010\n\u001a\u00020\u000bJ2\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\u0006\u0010\n\u001a\u00020\u000bH\u0007\u00a8\u0006\f"}, d2={"Lcom/jetbrains/rider/editorActions/TextModificationMapsDiff$Companion;", "", "<init>", "()V", "build", "", "Lcom/jetbrains/rider/editorActions/RangePair;", "applyingMap", "Lcom/jetbrains/rider/editorActions/TextModificationMap;", "appliedMap", "initialText", "Lcom/intellij/util/text/ImmutableCharSequence;", "intellij.rider.rdclient.dotnet"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final List<RangePair> build(@NotNull TextModificationMap applyingMap, @NotNull TextModificationMap appliedMap, @NotNull ImmutableCharSequence initialText) {
            Intrinsics.checkNotNullParameter((Object)applyingMap, (String)"applyingMap");
            Intrinsics.checkNotNullParameter((Object)appliedMap, (String)"appliedMap");
            Intrinsics.checkNotNullParameter((Object)initialText, (String)"initialText");
            return CollectionsKt.asReversed((List)new TextModificationMapsDiff(applyingMap.getSortedPairs((CharSequence)initialText), appliedMap.getSortedPairs((CharSequence)initialText), initialText, null).build());
        }

        @TestOnly
        @NotNull
        public final List<RangePair> build(@NotNull List<RangePair> applyingMap, @NotNull List<RangePair> appliedMap, @NotNull ImmutableCharSequence initialText) {
            Intrinsics.checkNotNullParameter(applyingMap, (String)"applyingMap");
            Intrinsics.checkNotNullParameter(appliedMap, (String)"appliedMap");
            Intrinsics.checkNotNullParameter((Object)initialText, (String)"initialText");
            return CollectionsKt.asReversed((List)new TextModificationMapsDiff(applyingMap, appliedMap, initialText, null).build());
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\b\n\u0002\b\r\n\u0002\u0010\u000e\n\u0000\b\u0082\b\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\t\u0010\f\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\r\u001a\u00020\u0005H\u00c6\u0003J\u001d\u0010\u000e\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010\u000f\u001a\u00020\u00032\b\u0010\u0010\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0011\u001a\u00020\u0005H\u00d6\u0001J\t\u0010\u0012\u001a\u00020\u0013H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0014"}, d2={"Lcom/jetbrains/rider/editorActions/TextModificationMapsDiff$FindResult;", "", "hasIntersection", "", "nearestOrIntersectedSegment", "", "<init>", "(ZI)V", "getHasIntersection", "()Z", "getNearestOrIntersectedSegment", "()I", "component1", "component2", "copy", "equals", "other", "hashCode", "toString", "", "intellij.rider.rdclient.dotnet"})
    private static final class FindResult {
        private final boolean hasIntersection;
        private final int nearestOrIntersectedSegment;

        public FindResult(boolean hasIntersection, int nearestOrIntersectedSegment) {
            this.hasIntersection = hasIntersection;
            this.nearestOrIntersectedSegment = nearestOrIntersectedSegment;
        }

        public final boolean getHasIntersection() {
            return this.hasIntersection;
        }

        public final int getNearestOrIntersectedSegment() {
            return this.nearestOrIntersectedSegment;
        }

        public final boolean component1() {
            return this.hasIntersection;
        }

        public final int component2() {
            return this.nearestOrIntersectedSegment;
        }

        @NotNull
        public final FindResult copy(boolean hasIntersection, int nearestOrIntersectedSegment) {
            return new FindResult(hasIntersection, nearestOrIntersectedSegment);
        }

        public static /* synthetic */ FindResult copy$default(FindResult findResult, boolean bl, int n, int n2, Object object) {
            if ((n2 & 1) != 0) {
                bl = findResult.hasIntersection;
            }
            if ((n2 & 2) != 0) {
                n = findResult.nearestOrIntersectedSegment;
            }
            return findResult.copy(bl, n);
        }

        @NotNull
        public String toString() {
            return "FindResult(hasIntersection=" + this.hasIntersection + ", nearestOrIntersectedSegment=" + this.nearestOrIntersectedSegment + ")";
        }

        public int hashCode() {
            int result2 = Boolean.hashCode(this.hasIntersection);
            result2 = result2 * 31 + Integer.hashCode(this.nearestOrIntersectedSegment);
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof FindResult)) {
                return false;
            }
            FindResult findResult = (FindResult)other;
            if (this.hasIntersection != findResult.hasIntersection) {
                return false;
            }
            return this.nearestOrIntersectedSegment == findResult.nearestOrIntersectedSegment;
        }
    }
}

