/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.editorActions;

import com.intellij.ide.IdeEventQueue;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CustomizedDataContext;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.DataKey;
import com.intellij.openapi.actionSystem.DataSink;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Caret;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorModificationUtil;
import com.intellij.openapi.editor.actionSystem.EditorActionHandler;
import com.intellij.openapi.editor.actionSystem.EditorTextInsertHandler;
import com.intellij.openapi.editor.actions.PasteAction;
import com.intellij.openapi.project.Project;
import com.intellij.util.Producer;
import com.jetbrains.rd.util.reactive.BoolPropertyExKt;
import com.jetbrains.rd.util.reactive.IOptPropertyView;
import com.jetbrains.rdclient.actions.ActionCallPolicy;
import com.jetbrains.rdclient.actions.ActionCallStrategy;
import com.jetbrains.rdclient.actions.base.BackendActionDelegationKt;
import com.jetbrains.rdclient.patches.PatchEngineRegistryKt;
import com.jetbrains.rdclient.services.IdeBackend;
import com.jetbrains.rdclient.util.idea.EditorUtilKt;
import com.jetbrains.rider.editorActions.TypingSessions;
import com.jetbrains.rider.util.idea.RiderDocumnetUtilKt;
import java.awt.datatransfer.Transferable;
import java.awt.dnd.DropTargetEvent;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\u0018\u0000 \u00162\u00020\u00012\u00020\u0002:\u0001\u0016B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J\"\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0014J*\u0010\u0010\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u000e\u001a\u00020\u000f2\u0010\u0010\u0011\u001a\f\u0012\u0006\b\u0001\u0012\u00020\u0013\u0018\u00010\u0012H\u0016J\u001a\u0010\u0014\u001a\u00020\u00152\u0006\u0010\n\u001a\u00020\u000b2\b\u0010\u000e\u001a\u0004\u0018\u00010\u000fH\u0002R\u0011\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0017"}, d2={"Lcom/jetbrains/rider/editorActions/RiderEditorPasteHandler;", "Lcom/intellij/openapi/editor/actionSystem/EditorTextInsertHandler;", "Lcom/intellij/openapi/editor/actionSystem/EditorActionHandler;", "baseHandler", "<init>", "(Lcom/intellij/openapi/editor/actionSystem/EditorActionHandler;)V", "getBaseHandler", "()Lcom/intellij/openapi/editor/actionSystem/EditorActionHandler;", "doExecute", "", "editor", "Lcom/intellij/openapi/editor/Editor;", "caret", "Lcom/intellij/openapi/editor/Caret;", "dataContext", "Lcom/intellij/openapi/actionSystem/DataContext;", "execute", "producer", "Lcom/intellij/util/Producer;", "Ljava/awt/datatransfer/Transferable;", "shouldUseFrontendHandler", "", "Companion", "intellij.rider.rdclient.dotnet"})
@SourceDebugExtension(value={"SMAP\nRiderEditorPasteHandler.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RiderEditorPasteHandler.kt\ncom/jetbrains/rider/editorActions/RiderEditorPasteHandler\n+ 2 Logger.kt\ncom/jetbrains/rd/platform/util/LoggerKt\n+ 3 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,83:1\n13#2:84\n13#3:85\n*S KotlinDebug\n*F\n+ 1 RiderEditorPasteHandler.kt\ncom/jetbrains/rider/editorActions/RiderEditorPasteHandler\n*L\n31#1:84\n31#1:85\n*E\n"})
public final class RiderEditorPasteHandler
extends EditorActionHandler
implements EditorTextInsertHandler {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final EditorActionHandler baseHandler;
    @NotNull
    private static final Logger logger;

    public RiderEditorPasteHandler(@NotNull EditorActionHandler baseHandler) {
        Intrinsics.checkNotNullParameter((Object)baseHandler, (String)"baseHandler");
        this.baseHandler = baseHandler;
    }

    @NotNull
    public final EditorActionHandler getBaseHandler() {
        return this.baseHandler;
    }

    protected void doExecute(@NotNull Editor editor, @Nullable Caret caret, @NotNull DataContext dataContext) {
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)dataContext, (String)"dataContext");
        this.execute(editor, dataContext, null);
    }

    public void execute(@NotNull Editor editor, @NotNull DataContext dataContext, @Nullable Producer<? extends Transferable> producer) {
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)dataContext, (String)"dataContext");
        if (this.shouldUseFrontendHandler(editor, dataContext)) {
            logger.info("Executing IDEA EditorPaste handler");
            EditorActionHandler editorActionHandler = this.baseHandler;
            Intrinsics.checkNotNull((Object)editorActionHandler, (String)"null cannot be cast to non-null type com.intellij.openapi.editor.actionSystem.EditorTextInsertHandler");
            ((EditorTextInsertHandler)editorActionHandler).execute(editor, dataContext, producer);
        } else {
            Transferable transferable = EditorModificationUtil.getContentsToPasteToEditor(producer);
            if (transferable == null) {
                return;
            }
            Transferable transferable2 = transferable;
            if (!EditorModificationUtil.checkModificationAllowed((Editor)editor)) {
                return;
            }
            if (!EditorModificationUtil.requestWriting((Editor)editor)) {
                return;
            }
            DataContext dataContext2 = CustomizedDataContext.withSnapshot((DataContext)dataContext, arg_0 -> RiderEditorPasteHandler.execute$lambda$0(transferable2, arg_0));
            Intrinsics.checkNotNullExpressionValue((Object)dataContext2, (String)"withSnapshot(...)");
            DataContext context = dataContext2;
            Project project = editor.getProject();
            if (project != null && TypingSessions.Companion.isEnabled(project)) {
                TypingSessions.Companion.getInstance(project).executeTypedAction("EditorPaste", editor, context, (Function0<Unit>)((Function0)() -> RiderEditorPasteHandler.execute$lambda$1(this, editor, dataContext, producer)));
            } else {
                logger.info("Executing ReSharper EditorPaste handler");
                AnActionEvent anActionEvent = AnActionEvent.createFromDataContext((String)"unknown", null, (DataContext)context);
                Intrinsics.checkNotNullExpressionValue((Object)anActionEvent, (String)"createFromDataContext(...)");
                AnActionEvent event = anActionEvent;
                BackendActionDelegationKt.backendActionPerformed("EditorPaste", event);
            }
        }
    }

    private final boolean shouldUseFrontendHandler(Editor editor, DataContext dataContext) {
        if (dataContext == null) {
            return true;
        }
        if (PatchEngineRegistryKt.isPatchEngineEnabled()) {
            return true;
        }
        Project project = editor.getProject();
        if (project == null) {
            return true;
        }
        Project project2 = project;
        IdeBackend backend = IdeBackend.Companion.tryGetInstance(project2);
        if (backend != null && !BoolPropertyExKt.getHasTrueValue((IOptPropertyView)((IOptPropertyView)backend.getSolution().getSolutionLifecycle().isReadyForTyping()))) {
            return true;
        }
        ActionCallStrategy strategy2 = ActionCallPolicy.Companion.getInstance().getActionCallStrategy(dataContext, "TextControl.Paste");
        if (strategy2.isFrontendInvolved()) {
            return true;
        }
        if (IdeEventQueue.Companion.getInstance().getTrueCurrentEvent() instanceof DropTargetEvent) {
            return true;
        }
        if (EditorUtilKt.hasMultipleEditPoints(editor)) {
            return true;
        }
        return !RiderDocumnetUtilKt.isRealDocument(editor);
    }

    private static final void execute$lambda$0(Transferable $transferable, DataSink sink) {
        Intrinsics.checkNotNullParameter((Object)sink, (String)"sink");
        DataKey dataKey = PasteAction.TRANSFERABLE_PROVIDER;
        Intrinsics.checkNotNullExpressionValue((Object)dataKey, (String)"TRANSFERABLE_PROVIDER");
        sink.set(dataKey, () -> RiderEditorPasteHandler.execute$lambda$0$0($transferable));
    }

    private static final Transferable execute$lambda$0$0(Transferable $transferable) {
        return $transferable;
    }

    private static final Unit execute$lambda$1(RiderEditorPasteHandler this$0, Editor $editor, DataContext $dataContext, Producer $producer) {
        logger.info("Executing IDEA EditorPaste handler");
        EditorActionHandler editorActionHandler = this$0.baseHandler;
        Intrinsics.checkNotNull((Object)editorActionHandler, (String)"null cannot be cast to non-null type com.intellij.openapi.editor.actionSystem.EditorTextInsertHandler");
        ((EditorTextInsertHandler)editorActionHandler).execute($editor, $dataContext, $producer);
        return Unit.INSTANCE;
    }

    static {
        boolean $i$f$getLogger = false;
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(RiderEditorPasteHandler.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        RiderEditorPasteHandler.logger = logger;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/jetbrains/rider/editorActions/RiderEditorPasteHandler$Companion;", "", "<init>", "()V", "logger", "Lcom/intellij/openapi/diagnostic/Logger;", "intellij.rider.rdclient.dotnet"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

