/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.editorActions;

import com.intellij.lang.Language;
import com.intellij.openapi.actionSystem.ActionPlaces;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.client.ClientAppSession;
import com.intellij.openapi.command.impl.ResetUndoHistoryToken;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.diagnostic.LoggerKt;
import com.intellij.openapi.editor.Caret;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorCopyPasteHelper;
import com.intellij.openapi.editor.LogicalPosition;
import com.intellij.openapi.editor.VisualPosition;
import com.intellij.openapi.editor.impl.CopiedFromEmptySelectionPasteMode;
import com.intellij.openapi.editor.impl.EditorCopyPasteHelperImpl;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.ide.CopyPasteManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.util.PsiUtilBase;
import com.jetbrains.rd.ide.model.RdPatch;
import com.jetbrains.rd.ide.model.TextControlId;
import com.jetbrains.rd.ide.requests.ChangeScope;
import com.jetbrains.rd.ide.requests.PatchEngine;
import com.jetbrains.rd.ide.requests.RdPatchEngine;
import com.jetbrains.rd.lang.ProtocolLanguageManager;
import com.jetbrains.rdclient.editorActions.cwm.EditorActionCommandInfo;
import com.jetbrains.rdclient.editorActions.cwm.FrontendAsyncEditorActionHandler;
import com.jetbrains.rdclient.editorActions.cwm.FrontendCallEditorActionRequest;
import com.jetbrains.rdclient.editorActions.cwm.PhantomCallEditorActionRequest;
import com.jetbrains.rdclient.patches.FrontendPatchEngineHost;
import com.jetbrains.rdclient.requests.FrontendApplyPatchRequest;
import com.jetbrains.rdclient.requests.FrontendAsyncRequest;
import com.jetbrains.rdclient.requests.FrontendAsyncRequestWithImmediateResultKt;
import com.jetbrains.rdclient.requests.FrontendSpeculativeRequestRecordingListener;
import com.jetbrains.rider.editorActions.RiderEditorActionPolicy;
import com.jetbrains.rider.editorActions.RiderPatchEngineBackendIsFrozenTracker;
import com.jetbrains.rider.editorActions.RiderWritingAccessProviderKt;
import com.jetbrains.rider.rdclient.languages.assists.UtilsKt;
import java.awt.datatransfer.Transferable;
import java.lang.invoke.MethodHandles;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jdk7.AutoCloseableKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005JB\u0010\u000b\u001a\u0004\u0018\u00010\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\b2\b\u0010\u0012\u001a\u0004\u0018\u00010\u00132\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00160\u00152\u0006\u0010\u0017\u001a\u00020\u0018H\u0016J\u0018\u0010\u0019\u001a\u00020\u00162\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u001a\u001a\u00020\u001bH\u0002J2\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\r\u001a\u00020\u000e2\b\u0010\u0012\u001a\u0004\u0018\u00010\u00132\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u001c\u001a\u00020\b2\u0006\u0010\u001d\u001a\u00020\u001bH\u0002J\u0010\u0010\u001e\u001a\u00020\u001b2\u0006\u0010\r\u001a\u00020\u000eH\u0002J\b\u0010\u001d\u001a\u00020\u001bH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u001f"}, d2={"Lcom/jetbrains/rider/editorActions/RiderCallEditorActionRequestFactory;", "Lcom/jetbrains/rdclient/editorActions/cwm/FrontendAsyncEditorActionHandler$CallEditorActionRequestFactory;", "session", "Lcom/intellij/openapi/client/ClientAppSession;", "<init>", "(Lcom/intellij/openapi/client/ClientAppSession;)V", "speculativeExecutionNotAllowed", "", "", "getSpeculativeExecutionNotAllowed", "()Ljava/util/List;", "createRequest", "Lcom/jetbrains/rdclient/requests/FrontendAsyncRequest;", "editor", "Lcom/intellij/openapi/editor/Editor;", "editorId", "Lcom/jetbrains/rd/ide/model/TextControlId;", "frontendActionId", "caret", "Lcom/intellij/openapi/editor/Caret;", "executeFrontend", "Lkotlin/Function0;", "", "dataContext", "Lcom/intellij/openapi/actionSystem/DataContext;", "resetEditorActionFrontendExecutionMarkers", "shouldExecuteLocally", "", "actionId", "isBackendFrozen", "shouldExecutePasteEditorActionLocally", "intellij.rider.rdclient.dotnet"})
@SourceDebugExtension(value={"SMAP\nRiderCallEditorActionRequestFactory.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RiderCallEditorActionRequestFactory.kt\ncom/jetbrains/rider/editorActions/RiderCallEditorActionRequestFactory\n+ 2 PatchEngine.kt\ncom/jetbrains/rd/ide/requests/PatchEngineKt\n+ 3 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,162:1\n50#2,7:163\n57#2,2:175\n59#2,6:178\n65#2,2:185\n57#3:170\n35#3,2:171\n82#3,2:173\n84#3:177\n23#3:184\n*S KotlinDebug\n*F\n+ 1 RiderCallEditorActionRequestFactory.kt\ncom/jetbrains/rider/editorActions/RiderCallEditorActionRequestFactory\n*L\n80#1:163,7\n80#1:175,2\n80#1:178,6\n80#1:185,2\n80#1:170\n80#1:171,2\n80#1:173,2\n80#1:177\n80#1:184\n*E\n"})
public final class RiderCallEditorActionRequestFactory
implements FrontendAsyncEditorActionHandler.CallEditorActionRequestFactory {
    @NotNull
    private final ClientAppSession session;
    @NotNull
    private final List<String> speculativeExecutionNotAllowed;

    public RiderCallEditorActionRequestFactory(@NotNull ClientAppSession session2) {
        Intrinsics.checkNotNullParameter((Object)session2, (String)"session");
        this.session = session2;
        Object[] objectArray = new String[]{"EditorCodeBlockStart", "EditorCodeBlockEnd", "EditorCodeBlockStartWithSelection", "EditorCodeBlockEndWithSelection", "EditorStartNewLineBefore", "EditorSelectWord", "EditorUnSelectWord", "MoveStatementUp", "MoveStatementDown", "MoveElementLeft", "MoveElementRight", "EditorIndentSelection", "EditorUnindentSelection", "CommentByLineComment", "CommentByBlockComment"};
        this.speculativeExecutionNotAllowed = CollectionsKt.listOf((Object[])objectArray);
    }

    @NotNull
    public final List<String> getSpeculativeExecutionNotAllowed() {
        return this.speculativeExecutionNotAllowed;
    }

    @Override
    @Nullable
    public FrontendAsyncRequest createRequest(@NotNull Editor editor, @NotNull TextControlId editorId, @NotNull String frontendActionId, @Nullable Caret caret, @NotNull Function0<Unit> executeFrontend, @NotNull DataContext dataContext) {
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)editorId, (String)"editorId");
        Intrinsics.checkNotNullParameter((Object)frontendActionId, (String)"frontendActionId");
        Intrinsics.checkNotNullParameter(executeFrontend, (String)"executeFrontend");
        Intrinsics.checkNotNullParameter((Object)dataContext, (String)"dataContext");
        Caret caret2 = editor.getCaretModel().getPrimaryCaret();
        Intrinsics.checkNotNullExpressionValue((Object)caret2, (String)"getPrimaryCaret(...)");
        Caret oldCaret = caret2;
        int oldCaretOffset = oldCaret.getOffset();
        LogicalPosition logicalPosition = oldCaret.getLogicalPosition();
        Intrinsics.checkNotNullExpressionValue((Object)logicalPosition, (String)"getLogicalPosition(...)");
        LogicalPosition oldCaretLogicalPosition = logicalPosition;
        VisualPosition visualPosition = oldCaret.getVisualPosition();
        Intrinsics.checkNotNullExpressionValue((Object)visualPosition, (String)"getVisualPosition(...)");
        VisualPosition oldCaretVisualPosition = visualPosition;
        int beforeTextLength = editor.getDocument().getTextLength();
        ResetUndoHistoryToken resetUndoHistoryToken = FrontendAsyncRequestWithImmediateResultKt.createResetUndoHistoryToken(editor);
        Project project = editor.getProject();
        boolean isBackendFrozen = this.isBackendFrozen();
        boolean shouldExecuteLocally = this.shouldExecuteLocally(editor, caret, dataContext, frontendActionId, isBackendFrozen);
        if (!shouldExecuteLocally && project != null && this.speculativeExecutionNotAllowed.contains(frontendActionId)) {
            Language language;
            boolean selectWordAtCaretByClick;
            boolean bl = selectWordAtCaretByClick = Intrinsics.areEqual((Object)frontendActionId, (Object)"EditorSelectWord") && !editor.getCaretModel().getPrimaryCaret().hasSelection();
            if (!selectWordAtCaretByClick && (language = PsiUtilBase.getLanguageInEditor((Editor)editor, (Project)project)) != null) {
                ProtocolLanguageManager protocolLanguageManager = ProtocolLanguageManager.Companion.getInstance();
                boolean bl2 = protocolLanguageManager != null ? protocolLanguageManager.isProtocolLanguage(language) : false;
                if (bl2) {
                    return new PhantomCallEditorActionRequest(frontendActionId, editorId, null);
                }
            }
        }
        this.resetEditorActionFrontendExecutionMarkers(editor, shouldExecuteLocally);
        Pair pair = EditorActionCommandInfo.Companion.capture(() -> RiderCallEditorActionRequestFactory.createRequest$lambda$0(this, executeFrontend));
        RdPatch patch = (RdPatch)pair.component1();
        EditorActionCommandInfo info = (EditorActionCommandInfo)pair.component2();
        if (!shouldExecuteLocally) {
            boolean handlerForcedExecutionOnFrontend;
            VirtualFile file = FileDocumentManager.getInstance().getFile(editor.getDocument());
            boolean isReadonlyFile = !editor.getDocument().isWritable() || file != null && Intrinsics.areEqual((Object)file.getUserData(RiderWritingAccessProviderKt.getREADONLY_FILE_KEY()), (Object)true);
            shouldExecuteLocally = handlerForcedExecutionOnFrontend = Intrinsics.areEqual((Object)editor.getUserData(UtilsKt.getEXECUTE_ON_FRONTEND()), (Object)true) || isReadonlyFile;
        }
        if (patch == null) {
            if (shouldExecuteLocally) {
                return null;
            }
            return new PhantomCallEditorActionRequest(frontendActionId, editorId, info);
        }
        if (shouldExecuteLocally) {
            return new FrontendApplyPatchRequest(patch, this.session, resetUndoHistoryToken);
        }
        Caret caret3 = editor.getCaretModel().getPrimaryCaret();
        Intrinsics.checkNotNullExpressionValue((Object)caret3, (String)"getPrimaryCaret(...)");
        Caret newCaret = caret3;
        int newCaretOffset = editor.getCaretModel().getPrimaryCaret().getOffset();
        boolean offsetChanged = oldCaretOffset != newCaretOffset;
        LogicalPosition logicalPosition2 = newCaret.getLogicalPosition();
        Intrinsics.checkNotNullExpressionValue((Object)logicalPosition2, (String)"getLogicalPosition(...)");
        LogicalPosition newCaretLogicalPosition = logicalPosition2;
        VisualPosition visualPosition2 = newCaret.getVisualPosition();
        Intrinsics.checkNotNullExpressionValue((Object)visualPosition2, (String)"getVisualPosition(...)");
        VisualPosition newCaretVisualPosition = visualPosition2;
        int afterTextLength = editor.getDocument().getTextLength();
        boolean logicalPositionChanged = !Intrinsics.areEqual((Object)oldCaretLogicalPosition, (Object)newCaretLogicalPosition);
        boolean documentChanged2 = beforeTextLength != afterTextLength;
        boolean visualPositionChanged = !Intrinsics.areEqual((Object)oldCaretVisualPosition, (Object)newCaretVisualPosition);
        boolean documentAndCaretOffsetUnchanged = (logicalPositionChanged || visualPositionChanged) && !documentChanged2 && !offsetChanged;
        return documentAndCaretOffsetUnchanged ? (FrontendAsyncRequest)new FrontendApplyPatchRequest(patch, this.session, resetUndoHistoryToken) : (FrontendAsyncRequest)new FrontendCallEditorActionRequest(patch, editorId, frontendActionId, this.session, resetUndoHistoryToken, info);
    }

    private final void resetEditorActionFrontendExecutionMarkers(Editor editor, boolean shouldExecuteLocally) {
        editor.putUserData(UtilsKt.getEXECUTE_ON_FRONTEND(), (Object)shouldExecuteLocally);
        editor.putUserData(RiderWritingAccessProviderKt.getREADONLY_FILE_KEY(), null);
    }

    private final boolean shouldExecuteLocally(Editor editor, Caret caret, DataContext dataContext, String actionId, boolean isBackendFrozen) {
        boolean forceLocalExecutionByLanguage;
        Project project;
        boolean isMultiCaret = editor.getCaretModel().getCaretCount() > 1;
        boolean forceLocalExecution = Intrinsics.areEqual((Object)editor.getUserData(ActionPlaces.EXECUTE_EDITOR_ACTION_ON_FRONTEND), (Object)true);
        if (isMultiCaret || forceLocalExecution || isBackendFrozen) {
            return true;
        }
        Project project2 = project = editor.getProject();
        Language language = project2 != null ? PsiUtilBase.getLanguageInEditor((Editor)editor, (Project)project2) : null;
        boolean bl = forceLocalExecutionByLanguage = language != null && RiderEditorActionPolicy.Companion.forceFrontendExecutionFor(language);
        if (forceLocalExecutionByLanguage) {
            return true;
        }
        return switch (actionId) {
            case "EditorPaste" -> this.shouldExecutePasteEditorActionLocally(editor);
            case "EditorLeft" -> true;
            case "EditorRight" -> true;
            default -> false;
        };
    }

    private final boolean shouldExecutePasteEditorActionLocally(Editor editor) {
        Transferable content = CopyPasteManager.getInstance().getContents();
        if (content == null) {
            return false;
        }
        EditorCopyPasteHelper.CopyPasteOptions copyPasteOptions = EditorCopyPasteHelperImpl.CopyPasteOptionsTransferableData.valueFromTransferable((Transferable)content);
        Intrinsics.checkNotNullExpressionValue((Object)copyPasteOptions, (String)"valueFromTransferable(...)");
        EditorCopyPasteHelper.CopyPasteOptions copyPasteOptions2 = copyPasteOptions;
        boolean copiedFromEmptySelection = copyPasteOptions2.isCopiedFromEmptySelection();
        CopiedFromEmptySelectionPasteMode copiedFromEmptySelectionPasteMode = copiedFromEmptySelection ? EditorCopyPasteHelperImpl.getCopiedFromEmptySelectionPasteMode() : CopiedFromEmptySelectionPasteMode.AT_CARET;
        Intrinsics.checkNotNull((Object)copiedFromEmptySelectionPasteMode);
        CopiedFromEmptySelectionPasteMode pasteMode = copiedFromEmptySelectionPasteMode;
        boolean isInsertingEntireLineAboveCaret = pasteMode == CopiedFromEmptySelectionPasteMode.ENTIRE_LINE_ABOVE_CARET && !editor.getSelectionModel().hasSelection();
        return isInsertingEntireLineAboveCaret;
    }

    private final boolean isBackendFrozen() {
        return RiderPatchEngineBackendIsFrozenTracker.Companion.getInstance(this.session).isBackendFrozen();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private static final RdPatch createRequest$lambda$0(RiderCallEditorActionRequestFactory this$0, Function0 $executeFrontend) {
        RdPatch rdPatch;
        void $this$recordChanges$iv;
        PatchEngine patchEngine = (PatchEngine)FrontendPatchEngineHost.Companion.getInstance(this$0.session).getEngine();
        String description$iv = "RiderCallEditorActionRequestFactory::createRequest";
        boolean $i$f$recordChanges = false;
        $this$recordChanges$iv.softAssertThereIsNoActivePatch("recordChanges must no be called under another patch, because it leads to recording and  sending the same patch multiple times");
        boolean alreadyOpened$iv = $this$recordChanges$iv.getHasActivePatch();
        try {
            RdPatch rdPatch2;
            AutoCloseable autoCloseable = (AutoCloseable)PatchEngine.openAccumulatingSession$default((PatchEngine)$this$recordChanges$iv, (boolean)false, (String)description$iv, null, (int)4, null);
            Throwable throwable = null;
            try {
                Object object;
                void $this$runAndLogException$iv$iv;
                RdPatchEngine.ChangeAccumulatingSessionToken it$iv = (RdPatchEngine.ChangeAccumulatingSessionToken)autoCloseable;
                boolean bl5 = false;
                boolean $i$f$fileLogger22 = false;
                boolean $i$f$currentClassLogger = false;
                Class<?> clazz$iv$iv$iv = MethodHandles.lookup().lookupClass();
                Logger logger = Logger.getInstance(clazz$iv$iv$iv);
                Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
                Logger $i$f$fileLogger22 = logger;
                boolean $i$f$runAndLogException = false;
                void var12_18 = $this$runAndLogException$iv$iv;
                try {
                    void $this$runAndLogException_u24lambda_u240$iv$iv = var12_18;
                    boolean bl2 = false;
                    boolean bl3 = false;
                    ChangeScope $this$createRequest_u24lambda_u240_u240 = it$iv.getSession().getChangeScope();
                    boolean bl4 = false;
                    FrontendSpeculativeRequestRecordingListener.Companion.withListener(this$0.session, () -> RiderCallEditorActionRequestFactory.createRequest$lambda$0$0$0($executeFrontend));
                    object = Result.constructor-impl((Object)Unit.INSTANCE);
                }
                catch (Throwable throwable2) {
                    object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable2));
                }
                LoggerKt.getOrLogException((Object)object, (Logger)$this$runAndLogException$iv$iv);
                rdPatch2 = it$iv.getSession().buildPatchAndClear();
            }
            catch (Throwable bl5) {
                try {
                    throwable = bl5;
                    throw bl5;
                }
                catch (Throwable bl5) {
                    AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable, throwable);
                    throw bl5;
                }
            }
            AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable, (Throwable)throwable);
            rdPatch = rdPatch2;
        }
        finally {
            if (!alreadyOpened$iv && $this$recordChanges$iv.getHasActivePatch()) {
                void $this$thisLogger$iv$iv = $this$recordChanges$iv;
                boolean $i$f$thisLogger = false;
                Logger logger = Logger.getInstance(PatchEngine.class);
                Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
                logger.error("There are unclosed accumulating sessions after recordChanges. Close them forcibly");
                while ($this$recordChanges$iv.getHasActivePatch()) {
                    $this$recordChanges$iv.closeCurrentSession("Wrong dispose ordering: " + description$iv);
                }
            }
        }
        return rdPatch;
    }

    private static final Unit createRequest$lambda$0$0$0(Function0 $executeFrontend) {
        $executeFrontend.invoke();
        return Unit.INSTANCE;
    }
}

