/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.ea;

import com.intellij.ide.troubleshooting.CompositeGeneralTroubleInfoCollector;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.troubleshooting.TroubleInfoCollector;
import java.io.BufferedOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.LinkOption;
import java.time.Duration;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import kotlin.Metadata;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.io.CloseableKt;
import kotlin.io.FilesKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import org.apache.commons.compress.archivers.tar.TarArchiveEntry;
import org.apache.commons.compress.archivers.tar.TarArchiveOutputStream;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.tukaani.xz.FilterOptions;
import org.tukaani.xz.LZMA2Options;
import org.tukaani.xz.XZOutputStream;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0002J0\u0010\n\u001a\u00020\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\r2\u0006\u0010\u000e\u001a\u00020\u000b2\u0006\u0010\b\u001a\u00020\t2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u0010H\u0007J\u0018\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u000b2\u0006\u0010\u0015\u001a\u00020\u000bH\u0002J \u0010\u0016\u001a\u00020\u00112\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\t2\u0006\u0010\u001a\u001a\u00020\u001bH\u0002J \u0010\u001c\u001a\u00020\u00112\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u001d\u001a\u00020\t2\u0006\u0010\u001a\u001a\u00020\u001bH\u0002J\u001a\u0010\u001e\u001a\n\u0018\u00010\u001fj\u0004\u0018\u0001` 2\b\u0010\f\u001a\u0004\u0018\u00010\rH\u0002J\u0010\u0010!\u001a\u00020\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\rR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\""}, d2={"Lcom/jetbrains/rider/ea/LogPacker;", "", "<init>", "()V", "logger", "Lcom/intellij/openapi/diagnostic/Logger;", "getFileTooHugeMessageBytes", "", "maxSizeToCopy", "", "packLogsImpl", "Ljava/io/File;", "project", "Lcom/intellij/openapi/project/Project;", "logsDirectory", "checkForInterrupt", "Lkotlin/Function0;", "", "copyFileSafely", "", "logFile", "logFileCopy", "writeBytesToTar", "raf", "Ljava/io/RandomAccessFile;", "bytesToWrite", "tar", "Lorg/apache/commons/compress/archivers/tar/TarArchiveOutputStream;", "writeToTar", "position", "collectTroubleshootingInfo", "Ljava/lang/StringBuilder;", "Lkotlin/text/StringBuilder;", "packLogs", "intellij.rider.rdclient.dotnet"})
@SourceDebugExtension(value={"SMAP\nLogPacker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LogPacker.kt\ncom/jetbrains/rider/ea/LogPacker\n+ 2 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 5 Logger.kt\ncom/jetbrains/rd/platform/util/LoggerKt\n+ 6 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,178:1\n1321#2:179\n1322#2:184\n1#3:180\n1761#4,3:181\n13#5:185\n13#6:186\n*S KotlinDebug\n*F\n+ 1 LogPacker.kt\ncom/jetbrains/rider/ea/LogPacker\n*L\n50#1:179\n50#1:184\n58#1:181,3\n25#1:185\n25#1:186\n*E\n"})
public final class LogPacker {
    @NotNull
    public static final LogPacker INSTANCE = new LogPacker();
    @NotNull
    private static final Logger logger;

    private LogPacker() {
    }

    private final byte[] getFileTooHugeMessageBytes(long maxSizeToCopy) {
        String string = "\n-----------------------------------------------------------------------\nLog file is truncated, showing only first and last " + maxSizeToCopy / (long)2 / (long)1024 / (long)1024 + " megabytes.\nIn order to access full log please use 'Collect Logs' action and attach it manually.\n-----------------------------------------------------------------------\n";
        byte[] byArray = string.getBytes(Charsets.UTF_8);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"getBytes(...)");
        return byArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ApiStatus.Internal
    @NotNull
    public final File packLogsImpl(@Nullable Project project, @NotNull File logsDirectory, long maxSizeToCopy, @NotNull Function0<Unit> checkForInterrupt) {
        Intrinsics.checkNotNullParameter((Object)logsDirectory, (String)"logsDirectory");
        Intrinsics.checkNotNullParameter(checkForInterrupt, (String)"checkForInterrupt");
        long currentTimeMillis = System.currentTimeMillis();
        File file = FileUtil.createTempFile((String)"rider-logs-attachment", (String)".tar.xz", (boolean)true);
        Intrinsics.checkNotNullExpressionValue((Object)file, (String)"createTempFile(...)");
        File logsFile = file;
        logsFile.deleteOnExit();
        byte[] fileTooHugeMessageBytes = this.getFileTooHugeMessageBytes(maxSizeToCopy);
        Closeable closeable = new FileOutputStream(logsFile);
        int n = 153600;
        closeable = closeable instanceof BufferedOutputStream ? (BufferedOutputStream)closeable : new BufferedOutputStream((OutputStream)closeable, n);
        Throwable throwable = null;
        try {
            BufferedOutputStream stream = (BufferedOutputStream)closeable;
            boolean bl = false;
            Closeable closeable2 = (Closeable)new TarArchiveOutputStream((OutputStream)new XZOutputStream((OutputStream)stream, (FilterOptions)new LZMA2Options(2)));
            Throwable throwable2 = null;
            try {
                TarArchiveOutputStream tar = (TarArchiveOutputStream)closeable2;
                boolean bl2 = false;
                tar.setLongFileMode(3);
                Object[] objectArray = new String[]{".txt", ".log", ".err", ".out", ".tdump"};
                List logExtensions = CollectionsKt.listOf((Object[])objectArray);
                Sequence $this$forEach$iv = (Sequence)FilesKt.walk$default((File)logsDirectory, null, (int)1, null);
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    File logFileCopy;
                    Duration fileAge;
                    boolean bl3;
                    File logFile;
                    block29: {
                        File resolvedLogFile;
                        Object $this$packLogsImpl_u24lambda_u240_u240_u240_u240;
                        logFile = (File)element$iv;
                        boolean bl4 = false;
                        checkForInterrupt.invoke();
                        Logger logger = LogPacker.logger;
                        try {
                            $this$packLogsImpl_u24lambda_u240_u240_u240_u240 = logger;
                            boolean bl5 = false;
                            $this$packLogsImpl_u24lambda_u240_u240_u240_u240 = Result.constructor-impl((Object)logFile.toPath().toRealPath(new LinkOption[0]).toFile());
                        }
                        catch (Throwable bl5) {
                            $this$packLogsImpl_u24lambda_u240_u240_u240_u240 = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)bl5));
                        }
                        if ((File)(Result.isFailure-impl((Object)(logger = $this$packLogsImpl_u24lambda_u240_u240_u240_u240)) ? null : logger) == null || !FileUtil.isAncestor((File)logsDirectory, (File)resolvedLogFile, (boolean)true) || !logFile.isFile()) continue;
                        Iterable $this$any$iv = logExtensions;
                        boolean $i$f$any = false;
                        if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                            bl3 = false;
                        } else {
                            for (Object element$iv2 : $this$any$iv) {
                                String it = (String)element$iv2;
                                boolean bl6 = false;
                                String string = logFile.getName();
                                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
                                if (!StringsKt.endsWith((String)string, (String)it, (boolean)true)) continue;
                                bl3 = true;
                                break block29;
                            }
                            bl3 = false;
                        }
                    }
                    if (!bl3 || (fileAge = Duration.ofMillis(currentTimeMillis - logFile.lastModified())).compareTo(Duration.ofDays(1L)) > 0) continue;
                    Intrinsics.checkNotNullExpressionValue((Object)FileUtil.createTempFile((String)logFile.getName(), (String)".tmp"), (String)"createTempFile(...)");
                    try {
                        if (!INSTANCE.copyFileSafely(logFile, logFileCopy)) {
                            continue;
                        }
                        TarArchiveEntry entry2 = new TarArchiveEntry(FilesKt.toRelativeString((File)logFile, (File)logsDirectory));
                        entry2.setModTime(logFile.lastModified() / (long)1000);
                        entry2.setSize(logFileCopy.length() <= maxSizeToCopy ? logFileCopy.length() : maxSizeToCopy + (long)fileTooHugeMessageBytes.length);
                        tar.putArchiveEntry(entry2);
                        Closeable closeable3 = new RandomAccessFile(logFileCopy, "r");
                        Throwable throwable3 = null;
                        try {
                            RandomAccessFile raf = (RandomAccessFile)closeable3;
                            boolean bl7 = false;
                            if (raf.length() <= maxSizeToCopy) {
                                INSTANCE.writeToTar(raf, 0L, tar);
                            } else {
                                long headSize = maxSizeToCopy / (long)2;
                                long tailSize = maxSizeToCopy - headSize;
                                INSTANCE.writeBytesToTar(raf, headSize, tar);
                                tar.write(fileTooHugeMessageBytes, 0, fileTooHugeMessageBytes.length);
                                long tailStartOffset = Math.max(0L, raf.length() - tailSize);
                                INSTANCE.writeToTar(raf, tailStartOffset, tar);
                            }
                            Unit unit = Unit.INSTANCE;
                        }
                        catch (Throwable throwable4) {
                            throwable3 = throwable4;
                            throw throwable4;
                        }
                        finally {
                            CloseableKt.closeFinally((Closeable)closeable3, (Throwable)throwable3);
                        }
                        tar.closeArchiveEntry();
                    }
                    finally {
                        logFileCopy.delete();
                    }
                }
                StringBuilder troubleshooting = INSTANCE.collectTroubleshootingInfo(project);
                if (troubleshooting != null) {
                    String string = troubleshooting.toString();
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
                    String string2 = string;
                    Charset charset = StandardCharsets.UTF_8;
                    Intrinsics.checkNotNullExpressionValue((Object)charset, (String)"UTF_8");
                    byte[] byArray = string2.getBytes(charset);
                    Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"getBytes(...)");
                    byte[] troubleshootingBytes = byArray;
                    TarArchiveEntry entry3 = new TarArchiveEntry("troubleshooting.txt");
                    entry3.setModTime(new Date(System.currentTimeMillis()));
                    entry3.setSize((long)troubleshootingBytes.length);
                    tar.putArchiveEntry(entry3);
                    tar.write(troubleshootingBytes);
                    tar.closeArchiveEntry();
                }
                Unit unit = Unit.INSTANCE;
            }
            catch (Throwable throwable5) {
                throwable2 = throwable5;
                throw throwable5;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable2, (Throwable)throwable2);
            }
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable6) {
            throwable = throwable6;
            throw throwable6;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
        return logsFile;
    }

    private final boolean copyFileSafely(File logFile, File logFileCopy) {
        boolean bl;
        try {
            FileUtil.copyFileOrDir((File)logFile, (File)logFileCopy, (boolean)false);
            bl = true;
        }
        catch (Throwable t) {
            logger.warn(t);
            bl = false;
        }
        return bl;
    }

    private final void writeBytesToTar(RandomAccessFile raf, long bytesToWrite, TarArchiveOutputStream tar) {
        byte[] buffer = new byte[524288];
        int bytes = raf.read(buffer);
        long recorded = 0L;
        while (bytes >= 0 && recorded + (long)bytes < bytesToWrite) {
            tar.write(buffer, 0, bytes);
            recorded += (long)bytes;
            bytes = raf.read(buffer);
        }
        int toWrite = (int)Math.min((long)bytes, bytesToWrite - recorded);
        if (toWrite > 0) {
            tar.write(buffer, 0, toWrite);
        }
    }

    private final void writeToTar(RandomAccessFile raf, long position, TarArchiveOutputStream tar) {
        raf.seek(position);
        byte[] buffer = new byte[524288];
        int bytes = raf.read(buffer);
        while (bytes >= 0) {
            tar.write(buffer, 0, bytes);
            bytes = raf.read(buffer);
        }
    }

    private final StringBuilder collectTroubleshootingInfo(Project project) {
        StringBuilder settings = null;
        if (project != null) {
            settings = new StringBuilder();
            settings.append(new CompositeGeneralTroubleInfoCollector().collectInfo(project));
            for (TroubleInfoCollector troubleInfoCollector : (TroubleInfoCollector[])TroubleInfoCollector.EP_SETTINGS.getExtensions()) {
                settings.append(troubleInfoCollector.collectInfo(project)).append('\n');
            }
        }
        return settings;
    }

    @NotNull
    public final File packLogs(@Nullable Project project) {
        return this.packLogsImpl(project, new File(PathManager.getLogPath()), 0x2800000L, (Function0<Unit>)((Function0)LogPacker::packLogs$lambda$0));
    }

    private static final Unit packLogs$lambda$0() {
        ProgressManager.checkCanceled();
        return Unit.INSTANCE;
    }

    static {
        boolean $i$f$getLogger = false;
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(LogPacker.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LogPacker.logger = logger;
    }
}

