/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.document;

import com.intellij.openapi.client.ClientProjectSession;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.ServicesKt;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.newvfs.NewVirtualFile;
import com.jetbrains.rd.ide.model.RdApplyPatchRequest;
import com.jetbrains.rd.ide.model.RdPatch;
import com.jetbrains.rd.ide.model.RdPatchItem;
import com.jetbrains.rd.ide.model.RdProjectId;
import com.jetbrains.rd.ide.model.RdRequest;
import com.jetbrains.rd.platform.ProjectUtilKt;
import com.jetbrains.rd.platform.util.idea.LifetimedService;
import com.jetbrains.rd.protocol.SolutionExtListener;
import com.jetbrains.rd.util.lifetime.Lifetime;
import com.jetbrains.rd.util.reactive.Signal;
import com.jetbrains.rd.util.string.IPrintableKt;
import com.jetbrains.rd.util.threading.SchedulerUtilKt;
import com.jetbrains.rdclient.patches.PatchEngineRegistryKt;
import com.jetbrains.rdclient.requests.FrontendAsyncRequest;
import com.jetbrains.rdclient.requests.FrontendAsyncRequestExecutor;
import com.jetbrains.rdclient.requests.FrontendSimpleRequest;
import com.jetbrains.rider.model.DocumentClosedChange;
import com.jetbrains.rider.model.EditorClosedChange;
import com.jetbrains.rider.model.RdCreateDocumentIdRequest;
import com.jetbrains.rider.model.RdCreateDocumentIdResult;
import com.jetbrains.rider.model.RdFrontendDocumentId;
import com.jetbrains.rider.model.RdFrontendDocumentInfo;
import com.jetbrains.rider.model.RiderDocumentModel;
import com.jetbrains.rider.model.RiderDocumentModel_PregeneratedKt;
import com.jetbrains.rider.projectView.SolutionHostExtensionsKt;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.io.path.PathsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.coroutines.CoroutineDispatcher;
import kotlinx.coroutines.Dispatchers;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000p\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u000b\b\u0016\u0018\u0000 72\u00020\u0001:\u0005789:;B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u001f\u0010\u0019\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u001a\u001a\u00020\u001b2\b\u0010\u001c\u001a\u0004\u0018\u00010\u0014\u00a2\u0006\u0002\u0010\u001dJ5\u0010\u0019\u001a\u000e\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020\u001f0\u001e2\b\u0010 \u001a\u0004\u0018\u00010\u000e2\u0006\u0010!\u001a\u00020\u00122\b\u0010\u001c\u001a\u0004\u0018\u00010\u0014H\u0002\u00a2\u0006\u0002\u0010\"J\u001a\u0010#\u001a\u00020\u000f2\b\u0010 \u001a\u0004\u0018\u00010\u000e2\u0006\u0010!\u001a\u00020\u0012H\u0002J\u000e\u0010$\u001a\u00020%2\u0006\u0010&\u001a\u00020\u000fJ\u000e\u0010'\u001a\u00020(2\u0006\u0010&\u001a\u00020\u000fJ\u0010\u0010)\u001a\u0004\u0018\u00010(2\u0006\u0010&\u001a\u00020\u000fJ\u0016\u0010*\u001a\u00020%2\u0006\u0010&\u001a\u00020\u000f2\u0006\u0010!\u001a\u00020(J\u0015\u0010+\u001a\u0004\u0018\u00010\u00142\u0006\u0010&\u001a\u00020\u000f\u00a2\u0006\u0002\u0010,J\u001d\u0010-\u001a\u00020%2\u0006\u0010&\u001a\u00020\u000f2\b\u0010\u001c\u001a\u0004\u0018\u00010\u0014\u00a2\u0006\u0002\u0010.J$\u0010/\u001a\u00020%2\u0006\u0010&\u001a\u00020\u000f2\u0012\u00100\u001a\u000e\u0012\u0004\u0012\u00020\u001f\u0012\u0004\u0012\u00020\u001f01H\u0002J\u0018\u00102\u001a\u00020\u001f2\u0006\u0010&\u001a\u00020\u000f2\u0006\u00103\u001a\u00020\u001fH\u0014J\u0014\u00104\u001a\u00020\u001f*\u00020\u001f2\u0006\u0010!\u001a\u00020(H\u0002J\u001b\u00105\u001a\u00020\u001f*\u00020\u001f2\b\u0010\u001c\u001a\u0004\u0018\u00010\u0014H\u0002\u00a2\u0006\u0002\u00106R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R*\u0010\f\u001a\u001e\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u000f0\rj\u000e\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u000f`\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R*\u0010\u0011\u001a\u001e\u0012\u0004\u0012\u00020\u0012\u0012\u0004\u0012\u00020\u000f0\rj\u000e\u0012\u0004\u0012\u00020\u0012\u0012\u0004\u0012\u00020\u000f`\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0014X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0017\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u000f0\u0016\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018\u00a8\u0006<"}, d2={"Lcom/jetbrains/rider/document/RiderDocumentBindingService;", "Lcom/jetbrains/rd/platform/util/idea/LifetimedService;", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/openapi/project/Project;)V", "getProject", "()Lcom/intellij/openapi/project/Project;", "model", "Lcom/jetbrains/rider/model/RiderDocumentModel;", "locker", "", "virtualFileToIdMap", "Ljava/util/HashMap;", "Lcom/intellij/openapi/vfs/VirtualFile;", "Lcom/jetbrains/rider/model/RdFrontendDocumentId;", "Lkotlin/collections/HashMap;", "pathToIdMap", "Ljava/nio/file/Path;", "nextId", "", "updateSignal", "Lcom/jetbrains/rd/util/reactive/Signal;", "getUpdateSignal", "()Lcom/jetbrains/rd/util/reactive/Signal;", "create", "document", "Lcom/intellij/openapi/editor/Document;", "projectModelId", "(Lcom/intellij/openapi/editor/Document;Ljava/lang/Integer;)Lcom/jetbrains/rider/model/RdFrontendDocumentId;", "Lkotlin/Pair;", "Lcom/jetbrains/rider/model/RdFrontendDocumentInfo;", "virtualFile", "path", "(Lcom/intellij/openapi/vfs/VirtualFile;Ljava/nio/file/Path;Ljava/lang/Integer;)Lkotlin/Pair;", "getFrontendDocumentIdUnderLock", "cleanup", "", "documentId", "getPath", "", "tryGetPath", "updatePath", "getProjectModelId", "(Lcom/jetbrains/rider/model/RdFrontendDocumentId;)Ljava/lang/Integer;", "updateProjectModelId", "(Lcom/jetbrains/rider/model/RdFrontendDocumentId;Ljava/lang/Integer;)V", "update", "changeAction", "Lkotlin/Function1;", "setInfoInProtocol", "info", "withPath", "withProjectModelId", "(Lcom/jetbrains/rider/model/RdFrontendDocumentInfo;Ljava/lang/Integer;)Lcom/jetbrains/rider/model/RdFrontendDocumentInfo;", "Companion", "ProtocolListener", "ResendClosedChangeRequest", "TextControlChangeRequest", "DocumentChangeRequest", "intellij.rider.rdclient.dotnet"})
@SourceDebugExtension(value={"SMAP\nRiderDocumentBindingService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RiderDocumentBindingService.kt\ncom/jetbrains/rider/document/RiderDocumentBindingService\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 CollectionEx.kt\ncom/jetbrains/rd/util/CollectionExKt\n+ 4 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,185:1\n1#2:186\n66#3,3:187\n13#4:190\n*S KotlinDebug\n*F\n+ 1 RiderDocumentBindingService.kt\ncom/jetbrains/rider/document/RiderDocumentBindingService\n*L\n66#1:187,3\n38#1:190\n*E\n"})
public class RiderDocumentBindingService
extends LifetimedService {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Project project;
    @NotNull
    private final RiderDocumentModel model;
    @NotNull
    private final Object locker;
    @NotNull
    private final HashMap<VirtualFile, RdFrontendDocumentId> virtualFileToIdMap;
    @NotNull
    private final HashMap<Path, RdFrontendDocumentId> pathToIdMap;
    private int nextId;
    @NotNull
    private final Signal<RdFrontendDocumentId> updateSignal;
    @NotNull
    private static final Logger logger;

    public RiderDocumentBindingService(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.project = project;
        this.model = RiderDocumentModel_PregeneratedKt.getRiderDocumentModel(SolutionHostExtensionsKt.getSolution(this.project));
        this.locker = new Object();
        this.virtualFileToIdMap = new HashMap();
        this.pathToIdMap = new HashMap();
        this.updateSignal = new Signal();
    }

    @NotNull
    public final Project getProject() {
        return this.project;
    }

    @NotNull
    public final Signal<RdFrontendDocumentId> getUpdateSignal() {
        return this.updateSignal;
    }

    @Nullable
    public final RdFrontendDocumentId create(@NotNull Document document, @Nullable Integer projectModelId) {
        Intrinsics.checkNotNullParameter((Object)document, (String)"document");
        VirtualFile virtualFile = FileDocumentManager.getInstance().getFile(document);
        NewVirtualFile newVirtualFile = virtualFile instanceof NewVirtualFile ? (NewVirtualFile)virtualFile : null;
        if (newVirtualFile == null) {
            return null;
        }
        NewVirtualFile virtualFile2 = newVirtualFile;
        VirtualFile virtualFile3 = (VirtualFile)virtualFile2;
        Path path = virtualFile2.toNioPath();
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"toNioPath(...)");
        RdFrontendDocumentId documentId = (RdFrontendDocumentId)((Object)this.create(virtualFile3, path, projectModelId).component1());
        return documentId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final Pair<RdFrontendDocumentId, RdFrontendDocumentInfo> create(VirtualFile virtualFile, Path path, Integer projectModelId) {
        RdFrontendDocumentId rdFrontendDocumentId;
        Object object = this.locker;
        synchronized (object) {
            boolean bl = false;
            rdFrontendDocumentId = this.getFrontendDocumentIdUnderLock(virtualFile, path);
        }
        RdFrontendDocumentId documentId = rdFrontendDocumentId;
        RdFrontendDocumentInfo documentInfo = new RdFrontendDocumentInfo(PathsKt.getInvariantSeparatorsPathString((Path)path), projectModelId);
        RdFrontendDocumentInfo protocolDocumentInfo = this.setInfoInProtocol(documentId, documentInfo);
        logger.trace("Create document info for " + documentId + " : " + documentInfo.getPath() + " [" + documentInfo.getProjectModelId() + "]");
        return new Pair((Object)documentId, (Object)protocolDocumentInfo);
    }

    /*
     * WARNING - void declaration
     */
    private final RdFrontendDocumentId getFrontendDocumentIdUnderLock(VirtualFile virtualFile, Path path) {
        if (virtualFile == null) {
            void $this$getOrCreate$iv;
            Map map = this.pathToIdMap;
            Path key$iv = path;
            boolean $i$f$getOrCreate = false;
            Object object = $this$getOrCreate$iv.get(key$iv);
            if (object == null) {
                Path it = key$iv;
                boolean bl = false;
                RdProjectId rdProjectId = ProjectUtilKt.getRdProjectId((Project)this.getProject());
                int n = this.nextId;
                this.nextId = n + 1;
                RdFrontendDocumentId it$iv = new RdFrontendDocumentId(rdProjectId, n);
                boolean bl2 = false;
                $this$getOrCreate$iv.put(key$iv, it$iv);
                object = it$iv;
            }
            return (RdFrontendDocumentId)((Object)object);
        }
        RdFrontendDocumentId existingVirtualFileId = this.virtualFileToIdMap.get(virtualFile);
        if (existingVirtualFileId != null) {
            return existingVirtualFileId;
        }
        RdFrontendDocumentId existingPathId = this.pathToIdMap.get(path);
        if (existingPathId != null) {
            ((Map)this.virtualFileToIdMap).put(virtualFile, existingPathId);
            this.pathToIdMap.remove(path);
            return existingPathId;
        }
        int n = this.nextId;
        this.nextId = n + 1;
        RdFrontendDocumentId newVirtualFileId = new RdFrontendDocumentId(ProjectUtilKt.getRdProjectId((Project)this.project), n);
        ((Map)this.virtualFileToIdMap).put(virtualFile, newVirtualFileId);
        return newVirtualFileId;
    }

    public final void cleanup(@NotNull RdFrontendDocumentId documentId) {
        Intrinsics.checkNotNullParameter((Object)((Object)documentId), (String)"documentId");
        logger.trace("Cleanup document info for " + documentId);
        RdFrontendDocumentInfo existingInfo = (RdFrontendDocumentInfo)this.model.getDocumentInfo().remove((Object)documentId);
        if (existingInfo != null) {
            Path path = Paths.get(existingInfo.getPath(), new String[0]);
            this.pathToIdMap.remove(path);
            VirtualFile file = VfsUtil.findFile((Path)path, (boolean)false);
            if (file != null) {
                this.virtualFileToIdMap.remove(file);
            }
        }
    }

    @NotNull
    public final String getPath(@NotNull RdFrontendDocumentId documentId) {
        Intrinsics.checkNotNullParameter((Object)((Object)documentId), (String)"documentId");
        String string = this.tryGetPath(documentId);
        Intrinsics.checkNotNull((Object)string);
        return string;
    }

    @Nullable
    public final String tryGetPath(@NotNull RdFrontendDocumentId documentId) {
        Intrinsics.checkNotNullParameter((Object)((Object)documentId), (String)"documentId");
        RdFrontendDocumentInfo rdFrontendDocumentInfo = (RdFrontendDocumentInfo)this.model.getDocumentInfo().get((Object)documentId);
        return rdFrontendDocumentInfo != null ? rdFrontendDocumentInfo.getPath() : null;
    }

    public final void updatePath(@NotNull RdFrontendDocumentId documentId, @NotNull String path) {
        Intrinsics.checkNotNullParameter((Object)((Object)documentId), (String)"documentId");
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        this.update(documentId, (Function1<? super RdFrontendDocumentInfo, RdFrontendDocumentInfo>)((Function1)arg_0 -> RiderDocumentBindingService.updatePath$lambda$0(this, path, arg_0)));
    }

    @Nullable
    public final Integer getProjectModelId(@NotNull RdFrontendDocumentId documentId) {
        Intrinsics.checkNotNullParameter((Object)((Object)documentId), (String)"documentId");
        RdFrontendDocumentInfo rdFrontendDocumentInfo = (RdFrontendDocumentInfo)this.model.getDocumentInfo().get((Object)documentId);
        return rdFrontendDocumentInfo != null ? rdFrontendDocumentInfo.getProjectModelId() : null;
    }

    public final void updateProjectModelId(@NotNull RdFrontendDocumentId documentId, @Nullable Integer projectModelId) {
        Intrinsics.checkNotNullParameter((Object)((Object)documentId), (String)"documentId");
        this.update(documentId, (Function1<? super RdFrontendDocumentInfo, RdFrontendDocumentInfo>)((Function1)arg_0 -> RiderDocumentBindingService.updateProjectModelId$lambda$0(this, projectModelId, arg_0)));
    }

    private final void update(RdFrontendDocumentId documentId, Function1<? super RdFrontendDocumentInfo, RdFrontendDocumentInfo> changeAction) {
        RdFrontendDocumentInfo existingInfo = (RdFrontendDocumentInfo)this.model.getDocumentInfo().get((Object)documentId);
        if (existingInfo != null) {
            this.setInfoInProtocol(documentId, (RdFrontendDocumentInfo)changeAction.invoke((Object)existingInfo));
            this.updateSignal.fire((Object)documentId);
        }
    }

    @NotNull
    protected RdFrontendDocumentInfo setInfoInProtocol(@NotNull RdFrontendDocumentId documentId, @NotNull RdFrontendDocumentInfo info) {
        Intrinsics.checkNotNullParameter((Object)((Object)documentId), (String)"documentId");
        Intrinsics.checkNotNullParameter((Object)info, (String)"info");
        RdFrontendDocumentInfo existingInfo = (RdFrontendDocumentInfo)this.model.getDocumentInfo().get((Object)documentId);
        if (existingInfo != null && Intrinsics.areEqual((Object)existingInfo.getPath(), (Object)info.getPath())) {
            Integer n = info.getProjectModelId();
            if (n != null && n == 0) {
                return existingInfo;
            }
        }
        logger.trace("Update document info for " + documentId + " : " + info.getPath() + " [" + info.getProjectModelId() + "]");
        ((Map)this.model.getDocumentInfo()).put(documentId, info);
        return info;
    }

    private final RdFrontendDocumentInfo withPath(RdFrontendDocumentInfo $this$withPath, String path) {
        return new RdFrontendDocumentInfo(path, $this$withPath.getProjectModelId());
    }

    private final RdFrontendDocumentInfo withProjectModelId(RdFrontendDocumentInfo $this$withProjectModelId, Integer projectModelId) {
        return new RdFrontendDocumentInfo($this$withProjectModelId.getPath(), projectModelId);
    }

    private static final RdFrontendDocumentInfo updatePath$lambda$0(RiderDocumentBindingService this$0, String $path, RdFrontendDocumentInfo it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return this$0.withPath(it, $path);
    }

    private static final RdFrontendDocumentInfo updateProjectModelId$lambda$0(RiderDocumentBindingService this$0, Integer $projectModelId, RdFrontendDocumentInfo it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return this$0.withProjectModelId(it, $projectModelId);
    }

    static {
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(RiderDocumentBindingService.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        RiderDocumentBindingService.logger = logger;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lcom/jetbrains/rider/document/RiderDocumentBindingService$Companion;", "", "<init>", "()V", "getInstance", "Lcom/jetbrains/rider/document/RiderDocumentBindingService;", "project", "Lcom/intellij/openapi/project/Project;", "logger", "Lcom/intellij/openapi/diagnostic/Logger;", "intellij.rider.rdclient.dotnet"})
    @SourceDebugExtension(value={"SMAP\nRiderDocumentBindingService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RiderDocumentBindingService.kt\ncom/jetbrains/rider/document/RiderDocumentBindingService$Companion\n+ 2 services.kt\ncom/intellij/openapi/components/ServicesKt\n*L\n1#1,185:1\n30#2,2:186\n*S KotlinDebug\n*F\n+ 1 RiderDocumentBindingService.kt\ncom/jetbrains/rider/document/RiderDocumentBindingService$Companion\n*L\n37#1:186,2\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final RiderDocumentBindingService getInstance(@NotNull Project project) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            ComponentManager $this$service$iv = (ComponentManager)project;
            boolean $i$f$service = false;
            Class<RiderDocumentBindingService> serviceClass$iv = RiderDocumentBindingService.class;
            Object object = $this$service$iv.getService(serviceClass$iv);
            if (object == null) {
                throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
            }
            return (RiderDocumentBindingService)((Object)object);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005\u00a8\u0006\u0006"}, d2={"Lcom/jetbrains/rider/document/RiderDocumentBindingService$DocumentChangeRequest;", "Lcom/jetbrains/rider/document/RiderDocumentBindingService$ResendClosedChangeRequest;", "change", "Lcom/jetbrains/rider/model/DocumentClosedChange;", "<init>", "(Lcom/jetbrains/rider/model/DocumentClosedChange;)V", "intellij.rider.rdclient.dotnet"})
    private static final class DocumentChangeRequest
    extends ResendClosedChangeRequest {
        public DocumentChangeRequest(@NotNull DocumentClosedChange change) {
            Intrinsics.checkNotNullParameter((Object)((Object)change), (String)"change");
            super(change, null);
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J \u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u0002H\u0016J\u0018\u0010\f\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\r\u001a\u00020\u000eH\u0002\u00a8\u0006\u000f"}, d2={"Lcom/jetbrains/rider/document/RiderDocumentBindingService$ProtocolListener;", "Lcom/jetbrains/rd/protocol/SolutionExtListener;", "Lcom/jetbrains/rider/model/RiderDocumentModel;", "<init>", "()V", "extensionCreated", "", "lifetime", "Lcom/jetbrains/rd/util/lifetime/Lifetime;", "session", "Lcom/intellij/openapi/client/ClientProjectSession;", "model", "resendToPatchEngine", "request", "Lcom/jetbrains/rider/document/RiderDocumentBindingService$ResendClosedChangeRequest;", "intellij.rider.rdclient.dotnet"})
    public static final class ProtocolListener
    implements SolutionExtListener<RiderDocumentModel> {
        public void extensionCreated(@NotNull Lifetime lifetime, @NotNull ClientProjectSession session2, @NotNull RiderDocumentModel model2) {
            Intrinsics.checkNotNullParameter((Object)lifetime, (String)"lifetime");
            Intrinsics.checkNotNullParameter((Object)session2, (String)"session");
            Intrinsics.checkNotNullParameter((Object)((Object)model2), (String)"model");
            model2.getInitialize().set(null, SchedulerUtilKt.getAsRdScheduler((CoroutineDispatcher)Dispatchers.getIO()), ProtocolListener::extensionCreated$lambda$0);
            model2.getCreateDocumentId().set(null, SchedulerUtilKt.getAsRdScheduler((CoroutineDispatcher)Dispatchers.getIO()), arg_0 -> ProtocolListener.extensionCreated$lambda$1(session2, arg_0));
            model2.getDocumentClosedOnBackend().advise(lifetime, arg_0 -> ProtocolListener.extensionCreated$lambda$2(this, session2, arg_0));
            model2.getTextControlClosedOnBackend().advise(lifetime, arg_0 -> ProtocolListener.extensionCreated$lambda$3(this, session2, arg_0));
        }

        private final void resendToPatchEngine(ClientProjectSession session2, ResendClosedChangeRequest request) {
            FrontendAsyncRequestExecutor.Companion.getInstance(session2.getAppSession()).submitRequest(request);
        }

        private static final Unit extensionCreated$lambda$0(Unit unit) {
            Intrinsics.checkNotNullParameter((Object)unit, (String)"<unused var>");
            return Unit.INSTANCE;
        }

        private static final RdCreateDocumentIdResult extensionCreated$lambda$1(ClientProjectSession $session, RdCreateDocumentIdRequest request) {
            Intrinsics.checkNotNullParameter((Object)request, (String)"request");
            Path path = Paths.get(request.getPath(), new String[0]);
            VirtualFile file = VfsUtil.findFile((Path)path, (boolean)false);
            RiderDocumentBindingService riderDocumentBindingService = Companion.getInstance($session.getProject());
            Intrinsics.checkNotNull((Object)path);
            Pair pair = riderDocumentBindingService.create(file, path, request.getProjectModelId());
            RdFrontendDocumentId documentId = (RdFrontendDocumentId)((Object)pair.component1());
            RdFrontendDocumentInfo documentInfo = (RdFrontendDocumentInfo)pair.component2();
            return new RdCreateDocumentIdResult(documentId, documentInfo);
        }

        private static final Unit extensionCreated$lambda$2(ProtocolListener this$0, ClientProjectSession $session, DocumentClosedChange it) {
            Intrinsics.checkNotNullParameter((Object)((Object)it), (String)"it");
            if (!PatchEngineRegistryKt.isPatchEngineEnabled()) {
                return Unit.INSTANCE;
            }
            this$0.resendToPatchEngine($session, new DocumentChangeRequest(it));
            return Unit.INSTANCE;
        }

        private static final Unit extensionCreated$lambda$3(ProtocolListener this$0, ClientProjectSession $session, EditorClosedChange it) {
            Intrinsics.checkNotNullParameter((Object)((Object)it), (String)"it");
            if (!PatchEngineRegistryKt.isPatchEngineEnabled()) {
                return Unit.INSTANCE;
            }
            this$0.resendToPatchEngine($session, new TextControlChangeRequest(it));
            return Unit.INSTANCE;
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b2\u0018\u00002\u00020\u0001B\u0011\b\u0004\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\b\u001a\u00020\tH\u0016J\b\u0010\n\u001a\u00020\u000bH\u0014R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u0082\u0001\u0002\f\r\u00a8\u0006\u000e"}, d2={"Lcom/jetbrains/rider/document/RiderDocumentBindingService$ResendClosedChangeRequest;", "Lcom/jetbrains/rdclient/requests/FrontendSimpleRequest;", "change", "Lcom/jetbrains/rd/ide/model/RdPatchItem;", "<init>", "(Lcom/jetbrains/rd/ide/model/RdPatchItem;)V", "getChange", "()Lcom/jetbrains/rd/ide/model/RdPatchItem;", "createModel", "Lcom/jetbrains/rd/ide/model/RdRequest;", "debugDescription", "", "Lcom/jetbrains/rider/document/RiderDocumentBindingService$DocumentChangeRequest;", "Lcom/jetbrains/rider/document/RiderDocumentBindingService$TextControlChangeRequest;", "intellij.rider.rdclient.dotnet"})
    private static abstract sealed class ResendClosedChangeRequest
    extends FrontendSimpleRequest
    permits DocumentChangeRequest, TextControlChangeRequest {
        @NotNull
        private final RdPatchItem change;

        private ResendClosedChangeRequest(RdPatchItem change) {
            super(true);
            this.change = change;
        }

        @NotNull
        public final RdPatchItem getChange() {
            return this.change;
        }

        @Override
        @NotNull
        public RdRequest createModel() {
            return (RdRequest)new RdApplyPatchRequest(RdPatch.copy$default((RdPatch)FrontendAsyncRequest.Companion.getEmptyPatch(), (List)CollectionsKt.listOf((Object)this.change), null, null, null, (int)14, null));
        }

        @Override
        @NotNull
        protected String debugDescription() {
            return "Resend " + IPrintableKt.printToString((Object)this.change) + " to patch engine";
        }

        public /* synthetic */ ResendClosedChangeRequest(RdPatchItem change, DefaultConstructorMarker $constructor_marker) {
            this(change);
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005\u00a8\u0006\u0006"}, d2={"Lcom/jetbrains/rider/document/RiderDocumentBindingService$TextControlChangeRequest;", "Lcom/jetbrains/rider/document/RiderDocumentBindingService$ResendClosedChangeRequest;", "change", "Lcom/jetbrains/rider/model/EditorClosedChange;", "<init>", "(Lcom/jetbrains/rider/model/EditorClosedChange;)V", "intellij.rider.rdclient.dotnet"})
    private static final class TextControlChangeRequest
    extends ResendClosedChangeRequest {
        public TextControlChangeRequest(@NotNull EditorClosedChange change) {
            Intrinsics.checkNotNullParameter((Object)((Object)change), (String)"change");
            super(change, null);
        }
    }
}

