/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.document;

import com.intellij.openapi.application.AccessToken;
import com.intellij.openapi.client.ClientAppSession;
import com.intellij.openapi.client.ClientSession;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.command.CommandProcessorEx;
import com.intellij.openapi.command.CommandToken;
import com.intellij.openapi.command.UndoConfirmationPolicy;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.actions.EditorActionUtil;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.ex.IdeDocumentHistory;
import com.intellij.openapi.project.Project;
import com.jetbrains.rd.ide.document.DocumentSynchronizer;
import com.jetbrains.rd.ide.model.CommandModel;
import com.jetbrains.rd.ide.model.RdBackendCommand;
import com.jetbrains.rd.ide.model.RdCommandGroupId;
import com.jetbrains.rd.ide.model.RdCommandItem;
import com.jetbrains.rd.ide.model.RdDeleteGroupId;
import com.jetbrains.rd.ide.model.RdDocumentGroupId;
import com.jetbrains.rd.ide.model.RdEditGroupId;
import com.jetbrains.rd.ide.model.RdPatchCommandDescriptorFinish;
import com.jetbrains.rd.ide.model.RdPatchCommandDescriptorStart;
import com.jetbrains.rd.ide.model.RdPatchCommandDescriptorUpdate;
import com.jetbrains.rd.ide.model.RdProjectId;
import com.jetbrains.rd.ide.model.RdTransparentGroupId;
import com.jetbrains.rd.platform.ProjectUtilKt;
import com.jetbrains.rd.protocol.RootExtListener;
import com.jetbrains.rd.util.lifetime.Lifetime;
import com.jetbrains.rd.util.lifetime.LifetimeDefinition;
import com.jetbrains.rd.util.lifetime.RLifetimeKt;
import com.jetbrains.rd.util.lifetime.SequentialLifetimes;
import com.jetbrains.rd.util.reactive.IViewable;
import com.jetbrains.rd.util.reactive.InterfacesKt;
import com.jetbrains.rd.util.reactive.Property;
import com.jetbrains.rdclient.document.FrontendDocumentHost;
import com.jetbrains.rdclient.editorActions.cwm.EditorActionCommandInfo;
import com.jetbrains.rdclient.editorActions.cwm.FrontendEditorActionRequest;
import com.jetbrains.rdclient.editorActions.cwm.FrontendTypeKeyRequest;
import com.jetbrains.rdclient.engine.handlers.FrontendRdPatchHandlerContext;
import com.jetbrains.rdclient.requests.FrontendAsyncRequest;
import com.jetbrains.rdclient.requests.FrontendAsyncRequestWithImmediateResult;
import com.jetbrains.rdclient.requests.PatchItemOperationType;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jdk7.AutoCloseableKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\b\b\u0007\u0018\u0000 \"2\u00020\u0001:\u0007\"#$%&'(B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u000e\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011J\u0006\u0010\u0012\u001a\u00020\u000fJ\u001f\u0010\u0012\u001a\u0002H\u0013\"\u0004\b\u0000\u0010\u00132\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u0002H\u00130\u0015\u00a2\u0006\u0002\u0010\u0016J\u0012\u0010\u0017\u001a\u0004\u0018\u00010\u00072\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J\u000e\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001bJ\u000e\u0010\u001c\u001a\u00020\u00192\u0006\u0010\u001d\u001a\u00020\u001eJ\u000e\u0010\u001f\u001a\u00020\u00192\u0006\u0010 \u001a\u00020!R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0006\u001a\u0004\u0018\u00010\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\b\u001a\u00020\t8F\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000bR\u0010\u0010\f\u001a\u0004\u0018\u00010\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006)"}, d2={"Lcom/jetbrains/rider/document/RdCommandService;", "", "appSession", "Lcom/intellij/openapi/client/ClientAppSession;", "<init>", "(Lcom/intellij/openapi/client/ClientAppSession;)V", "commandFromBackend", "Lcom/jetbrains/rider/document/RdCommandService$Command;", "hasBackendCommand", "", "getHasBackendCommand", "()Z", "session", "Lcom/jetbrains/rider/document/RdCommandService$Session;", "startSession", "Lcom/intellij/openapi/application/AccessToken;", "context", "Lcom/jetbrains/rdclient/engine/handlers/FrontendRdPatchHandlerContext;", "startSessionIfThereIsCommandFromBackend", "T", "action", "Lkotlin/Function0;", "(Lkotlin/jvm/functions/Function0;)Ljava/lang/Object;", "getCommand", "startCommand", "", "start", "Lcom/jetbrains/rd/ide/model/RdPatchCommandDescriptorStart;", "updateCommand", "update", "Lcom/jetbrains/rd/ide/model/RdPatchCommandDescriptorUpdate;", "finishCommand", "finish", "Lcom/jetbrains/rd/ide/model/RdPatchCommandDescriptorFinish;", "Companion", "CommandGroupId", "FrontendGroupId", "ProtocolGroupId", "Command", "Session", "MyCommandModelListener", "intellij.rider.rdclient.dotnet"})
@ApiStatus.Internal
@SourceDebugExtension(value={"SMAP\nPatchEngineFrontendCommandHost.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PatchEngineFrontendCommandHost.kt\ncom/jetbrains/rider/document/RdCommandService\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,314:1\n13#2:315\n*S KotlinDebug\n*F\n+ 1 PatchEngineFrontendCommandHost.kt\ncom/jetbrains/rider/document/RdCommandService\n*L\n35#1:315\n*E\n"})
public final class RdCommandService {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final ClientAppSession appSession;
    @Nullable
    private Command commandFromBackend;
    @Nullable
    private Session session;
    @NotNull
    private static final Logger logger;

    public RdCommandService(@NotNull ClientAppSession appSession) {
        Intrinsics.checkNotNullParameter((Object)appSession, (String)"appSession");
        this.appSession = appSession;
    }

    public final boolean getHasBackendCommand() {
        return this.commandFromBackend != null;
    }

    @NotNull
    public final AccessToken startSession(@NotNull FrontendRdPatchHandlerContext context) {
        PatchItemOperationType operation;
        PatchItemOperationType patchItemOperationType;
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Session session2 = this.session;
        boolean bl = session2 != null ? session2.isAlive() : false;
        if (bl) {
            logger.error("An attempt to start a new session, but previous session: " + this.session + " is still alive");
            Session session3 = this.session;
            Intrinsics.checkNotNull((Object)((Object)session3));
            session3.finish();
        }
        if (Intrinsics.areEqual((Object)(patchItemOperationType = (operation = context.getOperation())), (Object)PatchItemOperationType.Merge.INSTANCE) || Intrinsics.areEqual((Object)patchItemOperationType, (Object)PatchItemOperationType.Rollback.INSTANCE) || Intrinsics.areEqual((Object)patchItemOperationType, (Object)PatchItemOperationType.SoftPerform.INSTANCE) || Intrinsics.areEqual((Object)patchItemOperationType, (Object)PatchItemOperationType.SoftRedo.INSTANCE) || Intrinsics.areEqual((Object)patchItemOperationType, (Object)PatchItemOperationType.SoftRollback.INSTANCE)) {
            AccessToken accessToken = AccessToken.EMPTY_ACCESS_TOKEN;
            Intrinsics.checkNotNullExpressionValue((Object)accessToken, (String)"EMPTY_ACCESS_TOKEN");
            return accessToken;
        }
        if (Intrinsics.areEqual((Object)patchItemOperationType, (Object)PatchItemOperationType.Perform.INSTANCE) || Intrinsics.areEqual((Object)patchItemOperationType, (Object)PatchItemOperationType.Redo.INSTANCE)) {
            Session session4;
            if (CollectionsKt.singleOrNull((List)context.getPatch().getChanges()) instanceof RdCommandItem) {
                AccessToken accessToken = AccessToken.EMPTY_ACCESS_TOKEN;
                Intrinsics.checkNotNullExpressionValue((Object)accessToken, (String)"EMPTY_ACCESS_TOKEN");
                return accessToken;
            }
            Session $this$startSession_u24lambda_u240 = session4 = new Session(this.appSession);
            boolean bl2 = false;
            $this$startSession_u24lambda_u240.getLifetime().onTermination(() -> RdCommandService.startSession$lambda$0$0(this));
            Command command = this.getCommand(context);
            if (command != null) {
                $this$startSession_u24lambda_u240.startNewCommand(command);
            }
            this.session = $this$startSession_u24lambda_u240;
            return session4;
        }
        throw new NoWhenBranchMatchedException();
    }

    @NotNull
    public final AccessToken startSessionIfThereIsCommandFromBackend() {
        Session session2;
        Session session3 = this.session;
        boolean bl = session3 != null ? session3.isAlive() : false;
        if (bl) {
            AccessToken accessToken = AccessToken.EMPTY_ACCESS_TOKEN;
            Intrinsics.checkNotNullExpressionValue((Object)accessToken, (String)"EMPTY_ACCESS_TOKEN");
            return accessToken;
        }
        Command command = this.commandFromBackend;
        if (command == null) {
            AccessToken accessToken = AccessToken.EMPTY_ACCESS_TOKEN;
            Intrinsics.checkNotNullExpressionValue((Object)accessToken, (String)"EMPTY_ACCESS_TOKEN");
            return accessToken;
        }
        Session $this$startSessionIfThereIsCommandFromBackend_u24lambda_u240 = session2 = new Session(this.appSession);
        boolean bl2 = false;
        $this$startSessionIfThereIsCommandFromBackend_u24lambda_u240.getLifetime().onTermination(() -> RdCommandService.startSessionIfThereIsCommandFromBackend$lambda$0$0(this));
        $this$startSessionIfThereIsCommandFromBackend_u24lambda_u240.startNewCommand(command);
        this.session = $this$startSessionIfThereIsCommandFromBackend_u24lambda_u240;
        return session2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final <T> T startSessionIfThereIsCommandFromBackend(@NotNull Function0<? extends T> action2) {
        Intrinsics.checkNotNullParameter(action2, (String)"action");
        AutoCloseable autoCloseable = (AutoCloseable)this.startSessionIfThereIsCommandFromBackend();
        Throwable throwable = null;
        try {
            AccessToken it = (AccessToken)autoCloseable;
            boolean bl = false;
            Object object = action2.invoke();
            return (T)object;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable, (Throwable)throwable);
        }
    }

    private final Command getCommand(FrontendRdPatchHandlerContext context) {
        Command command = this.commandFromBackend;
        if (command == null) {
            EditorActionCommandInfo info;
            RdCommandService $this$getCommand_u24lambda_u240 = this;
            boolean bl = false;
            FrontendAsyncRequest request = context.getRequest();
            if (!(request instanceof FrontendAsyncRequestWithImmediateResult)) {
                return null;
            }
            FrontendAsyncRequestWithImmediateResult frontendAsyncRequestWithImmediateResult = (FrontendAsyncRequestWithImmediateResult)request;
            command = frontendAsyncRequestWithImmediateResult instanceof FrontendTypeKeyRequest ? new Command("Typing", ((FrontendTypeKeyRequest)request).getEditorId().getProjectId(), new ProtocolGroupId((RdCommandGroupId)new RdDocumentGroupId(((FrontendTypeKeyRequest)request).getEditorId().getDocumentId())), false) : (frontendAsyncRequestWithImmediateResult instanceof FrontendEditorActionRequest ? ((info = ((FrontendEditorActionRequest)((Object)request)).getInfo()) != null ? new Command(info.getName(), ((FrontendEditorActionRequest)((Object)request)).getEditorId().getProjectId(), new FrontendGroupId(info.getGroupId(), false), false) : null) : null);
        }
        return command;
    }

    public final void startCommand(@NotNull RdPatchCommandDescriptorStart start2) {
        block0: {
            Command command;
            Intrinsics.checkNotNullParameter((Object)start2, (String)"start");
            this.commandFromBackend = command = new Command(start2.getName(), start2.getProjectId(), new ProtocolGroupId(start2.getGroupId()), start2.isNavigatable());
            Session session2 = this.session;
            if (session2 == null) break block0;
            session2.startNewCommand(command);
        }
    }

    public final void updateCommand(@NotNull RdPatchCommandDescriptorUpdate update2) {
        block0: {
            Intrinsics.checkNotNullParameter((Object)update2, (String)"update");
            Command command = this.commandFromBackend;
            logger.assertTrue(command != null, (Object)"commandFromBackend must not be null");
            Command command2 = command;
            Intrinsics.checkNotNull((Object)command2);
            this.commandFromBackend = Command.copy$default(command2, update2.getName(), null, new ProtocolGroupId(update2.getGroupId()), false, 10, null);
            Session session2 = this.session;
            if (session2 == null) break block0;
            session2.updateCurrentCommand(update2);
        }
    }

    public final void finishCommand(@NotNull RdPatchCommandDescriptorFinish finish) {
        block0: {
            Intrinsics.checkNotNullParameter((Object)finish, (String)"finish");
            this.commandFromBackend = null;
            Session session2 = this.session;
            if (session2 == null) break block0;
            session2.finishCurrentCommand();
        }
    }

    private static final Unit startSession$lambda$0$0(RdCommandService this$0) {
        this$0.session = null;
        return Unit.INSTANCE;
    }

    private static final Unit startSessionIfThereIsCommandFromBackend$lambda$0$0(RdCommandService this$0) {
        this$0.session = null;
        return Unit.INSTANCE;
    }

    static {
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(RdCommandService.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        RdCommandService.logger = logger;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0014\n\u0002\u0010\b\n\u0002\b\u0002\b\u0082\b\u0018\u00002\u00020\u0001B)\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0004\b\n\u0010\u000bJ\t\u0010\u0016\u001a\u00020\u0003H\u00c6\u0003J\u000b\u0010\u0017\u001a\u0004\u0018\u00010\u0005H\u00c6\u0003J\t\u0010\u0018\u001a\u00020\u0007H\u00c6\u0003J\t\u0010\u0019\u001a\u00020\tH\u00c6\u0003J3\u0010\u001a\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u00072\b\b\u0002\u0010\b\u001a\u00020\tH\u00c6\u0001J\u0013\u0010\u001b\u001a\u00020\t2\b\u0010\u001c\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u001d\u001a\u00020\u001eH\u00d6\u0001J\t\u0010\u001f\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0013\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u001a\u0010\b\u001a\u00020\tX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\b\u0010\u0012\"\u0004\b\u0013\u0010\u0014R\u0011\u0010\u0015\u001a\u00020\t8F\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\u0012\u00a8\u0006 "}, d2={"Lcom/jetbrains/rider/document/RdCommandService$Command;", "", "name", "", "projectId", "Lcom/jetbrains/rd/ide/model/RdProjectId;", "groupId", "Lcom/jetbrains/rider/document/RdCommandService$CommandGroupId;", "isNavigation", "", "<init>", "(Ljava/lang/String;Lcom/jetbrains/rd/ide/model/RdProjectId;Lcom/jetbrains/rider/document/RdCommandService$CommandGroupId;Z)V", "getName", "()Ljava/lang/String;", "getProjectId", "()Lcom/jetbrains/rd/ide/model/RdProjectId;", "getGroupId", "()Lcom/jetbrains/rider/document/RdCommandService$CommandGroupId;", "()Z", "setNavigation", "(Z)V", "isTransparent", "component1", "component2", "component3", "component4", "copy", "equals", "other", "hashCode", "", "toString", "intellij.rider.rdclient.dotnet"})
    private static final class Command {
        @NotNull
        private final String name;
        @Nullable
        private final RdProjectId projectId;
        @NotNull
        private final CommandGroupId groupId;
        private boolean isNavigation;

        public Command(@NotNull String name, @Nullable RdProjectId projectId, @NotNull CommandGroupId groupId, boolean isNavigation) {
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            Intrinsics.checkNotNullParameter((Object)groupId, (String)"groupId");
            this.name = name;
            this.projectId = projectId;
            this.groupId = groupId;
            this.isNavigation = isNavigation;
        }

        @NotNull
        public final String getName() {
            return this.name;
        }

        @Nullable
        public final RdProjectId getProjectId() {
            return this.projectId;
        }

        @NotNull
        public final CommandGroupId getGroupId() {
            return this.groupId;
        }

        public final boolean isNavigation() {
            return this.isNavigation;
        }

        public final void setNavigation(boolean bl) {
            this.isNavigation = bl;
        }

        public final boolean isTransparent() {
            return this.groupId.isTransparent();
        }

        @NotNull
        public final String component1() {
            return this.name;
        }

        @Nullable
        public final RdProjectId component2() {
            return this.projectId;
        }

        @NotNull
        public final CommandGroupId component3() {
            return this.groupId;
        }

        public final boolean component4() {
            return this.isNavigation;
        }

        @NotNull
        public final Command copy(@NotNull String name, @Nullable RdProjectId projectId, @NotNull CommandGroupId groupId, boolean isNavigation) {
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            Intrinsics.checkNotNullParameter((Object)groupId, (String)"groupId");
            return new Command(name, projectId, groupId, isNavigation);
        }

        public static /* synthetic */ Command copy$default(Command command, String string, RdProjectId rdProjectId, CommandGroupId commandGroupId, boolean bl, int n, Object object) {
            if ((n & 1) != 0) {
                string = command.name;
            }
            if ((n & 2) != 0) {
                rdProjectId = command.projectId;
            }
            if ((n & 4) != 0) {
                commandGroupId = command.groupId;
            }
            if ((n & 8) != 0) {
                bl = command.isNavigation;
            }
            return command.copy(string, rdProjectId, commandGroupId, bl);
        }

        @NotNull
        public String toString() {
            return "Command(name=" + this.name + ", projectId=" + this.projectId + ", groupId=" + this.groupId + ", isNavigation=" + this.isNavigation + ")";
        }

        public int hashCode() {
            int result2 = this.name.hashCode();
            result2 = result2 * 31 + (this.projectId == null ? 0 : this.projectId.hashCode());
            result2 = result2 * 31 + this.groupId.hashCode();
            result2 = result2 * 31 + Boolean.hashCode(this.isNavigation);
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Command)) {
                return false;
            }
            Command command = (Command)other;
            if (!Intrinsics.areEqual((Object)this.name, (Object)command.name)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.projectId, (Object)command.projectId)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.groupId, (Object)command.groupId)) {
                return false;
            }
            return this.isNavigation == command.isNavigation;
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\bv\u0018\u00002\u00020\u0001J\u0012\u0010\u0005\u001a\u0004\u0018\u00010\u00012\u0006\u0010\u0006\u001a\u00020\u0007H&R\u0012\u0010\u0002\u001a\u00020\u0003X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0002\u0010\u0004\u0082\u0001\u0002\b\t\u00f8\u0001\u0000\u0082\u0002\u0006\n\u0004\b!0\u0001\u00a8\u0006\n\u00c0\u0006\u0001"}, d2={"Lcom/jetbrains/rider/document/RdCommandService$CommandGroupId;", "", "isTransparent", "", "()Z", "asIdeaGroupId", "session", "Lcom/intellij/openapi/client/ClientAppSession;", "Lcom/jetbrains/rider/document/RdCommandService$FrontendGroupId;", "Lcom/jetbrains/rider/document/RdCommandService$ProtocolGroupId;", "intellij.rider.rdclient.dotnet"})
    public static sealed interface CommandGroupId
    permits FrontendGroupId, ProtocolGroupId {
        public boolean isTransparent();

        @Nullable
        public Object asIdeaGroupId(@NotNull ClientAppSession var1);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\u00020\u00078BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\t\u00a8\u0006\u000e"}, d2={"Lcom/jetbrains/rider/document/RdCommandService$Companion;", "", "<init>", "()V", "logger", "Lcom/intellij/openapi/diagnostic/Logger;", "commandProcessor", "Lcom/intellij/openapi/command/CommandProcessorEx;", "getCommandProcessor", "()Lcom/intellij/openapi/command/CommandProcessorEx;", "getInstance", "Lcom/jetbrains/rider/document/RdCommandService;", "session", "Lcom/intellij/openapi/client/ClientAppSession;", "intellij.rider.rdclient.dotnet"})
    @SourceDebugExtension(value={"SMAP\nPatchEngineFrontendCommandHost.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PatchEngineFrontendCommandHost.kt\ncom/jetbrains/rider/document/RdCommandService$Companion\n+ 2 Components.kt\ncom/jetbrains/rd/platform/util/ComponentsKt\n*L\n1#1,314:1\n23#2:315\n*S KotlinDebug\n*F\n+ 1 PatchEngineFrontendCommandHost.kt\ncom/jetbrains/rider/document/RdCommandService$Companion\n*L\n38#1:315\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        private final CommandProcessorEx getCommandProcessor() {
            CommandProcessor commandProcessor = CommandProcessor.getInstance();
            Intrinsics.checkNotNull((Object)commandProcessor, (String)"null cannot be cast to non-null type com.intellij.openapi.command.CommandProcessorEx");
            return (CommandProcessorEx)commandProcessor;
        }

        @NotNull
        public final RdCommandService getInstance(@NotNull ClientAppSession session2) {
            Intrinsics.checkNotNullParameter((Object)session2, (String)"session");
            ClientSession $this$service$iv = (ClientSession)session2;
            boolean $i$f$service = false;
            Object object = $this$service$iv.getService(RdCommandService.class);
            if (object == null) {
                throw new IllegalStateException(("Can't find service for " + $this$service$iv).toString());
            }
            return (RdCommandService)object;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0019\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0012\u0010\u000b\u001a\u0004\u0018\u00010\u00032\u0006\u0010\f\u001a\u00020\rH\u0016R\u0013\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0014\u0010\u0004\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0004\u0010\n\u00a8\u0006\u000e"}, d2={"Lcom/jetbrains/rider/document/RdCommandService$FrontendGroupId;", "Lcom/jetbrains/rider/document/RdCommandService$CommandGroupId;", "groupId", "", "isTransparent", "", "<init>", "(Ljava/lang/Object;Z)V", "getGroupId", "()Ljava/lang/Object;", "()Z", "asIdeaGroupId", "session", "Lcom/intellij/openapi/client/ClientAppSession;", "intellij.rider.rdclient.dotnet"})
    public static final class FrontendGroupId
    implements CommandGroupId {
        @Nullable
        private final Object groupId;
        private final boolean isTransparent;

        public FrontendGroupId(@Nullable Object groupId, boolean isTransparent) {
            this.groupId = groupId;
            this.isTransparent = isTransparent;
        }

        @Nullable
        public final Object getGroupId() {
            return this.groupId;
        }

        @Override
        public boolean isTransparent() {
            return this.isTransparent;
        }

        @Override
        @Nullable
        public Object asIdeaGroupId(@NotNull ClientAppSession session2) {
            Intrinsics.checkNotNullParameter((Object)session2, (String)"session");
            return this.groupId;
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J \u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u0002H\u0016\u00a8\u0006\f"}, d2={"Lcom/jetbrains/rider/document/RdCommandService$MyCommandModelListener;", "Lcom/jetbrains/rd/protocol/RootExtListener;", "Lcom/jetbrains/rd/ide/model/CommandModel;", "<init>", "()V", "extensionCreated", "", "lifetime", "Lcom/jetbrains/rd/util/lifetime/Lifetime;", "session", "Lcom/intellij/openapi/client/ClientAppSession;", "model", "intellij.rider.rdclient.dotnet"})
    public static final class MyCommandModelListener
    implements RootExtListener<CommandModel> {
        public void extensionCreated(@NotNull Lifetime lifetime, @NotNull ClientAppSession session2, @NotNull CommandModel model2) {
            Intrinsics.checkNotNullParameter((Object)lifetime, (String)"lifetime");
            Intrinsics.checkNotNullParameter((Object)session2, (String)"session");
            Intrinsics.checkNotNullParameter((Object)model2, (String)"model");
            Property property = new Property(null);
            InterfacesKt.viewNotNull((IViewable)((IViewable)property), (Lifetime)lifetime, (arg_0, arg_1) -> MyCommandModelListener.extensionCreated$lambda$0(session2, arg_0, arg_1));
            model2.getOverrideCommandFromBackend().advise(lifetime, arg_0 -> MyCommandModelListener.extensionCreated$lambda$1(property, arg_0));
        }

        private static final Unit extensionCreated$lambda$0(ClientAppSession $session, Lifetime commandLifetime, RdPatchCommandDescriptorStart start2) {
            Intrinsics.checkNotNullParameter((Object)commandLifetime, (String)"commandLifetime");
            Intrinsics.checkNotNullParameter((Object)start2, (String)"start");
            RdCommandService instance = Companion.getInstance($session);
            Command command = new Command(start2.getName(), start2.getProjectId(), new ProtocolGroupId(start2.getGroupId()), start2.isNavigatable());
            commandLifetime.bracketOrThrow(() -> MyCommandModelListener.extensionCreated$lambda$0$0(instance, command), () -> MyCommandModelListener.extensionCreated$lambda$0$1(instance, command));
            return Unit.INSTANCE;
        }

        private static final Unit extensionCreated$lambda$0$0(RdCommandService $instance, Command $command) {
            $instance.commandFromBackend = $command;
            return Unit.INSTANCE;
        }

        private static final Unit extensionCreated$lambda$0$1(RdCommandService $instance, Command $command) {
            if ($instance.commandFromBackend == $command) {
                $instance.commandFromBackend = null;
            }
            return Unit.INSTANCE;
        }

        private static final Unit extensionCreated$lambda$1(Property $property, RdPatchCommandDescriptorStart it) {
            $property.set((Object)it);
            return Unit.INSTANCE;
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0011\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0012\u0010\u000b\u001a\u0004\u0018\u00010\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016J\u0016\u0010\u000f\u001a\u0004\u0018\u00010\f*\u00020\u00032\u0006\u0010\u0010\u001a\u00020\u000eH\u0002R\u0013\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0014\u0010\b\u001a\u00020\t8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\n\u00a8\u0006\u0011"}, d2={"Lcom/jetbrains/rider/document/RdCommandService$ProtocolGroupId;", "Lcom/jetbrains/rider/document/RdCommandService$CommandGroupId;", "groupId", "Lcom/jetbrains/rd/ide/model/RdCommandGroupId;", "<init>", "(Lcom/jetbrains/rd/ide/model/RdCommandGroupId;)V", "getGroupId", "()Lcom/jetbrains/rd/ide/model/RdCommandGroupId;", "isTransparent", "", "()Z", "asIdeaGroupId", "", "session", "Lcom/intellij/openapi/client/ClientAppSession;", "toGroupId", "appSession", "intellij.rider.rdclient.dotnet"})
    public static final class ProtocolGroupId
    implements CommandGroupId {
        @Nullable
        private final RdCommandGroupId groupId;

        public ProtocolGroupId(@Nullable RdCommandGroupId groupId) {
            this.groupId = groupId;
        }

        @Nullable
        public final RdCommandGroupId getGroupId() {
            return this.groupId;
        }

        @Override
        public boolean isTransparent() {
            return this.groupId instanceof RdTransparentGroupId;
        }

        @Override
        @Nullable
        public Object asIdeaGroupId(@NotNull ClientAppSession session2) {
            Intrinsics.checkNotNullParameter((Object)session2, (String)"session");
            RdCommandGroupId rdCommandGroupId = this.groupId;
            return rdCommandGroupId != null ? this.toGroupId(rdCommandGroupId, session2) : null;
        }

        private final Object toGroupId(RdCommandGroupId $this$toGroupId, ClientAppSession appSession) {
            Object object;
            RdCommandGroupId rdCommandGroupId = $this$toGroupId;
            if (rdCommandGroupId instanceof RdBackendCommand) {
                object = ((RdBackendCommand)$this$toGroupId).getId();
            } else if (rdCommandGroupId instanceof RdDeleteGroupId) {
                object = EditorActionUtil.DELETE_COMMAND_GROUP;
            } else if (rdCommandGroupId instanceof RdEditGroupId) {
                object = EditorActionUtil.EDIT_COMMAND_GROUP;
            } else if (rdCommandGroupId instanceof RdDocumentGroupId) {
                DocumentSynchronizer documentSynchronizer = FrontendDocumentHost.Companion.getInstance(appSession).getSynchronizer(((RdDocumentGroupId)$this$toGroupId).getDocumentId());
                object = documentSynchronizer != null ? documentSynchronizer.getDocument() : null;
            } else {
                if (rdCommandGroupId instanceof RdTransparentGroupId) {
                    logger.error("RdTransparentGroupId cannot be used as a group id");
                    return null;
                }
                logger.error("Unknown group id: " + $this$toGroupId);
                return null;
            }
            return object;
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u000e\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014J\u0018\u0010\u0015\u001a\n\u0018\u00010\u0016j\u0004\u0018\u0001`\u00172\u0006\u0010\u0013\u001a\u00020\u0014H\u0002J\u0006\u0010\u0018\u001a\u00020\u0012J\b\u0010\u0019\u001a\u00020\u0012H\u0016J\u000e\u0010\u001a\u001a\u00020\u00122\u0006\u0010\u001b\u001a\u00020\u001cR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\n\u001a\u00020\u000b8F\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\rR\u0011\u0010\u000e\u001a\u00020\u000f8F\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u0010\u00a8\u0006\u001d"}, d2={"Lcom/jetbrains/rider/document/RdCommandService$Session;", "Lcom/intellij/openapi/application/AccessToken;", "appSession", "Lcom/intellij/openapi/client/ClientAppSession;", "<init>", "(Lcom/intellij/openapi/client/ClientAppSession;)V", "def", "Lcom/jetbrains/rd/util/lifetime/LifetimeDefinition;", "lifetimes", "Lcom/jetbrains/rd/util/lifetime/SequentialLifetimes;", "lifetime", "Lcom/jetbrains/rd/util/lifetime/Lifetime;", "getLifetime", "()Lcom/jetbrains/rd/util/lifetime/Lifetime;", "isAlive", "", "()Z", "startNewCommand", "", "command", "Lcom/jetbrains/rider/document/RdCommandService$Command;", "startCommandAndGetClosable", "Ljava/lang/AutoCloseable;", "Lkotlin/AutoCloseable;", "finishCurrentCommand", "finish", "updateCurrentCommand", "update", "Lcom/jetbrains/rd/ide/model/RdPatchCommandDescriptorUpdate;", "intellij.rider.rdclient.dotnet"})
    @SourceDebugExtension(value={"SMAP\nPatchEngineFrontendCommandHost.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PatchEngineFrontendCommandHost.kt\ncom/jetbrains/rider/document/RdCommandService$Session\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,314:1\n1#2:315\n*E\n"})
    private static final class Session
    extends AccessToken {
        @NotNull
        private final ClientAppSession appSession;
        @NotNull
        private final LifetimeDefinition def;
        @NotNull
        private final SequentialLifetimes lifetimes;

        public Session(@NotNull ClientAppSession appSession) {
            Intrinsics.checkNotNullParameter((Object)appSession, (String)"appSession");
            this.appSession = appSession;
            this.def = new LifetimeDefinition();
            this.lifetimes = new SequentialLifetimes(this.def.getLifetime());
        }

        @NotNull
        public final Lifetime getLifetime() {
            return this.def.getLifetime();
        }

        public final boolean isAlive() {
            return RLifetimeKt.isAlive((Lifetime)this.def.getLifetime());
        }

        public final void startNewCommand(@NotNull Command command) {
            Intrinsics.checkNotNullParameter((Object)command, (String)"command");
            LifetimeDefinition lifetime = this.lifetimes.next();
            AutoCloseable token = this.startCommandAndGetClosable(command);
            if (token != null) {
                lifetime.onTermination(() -> Session.startNewCommand$lambda$0(token));
            }
        }

        private final AutoCloseable startCommandAndGetClosable(Command command) {
            FileEditor fileEditor;
            Project project;
            if (command.isTransparent()) {
                return Companion.getCommandProcessor().withUndoTransparentAction();
            }
            RdProjectId rdProjectId = command.getProjectId();
            Project project2 = project = rdProjectId != null ? ProjectUtilKt.toProjectOrNull((RdProjectId)rdProjectId) : null;
            if (project2 != null) {
                Project it = project2;
                boolean bl = false;
                fileEditor = FileEditorManager.getInstance((Project)project).getSelectedEditor();
            } else {
                fileEditor = null;
            }
            FileEditor selectedEditorBeforeCommand = fileEditor;
            Object groupId = command.getGroupId().asIdeaGroupId(this.appSession);
            CommandToken commandToken = Companion.getCommandProcessor().startCommand(project, command.getName(), groupId, UndoConfirmationPolicy.DEFAULT);
            if (commandToken == null) {
                return null;
            }
            CommandToken token = commandToken;
            AccessToken allowMergeGlobalCommandsToken = Companion.getCommandProcessor().allowMergeGlobalCommands();
            return () -> Session.startCommandAndGetClosable$lambda$1(command, project, selectedEditorBeforeCommand, token, allowMergeGlobalCommandsToken);
        }

        public final void finishCurrentCommand() {
            this.lifetimes.terminateCurrent();
        }

        public void finish() {
            LifetimeDefinition.terminate$default((LifetimeDefinition)this.def, (boolean)false, (int)1, null);
        }

        public final void updateCurrentCommand(@NotNull RdPatchCommandDescriptorUpdate update2) {
            Intrinsics.checkNotNullParameter((Object)update2, (String)"update");
            Companion.getCommandProcessor().setCurrentCommandName(update2.getName());
            Companion.getCommandProcessor().setCurrentCommandGroupId((Object)update2.getGroupId());
        }

        private static final Unit startNewCommand$lambda$0(AutoCloseable $token) {
            $token.close();
            return Unit.INSTANCE;
        }

        private static final void startCommandAndGetClosable$lambda$1(Command $command, Project $project, FileEditor $selectedEditorBeforeCommand, CommandToken $token, AccessToken $allowMergeGlobalCommandsToken) {
            if ($command.isNavigation() && $project != null) {
                FileEditor selectedEditor = FileEditorManager.getInstance((Project)$project).getSelectedEditor();
                if (!Intrinsics.areEqual((Object)selectedEditor, (Object)$selectedEditorBeforeCommand)) {
                    IdeDocumentHistory.getInstance((Project)$project).setCurrentCommandHasMoves();
                }
                IdeDocumentHistory.getInstance((Project)$project).includeCurrentCommandAsNavigation();
            }
            Companion.getCommandProcessor().finishCommand($token, null);
            $allowMergeGlobalCommandsToken.finish();
        }
    }
}

