/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.document;

import com.intellij.openapi.command.undo.UndoUtil;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.editor.impl.event.DocumentEventImpl;
import com.intellij.openapi.util.TextRange;
import com.jetbrains.rd.rdtext.intrinsics.RdTextChange;
import com.jetbrains.rd.rdtext.intrinsics.RdTextChangeKind;
import com.jetbrains.rd.rdtext.intrinsics.RdTextChangeKt;
import com.jetbrains.rdclient.RiderOnly;
import com.jetbrains.rider.document.RiderDocumentExKt;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@RiderOnly
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\b\u00c7\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tJ\u001e\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u00072\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lcom/jetbrains/rider/document/DocumentChangeModelConversion;", "", "<init>", "()V", "logger", "Lcom/intellij/openapi/diagnostic/Logger;", "createModelChange", "Lcom/jetbrains/rd/rdtext/intrinsics/RdTextChange;", "ideaChange", "Lcom/intellij/openapi/editor/event/DocumentEvent;", "applyModelChange", "", "modelChange", "document", "Lcom/intellij/openapi/editor/Document;", "assertionEnabled", "", "intellij.rider.rdclient.dotnet"})
@SourceDebugExtension(value={"SMAP\nDocumentChangeModelConversion.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DocumentChangeModelConversion.kt\ncom/jetbrains/rider/document/DocumentChangeModelConversion\n+ 2 Logger.kt\ncom/jetbrains/rdclient/util/idea/LoggerKt\n+ 3 Logger.kt\ncom/jetbrains/rd/platform/util/LoggerKt\n+ 4 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,103:1\n6#2:104\n13#3:105\n13#4:106\n*S KotlinDebug\n*F\n+ 1 DocumentChangeModelConversion.kt\ncom/jetbrains/rider/document/DocumentChangeModelConversion\n*L\n18#1:104\n18#1:105\n18#1:106\n*E\n"})
public final class DocumentChangeModelConversion {
    @NotNull
    public static final DocumentChangeModelConversion INSTANCE = new DocumentChangeModelConversion();
    @NotNull
    private static final Logger logger;

    private DocumentChangeModelConversion() {
    }

    @NotNull
    public final RdTextChange createModelChange(@NotNull DocumentEvent ideaChange) {
        RdTextChangeKind rdTextChangeKind;
        Intrinsics.checkNotNullParameter((Object)ideaChange, (String)"ideaChange");
        Document document = ideaChange.getDocument();
        Intrinsics.checkNotNullExpressionValue((Object)document, (String)"getDocument(...)");
        Document document2 = document;
        boolean sandbox = RiderDocumentExKt.isSandbox(document2);
        int startOffset = ideaChange.getOffset();
        String newFragment = ((Object)ideaChange.getNewFragment()).toString();
        String oldFragment = ((Object)ideaChange.getOldFragment()).toString();
        int fullTextLength = sandbox ? -1 : document2.getTextLength();
        if (((CharSequence)oldFragment).length() == 0) {
            if (ideaChange instanceof DocumentEventImpl) {
                if (((DocumentEventImpl)ideaChange).getInitialStartOffset() < startOffset) {
                }
                if (((DocumentEventImpl)ideaChange).getInitialStartOffset() + ((DocumentEventImpl)ideaChange).getInitialOldLength() > startOffset) {
                }
            }
            rdTextChangeKind = RdTextChangeKind.Insert;
        } else {
            rdTextChangeKind = ((CharSequence)newFragment).length() == 0 ? RdTextChangeKind.Remove : RdTextChangeKind.Replace;
        }
        RdTextChangeKind kind = rdTextChangeKind;
        return new RdTextChange(kind, startOffset, oldFragment, newFragment, fullTextLength);
    }

    public final void applyModelChange(@NotNull RdTextChange modelChange, @NotNull Document document, boolean assertionEnabled) {
        Intrinsics.checkNotNullParameter((Object)modelChange, (String)"modelChange");
        Intrinsics.checkNotNullParameter((Object)document, (String)"document");
        if (modelChange.getFullTextLength() != -1) {
            RdTextChangeKt.assertDocumentLength((RdTextChange)modelChange, (int)document.getTextLength());
        }
        int start2 = modelChange.getStartOffset();
        String oldText = modelChange.getOld();
        String newText = modelChange.getNew();
        int end = start2 + oldText.length();
        switch (WhenMappings.$EnumSwitchMapping$0[modelChange.getKind().ordinal()]) {
            case 1: {
                document.insertString(start2, (CharSequence)newText);
                break;
            }
            case 2: {
                int initialEnd = Math.min(document.getTextLength(), end + 1);
                String initialNewText = newText + document.getText(new TextRange(end, initialEnd));
                document.replaceString(start2, initialEnd, (CharSequence)initialNewText);
                break;
            }
            case 3: {
                int initialStart = Math.max(0, start2 - 1);
                String initialNewText = document.getText(new TextRange(initialStart, start2)) + newText;
                document.replaceString(initialStart, start2, (CharSequence)initialNewText);
                break;
            }
            case 4: {
                String docOld;
                if (assertionEnabled && !Intrinsics.areEqual((Object)(docOld = ((Object)document.getImmutableCharSequence().subSequence(start2, end)).toString()), (Object)oldText)) {
                    throw new IllegalStateException("Expected old: " + oldText + ", but document old: " + docOld);
                }
                document.deleteString(start2, end);
                break;
            }
            case 5: {
                String docOld;
                if (assertionEnabled && !Intrinsics.areEqual((Object)(docOld = ((Object)document.getImmutableCharSequence().subSequence(start2, end)).toString()), (Object)oldText)) {
                    throw new IllegalStateException("Expected old: " + oldText + ", but document old: " + docOld);
                }
                document.replaceString(start2, end, (CharSequence)newText);
                break;
            }
            case 6: {
                String string = document.getText();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
                String actualText = string;
                if (Intrinsics.areEqual((Object)actualText, (Object)newText)) break;
                int logLimit = 1280000;
                if (actualText.length() > logLimit || newText.length() > logLimit) {
                    logger.warn("Client text differs from backend text.\nClient.length:\n " + actualText.length() + " \nBackend.length:\n " + newText.length() + " \nChoosing backend text.");
                } else {
                    logger.warn("Client text differs from backend text.\nClient:\n " + actualText + " \nBackend:\n " + newText + " \nChoosing backend text.");
                }
                UndoUtil.disableUndoIn((Document)document, () -> DocumentChangeModelConversion.applyModelChange$lambda$0(document, newText));
                break;
            }
            case 7: {
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
    }

    private static final void applyModelChange$lambda$0(Document $document, String $newText) {
        $document.setText((CharSequence)$newText);
    }

    static {
        boolean $i$f$getLogger = false;
        boolean $i$f$getLogger2 = false;
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(DocumentChangeModelConversion.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        DocumentChangeModelConversion.logger = logger;
    }

    @Metadata(mv={2, 2, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[RdTextChangeKind.values().length];
            try {
                nArray[RdTextChangeKind.Insert.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[RdTextChangeKind.InsertLeftSide.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[RdTextChangeKind.InsertRightSide.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[RdTextChangeKind.Remove.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[RdTextChangeKind.Replace.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[RdTextChangeKind.Reset.ordinal()] = 6;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[RdTextChangeKind.PromoteVersion.ordinal()] = 7;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

