/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.diagnostics;

import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.actionSystem.ex.ActionManagerEx;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.DumbAware;
import com.jetbrains.rd.platform.util.ApplicationKt;
import com.jetbrains.rd.util.lifetime.Lifetime;
import com.jetbrains.rd.util.threading.coroutines.LifetimeCoroutineUtilKt;
import com.jetbrains.rdclient.actions.ActionsOverriderKt;
import com.jetbrains.rider.diagnostics.ProfilerArgs;
import com.jetbrains.rider.diagnostics.RiderStopProfilingAction;
import com.jetbrains.rider.diagnostics.StartDotnetSelfProfilingAction;
import com.jetbrains.rider.diagnostics.dotnetSelfProfiling.DotnetSelfProfiler;
import com.jetbrains.rider.diagnostics.dotnetSelfProfiling.DotnetSelfProfilerRunner;
import com.jetbrains.rider.diagnostics.dotnetSelfProfiling.ProfiledProcessInfo;
import com.jetbrains.rider.protocol.ApplicationProtocolKt;
import com.jetbrains.rider.protocol.IProtocolHostWithBackend;
import com.jetbrains.rider.protocol.ProtocolManager;
import com.jetbrains.rider.protocol.ReSharperProcessBase;
import java.io.File;
import java.util.function.Supplier;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.SpillingKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.coroutines.CompletableDeferred;
import kotlinx.coroutines.CompletableDeferredKt;
import kotlinx.coroutines.CoroutineScope;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b&\u0018\u0000 \u00182\u00020\u00012\u00020\u0002:\u0001\u0018B\"\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0011\u0010\u0005\u001a\r\u0012\t\u0012\u00070\u0007\u00a2\u0006\u0002\b\b0\u0006\u00a2\u0006\u0004\b\t\u0010\nJ\b\u0010\u000f\u001a\u00020\u0010H\u0016J\u0010\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0016J\u0010\u0010\u0015\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0016J\u0012\u0010\u0016\u001a\u0004\u0018\u00010\u00172\u0006\u0010\u0013\u001a\u00020\u0014H\u0002R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u001c\u0010\u0005\u001a\r\u0012\t\u0012\u00070\u0007\u00a2\u0006\u0002\b\b0\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u0019"}, d2={"Lcom/jetbrains/rider/diagnostics/StartProfilingAction;", "Lcom/intellij/openapi/actionSystem/AnAction;", "Lcom/intellij/openapi/project/DumbAware;", "kind", "Lcom/jetbrains/rider/diagnostics/dotnetSelfProfiling/DotnetSelfProfiler$SnapshotKind;", "text", "Ljava/util/function/Supplier;", "", "Lcom/intellij/openapi/util/NlsActions$ActionText;", "<init>", "(Lcom/jetbrains/rider/diagnostics/dotnetSelfProfiling/DotnetSelfProfiler$SnapshotKind;Ljava/util/function/Supplier;)V", "getKind", "()Lcom/jetbrains/rider/diagnostics/dotnetSelfProfiling/DotnetSelfProfiler$SnapshotKind;", "getText", "()Ljava/util/function/Supplier;", "getActionUpdateThread", "Lcom/intellij/openapi/actionSystem/ActionUpdateThread;", "actionPerformed", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "update", "tryGetProtocolHost", "Lcom/jetbrains/rider/protocol/IProtocolHostWithBackend;", "Companion", "intellij.rider.rdclient.dotnet"})
public abstract class StartProfilingAction
extends AnAction
implements DumbAware {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final DotnetSelfProfiler.SnapshotKind kind;
    @NotNull
    private final Supplier<String> text;
    @NotNull
    private static final Logger logger;

    public StartProfilingAction(@NotNull DotnetSelfProfiler.SnapshotKind kind, @NotNull Supplier<String> text) {
        Intrinsics.checkNotNullParameter((Object)((Object)kind), (String)"kind");
        Intrinsics.checkNotNullParameter(text, (String)"text");
        super(text);
        this.kind = kind;
        this.text = text;
    }

    @NotNull
    public final DotnetSelfProfiler.SnapshotKind getKind() {
        return this.kind;
    }

    @NotNull
    public final Supplier<String> getText() {
        return this.text;
    }

    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        return ActionUpdateThread.BGT;
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        IProtocolHostWithBackend iProtocolHostWithBackend = this.tryGetProtocolHost(e);
        if (iProtocolHostWithBackend == null) {
            return;
        }
        IProtocolHostWithBackend protocolHost = iProtocolHostWithBackend;
        ReSharperProcessBase reSharperProcessBase = protocolHost.getResharperProcess();
        if (reSharperProcessBase == null) {
            return;
        }
        long pid = reSharperProcessBase.getBackendPid();
        ProfiledProcessInfo info = new ProfiledProcessInfo("Rider.Backend", (int)pid);
        LifetimeCoroutineUtilKt.launch$default((Lifetime)protocolHost.getLifetime(), null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(info, this, protocolHost, null){
            int label;
            final /* synthetic */ ProfiledProcessInfo $info;
            final /* synthetic */ StartProfilingAction this$0;
            final /* synthetic */ IProtocolHostWithBackend $protocolHost;
            {
                this.$info = $info;
                this.this$0 = $receiver;
                this.$protocolHost = $protocolHost;
                super(2, $completion);
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final Object invokeSuspend(Object $result) {
                Object object = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)$result);
                        this.label = 1;
                        Object object2 = StartDotnetSelfProfilingAction.Companion.startProfiling(this.$info, new ProfilerArgs(this.this$0.getKind(), null, false, null, 14, null), this.$protocolHost.getProjectFlow(), (Function2<? super CoroutineScope, ? super Continuation<? super Unit>, ? extends Object>)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(null){
                            Object L$0;
                            Object L$1;
                            Object L$2;
                            Object L$3;
                            int label;

                            /*
                             * WARNING - Removed try catching itself - possible behaviour change.
                             * Enabled force condition propagation
                             * Lifted jumps to return sites
                             */
                            public final Object invokeSuspend(Object $result) {
                                Object object = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                switch (this.label) {
                                    case 0: {
                                        ResultKt.throwOnFailure((Object)$result);
                                        ActionManagerEx actionManager = ActionManagerEx.Companion.getInstanceEx();
                                        String stopActionId = "RiderStopProfiling";
                                        String groupId = "RiderBackendProfiling";
                                        CompletableDeferred job2 = CompletableDeferredKt.CompletableDeferred$default(null, (int)1, null);
                                        actionManager.registerAction(stopActionId, (AnAction)new RiderStopProfilingAction((CompletableDeferred<Unit>)job2));
                                        ActionsOverriderKt.addActionToGroup(groupId, stopActionId, actionManager.asActionRuntimeRegistrar());
                                        this.L$0 = actionManager;
                                        this.L$1 = stopActionId;
                                        this.L$2 = groupId;
                                        this.L$3 = SpillingKt.nullOutSpilledVariable((Object)job2);
                                        this.label = 1;
                                        Object object2 = job2.join((Continuation)this);
                                        if (object2 != object) return Unit.INSTANCE;
                                        return object;
                                    }
                                    case 1: {
                                        Object object2;
                                        CompletableDeferred job3 = (CompletableDeferred)this.L$3;
                                        String groupId = (String)this.L$2;
                                        String stopActionId = (String)this.L$1;
                                        ActionManagerEx actionManager = (ActionManagerEx)this.L$0;
                                        try {
                                            ResultKt.throwOnFailure((Object)$result);
                                            object2 = $result;
                                            return Unit.INSTANCE;
                                        }
                                        catch (Throwable throwable) {
                                            throw throwable;
                                        }
                                        finally {
                                            ActionsOverriderKt.removeActionFromGroup(groupId, stopActionId, actionManager.asActionRuntimeRegistrar());
                                            actionManager.unregisterAction(stopActionId);
                                        }
                                    }
                                }
                                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                            }

                            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                                return (Continuation)new /* invalid duplicate definition of identical inner class */;
                            }

                            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                            }
                        }), (Continuation<? super File>)((Continuation)this));
                        if (object2 != object) return Unit.INSTANCE;
                        return object;
                    }
                    case 1: {
                        ResultKt.throwOnFailure((Object)$result);
                        Object object2 = $result;
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)3, null);
    }

    public void update(@NotNull AnActionEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        Presentation presentation = e.getPresentation();
        Intrinsics.checkNotNullExpressionValue((Object)presentation, (String)"getPresentation(...)");
        Presentation presentation2 = presentation;
        presentation2.setEnabledAndVisible(false);
        IProtocolHostWithBackend iProtocolHostWithBackend = this.tryGetProtocolHost(e);
        if (iProtocolHostWithBackend == null) {
            return;
        }
        IProtocolHostWithBackend protocolHost = iProtocolHostWithBackend;
        ReSharperProcessBase reSharperProcessBase = protocolHost.getResharperProcess();
        if (reSharperProcessBase == null) {
            return;
        }
        long pid = reSharperProcessBase.getBackendPid();
        if (DotnetSelfProfilerRunner.INSTANCE.isUnderProfiling((int)pid)) {
            return;
        }
        presentation2.setEnabledAndVisible(true);
    }

    private final IProtocolHostWithBackend tryGetProtocolHost(AnActionEvent e) {
        Object protocolHost;
        Object object = e.getProject();
        if (object == null || (object = ApplicationProtocolKt.getProtocolHost(object)) == null) {
            Object object2 = ApplicationKt.getApplicationOrNull();
            object = object2 != null && (object2 = ApplicationProtocolKt.getProtocolManager((Application)object2)) != null && (object2 = ((ProtocolManager)object2).getProtocolHosts()) != null ? (IProtocolHostWithBackend)CollectionsKt.singleOrNull((Iterable)((Iterable)object2)) : null;
        }
        return (protocolHost = object) instanceof IProtocolHostWithBackend ? (IProtocolHostWithBackend)protocolHost : null;
    }

    static {
        Logger logger = Logger.getInstance(StartProfilingAction.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        StartProfilingAction.logger = logger;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0016\u0010\u0004\u001a\u00070\u0005\u00a2\u0006\u0002\b\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\t"}, d2={"Lcom/jetbrains/rider/diagnostics/StartProfilingAction$Companion;", "", "<init>", "()V", "logger", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "getLogger", "()Lcom/intellij/openapi/diagnostic/Logger;", "intellij.rider.rdclient.dotnet"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Logger getLogger() {
            return logger;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

