/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.diagnostics;

import com.intellij.util.ui.JBDimension;
import com.jetbrains.rd.util.lifetime.Lifetime;
import com.jetbrains.rd.util.lifetime.LifetimeDefinition;
import com.jetbrains.rd.util.reactive.ISignal;
import com.jetbrains.rd.util.reactive.InterfacesKt;
import com.jetbrains.rd.util.reactive.Signal;
import com.jetbrains.rider.diagnostics.RiderMemoryUsagePresenter;
import com.jetbrains.rider.model.RdMemoryUsageIndicator;
import com.jetbrains.rider.model.RdMemoryUsageState;
import com.jetbrains.rider.settings.RdClientDotnetBundle;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.JFrame;
import javax.swing.JTextArea;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007R\u0017\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\r"}, d2={"Lcom/jetbrains/rider/diagnostics/RiderMemoryUsageFrame;", "Ljavax/swing/JFrame;", "lifetime", "Lcom/jetbrains/rd/util/lifetime/Lifetime;", "rdIndicator", "Lcom/jetbrains/rider/model/RdMemoryUsageIndicator;", "<init>", "(Lcom/jetbrains/rd/util/lifetime/Lifetime;Lcom/jetbrains/rider/model/RdMemoryUsageIndicator;)V", "onClose", "Lcom/jetbrains/rd/util/reactive/Signal;", "", "getOnClose", "()Lcom/jetbrains/rd/util/reactive/Signal;", "intellij.rider.rdclient.dotnet"})
public final class RiderMemoryUsageFrame
extends JFrame {
    @NotNull
    private final Signal<Unit> onClose;

    public RiderMemoryUsageFrame(@NotNull Lifetime lifetime, @NotNull RdMemoryUsageIndicator rdIndicator) {
        Intrinsics.checkNotNullParameter((Object)lifetime, (String)"lifetime");
        Intrinsics.checkNotNullParameter((Object)((Object)rdIndicator), (String)"rdIndicator");
        super(RdClientDotnetBundle.INSTANCE.message("memory.usage", new Object[0]));
        this.onClose = new Signal();
        this.setPreferredSize((Dimension)new JBDimension(300, 300));
        JTextArea textArea = new JTextArea("");
        this.getContentPane().add((Component)textArea, "Center");
        this.setAlwaysOnTop(true);
        this.pack();
        final LifetimeDefinition frameLifetimeDef = lifetime.createNested();
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                LifetimeDefinition.terminate$default((LifetimeDefinition)frameLifetimeDef, (boolean)false, (int)1, null);
                InterfacesKt.fire((ISignal)((ISignal)this.getOnClose()));
            }
        });
        rdIndicator.getState().advise(frameLifetimeDef.getLifetime(), arg_0 -> RiderMemoryUsageFrame._init_$lambda$0(textArea, arg_0));
        this.setVisible(true);
    }

    @NotNull
    public final Signal<Unit> getOnClose() {
        return this.onClose;
    }

    private static final Unit _init_$lambda$0(JTextArea $textArea, RdMemoryUsageState state2) {
        Intrinsics.checkNotNullParameter((Object)state2, (String)"state");
        $textArea.setText(RiderMemoryUsagePresenter.getDetailedText$default(RiderMemoryUsagePresenter.INSTANCE, state2, "\n", false, 4, null));
        return Unit.INSTANCE;
    }
}

