/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.completion.summaryInfo;

import com.intellij.codeInsight.CodeInsightSettings;
import com.intellij.codeInsight.lookup.LookupEvent;
import com.intellij.codeInsight.lookup.LookupEx;
import com.intellij.codeInsight.lookup.LookupListener;
import com.intellij.codeInsight.lookup.impl.LookupImpl;
import com.intellij.lang.documentation.ide.impl.DocumentationManagerKt;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.rd.LifetimeDisposableExKt;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.ui.awt.RelativePoint;
import com.intellij.util.Alarm;
import com.intellij.util.ApplicationKt;
import com.jetbrains.rd.ide.model.QuickDocHostModel;
import com.jetbrains.rd.ide.model.QuickDocHostModel_GeneratedKt;
import com.jetbrains.rd.ide.model.QuickDocSession;
import com.jetbrains.rd.ide.model.Solution;
import com.jetbrains.rd.platform.util.ComponentsKt;
import com.jetbrains.rd.util.lifetime.Lifetime;
import com.jetbrains.rd.util.lifetime.LifetimeDefinition;
import com.jetbrains.rd.util.lifetime.SequentialLifetimes;
import com.jetbrains.rdclient.client.FrontendSessionsUtilKt;
import com.jetbrains.rdclient.completion.ProtocolLookupItemBase;
import com.jetbrains.rdclient.completion.UtilsKt;
import com.jetbrains.rdclient.patches.PatchEngineRegistryKt;
import com.jetbrains.rider.completion.summaryInfo.RiderLookupSummaryInfos;
import java.awt.Component;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin._Assertions;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0006\u0018\u0000 \u001a2\u00020\u00012\u00020\u0002:\u0001\u001aB\u0011\b\u0002\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J\b\u0010\r\u001a\u00020\u000eH\u0002J\u0010\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J\u0010\u0010\u0012\u001a\u00020\u000e2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J\u0010\u0010\u0013\u001a\u00020\u000e2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J\b\u0010\u0014\u001a\u00020\u0015H\u0002J\b\u0010\u0016\u001a\u00020\u000eH\u0002J\b\u0010\u0017\u001a\u00020\u0015H\u0002J\b\u0010\u0018\u001a\u00020\u000eH\u0002J\b\u0010\u0019\u001a\u00020\u000eH\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Lcom/jetbrains/rider/completion/summaryInfo/SummaryInfoTracker;", "Lcom/intellij/codeInsight/lookup/LookupListener;", "Lcom/intellij/openapi/Disposable;", "lookup", "Lcom/intellij/codeInsight/lookup/impl/LookupImpl;", "<init>", "(Lcom/intellij/codeInsight/lookup/impl/LookupImpl;)V", "requestLifetimes", "Lcom/jetbrains/rd/util/lifetime/SequentialLifetimes;", "alarm", "Lcom/intellij/util/Alarm;", "delay", "", "request", "", "itemSelected", "event", "Lcom/intellij/codeInsight/lookup/LookupEvent;", "lookupCanceled", "currentItemChanged", "isQuickDocSessionActive", "", "viewQuickDocSessions", "isItemVisible", "close", "dispose", "Companion", "intellij.rider.rdclient.dotnet"})
public final class SummaryInfoTracker
implements LookupListener,
Disposable {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final LookupImpl lookup;
    @NotNull
    private final SequentialLifetimes requestLifetimes;
    @NotNull
    private final Alarm alarm;
    private final int delay;
    @NotNull
    private static final Key<SummaryInfoTracker> SummaryInfoTrackerKey = new Key("SummaryInfoTracker");

    private SummaryInfoTracker(LookupImpl lookup) {
        this.lookup = lookup;
        this.requestLifetimes = new SequentialLifetimes(LifetimeDisposableExKt.createLifetime((Disposable)this));
        this.alarm = new Alarm();
        this.delay = CodeInsightSettings.getInstance().JAVADOC_INFO_DELAY;
        List list2 = this.lookup.getItems();
        Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"getItems(...)");
        if (!((Collection)list2).isEmpty()) {
            this.alarm.addRequest(this::request, this.delay);
        }
        Disposer.register((Disposable)((Disposable)this.lookup), (Disposable)this);
        this.viewQuickDocSessions();
    }

    private final void request() {
        ApplicationKt.getApplication().assertIsDispatchThread();
        LifetimeDefinition lifetime = this.requestLifetimes.next();
        if (this.isQuickDocSessionActive()) {
            return;
        }
        ProtocolLookupItemBase currentItem = UtilsKt.tryGetProtocolItem(this.lookup.getCurrentItem());
        if (currentItem != null && (this.isItemVisible() || PatchEngineRegistryKt.isPatchEngineEnabled())) {
            Project project = this.lookup.getProject();
            Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
            RiderLookupSummaryInfos.Companion.getInstance(project).beginShowSummaryInfo((Lifetime)lifetime, currentItem, this.lookup);
        }
    }

    public void itemSelected(@NotNull LookupEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        this.close();
    }

    public void lookupCanceled(@NotNull LookupEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        this.close();
    }

    public void currentItemChanged(@NotNull LookupEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        if (event.getItem() == null) {
            return;
        }
        boolean bl = Intrinsics.areEqual((Object)this.lookup, (Object)event.getLookup());
        if (_Assertions.ENABLED && !bl) {
            String string = "Assertion failed";
            throw new AssertionError((Object)string);
        }
        ApplicationKt.getApplication().assertIsDispatchThread();
        this.alarm.cancelAllRequests();
        this.requestLifetimes.terminateCurrent();
        this.alarm.addRequest(this::request, this.delay);
    }

    private final boolean isQuickDocSessionActive() {
        Project project = this.lookup.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        return DocumentationManagerKt.isDocumentationPopupVisible((Project)project);
    }

    private final void viewQuickDocSessions() {
        Project project = this.lookup.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        QuickDocHostModel quickDocHostModel = QuickDocHostModel_GeneratedKt.getQuickDocHostModel((Solution)FrontendSessionsUtilKt.getProtocolModel(FrontendSessionsUtilKt.getFrontendProjectSession(project)));
        quickDocHostModel.getQuickDocSessions().view(ComponentsKt.getLifetime((UserDataHolder)((UserDataHolder)this.lookup)), (arg_0, arg_1, arg_2) -> SummaryInfoTracker.viewQuickDocSessions$lambda$0(this, arg_0, arg_1, arg_2));
    }

    private final boolean isItemVisible() {
        return this.lookup.isInsideHint(new RelativePoint((Component)this.lookup.getComponent(), this.lookup.getCurrentItemBounds().getLocation()));
    }

    private final void close() {
        Disposer.dispose((Disposable)this);
    }

    public void dispose() {
        ApplicationKt.getApplication().assertIsDispatchThread();
        this.alarm.cancelAllRequests();
        this.lookup.removeLookupListener((LookupListener)this);
        this.lookup.putUserData(SummaryInfoTrackerKey, null);
    }

    private static final Unit viewQuickDocSessions$lambda$0(SummaryInfoTracker this$0, Lifetime lifetime, int n, QuickDocSession quickDocSession) {
        Intrinsics.checkNotNullParameter((Object)lifetime, (String)"<unused var>");
        Intrinsics.checkNotNullParameter((Object)quickDocSession, (String)"<unused var>");
        this$0.alarm.cancelAllRequests();
        this$0.requestLifetimes.terminateCurrent();
        return Unit.INSTANCE;
    }

    public /* synthetic */ SummaryInfoTracker(LookupImpl lookup, DefaultConstructorMarker $constructor_marker) {
        this(lookup);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0007\u001a\u0004\u0018\u00010\b2\u0006\u0010\t\u001a\u00020\nR\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lcom/jetbrains/rider/completion/summaryInfo/SummaryInfoTracker$Companion;", "", "<init>", "()V", "SummaryInfoTrackerKey", "Lcom/intellij/openapi/util/Key;", "Lcom/jetbrains/rider/completion/summaryInfo/SummaryInfoTracker;", "addSummaryInfoTracker", "Lcom/intellij/codeInsight/lookup/impl/LookupImpl;", "lookup", "Lcom/intellij/codeInsight/lookup/LookupEx;", "intellij.rider.rdclient.dotnet"})
    public static final class Companion {
        private Companion() {
        }

        @Nullable
        public final LookupImpl addSummaryInfoTracker(@NotNull LookupEx lookup) {
            LookupImpl lookupImpl;
            Intrinsics.checkNotNullParameter((Object)lookup, (String)"lookup");
            LookupImpl lookupImpl2 = lookup instanceof LookupImpl ? (LookupImpl)lookup : null;
            if (lookupImpl2 != null) {
                LookupImpl lookupImpl3;
                LookupImpl $this$addSummaryInfoTracker_u24lambda_u240 = lookupImpl3 = lookupImpl2;
                boolean bl = false;
                SummaryInfoTracker tracker = (SummaryInfoTracker)$this$addSummaryInfoTracker_u24lambda_u240.getUserData(SummaryInfoTrackerKey);
                if (tracker == null) {
                    SummaryInfoTracker summaryInfoTracker = new SummaryInfoTracker($this$addSummaryInfoTracker_u24lambda_u240, null);
                    $this$addSummaryInfoTracker_u24lambda_u240.addLookupListener((LookupListener)summaryInfoTracker);
                    $this$addSummaryInfoTracker_u24lambda_u240.putUserData(SummaryInfoTrackerKey, (Object)summaryInfoTracker);
                }
                lookupImpl = lookupImpl3;
            } else {
                lookupImpl = null;
            }
            return lookupImpl;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

