/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.completion;

import com.intellij.codeInsight.completion.CompletionType;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.ex.AnActionListener;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.jetbrains.rdclient.services.IdeBackend;
import com.jetbrains.rider.completion.CompletionStateData;
import com.jetbrains.rider.completion.FrontendCompletionHost;
import com.jetbrains.rider.completion.FrontendCompletionHostKt;
import com.jetbrains.rider.completion.PreemptiveCompletionHost;
import com.jetbrains.rider.completion.UtilsKt;
import com.jetbrains.rider.editorActions.FrontendTypedHandler;
import com.jetbrains.rider.services.RiderDefaultBackend;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\f\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016\u00a8\u0006\n"}, d2={"Lcom/jetbrains/rider/completion/MyEditorTypingListener;", "Lcom/intellij/openapi/actionSystem/ex/AnActionListener;", "<init>", "()V", "beforeEditorTyping", "", "c", "", "dataContext", "Lcom/intellij/openapi/actionSystem/DataContext;", "intellij.rider.rdclient.dotnet"})
@SourceDebugExtension(value={"SMAP\nCompletionSessionHeuristics.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CompletionSessionHeuristics.kt\ncom/jetbrains/rider/completion/MyEditorTypingListener\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,409:1\n23#2:410\n*S KotlinDebug\n*F\n+ 1 CompletionSessionHeuristics.kt\ncom/jetbrains/rider/completion/MyEditorTypingListener\n*L\n61#1:410\n*E\n"})
final class MyEditorTypingListener
implements AnActionListener {
    public void beforeEditorTyping(char c, @NotNull DataContext dataContext) {
        Intrinsics.checkNotNullParameter((Object)dataContext, (String)"dataContext");
        if (!UtilsKt.isTypingSessionCompletionPreemptivenessEnabled()) {
            return;
        }
        Project project = (Project)dataContext.getData(CommonDataKeys.PROJECT);
        if (project == null) {
            return;
        }
        Project prj = project;
        IdeBackend ideBackend = IdeBackend.Companion.tryGetInstance(prj);
        RiderDefaultBackend riderDefaultBackend = ideBackend instanceof RiderDefaultBackend ? (RiderDefaultBackend)ideBackend : null;
        if (riderDefaultBackend == null) {
            return;
        }
        RiderDefaultBackend backend = riderDefaultBackend;
        Editor editor = (Editor)dataContext.getData(CommonDataKeys.EDITOR);
        if (editor == null) {
            return;
        }
        Editor editor2 = editor;
        FrontendTypedHandler frontendTypedHandler = backend.getTypedHandler(editor2, editor2.getCaretModel().getOffset());
        if (frontendTypedHandler == null) {
            return;
        }
        FrontendTypedHandler typedHandler = frontendTypedHandler;
        boolean isCompletionTerminator = typedHandler.isCompletionTerminator(editor2, c);
        MyEditorTypingListener $this$thisLogger$iv = this;
        boolean $i$f$thisLogger = false;
        Logger logger = Logger.getInstance(MyEditorTypingListener.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        logger.trace("checking beforeEditorTyping heuristics to start completion session right away...");
        CompletionStateData completionStateData = FrontendCompletionHostKt.getCompletionStateData(editor2);
        if (!isCompletionTerminator && !completionStateData.getHasSession()) {
            FrontendCompletionHost.ensureCompletionIsRunning$default(PreemptiveCompletionHost.Companion.getInstance(prj), editor2, CompletionType.BASIC, 0, null, null, 24, null);
        }
    }
}

