/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.completion;

import com.intellij.codeInsight.completion.CompletionProgressIndicator;
import com.intellij.codeInsight.completion.impl.CompletionServiceImpl;
import com.intellij.codeInsight.lookup.impl.LookupImpl;
import com.intellij.codeInsight.lookup.impl.LookupManagerImpl;
import com.intellij.codeWithMe.ClientId;
import com.intellij.ide.PowerSaveMode;
import com.intellij.lang.Language;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ex.AnActionListener;
import com.intellij.openapi.application.AccessToken;
import com.intellij.openapi.client.ClientAppSession;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.components.ServicesKt;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Caret;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorFactory;
import com.intellij.openapi.editor.LogicalPosition;
import com.intellij.openapi.editor.event.CaretEvent;
import com.intellij.openapi.editor.event.CaretListener;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.editor.event.DocumentListener;
import com.intellij.openapi.editor.event.EditorEventMulticaster;
import com.intellij.openapi.editor.event.SelectionEvent;
import com.intellij.openapi.editor.event.SelectionListener;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.TextEditor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.rd.LifetimeDisposableExKt;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiFile;
import com.intellij.util.Alarm;
import com.intellij.util.ApplicationKt;
import com.intellij.util.SlowOperations;
import com.intellij.util.messages.MessageBusConnection;
import com.intellij.util.messages.Topic;
import com.intellij.util.ui.UIUtil;
import com.jetbrains.rd.ide.completion.CompletionSessionMarkerKt;
import com.jetbrains.rd.ide.model.CompletionModel_GeneratedKt;
import com.jetbrains.rd.ide.model.CompletionSessionModel;
import com.jetbrains.rd.ide.model.CompletionTuple;
import com.jetbrains.rd.ide.model.TextControlId;
import com.jetbrains.rd.ide.model.TextControlModel;
import com.jetbrains.rd.util.lifetime.Lifetime;
import com.jetbrains.rd.util.lifetime.LifetimeDefinition;
import com.jetbrains.rd.util.lifetime.RLifetimeKt;
import com.jetbrains.rd.util.lifetime.SequentialLifetimes;
import com.jetbrains.rdclient.document.DocumentExKt;
import com.jetbrains.rdclient.editors.FrontendTextControlHostListener;
import com.jetbrains.rdclient.util.idea.DocumentUtilKt;
import com.jetbrains.rdclient.util.idea.LifetimedProjectComponent;
import com.jetbrains.rider.completion.ClientCompletionSupport;
import com.jetbrains.rider.completion.CompletionSessionHeuristics;
import com.jetbrains.rider.completion.CompletionSessionState;
import com.jetbrains.rider.completion.CompletionSessionStrategy;
import com.jetbrains.rider.completion.CompletionStateData;
import com.jetbrains.rider.completion.FrontendCompletionHost;
import com.jetbrains.rider.completion.FrontendCompletionHostKt;
import com.jetbrains.rider.completion.ModelUtilKt;
import com.jetbrains.rider.completion.MyEditorTypingListener;
import com.jetbrains.rider.completion.PreemptiveCompletionHost;
import com.jetbrains.rider.completion.UtilsKt;
import com.jetbrains.rider.editors.PlatformTextControlUtilsKt;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jdk7.AutoCloseableKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Service(value={Service.Level.PROJECT})
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\f\n\u0000\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u000e\n\u0002\b\u0006\b\u0007\u0018\u0000 -2\u00020\u0001:\u0002-.B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0018\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0014J/\u0010\f\u001a\u00020\r2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0002\u00a2\u0006\u0002\u0010\u0014J\u0017\u0010\u0015\u001a\u00020\r2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0011H\u0016\u00a2\u0006\u0002\u0010\u0016J,\u0010\u0017\u001a\u00020\u00072\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0018\u001a\u00020\u00132\b\u0010\u0019\u001a\u0004\u0018\u00010\u001a2\n\b\u0002\u0010\u001b\u001a\u0004\u0018\u00010\u001cJ\u0018\u0010\u001d\u001a\u00020\r2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u001e\u001a\u00020\u001fH\u0002J\u0012\u0010 \u001a\u00020\r2\b\u0010\u001b\u001a\u0004\u0018\u00010\u001cH\u0014J\u0012\u0010!\u001a\u00020\r2\b\u0010\u0019\u001a\u0004\u0018\u00010\u001aH\u0002J\u0017\u0010\"\u001a\u0004\u0018\u00010\u00132\u0006\u0010\n\u001a\u00020\u000bH\u0002\u00a2\u0006\u0002\u0010#J(\u0010$\u001a\u00020\u00072\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010%\u001a\u00020\u00132\u0006\u0010&\u001a\u00020\u0013H\u0002J\u0018\u0010'\u001a\u00020\u00072\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010(\u001a\u00020)H\u0002J\u0018\u0010*\u001a\u00020\r2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0012\u001a\u00020\u0013H\u0002J\u0018\u0010+\u001a\u00020\r2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0012\u001a\u00020\u0013H\u0002J\u0010\u0010,\u001a\u00020\r2\u0006\u0010\u0012\u001a\u00020\u0013H\u0002\u00a8\u0006/"}, d2={"Lcom/jetbrains/rider/completion/CompletionSessionHeuristics;", "Lcom/jetbrains/rdclient/util/idea/LifetimedProjectComponent;", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/openapi/project/Project;)V", "adviceTerminateIfNoResults", "", "textControlLifetime", "Lcom/jetbrains/rd/util/lifetime/Lifetime;", "editor", "Lcom/intellij/openapi/editor/Editor;", "shouldRescheduleCompletion", "", "psiFile", "Lcom/intellij/psi/PsiFile;", "char", "", "offset", "", "(Lcom/intellij/openapi/editor/Editor;Lcom/intellij/psi/PsiFile;Ljava/lang/Character;I)Z", "shouldRescheduleDefaultStrategy", "(Ljava/lang/Character;)Z", "terminateCompletionSessionIfNeeded", "currentOffset", "language", "Lcom/intellij/lang/Language;", "event", "Lcom/intellij/openapi/editor/event/DocumentEvent;", "isCompletingSameIdentifier", "completionHost", "Lcom/jetbrains/rider/completion/FrontendCompletionHost;", "shouldTerminateOnRemove", "shouldTerminateOnEmptyPrefix", "getHideLookupOffset", "(Lcom/intellij/openapi/editor/Editor;)Ljava/lang/Integer;", "handleCaretChange", "newPosition", "oldPosition", "tryScheduleCompletion", "reason", "", "shouldSaveWhenActiveSessionFor", "shouldSaveWhenActiveSession", "isCaretInLookupRange", "Companion", "MyTextControlListener", "intellij.rider.rdclient.dotnet"})
@SourceDebugExtension(value={"SMAP\nCompletionSessionHeuristics.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CompletionSessionHeuristics.kt\ncom/jetbrains/rider/completion/CompletionSessionHeuristics\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n+ 4 Logger.kt\ncom/jetbrains/rd/platform/util/LoggerKt\n*L\n1#1,409:1\n1761#2,3:410\n1740#2,3:421\n67#3,4:413\n67#3,4:417\n67#3,4:424\n13#3:429\n13#4:428\n*S KotlinDebug\n*F\n+ 1 CompletionSessionHeuristics.kt\ncom/jetbrains/rider/completion/CompletionSessionHeuristics\n*L\n325#1:410,3\n389#1:421,3\n359#1:413,4\n362#1:417,4\n192#1:424,4\n77#1:429\n77#1:428\n*E\n"})
public final class CompletionSessionHeuristics
extends LifetimedProjectComponent {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final Logger logger;

    public CompletionSessionHeuristics(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        super(project);
        UIUtil.invokeLaterIfNeeded(() -> CompletionSessionHeuristics._init_$lambda$0(this, project));
    }

    protected void adviceTerminateIfNoResults(@NotNull Lifetime textControlLifetime, @NotNull Editor editor) {
        Intrinsics.checkNotNullParameter((Object)textControlLifetime, (String)"textControlLifetime");
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        TextControlModel textControlModel = DocumentExKt.getTextControlModel(editor);
        if (textControlModel == null) {
            return;
        }
        TextControlModel textControlModel2 = textControlModel;
        CompletionModel_GeneratedKt.getCompletionModel((TextControlModel)textControlModel2).getCompletionSession().view(textControlLifetime, (arg_0, arg_1) -> CompletionSessionHeuristics.adviceTerminateIfNoResults$lambda$0(editor, this, textControlModel2, arg_0, arg_1));
    }

    private final boolean shouldRescheduleCompletion(Editor editor, PsiFile psiFile, Character c, int offset) {
        if (this.shouldSaveWhenActiveSession(editor, offset)) {
            return false;
        }
        Document document = psiFile.getViewProvider().getDocument();
        if (document == null) {
            return false;
        }
        Document document2 = document;
        TextControlModel textControlModel = DocumentExKt.getTextControlModel(editor);
        if (textControlModel != null) {
            String prefix = FrontendCompletionHost.getCompletionPrefix$default(PreemptiveCompletionHost.Companion.getInstance(this.getProject()), offset, document2, psiFile, ModelUtilKt.getCurrentOffsetSafe(textControlModel), null, false, 48, null);
            List list2 = CompletionSessionStrategy.Companion.getExtensions().allForLanguage(psiFile.getLanguage());
            Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"allForLanguage(...)");
            List strategies = list2;
            for (CompletionSessionStrategy strategy2 : strategies) {
                try {
                    Boolean shouldRescheduleCompletion = strategy2.shouldRescheduleCompletion(prefix, psiFile, c, offset);
                    if (shouldRescheduleCompletion == null) continue;
                    return shouldRescheduleCompletion;
                }
                catch (Throwable throwable) {
                    logger.error("Error while calling shouldRescheduleCompletion API for '" + strategy2.getClass().getName() + "' for char '" + c + "' for offset '" + offset + "'");
                }
            }
        }
        return this.shouldRescheduleDefaultStrategy(c);
    }

    public boolean shouldRescheduleDefaultStrategy(@Nullable Character c) {
        return c == null || !Character.isLetterOrDigit(c.charValue());
    }

    public final void terminateCompletionSessionIfNeeded(@NotNull Editor editor, int currentOffset, @Nullable Language language, @Nullable DocumentEvent event) {
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        boolean terminateOnEmptyPrefix = this.shouldTerminateOnEmptyPrefix(language);
        boolean terminateOnRemove = this.shouldTerminateOnRemove(event);
        FrontendCompletionHost frontendCompletionHost = FrontendCompletionHost.Companion.getInstanceOrNull(this.getProject());
        if (frontendCompletionHost == null) {
            return;
        }
        FrontendCompletionHost completionHost = frontendCompletionHost;
        Integer hideLookupOffset = this.getHideLookupOffset(editor);
        if (hideLookupOffset != null) {
            if (currentOffset < hideLookupOffset || terminateOnRemove || terminateOnEmptyPrefix && currentOffset == hideLookupOffset) {
                completionHost.terminateCurrentCompletion(editor, "Modification offset [" + currentOffset + "] < hideOffset [" + hideLookupOffset + "]");
            } else if (!this.isCompletingSameIdentifier(editor, completionHost)) {
                completionHost.terminateCurrentCompletion(editor, "Caret is moved outside identifier");
            }
        }
    }

    public static /* synthetic */ void terminateCompletionSessionIfNeeded$default(CompletionSessionHeuristics completionSessionHeuristics, Editor editor, int n, Language language, DocumentEvent documentEvent, int n2, Object object) {
        if ((n2 & 8) != 0) {
            documentEvent = null;
        }
        completionSessionHeuristics.terminateCompletionSessionIfNeeded(editor, n, language, documentEvent);
    }

    private final boolean isCompletingSameIdentifier(Editor editor, FrontendCompletionHost completionHost) {
        TextControlModel textControlModel = DocumentExKt.getTextControlModel(editor);
        if (textControlModel == null) {
            return true;
        }
        TextControlModel textControlModel2 = textControlModel;
        CompletionTuple completionTuple = (CompletionTuple)CompletionModel_GeneratedKt.getCompletionModel((TextControlModel)textControlModel2).getCompletionSession().getValue();
        if (completionTuple == null || (completionTuple = completionTuple.getParameters()) == null) {
            return true;
        }
        CompletionTuple parameters = completionTuple;
        PsiFile psiFile = PlatformTextControlUtilsKt.getPsiFile(editor);
        if (psiFile == null) {
            return true;
        }
        PsiFile psiFile2 = psiFile;
        int prefixOffset = PlatformTextControlUtilsKt.getStartOffset(editor);
        Document document = editor.getDocument();
        Intrinsics.checkNotNullExpressionValue((Object)document, (String)"getDocument(...)");
        String prefix = FrontendCompletionHost.getCompletionPrefix$default(completionHost, prefixOffset, document, psiFile2, ModelUtilKt.getCurrentOffsetSafe(textControlModel2), editor, false, 32, null);
        String string = parameters.getPrefix();
        int completionStart = parameters.getOffset() - (string != null ? string.length() : 0);
        int identifierStart = prefixOffset - prefix.length();
        return identifierStart == completionStart;
    }

    protected boolean shouldTerminateOnRemove(@Nullable DocumentEvent event) {
        if (event == null) {
            return false;
        }
        return Intrinsics.areEqual((Object)((Object)event.getNewFragment()).toString(), (Object)"") && Intrinsics.areEqual((Object)((Object)event.getOldFragment()).toString(), (Object)"\n");
    }

    private final boolean shouldTerminateOnEmptyPrefix(Language language) {
        boolean bl;
        block6: {
            if (language == null) {
                return false;
            }
            List list2 = CompletionSessionStrategy.Companion.getExtensions().allForLanguage(language);
            Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"allForLanguage(...)");
            List strategies = list2;
            Iterable $this$any$iv = strategies;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    boolean bl2;
                    CompletionSessionStrategy it = (CompletionSessionStrategy)element$iv;
                    boolean bl3 = false;
                    try {
                        bl2 = it.shouldTerminateOnEmptyPrefix();
                    }
                    catch (Throwable throwable) {
                        logger.error("Error while calling shouldTerminateOnEmptyPrefix API for '" + it.getClass().getName() + "'");
                        bl2 = false;
                    }
                    if (!bl2) continue;
                    bl = true;
                    break block6;
                }
                bl = false;
            }
        }
        return bl;
    }

    private final Integer getHideLookupOffset(Editor editor) {
        TextControlModel textControlModel = DocumentExKt.getTextControlModel(editor);
        if (textControlModel == null) {
            return null;
        }
        TextControlModel textControlModel2 = textControlModel;
        int hideLookupOffset = ModelUtilKt.getCurrentOffsetSafe(textControlModel2);
        if (hideLookupOffset < 0) {
            return null;
        }
        String string = ModelUtilKt.getCurrentSessionPrefix(textControlModel2);
        if (string == null) {
            string = "";
        }
        return hideLookupOffset - string.length();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void handleCaretChange(Editor editor, int offset, int newPosition, int oldPosition) {
        Logger logger;
        Character c;
        AccessToken it;
        if (!Intrinsics.areEqual((Object)editor.getProject(), (Object)this.getProject())) {
            return;
        }
        TextControlId textControlId = DocumentExKt.getTextControlId(editor);
        if (!Intrinsics.areEqual((Object)(textControlId != null ? textControlId.getClientId() : null), (Object)ClientId.Companion.getCurrent().getValue())) {
            return;
        }
        AutoCloseable autoCloseable = (AutoCloseable)SlowOperations.knownIssue((String)"RIDER-119889");
        Throwable throwable = null;
        try {
            PsiFile psiFile;
            it = (AccessToken)autoCloseable;
            boolean bl = false;
            if (PsiDocumentManager.getInstance((Project)this.getProject()).getPsiFile(editor.getDocument()) == null) {
                return;
            }
            it = psiFile;
        }
        catch (Throwable bl) {
            throwable = bl;
            throw bl;
        }
        finally {
            AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable, (Throwable)throwable);
        }
        AccessToken psiFile = it;
        if (!ClientCompletionSupport.Companion.getInstance().preemptiveCompletionEnabled((PsiFile)psiFile, offset)) {
            CompletionSessionHeuristics.terminateCompletionSessionIfNeeded$default(this, editor, editor.getCaretModel().getOffset(), DocumentUtilKt.getLanguage(editor), null, 8, null);
            return;
        }
        if (newPosition - oldPosition == 1) {
            Document document = editor.getDocument();
            Intrinsics.checkNotNullExpressionValue((Object)document, (String)"getDocument(...)");
            c = DocumentExKt.getCharAt(document, oldPosition);
        } else {
            c = null;
        }
        Character typedChar = c;
        Logger $this$trace$iv = CompletionSessionHeuristics.logger;
        boolean $i$f$trace = false;
        if ($this$trace$iv.isTraceEnabled()) {
            logger = $this$trace$iv;
            boolean bl = false;
            logger.trace("Viewing new caret change. Typed Char is '" + typedChar + "'");
        }
        if (this.shouldSaveWhenActiveSession(editor, offset)) {
            $this$trace$iv = CompletionSessionHeuristics.logger;
            $i$f$trace = false;
            if ($this$trace$iv.isTraceEnabled()) {
                logger = $this$trace$iv;
                boolean bl = false;
                logger.trace("Caret " + offset + " was moved within the active frontend completion. Don't interrupt the session...");
            }
            return;
        }
        if (typedChar != null && !this.shouldRescheduleCompletion(editor, (PsiFile)psiFile, typedChar, offset)) {
            CompletionSessionHeuristics.logger.trace("Caret was moved due to the simple letter typing. Don't interrupt the session...");
            return;
        }
        this.tryScheduleCompletion(editor, "New completion session is coming for offset " + offset + " and char " + typedChar + ".");
    }

    private final void tryScheduleCompletion(Editor editor, String reason) {
        if (PowerSaveMode.isEnabled()) {
            logger.debug("skipping preemptive completion session, cause PowerSave mode is on");
            return;
        }
        PreemptiveCompletionHost.Companion.getInstance(this.getProject()).tryScheduleCompletion(editor, reason);
    }

    private final boolean shouldSaveWhenActiveSessionFor(Editor editor, int offset) {
        boolean bl;
        block4: {
            PsiFile psiFile = PsiDocumentManager.getInstance((Project)this.getProject()).getPsiFile(editor.getDocument());
            if (psiFile == null) {
                return false;
            }
            PsiFile psiFile2 = psiFile;
            List list2 = CompletionSessionStrategy.Companion.getExtensions().allForLanguage(psiFile2.getLanguage());
            Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"allForLanguage(...)");
            List strategies = list2;
            Iterable $this$all$iv = strategies;
            boolean $i$f$all = false;
            if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                bl = true;
            } else {
                for (Object element$iv : $this$all$iv) {
                    CompletionSessionStrategy it = (CompletionSessionStrategy)element$iv;
                    boolean bl2 = false;
                    if (it.shouldSaveWhenActiveSession(editor, psiFile2, offset)) continue;
                    bl = false;
                    break block4;
                }
                bl = true;
            }
        }
        return bl;
    }

    private final boolean shouldSaveWhenActiveSession(Editor editor, int offset) {
        return this.shouldSaveWhenActiveSessionFor(editor, offset) && (CompletionSessionMarkerKt.isCompletionSessionExecuting((Editor)editor) || CompletionServiceImpl.Companion.getCompletionService().getCurrentCompletion() != null && this.isCaretInLookupRange(offset));
    }

    private final boolean isCaretInLookupRange(int offset) {
        CompletionProgressIndicator completionProgressIndicator = CompletionServiceImpl.Companion.getCurrentCompletionProgressIndicator();
        if (completionProgressIndicator == null) {
            return false;
        }
        CompletionProgressIndicator currentCompletion = completionProgressIndicator;
        LookupImpl lookupImpl = currentCompletion.getLookup();
        Intrinsics.checkNotNullExpressionValue((Object)lookupImpl, (String)"getLookup(...)");
        LookupImpl lookup = lookupImpl;
        if (lookup.getLookupOriginalStart() < 0) {
            return false;
        }
        Editor editor = lookup.getEditor();
        Intrinsics.checkNotNullExpressionValue((Object)editor, (String)"getEditor(...)");
        Integer n = this.getHideLookupOffset(editor);
        int lookupStart = n != null ? n.intValue() : lookup.getLookupStart();
        return lookupStart <= offset;
    }

    private static final void _init_$lambda$0(CompletionSessionHeuristics this$0, Project $project) {
        if (!UtilsKt.isTypingSessionCompletionPreemptivenessEnabled()) {
            return;
        }
        EditorEventMulticaster editorEventMulticaster = EditorFactory.getInstance().getEventMulticaster();
        Intrinsics.checkNotNullExpressionValue((Object)editorEventMulticaster, (String)"getEventMulticaster(...)");
        EditorEventMulticaster eventMulticaster = editorEventMulticaster;
        CaretListener adapter2 = new CaretListener(this$0, $project){
            final /* synthetic */ CompletionSessionHeuristics this$0;
            final /* synthetic */ Project $project;
            {
                this.this$0 = $receiver;
                this.$project = $project;
            }

            public void caretPositionChanged(CaretEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                ApplicationKt.getApplication().assertIsDispatchThread();
                Editor editor = e.getEditor();
                Intrinsics.checkNotNullExpressionValue((Object)editor, (String)"getEditor(...)");
                Editor editor2 = editor;
                LogicalPosition logicalPosition = e.getNewPosition();
                Intrinsics.checkNotNullExpressionValue((Object)logicalPosition, (String)"getNewPosition(...)");
                LogicalPosition newPosition = logicalPosition;
                LogicalPosition logicalPosition2 = e.getOldPosition();
                Intrinsics.checkNotNullExpressionValue((Object)logicalPosition2, (String)"getOldPosition(...)");
                LogicalPosition oldPosition = logicalPosition2;
                Caret caret = e.getCaret();
                Intrinsics.checkNotNull((Object)caret);
                int eventOffset = caret.getOffset();
                CompletionSessionHeuristics.access$handleCaretChange(this.this$0, editor2, eventOffset, editor2.logicalPositionToOffset(newPosition), editor2.logicalPositionToOffset(oldPosition));
            }

            public void caretAdded(CaretEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                this.onAddRemove(e);
            }

            public void caretRemoved(CaretEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                this.onAddRemove(e);
            }

            private final void onAddRemove(CaretEvent e) {
                PreemptiveCompletionHost preemptiveCompletionHost = PreemptiveCompletionHost.Companion.getInstance(this.$project);
                Editor editor = e.getEditor();
                Intrinsics.checkNotNullExpressionValue((Object)editor, (String)"getEditor(...)");
                preemptiveCompletionHost.tryScheduleCompletion(editor, "onAddRemove caret event");
            }
        };
        SelectionListener selectionListener2 = new SelectionListener(this$0){
            final /* synthetic */ CompletionSessionHeuristics this$0;
            {
                this.this$0 = $receiver;
            }

            public void selectionChanged(SelectionEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                super.selectionChanged(e);
                ApplicationKt.getApplication().assertIsDispatchThread();
                if (e.getOldRange().isEmpty()) {
                    return;
                }
                Editor editor = e.getEditor();
                int newPosition = e.getNewRange().getStartOffset();
                int oldPosition = e.getOldRange().getStartOffset();
                int eventOffset = newPosition;
                Intrinsics.checkNotNull((Object)editor);
                CompletionSessionHeuristics.access$handleCaretChange(this.this$0, editor, eventOffset, newPosition, oldPosition);
            }
        };
        DocumentListener documentListener2 = new DocumentListener($project, this$0){
            final /* synthetic */ Project $project;
            final /* synthetic */ CompletionSessionHeuristics this$0;
            {
                this.$project = $project;
                this.this$0 = $receiver;
            }

            public void documentChanged(DocumentEvent event) {
                Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                Document document = event.getDocument();
                Intrinsics.checkNotNullExpressionValue((Object)document, (String)"getDocument(...)");
                if (DocumentExKt.getDocumentSynchronizer(document, this.$project) == null) {
                    return;
                }
                FileEditor fileEditor = FileEditorManager.getInstance((Project)this.$project).getSelectedEditor();
                TextEditor textEditor = fileEditor instanceof TextEditor ? (TextEditor)fileEditor : null;
                if (textEditor == null) {
                    return;
                }
                TextEditor selectedEditor = textEditor;
                Editor editor = selectedEditor.getEditor();
                Intrinsics.checkNotNullExpressionValue((Object)editor, (String)"getEditor(...)");
                Editor editor2 = editor;
                if (!Intrinsics.areEqual((Object)editor2.getDocument(), (Object)event.getDocument())) {
                    return;
                }
                TextControlId textControlId = DocumentExKt.getTextControlId(editor2);
                if (!Intrinsics.areEqual((Object)(textControlId != null ? textControlId.getClientId() : null), (Object)ClientId.Companion.getCurrent().getValue())) {
                    return;
                }
                if (CompletionSessionHeuristics.access$shouldSaveWhenActiveSession(this.this$0, editor2, event.getOffset())) {
                    return;
                }
                PsiFile psiFile = PsiDocumentManager.getInstance((Project)this.$project).getPsiFile(event.getDocument());
                if (psiFile == null) {
                    return;
                }
                PsiFile psiFile2 = psiFile;
                if (event.getOldLength() == 1 && event.getNewLength() == 0) {
                    this.this$0.terminateCompletionSessionIfNeeded(editor2, event.getOffset(), psiFile2.getLanguage(), event);
                } else if (event.getOldLength() == 0 && event.getNewLength() == 1) {
                    CharSequence charSequence = event.getNewFragment();
                    Intrinsics.checkNotNullExpressionValue((Object)charSequence, (String)"getNewFragment(...)");
                    if (CompletionSessionHeuristics.access$shouldRescheduleCompletion(this.this$0, editor2, psiFile2, Character.valueOf(StringsKt.single((CharSequence)charSequence)), event.getOffset())) {
                        CompletionSessionHeuristics.access$tryScheduleCompletion(this.this$0, editor2, "documentModel changed with param: " + event);
                    }
                } else {
                    CompletionSessionHeuristics.access$tryScheduleCompletion(this.this$0, editor2, "documentModel changed with param: " + event);
                }
            }

            public void beforeDocumentChange(DocumentEvent event) {
                Intrinsics.checkNotNullParameter((Object)event, (String)"event");
            }
        };
        eventMulticaster.addSelectionListener(selectionListener2, (Disposable)this$0);
        eventMulticaster.addCaretListener(adapter2, (Disposable)this$0);
        eventMulticaster.addDocumentListener(documentListener2, (Disposable)this$0);
        MessageBusConnection messageBusConnection = $project.getMessageBus().connect();
        Topic topic = AnActionListener.TOPIC;
        Intrinsics.checkNotNullExpressionValue((Object)topic, (String)"TOPIC");
        messageBusConnection.subscribe(topic, (Object)new MyEditorTypingListener());
        Project myProject = this$0.getProject();
    }

    private static final Unit adviceTerminateIfNoResults$lambda$0(Editor $editor, CompletionSessionHeuristics this$0, TextControlModel $textControlModel, Lifetime completionSessionLifetime, CompletionTuple completionTuple) {
        Intrinsics.checkNotNullParameter((Object)completionSessionLifetime, (String)"completionSessionLifetime");
        CompletionTuple completionTuple2 = completionTuple;
        if (completionTuple2 == null || (completionTuple2 = completionTuple2.getSession()) == null) {
            return Unit.INSTANCE;
        }
        CompletionTuple session2 = completionTuple2;
        Logger $this$trace$iv = logger;
        boolean $i$f$trace = false;
        if ($this$trace$iv.isTraceEnabled()) {
            Logger logger = $this$trace$iv;
            boolean bl = false;
            logger.trace("ReleaseChangesIfNotUsedStrategy: viewing new completion session: " + completionTuple.getSession().hashCode());
        }
        SequentialLifetimes typingSeqLifetime = new SequentialLifetimes(completionSessionLifetime);
        DocumentListener typingWithinSessionListener2 = new DocumentListener(completionSessionLifetime, $editor, typingSeqLifetime, this$0, $textControlModel, (CompletionSessionModel)session2){
            final /* synthetic */ Lifetime $completionSessionLifetime;
            final /* synthetic */ Editor $editor;
            final /* synthetic */ SequentialLifetimes $typingSeqLifetime;
            final /* synthetic */ CompletionSessionHeuristics this$0;
            final /* synthetic */ TextControlModel $textControlModel;
            final /* synthetic */ CompletionSessionModel $session;
            {
                this.$completionSessionLifetime = $completionSessionLifetime;
                this.$editor = $editor;
                this.$typingSeqLifetime = $typingSeqLifetime;
                this.this$0 = $receiver;
                this.$textControlModel = $textControlModel;
                this.$session = $session;
            }

            public void documentChanged(DocumentEvent event) {
                Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                if (!RLifetimeKt.isAlive((Lifetime)this.$completionSessionLifetime)) {
                    return;
                }
                TextControlId textControlId = DocumentExKt.getTextControlId(this.$editor);
                if (!Intrinsics.areEqual((Object)(textControlId != null ? textControlId.getClientId() : null), (Object)ClientId.Companion.getCurrent().getValue())) {
                    return;
                }
                LifetimeDefinition currentTypingLifetime = this.$typingSeqLifetime.next();
                CompletionStateData completionStateData = FrontendCompletionHostKt.getCompletionStateData(this.$editor);
                completionStateData.getState().advise((Lifetime)currentTypingLifetime, arg_0 -> adviceTerminateIfNoResults.1.typingWithinSessionListener.1.documentChanged$lambda$0(currentTypingLifetime, this.this$0, completionStateData, this.$textControlModel, this.$session, this.$editor, arg_0));
            }

            private static final Unit documentChanged$lambda$0(LifetimeDefinition $currentTypingLifetime, CompletionSessionHeuristics this$0, CompletionStateData $completionStateData, TextControlModel $textControlModel, CompletionSessionModel $session, Editor $editor, CompletionSessionState completionSessionState) {
                Intrinsics.checkNotNullParameter((Object)((Object)completionSessionState), (String)"completionSessionState");
                if (completionSessionState.getOrder() < CompletionSessionState.Completed.getOrder()) {
                    return Unit.INSTANCE;
                }
                ApplicationKt.getApplication().invokeLater(() -> adviceTerminateIfNoResults.1.typingWithinSessionListener.1.documentChanged$lambda$0$0($currentTypingLifetime, this$0, $completionStateData, $textControlModel, $session, $editor));
                return Unit.INSTANCE;
            }

            private static final void documentChanged$lambda$0$0(LifetimeDefinition $currentTypingLifetime, CompletionSessionHeuristics this$0, CompletionStateData $completionStateData, TextControlModel $textControlModel, CompletionSessionModel $session, Editor $editor) {
                if (!RLifetimeKt.isAlive((Lifetime)((Lifetime)$currentTypingLifetime))) {
                    return;
                }
                PsiDocumentManager.getInstance((Project)this$0.getProject()).performWhenAllCommitted(() -> adviceTerminateIfNoResults.1.typingWithinSessionListener.1.documentChanged$lambda$0$0$0($currentTypingLifetime, $completionStateData, $textControlModel, $session, this$0, $editor));
            }

            private static final void documentChanged$lambda$0$0$0(LifetimeDefinition $currentTypingLifetime, CompletionStateData $completionStateData, TextControlModel $textControlModel, CompletionSessionModel $session, CompletionSessionHeuristics this$0, Editor $editor) {
                $currentTypingLifetime.executeIfAlive(() -> adviceTerminateIfNoResults.1.typingWithinSessionListener.1.documentChanged$lambda$0$0$0$0($currentTypingLifetime, $completionStateData, $textControlModel, $session, this$0, $editor));
            }

            private static final Unit documentChanged$lambda$0$0$0$0(LifetimeDefinition $currentTypingLifetime, CompletionStateData $completionStateData, TextControlModel $textControlModel, CompletionSessionModel $session, CompletionSessionHeuristics this$0, Editor $editor) {
                Logger $this$trace$iv = CompletionSessionHeuristics.access$getLogger$cp();
                boolean $i$f$trace = false;
                if ($this$trace$iv.isTraceEnabled()) {
                    Logger logger = $this$trace$iv;
                    boolean bl = false;
                    logger.trace("ReleaseChangesIfNotUsedStrategy: document has changed and is committed, completion is calculated, waiting for 1 sec...");
                }
                new Alarm(LifetimeDisposableExKt.createNestedDisposable$default((Lifetime)((Lifetime)$currentTypingLifetime), null, (int)1, null)).addRequest(() -> adviceTerminateIfNoResults.1.typingWithinSessionListener.1.documentChanged$lambda$0$0$0$0$1($completionStateData, $textControlModel, $session, this$0, $editor), 1000);
                return Unit.INSTANCE;
            }

            private static final void documentChanged$lambda$0$0$0$0$1(CompletionStateData $completionStateData, TextControlModel $textControlModel, CompletionSessionModel $session, CompletionSessionHeuristics this$0, Editor $editor) {
                if ($completionStateData.getHasSession()) {
                    CompletionTuple completionTuple = (CompletionTuple)CompletionModel_GeneratedKt.getCompletionModel((TextControlModel)$textControlModel).getCompletionSession().getValue();
                    if (Intrinsics.areEqual((Object)(completionTuple != null ? completionTuple.getSession() : null), (Object)$session) && LookupManagerImpl.Companion.getInstance(this$0.getProject()).getActiveLookup() == null && CompletionServiceImpl.Companion.getCompletionService().getCurrentCompletion() == null && !CompletionSessionMarkerKt.isCompletionSessionExecuting((Editor)$editor)) {
                        PreemptiveCompletionHost.Companion.getInstance(this$0.getProject()).terminateCurrentCompletion($editor, "All items are calculated and still no lookup is shown after 1 second");
                    }
                }
            }
        };
        $editor.getDocument().addDocumentListener(typingWithinSessionListener2, LifetimeDisposableExKt.createNestedDisposable$default((Lifetime)completionSessionLifetime, null, (int)1, null));
        return Unit.INSTANCE;
    }

    public static final /* synthetic */ void access$handleCaretChange(CompletionSessionHeuristics $this, Editor editor, int offset, int newPosition, int oldPosition) {
        $this.handleCaretChange(editor, offset, newPosition, oldPosition);
    }

    public static final /* synthetic */ boolean access$shouldSaveWhenActiveSession(CompletionSessionHeuristics $this, Editor editor, int offset) {
        return $this.shouldSaveWhenActiveSession(editor, offset);
    }

    public static final /* synthetic */ boolean access$shouldRescheduleCompletion(CompletionSessionHeuristics $this, Editor editor, PsiFile psiFile, Character c, int offset) {
        return $this.shouldRescheduleCompletion(editor, psiFile, c, offset);
    }

    public static final /* synthetic */ void access$tryScheduleCompletion(CompletionSessionHeuristics $this, Editor editor, String reason) {
        $this.tryScheduleCompletion(editor, reason);
    }

    public static final /* synthetic */ Logger access$getLogger$cp() {
        return logger;
    }

    static {
        boolean $i$f$getLogger = false;
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(CompletionSessionHeuristics.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        CompletionSessionHeuristics.logger = logger;
        CompletionProgressIndicator.setAutopopupTriggerTime((int)10);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007J\u0010\u0010\b\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u0007R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lcom/jetbrains/rider/completion/CompletionSessionHeuristics$Companion;", "", "<init>", "()V", "getInstance", "Lcom/jetbrains/rider/completion/CompletionSessionHeuristics;", "project", "Lcom/intellij/openapi/project/Project;", "tryGetInstance", "logger", "Lcom/intellij/openapi/diagnostic/Logger;", "intellij.rider.rdclient.dotnet"})
    @SourceDebugExtension(value={"SMAP\nCompletionSessionHeuristics.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CompletionSessionHeuristics.kt\ncom/jetbrains/rider/completion/CompletionSessionHeuristics$Companion\n+ 2 services.kt\ncom/intellij/openapi/components/ServicesKt\n+ 3 ComponentContainerUtil.kt\ncom/jetbrains/rider/util/idea/ComponentContainerUtilKt\n*L\n1#1,409:1\n30#2,2:410\n22#3:412\n*S KotlinDebug\n*F\n+ 1 CompletionSessionHeuristics.kt\ncom/jetbrains/rider/completion/CompletionSessionHeuristics$Companion\n*L\n72#1:410,2\n74#1:412\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final CompletionSessionHeuristics getInstance(@NotNull Project project) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            ComponentManager $this$service$iv = (ComponentManager)project;
            boolean $i$f$service = false;
            Class<CompletionSessionHeuristics> serviceClass$iv = CompletionSessionHeuristics.class;
            Object object = $this$service$iv.getService(serviceClass$iv);
            if (object == null) {
                throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
            }
            return (CompletionSessionHeuristics)object;
        }

        @Nullable
        public final CompletionSessionHeuristics tryGetInstance(@NotNull Project project) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            ComponentManager $this$tryGetService$iv = (ComponentManager)project;
            boolean $i$f$tryGetService = false;
            return (CompletionSessionHeuristics)$this$tryGetService$iv.getService(CompletionSessionHeuristics.class);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J0\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016\u00a8\u0006\u0010"}, d2={"Lcom/jetbrains/rider/completion/CompletionSessionHeuristics$MyTextControlListener;", "Lcom/jetbrains/rdclient/editors/FrontendTextControlHostListener;", "<init>", "()V", "editorBound", "", "lifetime", "Lcom/jetbrains/rd/util/lifetime/Lifetime;", "appSession", "Lcom/intellij/openapi/client/ClientAppSession;", "textControlId", "Lcom/jetbrains/rd/ide/model/TextControlId;", "editorModel", "Lcom/jetbrains/rd/ide/model/TextControlModel;", "editor", "Lcom/intellij/openapi/editor/Editor;", "intellij.rider.rdclient.dotnet"})
    public static final class MyTextControlListener
    implements FrontendTextControlHostListener {
        @Override
        public void editorBound(@NotNull Lifetime lifetime, @NotNull ClientAppSession appSession, @NotNull TextControlId textControlId, @NotNull TextControlModel editorModel, @NotNull Editor editor) {
            block1: {
                Intrinsics.checkNotNullParameter((Object)lifetime, (String)"lifetime");
                Intrinsics.checkNotNullParameter((Object)appSession, (String)"appSession");
                Intrinsics.checkNotNullParameter((Object)textControlId, (String)"textControlId");
                Intrinsics.checkNotNullParameter((Object)editorModel, (String)"editorModel");
                Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
                Project project = editor.getProject();
                if (project == null) {
                    return;
                }
                CompletionSessionHeuristics completionSessionHeuristics = Companion.tryGetInstance(project);
                if (completionSessionHeuristics == null) break block1;
                completionSessionHeuristics.adviceTerminateIfNoResults(lifetime, editor);
            }
        }
    }
}

