/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider;

import com.intellij.ide.AppLifecycleListener;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationListener;
import com.intellij.openapi.application.ApplicationNamesInfo;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.rd.LifetimeDisposableExKt;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.platform.ide.bootstrap.StartupErrorReporter;
import com.intellij.util.SystemProperties;
import com.intellij.util.messages.MessageBusConnection;
import com.intellij.util.messages.Topic;
import com.intellij.util.system.CpuArch;
import com.jetbrains.rd.platform.util.ComponentsKt;
import com.jetbrains.rd.util.lifetime.Lifetime;
import com.jetbrains.rd.util.lifetime.RLifetimeKt;
import com.jetbrains.rider.ReSharperBackendLauncher;
import com.jetbrains.rider.RiderApplicationLoadListenerKt;
import com.jetbrains.rider.RiderApplicationPreloadListener;
import com.jetbrains.rider.protocol.EarlyBackendStarter;
import com.jetbrains.rider.protocol.IProtocolHostWithBackend;
import com.jetbrains.rider.protocol.ProtocolKeys;
import com.jetbrains.rider.protocol.ProtocolManager;
import com.jetbrains.rider.protocol.ReSharperProcessBase;
import com.jetbrains.rider.settings.RdClientDotnetBundle;
import java.nio.file.Path;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0016\u0018\u0000 \u000e2\u00020\u0001:\u0003\r\u000e\u000fB\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J \u0010\n\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\u000b\u001a\u00020\fH\u0004\u00a8\u0006\u0010"}, d2={"Lcom/jetbrains/rider/ReSharperBackendLauncher;", "", "<init>", "()V", "launchBackend", "", "application", "Lcom/intellij/openapi/application/Application;", "configPath", "Ljava/nio/file/Path;", "launchReSharperBackend", "protocolLauncherHelper", "Lcom/jetbrains/rider/ReSharperBackendLauncher$ProtocolLauncherHelper;", "ProtocolManagerFactory", "Companion", "ProtocolLauncherHelper", "intellij.rider.rdclient.dotnet"})
public class ReSharperBackendLauncher {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final ProtocolManagerFactory protocolManagerFactory = new ProtocolManagerFactory();

    public void launchBackend(@NotNull Application application, @NotNull Path configPath) {
        Intrinsics.checkNotNullParameter((Object)application, (String)"application");
        Intrinsics.checkNotNullParameter((Object)configPath, (String)"configPath");
        this.launchReSharperBackend(application, configPath, new ProtocolLauncherHelper(ProtocolKeys.Companion.getProtocolManagerKey(), protocolManagerFactory));
    }

    protected final void launchReSharperBackend(@NotNull Application application, @NotNull Path configPath, @NotNull ProtocolLauncherHelper protocolLauncherHelper) {
        Intrinsics.checkNotNullParameter((Object)application, (String)"application");
        Intrinsics.checkNotNullParameter((Object)configPath, (String)"configPath");
        Intrinsics.checkNotNullParameter((Object)protocolLauncherHelper, (String)"protocolLauncherHelper");
        if (!EarlyBackendStarter.Companion.isEnabled()) {
            RiderApplicationPreloadListener.Companion.beforeRiderLoaded(application, configPath);
        }
        if (CpuArch.is32Bit()) {
            RiderApplicationLoadListenerKt.access$getLauncherLogger$p().warn("Attempt to run Rider in 32-bit Java Runtime");
            String riderSupports32BitEnvVarName = "RIDER_32_BIT";
            String envVarValue = System.getenv(riderSupports32BitEnvVarName);
            RiderApplicationLoadListenerKt.access$getLauncherLogger$p().info("Environment variable " + riderSupports32BitEnvVarName + "=" + envVarValue);
            Intrinsics.checkNotNull((Object)envVarValue);
            String string = envVarValue.toLowerCase(Locale.ROOT);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toLowerCase(...)");
            if (!Intrinsics.areEqual((Object)string, (Object)"true")) {
                String string2 = RdClientDotnetBundle.INSTANCE.message("unsupported.java.runtime.title", new Object[0]);
                Object[] objectArray = new Object[1];
                Intrinsics.checkNotNullExpressionValue((Object)ApplicationNamesInfo.getInstance().getProductName(), (String)"getProductName(...)");
                StartupErrorReporter.showError((String)string2, (String)RdClientDotnetBundle.INSTANCE.message("unsupported.java.runtime.message.template", objectArray));
                System.exit(1);
                throw new RuntimeException("System.exit returned normally, while it was supposed to halt JVM.");
            }
        }
        System.out.println((Object)("Installation home directory: file:///" + FileUtil.toSystemIndependentName((String)PathManager.getHomePath())));
        System.out.println((Object)("System directory: file:///" + FileUtil.toSystemIndependentName((String)PathManager.getSystemPath())));
        System.out.println((Object)("Config directory: file:///" + FileUtil.toSystemIndependentName((String)PathManager.getConfigPath())));
        System.out.println((Object)("Log directory: file:///" + FileUtil.toSystemIndependentName((String)PathManager.getLogPath())));
        Lifetime applicationLifetime = ComponentsKt.getLifetime((UserDataHolder)((UserDataHolder)application));
        Key<ProtocolManager> protocolKey = protocolLauncherHelper.getProtocolKey();
        ProtocolManager protocolManager = protocolLauncherHelper.getProtocolManagerFactory().createProtocolManager(application, applicationLifetime);
        application.putUserData(protocolKey, (Object)protocolManager);
        MessageBusConnection connection = application.getMessageBus().connect();
        Topic topic = AppLifecycleListener.TOPIC;
        Intrinsics.checkNotNullExpressionValue((Object)topic, (String)"TOPIC");
        connection.subscribe(topic, (Object)new AppLifecycleListener(applicationLifetime, protocolManager){
            final /* synthetic */ Lifetime $applicationLifetime;
            final /* synthetic */ ProtocolManager $protocolManager;
            {
                this.$applicationLifetime = $applicationLifetime;
                this.$protocolManager = $protocolManager;
            }

            /*
             * WARNING - void declaration
             */
            public void appWillBeClosed(boolean isRestart) {
                void $this$forEach$iv;
                RLifetimeKt.assertAlive((Lifetime)this.$applicationLifetime);
                Iterable iterable = (Iterable)this.$protocolManager.getProtocolHosts();
                ProtocolManager protocolManager = this.$protocolManager;
                boolean $i$f$forEach = false;
                for (T element$iv : $this$forEach$iv) {
                    IProtocolHostWithBackend it = (IProtocolHostWithBackend)element$iv;
                    boolean bl = false;
                    protocolManager.requestShutdown(it);
                    if (!SystemProperties.getBooleanProperty((String)"waitForBackendShutdown", (boolean)false)) continue;
                    RiderApplicationLoadListenerKt.access$getLauncherLogger$p().info("Waiting for backend shutdown in Playback tests");
                    ReSharperProcessBase reSharperProcessBase = it.getResharperProcess();
                    if (reSharperProcessBase != null) {
                        reSharperProcessBase.waitFor(false, (Function0<Unit>)((Function0)launchReSharperBackend.1::appWillBeClosed$lambda$0$0));
                    }
                    RiderApplicationLoadListenerKt.access$getLauncherLogger$p().info("Backend process shutdown complete");
                }
            }

            private static final Unit appWillBeClosed$lambda$0$0() {
                return Unit.INSTANCE;
            }
        });
        application.addApplicationListener(new ApplicationListener(protocolManager){
            final /* synthetic */ ProtocolManager $protocolManager;
            {
                this.$protocolManager = $protocolManager;
            }

            public void applicationExiting() {
                this.$protocolManager.forceShutdown();
            }
        }, LifetimeDisposableExKt.createNestedDisposable$default((Lifetime)applicationLifetime, null, (int)1, null));
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/jetbrains/rider/ReSharperBackendLauncher$Companion;", "", "<init>", "()V", "protocolManagerFactory", "Lcom/jetbrains/rider/ReSharperBackendLauncher$ProtocolManagerFactory;", "intellij.rider.rdclient.dotnet"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u00002\u00020\u0001B\u001d\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003R\u0014\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\f"}, d2={"Lcom/jetbrains/rider/ReSharperBackendLauncher$ProtocolLauncherHelper;", "", "protocolKey", "Lcom/intellij/openapi/util/Key;", "Lcom/jetbrains/rider/protocol/ProtocolManager;", "protocolManagerFactory", "Lcom/jetbrains/rider/ReSharperBackendLauncher$ProtocolManagerFactory;", "<init>", "(Lcom/intellij/openapi/util/Key;Lcom/jetbrains/rider/ReSharperBackendLauncher$ProtocolManagerFactory;)V", "getProtocolManagerFactory", "()Lcom/jetbrains/rider/ReSharperBackendLauncher$ProtocolManagerFactory;", "getProtocolKey", "intellij.rider.rdclient.dotnet"})
    public static final class ProtocolLauncherHelper {
        @NotNull
        private final Key<ProtocolManager> protocolKey;
        @NotNull
        private final ProtocolManagerFactory protocolManagerFactory;

        public ProtocolLauncherHelper(@NotNull Key<ProtocolManager> protocolKey, @NotNull ProtocolManagerFactory protocolManagerFactory) {
            Intrinsics.checkNotNullParameter(protocolKey, (String)"protocolKey");
            Intrinsics.checkNotNullParameter((Object)protocolManagerFactory, (String)"protocolManagerFactory");
            this.protocolKey = protocolKey;
            this.protocolManagerFactory = protocolManagerFactory;
        }

        @NotNull
        public final ProtocolManagerFactory getProtocolManagerFactory() {
            return this.protocolManagerFactory;
        }

        @NotNull
        public final Key<ProtocolManager> getProtocolKey() {
            return this.protocolKey;
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0016\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016\u00a8\u0006\n"}, d2={"Lcom/jetbrains/rider/ReSharperBackendLauncher$ProtocolManagerFactory;", "", "<init>", "()V", "createProtocolManager", "Lcom/jetbrains/rider/protocol/ProtocolManager;", "application", "Lcom/intellij/openapi/application/Application;", "componentLifetime", "Lcom/jetbrains/rd/util/lifetime/Lifetime;", "intellij.rider.rdclient.dotnet"})
    public static class ProtocolManagerFactory {
        @NotNull
        public ProtocolManager createProtocolManager(@NotNull Application application, @NotNull Lifetime componentLifetime) {
            Intrinsics.checkNotNullParameter((Object)application, (String)"application");
            Intrinsics.checkNotNullParameter((Object)componentLifetime, (String)"componentLifetime");
            return new ProtocolManager(application, componentLifetime, false);
        }
    }
}

