/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider;

import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.util.EnvironmentUtil;
import com.intellij.util.system.CpuArch;
import com.jetbrains.rider.BundledAssemblyLauncherInfo;
import com.jetbrains.rider.NetCoreRuntime;
import com.jetbrains.rider.NetCoreUtil;
import com.jetbrains.rider.RiderEnvironment;
import com.jetbrains.rider.inTests.PerformancePlaybackTestsKt;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.io.FilesKt;
import kotlin.io.NoSuchFileException;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0010$\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 \u000f2\u00020\u0001:\u0001\u000fB3\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00030\u0005\u0012\u0012\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00030\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\u0006\u0010\n\u001a\u00020\u000bJ\u000e\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\rR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00030\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00030\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lcom/jetbrains/rider/AssemblyExecutionContext;", "", "executablePath", "", "arguments", "", "envVars", "", "<init>", "(Ljava/lang/String;Ljava/util/List;Ljava/util/Map;)V", "toProcessBuilder", "Ljava/lang/ProcessBuilder;", "fillCommandLine", "Lcom/intellij/execution/configurations/GeneralCommandLine;", "cmd", "Companion", "intellij.rider.rdclient.dotnet"})
public final class AssemblyExecutionContext {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String executablePath;
    @NotNull
    private final List<String> arguments;
    @NotNull
    private final Map<String, String> envVars;
    private static final boolean collectFullContainerStatistics = Intrinsics.areEqual((Object)System.getProperty("rider.collect.full.container.statistics"), (Object)"true");

    private AssemblyExecutionContext(String executablePath, List<String> arguments, Map<String, String> envVars) {
        this.executablePath = executablePath;
        this.arguments = arguments;
        this.envVars = envVars;
    }

    @NotNull
    public final ProcessBuilder toProcessBuilder() {
        String[] stringArray = new String[]{this.executablePath};
        ProcessBuilder builder = new ProcessBuilder(stringArray);
        builder.command().addAll((Collection<String>)this.arguments);
        builder.environment().putAll(this.envVars);
        return builder;
    }

    @NotNull
    public final GeneralCommandLine fillCommandLine(@NotNull GeneralCommandLine cmd) {
        Intrinsics.checkNotNullParameter((Object)cmd, (String)"cmd");
        cmd.setExePath(this.executablePath);
        cmd.addParameters(this.arguments);
        cmd.getEnvironment().putAll(this.envVars);
        return cmd;
    }

    public /* synthetic */ AssemblyExecutionContext(String executablePath, List arguments, Map envVars, DefaultConstructorMarker $constructor_marker) {
        this(executablePath, arguments, envVars);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0012\u0010\u0006\u001a\u0004\u0018\u00010\u00072\u0006\u0010\b\u001a\u00020\u0007H\u0002J'\u0010\t\u001a\u00020\n2\u0006\u0010\b\u001a\u00020\u00072\u0012\u0010\u000b\u001a\n\u0012\u0006\b\u0001\u0012\u00020\r0\f\"\u00020\r\u00a2\u0006\u0002\u0010\u000eJ'\u0010\t\u001a\u00020\n2\u0006\u0010\u000f\u001a\u00020\u00102\u0012\u0010\u000b\u001a\n\u0012\u0006\b\u0001\u0012\u00020\r0\f\"\u00020\r\u00a2\u0006\u0002\u0010\u0011Jk\u0010\t\u001a\u00020\n2\u0006\u0010\u0012\u001a\u00020\r2\u0006\u0010\u0013\u001a\u00020\r2\u0006\u0010\u0014\u001a\u00020\r2\b\u0010\u0015\u001a\u0004\u0018\u00010\r2\u0006\u0010\u0016\u001a\u00020\u00052\u000e\u0010\u0017\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\r0\u00182\u0006\u0010\u0019\u001a\u00020\u00052\u0006\u0010\u001a\u001a\u00020\u00052\u0012\u0010\u000b\u001a\n\u0012\u0006\b\u0001\u0012\u00020\r0\f\"\u00020\rH\u0002\u00a2\u0006\u0002\u0010\u001bR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"Lcom/jetbrains/rider/AssemblyExecutionContext$Companion;", "", "<init>", "()V", "collectFullContainerStatistics", "", "getRuntimeConfig", "Ljava/io/File;", "assemblyFile", "create", "Lcom/jetbrains/rider/AssemblyExecutionContext;", "params", "", "", "(Ljava/io/File;[Ljava/lang/String;)Lcom/jetbrains/rider/AssemblyExecutionContext;", "launcherInfo", "Lcom/jetbrains/rider/BundledAssemblyLauncherInfo;", "(Lcom/jetbrains/rider/BundledAssemblyLauncherInfo;[Ljava/lang/String;)Lcom/jetbrains/rider/AssemblyExecutionContext;", "assemblyAbsolutePath", "assemblyParent", "assemblyName", "dotnetPath", "runOnNetCore", "runtimeConfigLazy", "Lkotlin/Lazy;", "isNativeLauncher", "isRiderBackend", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;ZLkotlin/Lazy;ZZ[Ljava/lang/String;)Lcom/jetbrains/rider/AssemblyExecutionContext;", "intellij.rider.rdclient.dotnet"})
    @SourceDebugExtension(value={"SMAP\nRiderEnvironment.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RiderEnvironment.kt\ncom/jetbrains/rider/AssemblyExecutionContext$Companion\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,892:1\n23#2:893\n67#2,4:894\n*S KotlinDebug\n*F\n+ 1 RiderEnvironment.kt\ncom/jetbrains/rider/AssemblyExecutionContext$Companion\n*L\n453#1:893\n551#1:894,4\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        /*
         * Unable to fully structure code
         */
        private final File getRuntimeConfig(File assemblyFile) {
            runtimeConfigDirectory = FileUtil.filesEqual((File)assemblyFile, (File)RiderEnvironment.INSTANCE.getRiderBackendExecutable()) != false && NetCoreUtil.INSTANCE.useNativeLauncher() != false ? assemblyFile.getParentFile().getParentFile() : assemblyFile.getParentFile();
            runtimeConfigJson = ".runtimeconfig.json";
            v0 = assemblyFile.getName();
            Intrinsics.checkNotNullExpressionValue((Object)v0, (String)"getName(...)");
            if (StringsKt.endsWith$default((String)v0, (String)".exe", (boolean)false, (int)2, null)) ** GOTO lbl-1000
            v1 = assemblyFile.getName();
            Intrinsics.checkNotNullExpressionValue((Object)v1, (String)"getName(...)");
            if (StringsKt.endsWith$default((String)v1, (String)".dll", (boolean)false, (int)2, null)) lbl-1000:
            // 2 sources

            {
                v2 = FilesKt.getNameWithoutExtension((File)assemblyFile);
            } else {
                v2 = name = assemblyFile.getName();
            }
            middle = SystemInfo.isWindows != false ? ".windows" + (NetCoreUtil.INSTANCE.useManagedLauncher() != false ? ".launcher" : "") : ".netcore";
            Intrinsics.checkNotNull((Object)runtimeConfigDirectory);
            configFile = FilesKt.resolve((File)runtimeConfigDirectory, (String)(name + middle + runtimeConfigJson));
            return configFile.exists() != false ? configFile : null;
        }

        @NotNull
        public final AssemblyExecutionContext create(@NotNull File assemblyFile, String ... params) {
            Intrinsics.checkNotNullParameter((Object)assemblyFile, (String)"assemblyFile");
            Intrinsics.checkNotNullParameter((Object)params, (String)"params");
            if (!assemblyFile.exists() || !assemblyFile.isFile()) {
                throw new NoSuchFileException(assemblyFile, null, null, 6, null);
            }
            String string = assemblyFile.getAbsolutePath();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getAbsolutePath(...)");
            String string2 = assemblyFile.getParentFile().getAbsolutePath();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getAbsolutePath(...)");
            String string3 = assemblyFile.getName();
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"getName(...)");
            return this.create(string, string2, string3, (String)NetCoreRuntime.INSTANCE.getCliPath().getValue(), NetCoreUtil.INSTANCE.runOnNetCore(), (Lazy<String>)LazyKt.lazy(() -> Companion.create$lambda$0(assemblyFile)), FileUtil.filesEqual((File)assemblyFile, (File)RiderEnvironment.INSTANCE.getRiderBackendExecutable()) && NetCoreUtil.INSTANCE.useNativeLauncher(), FileUtil.filesEqual((File)assemblyFile, (File)RiderEnvironment.INSTANCE.getRiderBackendExecutable()), Arrays.copyOf(params, params.length));
        }

        @NotNull
        public final AssemblyExecutionContext create(@NotNull BundledAssemblyLauncherInfo launcherInfo, String ... params) {
            Intrinsics.checkNotNullParameter((Object)launcherInfo, (String)"launcherInfo");
            Intrinsics.checkNotNullParameter((Object)params, (String)"params");
            String shortName = launcherInfo.getAssemblyName();
            return this.create(launcherInfo.getCustomInfo().getBinDirectory().getPath() + launcherInfo.getCustomInfo().getOs().getPlatform().fileSeparator + launcherInfo.getRelativePath(), launcherInfo.getCustomInfo().getBinDirectory().getPath(), shortName, launcherInfo.getCustomInfo().getDotnetExecutable(), launcherInfo.getCustomInfo().getRunOnNetCore(), (Lazy<String>)LazyKt.lazy(() -> Companion.create$lambda$1(launcherInfo, shortName)), launcherInfo.getCustomInfo().getUseNativeLauncher(), false, Arrays.copyOf(params, params.length));
        }

        private final AssemblyExecutionContext create(String assemblyAbsolutePath, String assemblyParent, String assemblyName, String dotnetPath, boolean runOnNetCore, Lazy<String> runtimeConfigLazy, boolean isNativeLauncher, boolean isRiderBackend, String ... params) {
            String backendGracefulShutdownTimeout;
            String executablePath = null;
            List arguments = new ArrayList();
            Map envVars = new LinkedHashMap();
            File bundledToolsDir = new File(PathManager.getHomePath(), "tools");
            envVars.put("JET_BUNDLED_TOOLS_PATH", bundledToolsDir.getPath());
            envVars.put("JET_CURRENT_DOTNET_CLI", NetCoreRuntime.INSTANCE.getCliPath().getValue());
            envVars.put("DOTNET_MULTILEVEL_LOOKUP", "0");
            String runtimeEventTracing = System.getProperty("rider.backend.JET_BACKEND_RUNTIME_EVENTS");
            if (runtimeEventTracing != null) {
                envVars.put("JET_BACKEND_RUNTIME_EVENTS", runtimeEventTracing);
            }
            if ((backendGracefulShutdownTimeout = System.getProperty("rider.backend.JET_GRACEFUL_SHUTDOWN_PERIOD_MS")) != null) {
                envVars.put("JET_GRACEFUL_SHUTDOWN_PERIOD_MS", backendGracefulShutdownTimeout);
            }
            Companion $this$thisLogger$iv = this;
            boolean $i$f$thisLogger = false;
            Logger logger = Logger.getInstance(Companion.class);
            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
            Logger logger2 = logger;
            if (runOnNetCore) {
                String dotnetTieredPgo;
                String string;
                String backendSchedulerImpl;
                String string2;
                String string3;
                String runtimeConfig;
                if (!isNativeLauncher) {
                    arguments.add("exec");
                }
                if ((runtimeConfig = (String)runtimeConfigLazy.getValue()) != null) {
                    arguments.add("--runtimeconfig");
                    arguments.add(runtimeConfig);
                }
                if (isNativeLauncher) {
                    string3 = assemblyAbsolutePath;
                } else {
                    string3 = dotnetPath;
                    if (string3 == null) {
                        throw new IllegalStateException("Launching netcore assembly " + assemblyName + " without native launcher, but the path to dotnet is not set");
                    }
                }
                executablePath = string3;
                if (isRiderBackend && NetCoreUtil.INSTANCE.useManagedLauncher()) {
                    String string4 = RiderEnvironment.getBundledFile$default(RiderEnvironment.INSTANCE, "JetLauncherILc.exe", false, null, false, 14, null).getAbsolutePath();
                    Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"getAbsolutePath(...)");
                    arguments.add(string4);
                    arguments.add("/Launcher::NoSplash");
                    arguments.add("/Launcher::Mode:InvokeMethod");
                    arguments.add("/Launcher::Target:Assembly");
                    arguments.add("/Launcher::AssemblyFile:" + assemblyAbsolutePath);
                    arguments.add("/Launcher::ClassName:JetBrains.Rider.Backend.Product.RiderBackendProgram");
                    arguments.add("/Launcher::MethodName:Main");
                    arguments.add("/Launcher::NetCoreAdditionalProbingPaths:" + assemblyParent + ";" + assemblyParent + "\\" + (CpuArch.isArm64() ? "arm64" : "x64"));
                } else if (!isNativeLauncher) {
                    String string5 = NetCoreUtil.INSTANCE.mapToNativeImage(assemblyAbsolutePath);
                    if (string5 == null) {
                        string5 = assemblyAbsolutePath;
                    }
                    arguments.add(string5);
                }
                if ((string2 = (backendSchedulerImpl = System.getProperty("rider.backend.shell.locks.use.task.scheduler.implementation"))) == null) {
                    string2 = "";
                }
                if (((CharSequence)string2).length() > 0) {
                    envVars.put("ShellLocks.Task.Scheduler.Implementation", backendSchedulerImpl);
                }
                if (NetCoreUtil.INSTANCE.getUseServerGC()) {
                    int heapCount;
                    envVars.put("DOTNET_gcServer", "1");
                    if (NetCoreUtil.INSTANCE.getServerGCNoAffinitize()) {
                        envVars.put("DOTNET_GCNoAffinitize", "1");
                    }
                    if ((heapCount = NetCoreUtil.INSTANCE.getServerGCHeapCount()) == -1) {
                        logger2.info("Enable DOTNET_GCDynamicAdaptationMode");
                        envVars.put("DOTNET_GCDynamicAdaptationMode", "1");
                    } else {
                        logger2.info("SET DOTNET_GCHeapCount = " + heapCount);
                        envVars.put("DOTNET_GCHeapCount", String.valueOf(heapCount));
                    }
                    int conserveMemory = NetCoreUtil.INSTANCE.getConserveMemory();
                    boolean bl = 1 <= conserveMemory ? conserveMemory < 10 : false;
                    if (bl) {
                        envVars.put("DOTNET_GCConserveMemory", String.valueOf(conserveMemory));
                    }
                }
                if ((string = (dotnetTieredPgo = System.getProperty("rider.backend.DOTNET_TieredPGO"))) == null) {
                    string = "0";
                }
                envVars.put("DOTNET_TieredPGO", string);
                Properties properties = System.getProperties();
                Intrinsics.checkNotNullExpressionValue((Object)properties, (String)"getProperties(...)");
                for (Map.Entry property : ((Map)properties).entrySet()) {
                    String propertyKey = property.getKey().toString();
                    if (!StringsKt.startsWith$default((String)propertyKey, (String)"rider.backend.DOTNET_", (boolean)false, (int)2, null)) continue;
                    String envVarKey = StringsKt.removePrefix((String)propertyKey, (CharSequence)"rider.backend.");
                    Object v = property.getValue();
                    String envVarValue = v != null ? v.toString() : null;
                    if (envVarValue == null) continue;
                    envVars.put(envVarKey, envVarValue);
                }
            } else {
                executablePath = assemblyAbsolutePath;
                if (RiderEnvironment.INSTANCE.isRiderForDebug() && RiderEnvironment.INSTANCE.isNotUnderTeamCity() && !PerformancePlaybackTestsKt.getApplicationIsPlayBackTestMode()) {
                    envVars.put("COMPLUS_FORCEENC", "1");
                    envVars.put("COMPLUS_ZapDisable", "1");
                }
            }
            CollectionsKt.addAll((Collection)arguments, (Object[])params);
            Map map = EnvironmentUtil.getEnvironmentMap();
            Intrinsics.checkNotNullExpressionValue((Object)map, (String)"getEnvironmentMap(...)");
            envVars.putAll(map);
            if (collectFullContainerStatistics) {
                envVars.put("COLLECT_FULL_CONTAINER_STATISTICS", "1");
            }
            Logger $this$trace$iv = logger2;
            boolean $i$f$trace = false;
            if ($this$trace$iv.isTraceEnabled()) {
                Logger logger3 = $this$trace$iv;
                boolean bl = false;
                logger3.trace("Executable chosen: \"" + executablePath + "\". Arguments: " + CollectionsKt.joinToString$default((Iterable)arguments, null, (CharSequence)"[", (CharSequence)"]", (int)0, null, null, (int)57, null) + ".");
            }
            return new AssemblyExecutionContext(executablePath, arguments, envVars, null);
        }

        private static final String create$lambda$0(File $assemblyFile) {
            File file = Companion.getRuntimeConfig(new File($assemblyFile.getAbsolutePath()));
            return file != null ? file.getAbsolutePath() : null;
        }

        private static final String create$lambda$1(BundledAssemblyLauncherInfo $launcherInfo, String $shortName) {
            String[] stringArray = new String[]{(StringsKt.endsWith((String)$shortName, (String)".dll", (boolean)true) || StringsKt.endsWith((String)$shortName, (String)".exe", (boolean)true) ? FileUtilRt.getNameWithoutExtension((String)$shortName) : $shortName) + ".runtimeconfig.json"};
            return $launcherInfo.getCustomInfo().getBinDirectory().appendPath(stringArray).getPath();
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

