/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rdclient.requests;

import com.intellij.openapi.client.ClientAppSession;
import com.jetbrains.rd.ide.document.DocumentSynchronizerListener;
import com.jetbrains.rd.ide.document.DocumentSynchronizerListeners;
import com.jetbrains.rd.ide.model.RdPatch;
import com.jetbrains.rd.ide.model.RdResponse;
import com.jetbrains.rd.ide.requests.PatchEngineRetryTimestampWithGeneration;
import com.jetbrains.rd.ide.requests.SpeculativelyEqualsResult;
import com.jetbrains.rd.tracing.SyncEventsLogger;
import com.jetbrains.rdclient.diagnostics.CaretMovementTracker;
import com.jetbrains.rdclient.diagnostics.ConflictTracker;
import com.jetbrains.rdclient.requests.BackendResponse;
import com.jetbrains.rdclient.requests.FrontendAsyncRequest;
import com.jetbrains.rdclient.requests.FrontendAsyncRequestExecutorHelper;
import com.jetbrains.rdclient.requests.FrontendAsyncRequestWithImmediateResult;
import com.jetbrains.rdclient.requests.FrontendRebaseSession;
import com.jetbrains.rdclient.requests.RequestStatus;
import com.jetbrains.rdclient.requests.SpeculativeRequestWrapper;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001B5\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\n\b\u0002\u0010\f\u001a\u0004\u0018\u00010\r\u00a2\u0006\u0004\b\u000e\u0010\u000fJ\u0010\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u0003H\u0016J \u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001a\u001a\u00020\u00032\u0006\u0010\u001f\u001a\u00020\u0002H\u0016J\u0018\u0010 \u001a\u00020\u001c2\u0006\u0010\u001a\u001a\u00020\u00032\u0006\u0010\u001f\u001a\u00020\u0002H\u0016J\b\u0010!\u001a\u00020\u001cH\u0016J$\u0010\"\u001a\u00020\u001c2\u0006\u0010#\u001a\u00020$2\u0012\u0010%\u001a\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u001c0&H\u0016R\u0014\u0010\u0004\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0013\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\f\u001a\u0004\u0018\u00010\rX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017\u00a8\u0006'"}, d2={"Lcom/jetbrains/rdclient/requests/SuccessResponseWrapper;", "Lcom/jetbrains/rdclient/requests/BackendResponse$Success;", "Lcom/jetbrains/rdclient/requests/FrontendRebaseSession;", "Lcom/jetbrains/rdclient/requests/SpeculativeRequestWrapper;", "requestId", "", "patch", "Lcom/jetbrains/rd/ide/model/RdPatch;", "response", "Lcom/jetbrains/rd/ide/model/RdResponse;", "session", "Lcom/intellij/openapi/client/ClientAppSession;", "newRetryTimestamp", "Lcom/jetbrains/rd/ide/requests/PatchEngineRetryTimestampWithGeneration;", "<init>", "(JLcom/jetbrains/rd/ide/model/RdPatch;Lcom/jetbrains/rd/ide/model/RdResponse;Lcom/intellij/openapi/client/ClientAppSession;Lcom/jetbrains/rd/ide/requests/PatchEngineRetryTimestampWithGeneration;)V", "getRequestId", "()J", "getPatch", "()Lcom/jetbrains/rd/ide/model/RdPatch;", "getResponse", "()Lcom/jetbrains/rd/ide/model/RdResponse;", "getNewRetryTimestamp", "()Lcom/jetbrains/rd/ide/requests/PatchEngineRetryTimestampWithGeneration;", "compare", "Lcom/jetbrains/rd/ide/requests/SpeculativelyEqualsResult;", "req", "apply", "", "virtually", "", "context", "complete", "executed", "withChangeContext", "elementsInContext", "", "action", "Lkotlin/Function1;", "intellij.rd.client"})
@SourceDebugExtension(value={"SMAP\nSuccessResponseWrapper.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SuccessResponseWrapper.kt\ncom/jetbrains/rdclient/requests/SuccessResponseWrapper\n+ 2 FrontendRebaseSession.kt\ncom/jetbrains/rdclient/requests/FrontendRebaseSession$Companion\n*L\n1#1,48:1\n36#2,13:49\n*S KotlinDebug\n*F\n+ 1 SuccessResponseWrapper.kt\ncom/jetbrains/rdclient/requests/SuccessResponseWrapper\n*L\n46#1:49,13\n*E\n"})
public final class SuccessResponseWrapper
implements BackendResponse.Success<FrontendRebaseSession, SpeculativeRequestWrapper> {
    private final long requestId;
    @Nullable
    private final RdPatch patch;
    @NotNull
    private final RdResponse response;
    @NotNull
    private final ClientAppSession session;
    @Nullable
    private final PatchEngineRetryTimestampWithGeneration newRetryTimestamp;

    public SuccessResponseWrapper(long requestId, @Nullable RdPatch patch, @NotNull RdResponse response, @NotNull ClientAppSession session2, @Nullable PatchEngineRetryTimestampWithGeneration newRetryTimestamp) {
        Intrinsics.checkNotNullParameter((Object)response, (String)"response");
        Intrinsics.checkNotNullParameter((Object)session2, (String)"session");
        this.requestId = requestId;
        this.patch = patch;
        this.response = response;
        this.session = session2;
        this.newRetryTimestamp = newRetryTimestamp;
    }

    public /* synthetic */ SuccessResponseWrapper(long l, RdPatch rdPatch, RdResponse rdResponse, ClientAppSession clientAppSession, PatchEngineRetryTimestampWithGeneration patchEngineRetryTimestampWithGeneration, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 0x10) != 0) {
            patchEngineRetryTimestampWithGeneration = null;
        }
        this(l, rdPatch, rdResponse, clientAppSession, patchEngineRetryTimestampWithGeneration);
    }

    @Override
    public long getRequestId() {
        return this.requestId;
    }

    @Nullable
    public final RdPatch getPatch() {
        return this.patch;
    }

    @NotNull
    public final RdResponse getResponse() {
        return this.response;
    }

    @Override
    @Nullable
    public PatchEngineRetryTimestampWithGeneration getNewRetryTimestamp() {
        return this.newRetryTimestamp;
    }

    @Override
    @NotNull
    public SpeculativelyEqualsResult compare(@NotNull SpeculativeRequestWrapper req) {
        Intrinsics.checkNotNullParameter((Object)req, (String)"req");
        FrontendAsyncRequest originalRequest = req.getRequest();
        if (originalRequest instanceof FrontendAsyncRequestWithImmediateResult) {
            return FrontendAsyncRequestExecutorHelper.INSTANCE.speculativelyEquals(((FrontendAsyncRequestWithImmediateResult)originalRequest).getPatch(), this.patch, (FrontendAsyncRequestWithImmediateResult)originalRequest, true);
        }
        return this.patch == null || this.patch.getChanges().isEmpty() ? SpeculativelyEqualsResult.Equals : SpeculativelyEqualsResult.Different;
    }

    @Override
    public void apply(boolean virtually, @NotNull SpeculativeRequestWrapper req, @NotNull FrontendRebaseSession context) {
        Intrinsics.checkNotNullParameter((Object)req, (String)"req");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        if (this.patch != null) {
            FrontendAsyncRequestExecutorHelper.INSTANCE.applyBackendChangesOnly(this.patch, virtually, context, req.getRequest(), this.session);
        }
    }

    @Override
    public void complete(@NotNull SpeculativeRequestWrapper req, @NotNull FrontendRebaseSession context) {
        Intrinsics.checkNotNullParameter((Object)req, (String)"req");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        if (this.patch != null) {
            FrontendAsyncRequestExecutorHelper.INSTANCE.applyBackendFeaturesOnlyAndUpdate(this.patch, context, req.getRequest(), this.session);
        }
        req.getRequest().setStatus(RequestStatus.Companion.getCOMPLETED());
        FrontendAsyncRequestExecutorHelper.INSTANCE.fireRequestCompleted(this.session, req.getRequest(), this.response);
    }

    @Override
    public void executed() {
        FrontendAsyncRequestExecutorHelper.INSTANCE.fireResponsesExecuted(this.session, CollectionsKt.listOf((Object)this.response));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @Override
    public void withChangeContext(int elementsInContext, @NotNull Function1<? super FrontendRebaseSession, Unit> action2) {
        void clientAppSession$iv;
        void this_$iv;
        void sessionType$iv;
        Intrinsics.checkNotNullParameter(action2, (String)"action");
        FrontendRebaseSession.Companion companion = FrontendRebaseSession.Companion;
        ClientAppSession clientAppSession = this.session;
        SyncEventsLogger.RebaseSessionType rebaseSessionType = SyncEventsLogger.RebaseSessionType.RESPONSE_HANDLING;
        int batchSize$iv = elementsInContext;
        boolean $i$f$using = false;
        ConflictTracker conflictTracker$iv = new ConflictTracker((SyncEventsLogger.RebaseSessionType)sessionType$iv, batchSize$iv);
        CaretMovementTracker caretMovementTracker$iv = new CaretMovementTracker();
        FrontendRebaseSession rebaseSession$iv = this_$iv.createEmpty((SyncEventsLogger.RebaseSessionType)sessionType$iv, conflictTracker$iv, caretMovementTracker$iv);
        try {
            DocumentSynchronizerListeners.Companion.getInstance((ClientAppSession)clientAppSession$iv).addListener((DocumentSynchronizerListener)rebaseSession$iv);
            action2.invoke((Object)rebaseSession$iv);
        }
        finally {
            DocumentSynchronizerListeners.Companion.getInstance((ClientAppSession)clientAppSession$iv).removeListener((DocumentSynchronizerListener)rebaseSession$iv);
            caretMovementTracker$iv.reportAllMovements(conflictTracker$iv);
            conflictTracker$iv.reportSummary();
        }
    }
}

