/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rdclient.requests;

import com.intellij.openapi.client.ClientAppSession;
import com.intellij.openapi.command.impl.ResetUndoHistoryToken;
import com.intellij.openapi.diagnostic.Logger;
import com.jetbrains.rd.ide.model.RdApplyPatchRequest;
import com.jetbrains.rd.ide.model.RdCaretStateChange;
import com.jetbrains.rd.ide.model.RdCaretStateSnapshot;
import com.jetbrains.rd.ide.model.RdEditorVersion;
import com.jetbrains.rd.ide.model.RdPatch;
import com.jetbrains.rd.ide.model.RdPatchEditorVersion;
import com.jetbrains.rd.ide.model.RdPatchItemId;
import com.jetbrains.rd.ide.model.RdRequest;
import com.jetbrains.rd.ide.model.RdSelectionChangeBase;
import com.jetbrains.rd.ide.model.TextControlId;
import com.jetbrains.rd.util.string.IPrintableKt;
import com.jetbrains.rdclient.engine.handlers.FrontendRdPatchHandlerContext;
import com.jetbrains.rdclient.patches.FrontendRdPatchHandlerRegistry;
import com.jetbrains.rdclient.requests.FrontendAsyncRequest;
import com.jetbrains.rdclient.requests.FrontendAsyncRequestWithImmediateResult;
import com.jetbrains.rdclient.requests.PatchItemOperationType;
import java.util.List;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\u0018\u0000 \u001b2\u00020\u0001:\u0001\u001bB!\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\b\u0010\u0010\u001a\u00020\u0011H\u0016J\u0012\u0010\u0012\u001a\u0004\u0018\u00010\u00132\u0006\u0010\u0014\u001a\u00020\u0013H\u0016J\u001a\u0010\u0015\u001a\u0004\u0018\u00010\u00162\u0006\u0010\u0017\u001a\u00020\u00162\u0006\u0010\u0018\u001a\u00020\u0016H\u0002J\b\u0010\u0019\u001a\u00020\u001aH\u0014R\u001b\u0010\n\u001a\u00020\u000b8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u000e\u0010\u000f\u001a\u0004\b\f\u0010\r\u00a8\u0006\u001c"}, d2={"Lcom/jetbrains/rdclient/requests/FrontendApplyPatchRequest;", "Lcom/jetbrains/rdclient/requests/FrontendAsyncRequestWithImmediateResult;", "p", "Lcom/jetbrains/rd/ide/model/RdPatch;", "session", "Lcom/intellij/openapi/client/ClientAppSession;", "resetUndoHistoryToken", "Lcom/intellij/openapi/command/impl/ResetUndoHistoryToken;", "<init>", "(Lcom/jetbrains/rd/ide/model/RdPatch;Lcom/intellij/openapi/client/ClientAppSession;Lcom/intellij/openapi/command/impl/ResetUndoHistoryToken;)V", "patchHandlerRegistry", "Lcom/jetbrains/rdclient/patches/FrontendRdPatchHandlerRegistry;", "getPatchHandlerRegistry", "()Lcom/jetbrains/rdclient/patches/FrontendRdPatchHandlerRegistry;", "patchHandlerRegistry$delegate", "Lkotlin/Lazy;", "createModel", "Lcom/jetbrains/rd/ide/model/RdRequest;", "tryMergeWith", "Lcom/jetbrains/rdclient/requests/FrontendAsyncRequest;", "nextRequest", "mergeCaretChanges", "Lcom/jetbrains/rd/ide/model/RdSelectionChangeBase;", "old", "new", "debugDescription", "", "Companion", "intellij.rd.client"})
@SourceDebugExtension(value={"SMAP\nFrontendApplyPatchRequest.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FrontendApplyPatchRequest.kt\ncom/jetbrains/rdclient/requests/FrontendApplyPatchRequest\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,62:1\n67#2,4:63\n67#2,4:67\n13#2:71\n*S KotlinDebug\n*F\n+ 1 FrontendApplyPatchRequest.kt\ncom/jetbrains/rdclient/requests/FrontendApplyPatchRequest\n*L\n47#1:63,4\n55#1:67,4\n19#1:71\n*E\n"})
public final class FrontendApplyPatchRequest
extends FrontendAsyncRequestWithImmediateResult {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Lazy patchHandlerRegistry$delegate;
    @NotNull
    private static final Logger logger;

    public FrontendApplyPatchRequest(@NotNull RdPatch p, @NotNull ClientAppSession session2, @Nullable ResetUndoHistoryToken resetUndoHistoryToken) {
        Intrinsics.checkNotNullParameter((Object)p, (String)"p");
        Intrinsics.checkNotNullParameter((Object)session2, (String)"session");
        super(session2, p, resetUndoHistoryToken);
        this.patchHandlerRegistry$delegate = LazyKt.lazy(FrontendApplyPatchRequest::patchHandlerRegistry_delegate$lambda$0);
    }

    private final FrontendRdPatchHandlerRegistry getPatchHandlerRegistry() {
        Lazy lazy = this.patchHandlerRegistry$delegate;
        return (FrontendRdPatchHandlerRegistry)lazy.getValue();
    }

    @Override
    @NotNull
    public RdRequest createModel() {
        RdPatch rdPatch = this.getPatch();
        if (rdPatch == null) {
            rdPatch = FrontendAsyncRequest.Companion.getEmptyPatch();
        }
        return (RdRequest)new RdApplyPatchRequest(rdPatch);
    }

    @Override
    @Nullable
    public FrontendAsyncRequest tryMergeWith(@NotNull FrontendAsyncRequest nextRequest) {
        Intrinsics.checkNotNullParameter((Object)nextRequest, (String)"nextRequest");
        RdPatch rdPatch = this.getPatch();
        if (rdPatch == null) {
            return null;
        }
        RdPatch currentPatch = rdPatch;
        FrontendApplyPatchRequest frontendApplyPatchRequest = nextRequest instanceof FrontendApplyPatchRequest ? (FrontendApplyPatchRequest)nextRequest : null;
        if (frontendApplyPatchRequest == null || (frontendApplyPatchRequest = frontendApplyPatchRequest.getPatch()) == null) {
            return null;
        }
        FrontendApplyPatchRequest newPatch = frontendApplyPatchRequest;
        Object object = CollectionsKt.singleOrNull((List)currentPatch.getChanges());
        RdSelectionChangeBase rdSelectionChangeBase = object instanceof RdSelectionChangeBase ? (RdSelectionChangeBase)object : null;
        if (rdSelectionChangeBase == null) {
            return null;
        }
        RdSelectionChangeBase currentCaretChange = rdSelectionChangeBase;
        Object object2 = CollectionsKt.singleOrNull((List)newPatch.getChanges());
        RdSelectionChangeBase rdSelectionChangeBase2 = object2 instanceof RdSelectionChangeBase ? (RdSelectionChangeBase)object2 : null;
        if (rdSelectionChangeBase2 == null) {
            return null;
        }
        RdSelectionChangeBase newCaretChange = rdSelectionChangeBase2;
        Object object3 = CollectionsKt.singleOrNull((List)currentPatch.getUpdatedItemVersions());
        RdPatchEditorVersion rdPatchEditorVersion = object3 instanceof RdPatchEditorVersion ? (RdPatchEditorVersion)object3 : null;
        if (rdPatchEditorVersion == null || (rdPatchEditorVersion = rdPatchEditorVersion.getVersion()) == null) {
            return null;
        }
        RdPatchEditorVersion currentUpdatedVersion = rdPatchEditorVersion;
        Object object4 = CollectionsKt.singleOrNull((List)newPatch.getUpdatedItemVersions());
        RdPatchEditorVersion rdPatchEditorVersion2 = object4 instanceof RdPatchEditorVersion ? (RdPatchEditorVersion)object4 : null;
        if (rdPatchEditorVersion2 == null || (rdPatchEditorVersion2 = rdPatchEditorVersion2.getVersion()) == null) {
            return null;
        }
        RdPatchEditorVersion newPatchUpdatedVersion = rdPatchEditorVersion2;
        if (!Intrinsics.areEqual((Object)currentUpdatedVersion.getDocumentVersion(), (Object)newPatchUpdatedVersion.getDocumentVersion())) {
            return null;
        }
        RdSelectionChangeBase rdSelectionChangeBase3 = this.mergeCaretChanges(currentCaretChange, newCaretChange);
        if (rdSelectionChangeBase3 == null) {
            return null;
        }
        RdSelectionChangeBase mergedCaretChange = rdSelectionChangeBase3;
        RdPatchEditorVersion newUpdatedVersion = new RdPatchEditorVersion(new RdEditorVersion(currentUpdatedVersion.getCaretModelVersion(), currentUpdatedVersion.getDocumentVersion(), newPatchUpdatedVersion.getHash()), (RdPatchItemId)currentCaretChange.getEditorId());
        List updatedVersions = CollectionsKt.listOf((Object)newUpdatedVersion);
        this.getPatchHandlerRegistry().update(updatedVersions, new FrontendRdPatchHandlerContext(this.getSession(), currentPatch, nextRequest, PatchItemOperationType.Merge.INSTANCE, null, 16, null));
        return new FrontendApplyPatchRequest(RdPatch.copy$default((RdPatch)currentPatch, (List)CollectionsKt.listOf((Object)mergedCaretChange), null, null, (List)updatedVersions, (int)6, null), this.getSession(), this.getResetUndoHistoryToken());
    }

    private final RdSelectionChangeBase mergeCaretChanges(RdSelectionChangeBase old, RdSelectionChangeBase rdSelectionChangeBase) {
        RdSelectionChangeBase rdSelectionChangeBase2;
        if (!Intrinsics.areEqual((Object)old.getEditorId(), (Object)rdSelectionChangeBase.getEditorId())) {
            Logger $this$trace$iv = logger;
            boolean $i$f$trace = false;
            if ($this$trace$iv.isTraceEnabled()) {
                Logger logger = $this$trace$iv;
                boolean bl = false;
                logger.trace("Failed to merge caret changes with different editorId: " + old.getEditorId() + " and " + rdSelectionChangeBase.getEditorId());
            }
            return null;
        }
        TextControlId editorId = old.getEditorId();
        if (rdSelectionChangeBase instanceof RdCaretStateSnapshot) {
            rdSelectionChangeBase2 = rdSelectionChangeBase;
        } else if (old instanceof RdCaretStateChange && rdSelectionChangeBase instanceof RdCaretStateChange) {
            rdSelectionChangeBase2 = (RdSelectionChangeBase)new RdCaretStateChange(((RdCaretStateChange)old).getOldState(), ((RdCaretStateChange)rdSelectionChangeBase).getNewState(), editorId);
        } else {
            Logger $this$trace$iv = logger;
            boolean $i$f$trace = false;
            if ($this$trace$iv.isTraceEnabled()) {
                Logger logger = $this$trace$iv;
                boolean bl = false;
                logger.trace("Failed to merge the following caret changes, old: " + old + ", new: " + rdSelectionChangeBase);
            }
            rdSelectionChangeBase2 = null;
        }
        return rdSelectionChangeBase2;
    }

    @Override
    @NotNull
    protected String debugDescription() {
        return "Patch: " + IPrintableKt.printToString((Object)this.getPatch());
    }

    private static final FrontendRdPatchHandlerRegistry patchHandlerRegistry_delegate$lambda$0() {
        return FrontendRdPatchHandlerRegistry.Companion.getInstance();
    }

    static {
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(FrontendApplyPatchRequest.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        FrontendApplyPatchRequest.logger = logger;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/jetbrains/rdclient/requests/FrontendApplyPatchRequest$Companion;", "", "<init>", "()V", "logger", "Lcom/intellij/openapi/diagnostic/Logger;", "intellij.rd.client"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

