/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rdclient.protocol;

import com.intellij.concurrency.ThreadContext;
import com.intellij.diagnostic.LoadingState;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.application.impl.InvocationUtil;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Condition;
import com.jetbrains.rd.platform.protocol.IRdDispatcher;
import com.jetbrains.rd.util.collections.CountingSet;
import com.jetbrains.rd.util.lifetime.Lifetime;
import com.jetbrains.rd.util.lifetime.RLifetimeKt;
import com.jetbrains.rd.util.reactive.ExecutionOrder;
import com.jetbrains.rd.util.reactive.IScheduler;
import com.jetbrains.rd.util.threading.SingleThreadScheduler;
import com.jetbrains.rdclient.protocol.IPermittedModalities;
import com.jetbrains.rdclient.protocol.ModalityStateWithCondition;
import com.jetbrains.rdclient.protocol.PermittedModalitiesImpl;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import javax.swing.SwingUtilities;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000|\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0000\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\n\b\u0016\u0018\u0000 A2\u00020\u0001:\u0001AB\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007B\u0011\b\u0016\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\bJ\b\u0010$\u001a\u00020%H\u0016J\u0018\u0010&\u001a\u00020\u001e2\u0006\u0010'\u001a\u00020\u00052\u0006\u0010(\u001a\u00020)H\u0002J\b\u0010*\u001a\u00020\fH\u0016J\u0012\u0010+\u001a\u00020\f2\b\u0010,\u001a\u0004\u0018\u00010-H\u0016J\u0016\u00100\u001a\u00020\f2\f\u00101\u001a\b\u0012\u0004\u0012\u00020\u00100\u000bH\u0016J\b\u00102\u001a\u00020\fH\u0002J\b\u00103\u001a\u00020\fH\u0002J\u0010\u00109\u001a\u00020\f2\u0006\u0010\u0004\u001a\u00020\u0005H\u0016J\u0010\u0010:\u001a\u00020\f2\u0006\u0010\u0004\u001a\u00020\u0005H\u0016J\u0016\u0010;\u001a\u00020\f2\f\u0010<\u001a\b\u0012\u0004\u0012\u00020\f0\u000bH\u0016J\u0010\u0010>\u001a\u00020\f2\u0006\u0010\u0004\u001a\u00020\u0005H\u0016J\b\u0010?\u001a\u00020\fH\u0002J\b\u0010@\u001a\u00020\fH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\t\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\f0\u000b0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0011\u001a\u00020\u0012X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u0014\u0010\u0015\u001a\u00020\u0016X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018R\u0014\u0010\u0019\u001a\u00020\u001a8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001b\u0010\u001cR\u000e\u0010\u001d\u001a\u00020\u001eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u001f\u001a\u00020\u001eX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b \u0010!\"\u0004\b\"\u0010#R\u0014\u0010.\u001a\u00020\u00108VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b.\u0010/R\u0014\u00104\u001a\b\u0012\u0004\u0012\u00020605X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u00107\u001a\u000208X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010=\u001a\u000208X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006B"}, d2={"Lcom/jetbrains/rdclient/protocol/RdDispatcher;", "Lcom/jetbrains/rd/platform/protocol/IRdDispatcher;", "application", "Lcom/intellij/openapi/application/Application;", "lifetime", "Lcom/jetbrains/rd/util/lifetime/Lifetime;", "<init>", "(Lcom/intellij/openapi/application/Application;Lcom/jetbrains/rd/util/lifetime/Lifetime;)V", "(Lcom/jetbrains/rd/util/lifetime/Lifetime;)V", "requests", "Ljava/util/concurrent/LinkedBlockingQueue;", "Lkotlin/Function0;", "", "flushAllRunnable", "Ljava/lang/Runnable;", "processingInProgress", "", "lock", "Ljava/lang/Object;", "getLock", "()Ljava/lang/Object;", "backgroundScheduler", "Lcom/jetbrains/rd/util/reactive/IScheduler;", "getBackgroundScheduler", "()Lcom/jetbrains/rd/util/reactive/IScheduler;", "executionOrder", "Lcom/jetbrains/rd/util/reactive/ExecutionOrder;", "getExecutionOrder", "()Lcom/jetbrains/rd/util/reactive/ExecutionOrder;", "DEFAULT", "Lcom/jetbrains/rdclient/protocol/ModalityStateWithCondition;", "currentModalityAndCondition", "getCurrentModalityAndCondition", "()Lcom/jetbrains/rdclient/protocol/ModalityStateWithCondition;", "setCurrentModalityAndCondition", "(Lcom/jetbrains/rdclient/protocol/ModalityStateWithCondition;)V", "getPermittedModalitiesInstance", "Lcom/jetbrains/rdclient/protocol/PermittedModalitiesImpl;", "createOrDefault", "lt", "modalityState", "Lcom/intellij/openapi/application/ModalityState;", "flush", "assertThread", "debugInfo", "", "isActive", "()Z", "pumpProtocolQueue", "condition", "flushAll", "flushAllInternal", "allowedOnThisThread", "Lcom/jetbrains/rd/util/collections/CountingSet;", "Ljava/lang/Thread;", "allowedOnAnyThread", "", "allowBackgroundThreadAndSuppressPumping", "allowAllBackgroundThreadsAndSuppressPumping", "queue", "action", "suppressRequests", "suppressPumping", "repostConditionally", "repost", "Companion", "intellij.rd.client"})
@SourceDebugExtension(value={"SMAP\nRdDispatcher.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RdDispatcher.kt\ncom/jetbrains/rdclient/protocol/RdDispatcher\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,240:1\n13#2:241\n*S KotlinDebug\n*F\n+ 1 RdDispatcher.kt\ncom/jetbrains/rdclient/protocol/RdDispatcher\n*L\n26#1:241\n*E\n"})
public class RdDispatcher
implements IRdDispatcher {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Application application;
    @NotNull
    private final LinkedBlockingQueue<Function0<Unit>> requests;
    @NotNull
    private final Runnable flushAllRunnable;
    private boolean processingInProgress;
    @NotNull
    private final Object lock;
    @NotNull
    private final IScheduler backgroundScheduler;
    @NotNull
    private final ModalityStateWithCondition DEFAULT;
    @NotNull
    private volatile ModalityStateWithCondition currentModalityAndCondition;
    @NotNull
    private final CountingSet<Thread> allowedOnThisThread;
    private int allowedOnAnyThread;
    private int suppressRequests;
    @NotNull
    private static final Logger LOG;

    public RdDispatcher(@NotNull Application application, @NotNull Lifetime lifetime) {
        Intrinsics.checkNotNullParameter((Object)application, (String)"application");
        Intrinsics.checkNotNullParameter((Object)lifetime, (String)"lifetime");
        this.application = application;
        this.requests = new LinkedBlockingQueue();
        this.flushAllRunnable = () -> RdDispatcher.flushAllRunnable$lambda$0(this);
        this.lock = new Object();
        this.backgroundScheduler = (IScheduler)new SingleThreadScheduler(lifetime, "BackgroundScheduler");
        ModalityState modalityState = ModalityState.nonModal();
        Intrinsics.checkNotNullExpressionValue((Object)modalityState, (String)"nonModal(...)");
        this.currentModalityAndCondition = this.DEFAULT = new ModalityStateWithCondition(modalityState, (Condition<Object>)((Condition)arg_0 -> RdDispatcher.DEFAULT$lambda$0(lifetime, arg_0)));
        SwingUtilities.invokeLater(() -> RdDispatcher._init_$lambda$0(this, lifetime));
        this.allowedOnThisThread = new CountingSet();
    }

    public RdDispatcher(@NotNull Lifetime lifetime) {
        Intrinsics.checkNotNullParameter((Object)lifetime, (String)"lifetime");
        Application application = ApplicationManager.getApplication();
        Intrinsics.checkNotNullExpressionValue((Object)application, (String)"getApplication(...)");
        this(application, lifetime);
    }

    @NotNull
    protected final Object getLock() {
        return this.lock;
    }

    @NotNull
    public IScheduler getBackgroundScheduler() {
        return this.backgroundScheduler;
    }

    @NotNull
    public ExecutionOrder getExecutionOrder() {
        return ExecutionOrder.Sequential;
    }

    @NotNull
    public final ModalityStateWithCondition getCurrentModalityAndCondition() {
        return this.currentModalityAndCondition;
    }

    public final void setCurrentModalityAndCondition(@NotNull ModalityStateWithCondition modalityStateWithCondition) {
        Intrinsics.checkNotNullParameter((Object)modalityStateWithCondition, (String)"<set-?>");
        this.currentModalityAndCondition = modalityStateWithCondition;
    }

    @NotNull
    public PermittedModalitiesImpl getPermittedModalitiesInstance() {
        return IPermittedModalities.Companion.getInstance(this.application);
    }

    private final ModalityStateWithCondition createOrDefault(Lifetime lt, ModalityState modalityState) {
        return !Intrinsics.areEqual((Object)ModalityState.nonModal(), (Object)modalityState) ? new ModalityStateWithCondition(modalityState, (Condition<Object>)((Condition)arg_0 -> RdDispatcher.createOrDefault$lambda$0(lt, arg_0))) : this.DEFAULT;
    }

    public void flush() {
        this.flushAll();
    }

    public void assertThread(@Nullable Object debugInfo) {
        if (!this.isActive()) {
            LOG.error("Must be executed on UI thread or background threads with special permissions", (Throwable)new IllegalStateException("|E| Wrong thread " + debugInfo));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean isActive() {
        if (this.application.isDispatchThread()) return true;
        Object object = this.lock;
        synchronized (object) {
            boolean bl = false;
            if (((Number)this.allowedOnThisThread.get((Object)Thread.currentThread())).intValue() > 0) return true;
            if (this.allowedOnAnyThread <= 0) return false;
            return true;
        }
    }

    public void pumpProtocolQueue(@NotNull Function0<Boolean> condition) {
        Intrinsics.checkNotNullParameter(condition, (String)"condition");
        ThreadContext.resetThreadContext(() -> RdDispatcher.pumpProtocolQueue$lambda$0(this, condition));
    }

    private final void flushAll() {
        ThreadContext.resetThreadContext(() -> RdDispatcher.flushAll$lambda$0(this));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void flushAllInternal() {
        while (true) {
            try {
                Object object = this.lock;
                synchronized (object) {
                    boolean bl = false;
                    if (this.suppressRequests > 0 || this.requests.size() == 0) {
                        this.processingInProgress = false;
                        return;
                    }
                    Unit $i$a$-synchronized-RdDispatcher$flushAllInternal$4 = Unit.INSTANCE;
                }
                long startTime = System.currentTimeMillis();
                Function0<Unit> next = this.requests.poll();
                if (next != null) {
                    ModalityState old;
                    boolean isModalityChanged;
                    Intrinsics.checkNotNullExpressionValue((Object)ModalityState.current(), (String)"current(...)");
                    next.invoke();
                    boolean bl = isModalityChanged = !Intrinsics.areEqual((Object)old, (Object)ModalityState.current());
                    if (isModalityChanged) {
                        Object object2 = this.lock;
                        synchronized (object2) {
                            boolean bl2 = false;
                            this.processingInProgress = false;
                            Unit unit = Unit.INSTANCE;
                        }
                        this.repost();
                        return;
                    }
                }
                if (!InvocationUtil.priorityEventPending() && System.currentTimeMillis() - startTime <= 50L) continue;
                Object object3 = this.lock;
                synchronized (object3) {
                    boolean bl = false;
                    this.processingInProgress = false;
                    Unit unit = Unit.INSTANCE;
                }
                this.repost();
                return;
            }
            catch (Throwable t) {
                LOG.error(t);
                continue;
            }
            break;
        }
    }

    public void allowBackgroundThreadAndSuppressPumping(@NotNull Lifetime lifetime) {
        Intrinsics.checkNotNullParameter((Object)lifetime, (String)"lifetime");
        this.suppressPumping(lifetime);
        Thread thread = Thread.currentThread();
        lifetime.bracketIfAlive(() -> RdDispatcher.allowBackgroundThreadAndSuppressPumping$lambda$0(this, thread), () -> RdDispatcher.allowBackgroundThreadAndSuppressPumping$lambda$1(this, thread));
    }

    public void allowAllBackgroundThreadsAndSuppressPumping(@NotNull Lifetime lifetime) {
        Intrinsics.checkNotNullParameter((Object)lifetime, (String)"lifetime");
        this.suppressPumping(lifetime);
        lifetime.bracketIfAlive(() -> RdDispatcher.allowAllBackgroundThreadsAndSuppressPumping$lambda$0(this), () -> RdDispatcher.allowAllBackgroundThreadsAndSuppressPumping$lambda$1(this));
    }

    public void queue(@NotNull Function0<Unit> action2) {
        Intrinsics.checkNotNullParameter(action2, (String)"action");
        this.requests.add((Function0<Unit>)ThreadContext.captureThreadContext(action2));
        this.repostConditionally();
    }

    public void suppressPumping(@NotNull Lifetime lifetime) {
        Intrinsics.checkNotNullParameter((Object)lifetime, (String)"lifetime");
        lifetime.bracketIfAlive(() -> RdDispatcher.suppressPumping$lambda$0(this), () -> RdDispatcher.suppressPumping$lambda$1(this));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void repostConditionally() {
        Object object = this.lock;
        synchronized (object) {
            block6: {
                block5: {
                    boolean bl = false;
                    if (this.suppressRequests > 0 || this.requests.size() == 0) break block5;
                    if (!this.processingInProgress) break block6;
                }
                return;
            }
            Unit unit = Unit.INSTANCE;
        }
        this.repost();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void repost() {
        Object object = this.lock;
        synchronized (object) {
            boolean $i$a$-synchronized-RdDispatcher$repost$22 = false;
            this.processingInProgress = true;
            Unit $i$a$-synchronized-RdDispatcher$repost$22 = Unit.INSTANCE;
        }
        if (LoadingState.COMPONENTS_LOADED.isOccurred()) {
            ModalityStateWithCondition modalityStateWithCondition = this.currentModalityAndCondition;
            ModalityState modality = modalityStateWithCondition.component1();
            Condition<Object> expired = modalityStateWithCondition.component2();
            this.application.invokeLater(this.flushAllRunnable, modality, expired);
        } else {
            SwingUtilities.invokeLater(this.flushAllRunnable);
        }
    }

    private static final void flushAllRunnable$lambda$0(RdDispatcher this$0) {
        this$0.flushAll();
    }

    private static final boolean DEFAULT$lambda$0(Lifetime $lifetime, Object it) {
        return RLifetimeKt.isNotAlive((Lifetime)$lifetime);
    }

    private static final void _init_$lambda$0(RdDispatcher this$0, Lifetime $lifetime) {
        this$0.getPermittedModalitiesInstance().viewPermittedModality($lifetime, (Function2<? super Lifetime, ? super ModalityState, Unit>)((Function2)(arg_0, arg_1) -> RdDispatcher.lambda$0$0(this$0, arg_0, arg_1)));
    }

    private static final Unit lambda$0$0(RdDispatcher this$0, Lifetime lt, ModalityState modalityState) {
        Intrinsics.checkNotNullParameter((Object)lt, (String)"lt");
        Intrinsics.checkNotNullParameter((Object)modalityState, (String)"modalityState");
        this$0.currentModalityAndCondition = this$0.createOrDefault(lt, modalityState);
        this$0.repost();
        return Unit.INSTANCE;
    }

    private static final boolean createOrDefault$lambda$0(Lifetime $lt, Object it) {
        return RLifetimeKt.isNotAlive((Lifetime)$lt);
    }

    private static final Unit pumpProtocolQueue$lambda$0(RdDispatcher this$0, Function0 $condition) {
        IScheduler.DefaultImpls.assertThread$default((IScheduler)((IScheduler)this$0), null, (int)1, null);
        while (((Boolean)$condition.invoke()).booleanValue()) {
            try {
                Function0<Unit> function0 = this$0.requests.poll(10L, TimeUnit.MILLISECONDS);
                if (function0 == null) continue;
                function0.invoke();
            }
            catch (Throwable t) {
                LOG.error(t);
            }
        }
        return Unit.INSTANCE;
    }

    private static final Unit flushAll$lambda$0(RdDispatcher this$0) {
        IScheduler.DefaultImpls.assertThread$default((IScheduler)((IScheduler)this$0), null, (int)1, null);
        try {
            this$0.flushAllInternal();
        }
        catch (Throwable t) {
            this$0.repost();
            LOG.error("Unexpected exception", t);
        }
        return Unit.INSTANCE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final int allowBackgroundThreadAndSuppressPumping$lambda$0(RdDispatcher this$0, Thread $thread) {
        int n;
        Object object = this$0.lock;
        synchronized (object) {
            boolean bl = false;
            CountingSet<Thread> countingSet = this$0.allowedOnThisThread;
            Intrinsics.checkNotNull((Object)$thread);
            n = countingSet.add((Object)$thread, 1);
        }
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final Unit allowBackgroundThreadAndSuppressPumping$lambda$1(RdDispatcher this$0, Thread $thread) {
        Object object = this$0.lock;
        synchronized (object) {
            boolean bl = false;
            CountingSet<Thread> countingSet = this$0.allowedOnThisThread;
            Intrinsics.checkNotNull((Object)$thread);
            countingSet.add((Object)$thread, -1);
            Unit unit = Unit.INSTANCE;
        }
        return Unit.INSTANCE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final int allowAllBackgroundThreadsAndSuppressPumping$lambda$0(RdDispatcher this$0) {
        int n;
        Object object = this$0.lock;
        synchronized (object) {
            boolean bl = false;
            int n2 = this$0.allowedOnAnyThread;
            this$0.allowedOnAnyThread = n2 + 1;
            n = n2;
        }
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final Unit allowAllBackgroundThreadsAndSuppressPumping$lambda$1(RdDispatcher this$0) {
        Object object = this$0.lock;
        synchronized (object) {
            boolean bl = false;
            int n = this$0.allowedOnAnyThread;
            this$0.allowedOnAnyThread = n + -1;
            Unit unit = Unit.INSTANCE;
        }
        return Unit.INSTANCE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final int suppressPumping$lambda$0(RdDispatcher this$0) {
        int n;
        Object object = this$0.lock;
        synchronized (object) {
            boolean bl = false;
            ++this$0.suppressRequests;
            n = this$0.suppressRequests;
        }
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final Unit suppressPumping$lambda$1(RdDispatcher this$0) {
        Object object = this$0.lock;
        synchronized (object) {
            boolean bl = false;
            int n = this$0.suppressRequests;
            this$0.suppressRequests = n + -1;
            int n2 = n;
        }
        this$0.repostConditionally();
        return Unit.INSTANCE;
    }

    @NotNull
    protected static final Logger getLOG() {
        return Companion.getLOG();
    }

    static {
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(RdDispatcher.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LOG = logger;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u001c\u0010\u0004\u001a\u00020\u00058\u0004X\u0085\u0004\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\u0006\u0010\u0003\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\t"}, d2={"Lcom/jetbrains/rdclient/protocol/RdDispatcher$Companion;", "", "<init>", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "getLOG$annotations", "getLOG", "()Lcom/intellij/openapi/diagnostic/Logger;", "intellij.rd.client"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        protected final Logger getLOG() {
            return LOG;
        }

        @JvmStatic
        protected static /* synthetic */ void getLOG$annotations() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

