/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rdclient.fileEditors;

import com.intellij.codeWithMe.ClientId;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.CoroutinesKt;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.ComponentManagerEx;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileEditor.FileEditorComposite;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.FileEditorProvider;
import com.intellij.openapi.fileEditor.ex.FileEditorWithProvider;
import com.intellij.openapi.fileEditor.impl.EditorComposite;
import com.intellij.openapi.fileEditor.impl.EditorCompositeModel;
import com.intellij.openapi.fileEditor.impl.EditorWindow;
import com.intellij.openapi.fileEditor.impl.EditorsSplitters;
import com.intellij.openapi.fileEditor.impl.FileEditorManagerImpl;
import com.intellij.openapi.fileEditor.impl.FileEditorManagerImplKt;
import com.intellij.openapi.fileEditor.impl.FileEditorOpenOptions;
import com.intellij.openapi.fileEditor.impl.PrecomputedFlow;
import com.intellij.openapi.fileEditor.impl.PsiAwareFileEditorManagerImpl;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.platform.fileEditor.FileEntry;
import com.intellij.platform.util.coroutines.CoroutineScopeKt;
import com.jetbrains.rd.ide.model.DeferredCompositeModel;
import com.jetbrains.rd.ide.model.FileEditorCompositeModel;
import com.jetbrains.rd.ide.model.FileNotFoundResponse;
import com.jetbrains.rd.ide.model.RdFileEditorCompositeId;
import com.jetbrains.rd.ide.model.RdFileId;
import com.jetbrains.rd.ide.model.RequestCompositeResponse;
import com.jetbrains.rd.ide.model.SuccessfulRequestComposite;
import com.jetbrains.rd.ide.vfs.IProtocolVirtualFile;
import com.jetbrains.rd.util.Boxed;
import com.jetbrains.rd.util.lifetime.Lifetime;
import com.jetbrains.rdclient.client.FrontendSessionsUtilKt;
import com.jetbrains.rdclient.fileEditors.AsyncTabCreationVetoer;
import com.jetbrains.rdclient.fileEditors.FrontendEditorComposite;
import com.jetbrains.rdclient.fileEditors.FrontendFileEditorCreationListener;
import com.jetbrains.rdclient.fileEditors.FrontendFileEditorHost;
import com.jetbrains.rdclient.fileEditors.FrontendFileEditorHostKt;
import com.jetbrains.rdclient.fileEditors.FrontendFileEditorManager;
import com.jetbrains.rdclient.protocol.IPermittedModalities;
import com.jetbrains.rdclient.vfs.FrontendVirtualFileManager;
import java.lang.invoke.LambdaMetafactory;
import java.util.List;
import javax.swing.SwingUtilities;
import kotlin.ExceptionsKt;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.ResultKt;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin._Assertions;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.Boxing;
import kotlin.coroutines.jvm.internal.ContinuationImpl;
import kotlin.coroutines.jvm.internal.SpillingKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.MutablePropertyReference0Impl;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.reflect.KMutableProperty0;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.Deferred;
import kotlinx.coroutines.Dispatchers;
import kotlinx.coroutines.flow.Flow;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u00a8\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0010\u0018\u0000 F2\u00020\u0001:\u0001FB\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J$\u0010\u000f\u001a\u0004\u0018\u00010\f2\u0006\u0010\u0010\u001a\u00020\u000b2\u0006\u0010\u0011\u001a\u00020\u00122\b\u0010\u0013\u001a\u0004\u0018\u00010\u0014H\u0016J\b\u0010\u0015\u001a\u00020\u0016H\u0002J\u001a\u0010\u0017\u001a\u0004\u0018\u00010\f2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0010\u001a\u00020\u000bH\u0002J\u0018\u0010\u0018\u001a\u0004\u0018\u00010\u00192\u0006\u0010\u0010\u001a\u00020\u000bH\u0082@\u00a2\u0006\u0002\u0010\u001aJ\u001e\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u000b2\u0006\u0010\u001e\u001a\u00020\u001fH\u0082@\u00a2\u0006\u0002\u0010 J\f\u0010!\u001a\u00020\"*\u00020\u000bH\u0002J(\u0010#\u001a\u0004\u0018\u00010\f2\u0006\u0010\u0010\u001a\u00020\u000b2\f\u0010$\u001a\b\u0012\u0004\u0012\u00020&0%2\u0006\u0010\u0004\u001a\u00020\u0005H\u0014J\u008b\u0001\u0010'\u001a\u00020(2\u0006\u0010\u0010\u001a\u00020\u000b2\u0006\u0010\u0004\u001a\u00020\u00052\f\u0010$\u001a\b\u0012\u0004\u0012\u00020&0%2\u0006\u0010)\u001a\u00020\u00162\u0006\u0010*\u001a\u00020\u00162\b\u0010+\u001a\u0004\u0018\u00010,2\u0006\u0010-\u001a\u00020\u00162\u0006\u0010.\u001a\u00020\u00162\u0006\u0010/\u001a\u00020\u00162\u0006\u00100\u001a\u00020\u00192\"\u00101\u001a\u001e\b\u0001\u0012\u0004\u0012\u00020\f\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u001c03\u0012\u0006\u0012\u0004\u0018\u00010402H\u0000\u00a2\u0006\u0004\b5\u00106Ji\u00107\u001a\u00020(2\u0006\u0010\u0010\u001a\u00020\u000b2\f\u00108\u001a\b\u0012\u0004\u0012\u00020:092\u0006\u0010)\u001a\u00020\u00162\u0006\u0010*\u001a\u00020\u00162\b\u0010+\u001a\u0004\u0018\u00010,2\u0006\u0010-\u001a\u00020\u00162\u0006\u0010.\u001a\u00020\u00162\u0006\u0010/\u001a\u00020\u00162\u0012\u00101\u001a\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\u001c0;H\u0000\u00a2\u0006\u0002\b<J\u0015\u0010=\u001a\u00020\u001c2\u0006\u0010>\u001a\u00020\fH\u0000\u00a2\u0006\u0002\b?J\u0012\u0010@\u001a\u0004\u0018\u00010\u00122\u0006\u0010>\u001a\u00020\fH\u0002J\u0010\u0010A\u001a\u00020\u00162\u0006\u0010\u0010\u001a\u00020\u000bH\u0016J$\u0010B\u001a\u00020\u00162\u0006\u0010\u0010\u001a\u00020\u000b2\f\u0010C\u001a\b\u0012\u0004\u0012\u00020D09H\u0094@\u00a2\u0006\u0002\u0010ER$\u0010\b\u001a\u0018\u0012\u0012\u0012\u0010\u0012\u0004\u0012\u00020\u000b\u0012\u0006\u0012\u0004\u0018\u00010\f0\n\u0018\u00010\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006G"}, d2={"Lcom/jetbrains/rdclient/fileEditors/FrontendFileEditorManager;", "Lcom/intellij/openapi/fileEditor/impl/PsiAwareFileEditorManagerImpl;", "project", "Lcom/intellij/openapi/project/Project;", "coroutineScope", "Lkotlinx/coroutines/CoroutineScope;", "<init>", "(Lcom/intellij/openapi/project/Project;Lkotlinx/coroutines/CoroutineScope;)V", "request", "Lcom/jetbrains/rd/util/Boxed;", "Lkotlin/Pair;", "Lcom/intellij/openapi/vfs/VirtualFile;", "Lcom/intellij/openapi/fileEditor/impl/EditorComposite;", "host", "Lcom/jetbrains/rdclient/fileEditors/FrontendFileEditorHost;", "createCompositeAndModel", "file", "window", "Lcom/intellij/openapi/fileEditor/impl/EditorWindow;", "fileEntry", "Lcom/intellij/platform/fileEditor/FileEntry;", "isAsyncCreationAllowed", "", "openFrontendRequestedCompositeDeferred", "getCompositeIdOrReopen", "Lcom/jetbrains/rd/ide/model/RdFileEditorCompositeId;", "(Lcom/intellij/openapi/vfs/VirtualFile;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "reopenCompositeIfFileNotFound", "", "oldFile", "newFileId", "Lcom/jetbrains/rd/ide/model/RdFileId;", "(Lcom/intellij/openapi/vfs/VirtualFile;Lcom/jetbrains/rd/ide/model/RdFileId;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "backendUrl", "", "createCompositeInstance", "model", "Lkotlinx/coroutines/flow/Flow;", "Lcom/intellij/openapi/fileEditor/impl/EditorCompositeModel;", "openFileFromBackendDeferred", "Lcom/intellij/openapi/fileEditor/FileEditorComposite;", "requestFocus", "selectAsCurrent", "openMode", "Lcom/intellij/openapi/fileEditor/impl/FileEditorManagerImpl$OpenMode;", "isSingletonEditorInWindow", "isPinned", "forceFocus", "compositeId", "initialize", "Lkotlin/Function2;", "Lkotlin/coroutines/Continuation;", "", "openFileFromBackendDeferred$intellij_rd_client", "(Lcom/intellij/openapi/vfs/VirtualFile;Lkotlinx/coroutines/CoroutineScope;Lkotlinx/coroutines/flow/Flow;ZZLcom/intellij/openapi/fileEditor/impl/FileEditorManagerImpl$OpenMode;ZZZLcom/jetbrains/rd/ide/model/RdFileEditorCompositeId;Lkotlin/jvm/functions/Function2;)Lcom/intellij/openapi/fileEditor/FileEditorComposite;", "openFileFromBackend", "editorsWithProviders", "", "Lcom/intellij/openapi/fileEditor/ex/FileEditorWithProvider;", "Lkotlin/Function1;", "openFileFromBackend$intellij_rd_client", "closeFile", "composite", "closeFile$intellij_rd_client", "getWindow", "canOpenFile", "canOpenFileAsync", "providers", "Lcom/intellij/openapi/fileEditor/FileEditorProvider;", "(Lcom/intellij/openapi/vfs/VirtualFile;Ljava/util/List;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "Companion", "intellij.rd.client"})
@SourceDebugExtension(value={"SMAP\nFrontendFileEditorManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FrontendFileEditorManager.kt\ncom/jetbrains/rdclient/fileEditors/FrontendFileEditorManager\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n+ 3 Reenterability.kt\ncom/jetbrains/rd/platform/util/ReenterabilityKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,346:1\n67#2,4:347\n67#2,4:358\n67#2,4:362\n67#2,4:366\n67#2,4:371\n67#2,4:379\n67#2,4:388\n67#2,4:393\n13#2:397\n55#3,7:351\n55#3,4:375\n61#3:383\n55#3,4:384\n61#3:392\n1#4:370\n*S KotlinDebug\n*F\n+ 1 FrontendFileEditorManager.kt\ncom/jetbrains/rdclient/fileEditors/FrontendFileEditorManager\n*L\n58#1:347,4\n70#1:358,4\n73#1:362,4\n76#1:366,4\n245#1:371,4\n256#1:379,4\n271#1:388,4\n284#1:393,4\n45#1:397\n65#1:351,7\n255#1:375,4\n255#1:383\n270#1:384,4\n270#1:392\n*E\n"})
public class FrontendFileEditorManager
extends PsiAwareFileEditorManagerImpl {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @Nullable
    private Boxed<Pair<VirtualFile, EditorComposite>> request;
    @NotNull
    private final FrontendFileEditorHost host;
    @NotNull
    private static final Logger LOG;

    public FrontendFileEditorManager(@NotNull Project project, @NotNull CoroutineScope coroutineScope) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)coroutineScope, (String)"coroutineScope");
        super(project, coroutineScope);
        this.host = FrontendFileEditorHost.Companion.getInstance(FrontendSessionsUtilKt.getFrontendProjectSession(project));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @Nullable
    public EditorComposite createCompositeAndModel(@NotNull VirtualFile file, @NotNull EditorWindow window, @Nullable FileEntry fileEntry) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter((Object)window, (String)"window");
        Logger $this$trace$iv = LOG;
        boolean $i$f$trace = false;
        if ($this$trace$iv.isTraceEnabled()) {
            Logger logger = $this$trace$iv;
            boolean bl = false;
            logger.trace("[file] createComposite called. file.name=" + file.getName() + ", isEdt=" + SwingUtilities.isEventDispatchThread());
        }
        if (!(file instanceof IProtocolVirtualFile)) {
            return super.createCompositeAndModel(file, window, fileEntry);
        }
        if (this.request == null) {
            void flag$iv;
            $this$trace$iv = (KMutableProperty0)new MutablePropertyReference0Impl((Object)this){

                public Object get() {
                    return FrontendFileEditorManager.access$getRequest$p((FrontendFileEditorManager)((Object)this.receiver));
                }

                public void set(Object value) {
                    FrontendFileEditorManager.access$setRequest$p((FrontendFileEditorManager)((Object)this.receiver), (Boxed)value);
                }
            };
            Boxed value$iv = new Boxed((Object)TuplesKt.to((Object)file, null));
            boolean $i$f$usingFlag = false;
            Object old$iv = flag$iv.get();
            try {
                RdFileEditorCompositeId rdFileEditorCompositeId;
                Logger logger;
                flag$iv.set((Object)value$iv);
                boolean bl = false;
                if (this.isAsyncCreationAllowed()) {
                    EditorComposite editorComposite = this.openFrontendRequestedCompositeDeferred(window, file);
                    return editorComposite;
                }
                LOG.warn("Synchronously waiting for editor for " + file);
                Logger $this$trace$iv2 = LOG;
                boolean $i$f$trace2 = false;
                if ($this$trace$iv2.isTraceEnabled()) {
                    logger = $this$trace$iv2;
                    boolean bl2 = false;
                    logger.trace("[file] createComposite: Synchronously waiting for editor (start)");
                }
                if (FrontendFileEditorHost.Companion.getInstance(FrontendSessionsUtilKt.getFrontendProjectSession(this.getProject())).requestCompositeFromBackendSync(((IProtocolVirtualFile)file).getFileId(), this.getProject()) == null) {
                    FrontendFileEditorManager $this$createCompositeAndModel_u24lambda_u241_u241 = this;
                    boolean bl3 = false;
                    Logger $this$trace$iv3 = LOG;
                    boolean $i$f$trace3 = false;
                    if ($this$trace$iv3.isTraceEnabled()) {
                        Logger logger2 = $this$trace$iv3;
                        boolean bl4 = false;
                        logger2.trace("[file] createComposite: Synchronously waiting for editor (finish with failure)). compositeId=null");
                    }
                    EditorComposite editorComposite = null;
                    return editorComposite;
                }
                RdFileEditorCompositeId compositeId = rdFileEditorCompositeId;
                Logger $this$trace$iv4 = LOG;
                boolean $i$f$trace4 = false;
                if ($this$trace$iv4.isTraceEnabled()) {
                    logger = $this$trace$iv4;
                    boolean bl5 = false;
                    logger.trace("[file] createComposite: Synchronously waiting for editor (finish with success)). compositeId=" + compositeId);
                }
                Boxed<Pair<VirtualFile, EditorComposite>> boxed = this.request;
                Intrinsics.checkNotNull(boxed);
                Pair pair = (Pair)boxed.getValue();
                VirtualFile currentFile = (VirtualFile)pair.component1();
                EditorComposite currentComposite = (EditorComposite)pair.component2();
                boolean bl6 = Intrinsics.areEqual((Object)currentFile, (Object)file);
                if (_Assertions.ENABLED && !bl6) {
                    boolean bl7 = false;
                    String string = "File mismatch after sync wait: expected: " + file + ", actual: " + currentFile;
                    throw new AssertionError((Object)string);
                }
                EditorComposite editorComposite = currentComposite;
                return editorComposite;
            }
            finally {
                flag$iv.set(old$iv);
            }
        }
        Boxed<Pair<VirtualFile, EditorComposite>> boxed = this.request;
        Intrinsics.checkNotNull(boxed);
        Pair pair = (Pair)boxed.getValue();
        VirtualFile currentFile = (VirtualFile)pair.component1();
        EditorComposite currentComposite = (EditorComposite)pair.component2();
        boolean bl = Intrinsics.areEqual((Object)currentFile, (Object)file);
        if (_Assertions.ENABLED && !bl) {
            boolean bl8 = false;
            String string = "File mismatch on backend open: expected: " + file + ", actual: " + currentFile;
            throw new AssertionError((Object)string);
        }
        return currentComposite;
    }

    private final boolean isAsyncCreationAllowed() {
        AsyncTabCreationVetoer vetoer = (AsyncTabCreationVetoer)AsyncTabCreationVetoer.Companion.getEP().findFirstSafe(arg_0 -> FrontendFileEditorManager.isAsyncCreationAllowed$lambda$1(FrontendFileEditorManager::isAsyncCreationAllowed$lambda$0, arg_0));
        return vetoer == null && Registry.Companion.is("rdclient.frontend.async.editor.composite.load", false);
    }

    private final EditorComposite openFrontendRequestedCompositeDeferred(EditorWindow window, VirtualFile file) {
        if (!(file instanceof IProtocolVirtualFile)) {
            return null;
        }
        IPermittedModalities.Companion.getInstance$default(IPermittedModalities.Companion, null, 1, null).allowPumpProtocolUnderCurrentModality();
        CoroutineScope coroutineScope = CoroutineScopeKt.childScope$default((CoroutineScope)window.getOwner().coroutineScope, (String)("EditorComposite(file=" + ((IProtocolVirtualFile)file).getFileId() + ")"), null, (boolean)false, (int)6, null);
        Deferred compositeIdDeferred2 = BuildersKt.async$default((CoroutineScope)coroutineScope, null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super RdFileEditorCompositeId>, Object>(this, file, null){
            int label;
            final /* synthetic */ FrontendFileEditorManager this$0;
            final /* synthetic */ VirtualFile $file;
            {
                this.this$0 = $receiver;
                this.$file = $file;
                super(2, $completion);
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final Object invokeSuspend(Object $result) {
                Object object = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)$result);
                        this.label = 1;
                        Object object2 = FrontendFileEditorManager.access$getCompositeIdOrReopen(this.this$0, this.$file, (Continuation)this);
                        if (object2 != object) return object2;
                        return object;
                    }
                    case 1: {
                        ResultKt.throwOnFailure((Object)$result);
                        Object object2 = $result;
                        return object2;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super RdFileEditorCompositeId> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)3, null);
        Deferred<FrontendFileEditorHost.PromisedCompositeModel> deferredModel = this.host.getBackendEditorProviderFlowAndLifetimePromise$intellij_rd_client((Deferred<RdFileEditorCompositeId>)compositeIdDeferred2, coroutineScope);
        Flow<EditorCompositeModel> flow2 = this.host.getCompositeModelFromDeferredModel$intellij_rd_client(deferredModel, file, window);
        EditorComposite editorComposite = this.createCompositeByEditorWithModel(file, flow2, coroutineScope);
        if (editorComposite == null) {
            return null;
        }
        EditorComposite currentComposite = editorComposite;
        if (currentComposite instanceof FrontendEditorComposite) {
            Deferred deferredPublisher2 = BuildersKt.async$default((CoroutineScope)coroutineScope, null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super FrontendFileEditorCreationListener>, Object>(this, null){
                int label;
                final /* synthetic */ FrontendFileEditorManager this$0;
                {
                    this.this$0 = $receiver;
                    super(2, $completion);
                }

                public final Object invokeSuspend(Object $result) {
                    IntrinsicsKt.getCOROUTINE_SUSPENDED();
                    switch (this.label) {
                        case 0: {
                            ResultKt.throwOnFailure((Object)$result);
                            return this.this$0.getProject().getMessageBus().syncPublisher(FrontendFileEditorCreationListener.Companion.getTOPIC());
                        }
                    }
                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                }

                public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                    return (Continuation)new /* invalid duplicate definition of identical inner class */;
                }

                public final Object invoke(CoroutineScope p1, Continuation<? super FrontendFileEditorCreationListener> p2) {
                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                }
            }), (int)3, null);
            BuildersKt.launch$default((CoroutineScope)coroutineScope, null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>((Deferred<? extends FrontendFileEditorCreationListener>)deferredPublisher2, (Deferred<RdFileEditorCompositeId>)compositeIdDeferred2, this, currentComposite, null){
                Object L$0;
                int label;
                final /* synthetic */ Deferred<FrontendFileEditorCreationListener> $deferredPublisher;
                final /* synthetic */ Deferred<RdFileEditorCompositeId> $compositeIdDeferred;
                final /* synthetic */ FrontendFileEditorManager this$0;
                final /* synthetic */ EditorComposite $currentComposite;
                {
                    this.$deferredPublisher = $deferredPublisher;
                    this.$compositeIdDeferred = $compositeIdDeferred;
                    this.this$0 = $receiver;
                    this.$currentComposite = $currentComposite;
                    super(2, $completion);
                }

                /*
                 * Unable to fully structure code
                 */
                public final Object invokeSuspend(Object $result) {
                    var4_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                    switch (this.label) {
                        case 0: {
                            ResultKt.throwOnFailure((Object)$result);
                            this.label = 1;
                            v0 = this.$deferredPublisher.await((Continuation)this);
                            if (v0 == var4_2) {
                                return var4_2;
                            }
                            ** GOTO lbl13
                        }
                        case 1: {
                            ResultKt.throwOnFailure((Object)$result);
                            v0 = $result;
lbl13:
                            // 2 sources

                            publisher = (FrontendFileEditorCreationListener)v0;
                            this.L$0 = publisher;
                            this.label = 2;
                            v1 = this.$compositeIdDeferred.await((Continuation)this);
                            if (v1 == var4_2) {
                                return var4_2;
                            }
                            ** GOTO lbl24
                        }
                        case 2: {
                            publisher = (FrontendFileEditorCreationListener)this.L$0;
                            ResultKt.throwOnFailure((Object)$result);
                            v1 = $result;
lbl24:
                            // 2 sources

                            if ((compositeId = (RdFileEditorCompositeId)v1) != null) {
                                publisher.onNewCompositeCreated(FrontendSessionsUtilKt.getFrontendProjectSession(this.this$0.getProject()), (FrontendEditorComposite)this.$currentComposite, compositeId, ExceptionsKt.stackTraceToString((Throwable)new Throwable()));
                            }
                            return Unit.INSTANCE;
                        }
                    }
                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                }

                public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                    return (Continuation)new /* invalid duplicate definition of identical inner class */;
                }

                public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                }
            }), (int)3, null);
            Disposer.register((Disposable)((Disposable)currentComposite), () -> FrontendFileEditorManager.openFrontendRequestedCompositeDeferred$lambda$0(compositeIdDeferred2, this, file));
            ((FrontendEditorComposite)currentComposite).scheduleBind((Function2<? super FrontendEditorComposite, ? super Continuation<? super Unit>, ? extends Object>)((Function2)new Function2<FrontendEditorComposite, Continuation<? super Unit>, Object>(deferredModel, (Deferred<RdFileEditorCompositeId>)compositeIdDeferred2, this, currentComposite, null){
                Object L$0;
                Object L$1;
                Object L$2;
                Object L$3;
                int label;
                final /* synthetic */ Deferred<FrontendFileEditorHost.PromisedCompositeModel> $deferredModel;
                final /* synthetic */ Deferred<RdFileEditorCompositeId> $compositeIdDeferred;
                final /* synthetic */ FrontendFileEditorManager this$0;
                final /* synthetic */ EditorComposite $currentComposite;
                {
                    this.$deferredModel = $deferredModel;
                    this.$compositeIdDeferred = $compositeIdDeferred;
                    this.this$0 = $receiver;
                    this.$currentComposite = $currentComposite;
                    super(2, $completion);
                }

                /*
                 * Unable to fully structure code
                 */
                public final Object invokeSuspend(Object $result) {
                    var7_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                    switch (this.label) {
                        case 0: {
                            ResultKt.throwOnFailure((Object)$result);
                            this.label = 1;
                            v0 = this.$deferredModel.await((Continuation)this);
                            if (v0 == var7_2) {
                                return var7_2;
                            }
                            ** GOTO lbl13
                        }
                        case 1: {
                            ResultKt.throwOnFailure((Object)$result);
                            v0 = $result;
lbl13:
                            // 2 sources

                            v1 = (FrontendFileEditorHost.PromisedCompositeModel)v0;
                            if (v1 == null) {
                                return Unit.INSTANCE;
                            }
                            var2_3 = v1;
                            lifetime = var2_3.component1();
                            deferredCompositeModel = var2_3.component2();
                            v2 = (RdFileEditorCompositeId)this.$compositeIdDeferred.getCompleted();
                            if (v2 == null) {
                                return Unit.INSTANCE;
                            }
                            compositeId = v2;
                            this.L$0 = lifetime;
                            this.L$1 = SpillingKt.nullOutSpilledVariable((Object)deferredCompositeModel);
                            this.L$2 = compositeId;
                            this.label = 2;
                            v3 = FrontendFileEditorHostKt.toDeferred(deferredCompositeModel, lifetime).await((Continuation)this);
                            if (v3 == var7_2) {
                                return var7_2;
                            }
                            ** GOTO lbl37
                        }
                        case 2: {
                            compositeId = (RdFileEditorCompositeId)this.L$2;
                            deferredCompositeModel = (DeferredCompositeModel)this.L$1;
                            lifetime = (Lifetime)this.L$0;
                            ResultKt.throwOnFailure((Object)$result);
                            v3 = $result;
lbl37:
                            // 2 sources

                            compositeModel = (FileEditorCompositeModel)v3;
                            this.L$0 = lifetime;
                            this.L$1 = SpillingKt.nullOutSpilledVariable((Object)deferredCompositeModel);
                            this.L$2 = compositeId;
                            this.L$3 = compositeModel;
                            this.label = 3;
                            v4 = CoroutinesKt.writeIntentReadAction((Function0)(Function0)LambdaMetafactory.metafactory(null, null, null, ()Ljava/lang/Object;, invokeSuspend$lambda$0(com.jetbrains.rdclient.fileEditors.FrontendFileEditorManager com.jetbrains.rd.util.lifetime.Lifetime com.jetbrains.rd.ide.model.RdFileEditorCompositeId com.jetbrains.rd.ide.model.FileEditorCompositeModel com.intellij.openapi.fileEditor.impl.EditorComposite ), ()Lkotlin/Unit;)((FrontendFileEditorManager)this.this$0, (Lifetime)lifetime, (RdFileEditorCompositeId)compositeId, (FileEditorCompositeModel)compositeModel, (EditorComposite)this.$currentComposite), (Continuation)((Continuation)this));
                            if (v4 == var7_2) {
                                return var7_2;
                            }
                            ** GOTO lbl54
                        }
                        case 3: {
                            compositeModel = (FileEditorCompositeModel)this.L$3;
                            compositeId = (RdFileEditorCompositeId)this.L$2;
                            deferredCompositeModel = (DeferredCompositeModel)this.L$1;
                            lifetime = (Lifetime)this.L$0;
                            ResultKt.throwOnFailure((Object)$result);
                            v4 = $result;
lbl54:
                            // 2 sources

                            FrontendFileEditorManager.access$getHost$p(this.this$0).subscribeOnOpen$intellij_rd_client(compositeModel, lifetime, compositeId, this.$currentComposite);
                            return Unit.INSTANCE;
                        }
                    }
                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                }

                public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                    return (Continuation)new /* invalid duplicate definition of identical inner class */;
                }

                public final Object invoke(FrontendEditorComposite p1, Continuation<? super Unit> p2) {
                    return (this.create((Object)((Object)p1), p2)).invokeSuspend(Unit.INSTANCE);
                }

                private static final Unit invokeSuspend$lambda$0(FrontendFileEditorManager this$0, Lifetime $lifetime, RdFileEditorCompositeId $compositeId, FileEditorCompositeModel $compositeModel, EditorComposite $currentComposite) {
                    FrontendFileEditorManager.access$getHost$p(this$0).bindCompositeAsync$intellij_rd_client($lifetime, $compositeId, $compositeModel, $currentComposite);
                    return Unit.INSTANCE;
                }
            }));
        }
        currentComposite.initDeferred.complete((Object)Unit.INSTANCE);
        return currentComposite;
    }

    /*
     * Unable to fully structure code
     */
    private final Object getCompositeIdOrReopen(VirtualFile file, Continuation<? super RdFileEditorCompositeId> $completion) {
        block13: {
            if (!($completion instanceof getCompositeIdOrReopen.1)) ** GOTO lbl-1000
            var7_3 = $completion;
            if ((var7_3.label & -2147483648) != 0) {
                var7_3.label -= -2147483648;
            } else lbl-1000:
            // 2 sources

            {
                $continuation = new ContinuationImpl(this, $completion){
                    Object L$0;
                    Object L$1;
                    /* synthetic */ Object result;
                    final /* synthetic */ FrontendFileEditorManager this$0;
                    int label;
                    {
                        this.this$0 = this$0;
                        super($completion);
                    }

                    @Nullable
                    public final Object invokeSuspend(@NotNull Object $result) {
                        this.result = $result;
                        this.label |= Integer.MIN_VALUE;
                        return FrontendFileEditorManager.access$getCompositeIdOrReopen(this.this$0, null, (Continuation)this);
                    }
                };
            }
            $result = $continuation.result;
            var8_5 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
            switch ($continuation.label) {
                case 0: {
                    ResultKt.throwOnFailure((Object)$result);
                    if (!(file instanceof IProtocolVirtualFile)) {
                        var3_6 = "Failed requirement.";
                        throw new IllegalArgumentException(var3_6.toString());
                    }
                    $continuation.L$0 = file;
                    $continuation.label = 1;
                    v0 = this.host.requestCompositeFromBackendAsync(((IProtocolVirtualFile)file).getFileId(), this.backendUrl(file), (Continuation<? super RequestCompositeResponse>)$continuation);
                    if (v0 == var8_5) {
                        return var8_5;
                    }
                    ** GOTO lbl25
                }
                case 1: {
                    file = (VirtualFile)$continuation.L$0;
                    ResultKt.throwOnFailure((Object)$result);
                    v0 = $result;
lbl25:
                    // 2 sources

                    if (!((response = (RequestCompositeResponse)v0) instanceof FileNotFoundResponse)) break;
                    $continuation.L$0 = file;
                    $continuation.L$1 = SpillingKt.nullOutSpilledVariable((Object)response);
                    $continuation.label = 2;
                    v1 = this.reopenCompositeIfFileNotFound(file, ((FileNotFoundResponse)response).getNewFileId(), (Continuation<? super Unit>)$continuation);
                    if (v1 == var8_5) {
                        return var8_5;
                    }
                    ** GOTO lbl38
                }
                case 2: {
                    response = (RequestCompositeResponse)$continuation.L$1;
                    file = (VirtualFile)$continuation.L$0;
                    ResultKt.throwOnFailure((Object)$result);
                    v1 = $result;
lbl38:
                    // 2 sources

                    v2 = null;
                    break block13;
                }
            }
            if (response instanceof SuccessfulRequestComposite) {
                v2 = ((SuccessfulRequestComposite)response).getCompositeId();
            } else {
                FrontendFileEditorManager.LOG.error("Invalid response type for `requestComposite. Got: " + Reflection.getOrCreateKotlinClass(response.getClass()).getSimpleName());
                v2 = v3 = null;
            }
        }
        if (v2 == null) {
            $this$getCompositeIdOrReopen_u24lambda_u240 = this;
            $i$a$-run-FrontendFileEditorManager$getCompositeIdOrReopen$2 = false;
            FrontendFileEditorManager.LOG.warn("[file] createCompositeAndModel: Failed to request composite from backend. file.name=" + ((IProtocolVirtualFile)file).getFileId());
            v3 = null;
        }
        return v3;
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    private final Object reopenCompositeIfFileNotFound(VirtualFile oldFile, RdFileId newFileId, Continuation<? super Unit> $completion) {
        if (!(oldFile instanceof IProtocolVirtualFile)) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
        VirtualFile virtualFile = FrontendVirtualFileManager.getVirtualFile$default(FrontendVirtualFileManager.Companion.getInstance(), newFileId, null, 2, null);
        if (virtualFile == null) {
            FrontendFileEditorManager $this$reopenCompositeIfFileNotFound_u24lambda_u240 = this;
            boolean bl = false;
            LOG.error("[reopen after indexing] Trying to open a composite for file");
            return Unit.INSTANCE;
        }
        VirtualFile newFile = virtualFile;
        if (!(newFile instanceof IProtocolVirtualFile)) {
            boolean bl = false;
            String string = "Required a ThinClientVirtualFile, but it's not";
            throw new IllegalArgumentException(string.toString());
        }
        Object object = BuildersKt.withContext((CoroutineContext)CoroutinesKt.getEDT((Dispatchers)Dispatchers.INSTANCE), (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, oldFile, newFile, null){
            int label;
            final /* synthetic */ FrontendFileEditorManager this$0;
            final /* synthetic */ VirtualFile $oldFile;
            final /* synthetic */ VirtualFile $newFile;
            {
                this.this$0 = $receiver;
                this.$oldFile = $oldFile;
                this.$newFile = $newFile;
                super(2, $completion);
            }

            public final Object invokeSuspend(Object $result) {
                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)$result);
                        FileEditorManagerImplKt.reopenVirtualFileEditor((Project)this.this$0.getProject(), (VirtualFile)this.$oldFile, (VirtualFile)this.$newFile, (boolean)true);
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), $completion);
        if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
            return object;
        }
        return Unit.INSTANCE;
    }

    private final String backendUrl(VirtualFile $this$backendUrl) {
        if (!($this$backendUrl instanceof IProtocolVirtualFile)) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
        String string = ((IProtocolVirtualFile)$this$backendUrl).getBackendProtocol();
        if (string == null) {
            string = "file";
        }
        String string2 = VirtualFileManager.constructUrl((String)string, (String)$this$backendUrl.getPath());
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"constructUrl(...)");
        return string2;
    }

    @Nullable
    protected EditorComposite createCompositeInstance(@NotNull VirtualFile file, @NotNull Flow<EditorCompositeModel> model2, @NotNull CoroutineScope coroutineScope) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter(model2, (String)"model");
        Intrinsics.checkNotNullParameter((Object)coroutineScope, (String)"coroutineScope");
        if (model2 instanceof PrecomputedFlow) {
            return super.createCompositeInstance(file, model2, coroutineScope);
        }
        LOG.assertTrue(ClientId.Companion.isCurrentlyUnderLocalId());
        return (EditorComposite)new FrontendEditorComposite(file, model2, this.getProject(), coroutineScope);
    }

    @NotNull
    public final FileEditorComposite openFileFromBackendDeferred$intellij_rd_client(@NotNull VirtualFile file, @NotNull CoroutineScope coroutineScope, @NotNull Flow<EditorCompositeModel> model2, boolean requestFocus, boolean selectAsCurrent, @Nullable FileEditorManagerImpl.OpenMode openMode, boolean isSingletonEditorInWindow, boolean isPinned, boolean forceFocus, @NotNull RdFileEditorCompositeId compositeId, @NotNull Function2<? super EditorComposite, ? super Continuation<? super Unit>, ? extends Object> initialize2) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter((Object)coroutineScope, (String)"coroutineScope");
        Intrinsics.checkNotNullParameter(model2, (String)"model");
        Intrinsics.checkNotNullParameter((Object)compositeId, (String)"compositeId");
        Intrinsics.checkNotNullParameter(initialize2, (String)"initialize");
        Function0 creationClosure = () -> FrontendFileEditorManager.openFileFromBackendDeferred$lambda$0(this, file, model2, coroutineScope, initialize2, compositeId);
        FileEditorOpenOptions options = new FileEditorOpenOptions(selectAsCurrent, false, false, requestFocus, isPinned, 0, false, openMode, false, isSingletonEditorInWindow, forceFocus, creationClosure, 100, null);
        return this.openFile(file, null, options);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @NotNull
    public final FileEditorComposite openFileFromBackend$intellij_rd_client(@NotNull VirtualFile file, @NotNull List<FileEditorWithProvider> editorsWithProviders2, boolean requestFocus, boolean selectAsCurrent, @Nullable FileEditorManagerImpl.OpenMode openMode, boolean isSingletonEditorInWindow, boolean isPinned, boolean forceFocus, @NotNull Function1<? super EditorComposite, Unit> initialize2) {
        boolean bl;
        Logger logger;
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter(editorsWithProviders2, (String)"editorsWithProviders");
        Intrinsics.checkNotNullParameter(initialize2, (String)"initialize");
        Logger $this$trace$iv = LOG;
        boolean $i$f$trace = false;
        if ($this$trace$iv.isTraceEnabled()) {
            logger = $this$trace$iv;
            boolean bl2 = false;
            logger.trace("[file] openFileFromBackend called. file.name=" + file.getName());
        }
        Flow flow2 = this.createCompositeModelByProvidedList(editorsWithProviders2);
        String string = file.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
        EditorComposite editorComposite = super.createCompositeByEditorWithModel(file, flow2, CoroutineScopeKt.childScope$default((CoroutineScope)this.coroutineScope, (String)string, null, (boolean)false, (int)6, null));
        Intrinsics.checkNotNull((Object)editorComposite);
        EditorComposite composite = editorComposite;
        initialize2.invoke((Object)composite);
        Boxed<Pair<VirtualFile, EditorComposite>> currentRequest = this.request;
        if (currentRequest == null) {
            void flag$iv;
            KMutableProperty0 bl2 = (KMutableProperty0)new MutablePropertyReference0Impl((Object)this){

                public Object get() {
                    return FrontendFileEditorManager.access$getRequest$p((FrontendFileEditorManager)((Object)this.receiver));
                }

                public void set(Object value) {
                    FrontendFileEditorManager.access$setRequest$p((FrontendFileEditorManager)((Object)this.receiver), (Boxed)value);
                }
            };
            Boxed value$iv = new Boxed((Object)TuplesKt.to((Object)composite.getFile(), (Object)composite));
            boolean $i$f$usingFlag = false;
            Object old$iv = flag$iv.get();
            try {
                flag$iv.set((Object)value$iv);
                boolean bl3 = false;
                Logger $this$trace$iv2 = LOG;
                boolean $i$f$trace2 = false;
                if ($this$trace$iv2.isTraceEnabled()) {
                    Logger logger2 = $this$trace$iv2;
                    boolean bl4 = false;
                    logger2.trace("[file] openFileFromBackend: currentRequest is null. Call openFile(...)");
                }
                FileEditorComposite fileEditorComposite = this.openFile(composite.getFile(), null, new FileEditorOpenOptions(selectAsCurrent, false, false, requestFocus, isPinned, 0, false, openMode, false, isSingletonEditorInWindow, forceFocus, null, 2404, null));
                return fileEditorComposite;
            }
            finally {
                flag$iv.set(old$iv);
            }
        }
        Pair pair = (Pair)currentRequest.getValue();
        VirtualFile currentFile = (VirtualFile)pair.component1();
        EditorComposite currentComposite = (EditorComposite)pair.component2();
        if (!Intrinsics.areEqual((Object)currentFile, (Object)composite.getFile())) {
            void flag$iv;
            KMutableProperty0 old$iv = (KMutableProperty0)new MutablePropertyReference0Impl((Object)this){

                public Object get() {
                    return FrontendFileEditorManager.access$getRequest$p((FrontendFileEditorManager)((Object)this.receiver));
                }

                public void set(Object value) {
                    FrontendFileEditorManager.access$setRequest$p((FrontendFileEditorManager)((Object)this.receiver), (Boxed)value);
                }
            };
            Boxed value$iv = new Boxed((Object)TuplesKt.to((Object)composite.getFile(), (Object)composite));
            boolean $i$f$usingFlag = false;
            Object old$iv2 = flag$iv.get();
            try {
                flag$iv.set((Object)value$iv);
                boolean bl5 = false;
                Logger $this$trace$iv3 = LOG;
                boolean $i$f$trace3 = false;
                if ($this$trace$iv3.isTraceEnabled()) {
                    Logger logger3 = $this$trace$iv3;
                    boolean bl6 = false;
                    logger3.trace("[file] openFileFromBackend: currentRequest is not null, but `request.value.first != composite.file`. Call openFile(...). currentRequest.value=" + currentRequest.getValue() + ", composite.file=" + composite.getFile());
                }
                FileEditorComposite fileEditorComposite = this.openFile(composite.getFile(), null, new FileEditorOpenOptions(false, false, false, requestFocus, false, 0, false, openMode, false, isSingletonEditorInWindow, forceFocus, null, 2421, null));
                return fileEditorComposite;
            }
            finally {
                flag$iv.set(old$iv2);
            }
        }
        Logger $this$trace$iv4 = LOG;
        boolean $i$f$trace4 = false;
        if ($this$trace$iv4.isTraceEnabled()) {
            logger = $this$trace$iv4;
            boolean bl7 = false;
            logger.trace("[file] openFileFromBackend: request is nit null. DO NOT call openFile(...), just put `composite` into `request`.");
        }
        boolean bl8 = bl = currentComposite == null;
        if (_Assertions.ENABLED && !bl) {
            String string2 = "Assertion failed";
            throw new AssertionError((Object)string2);
        }
        currentRequest.setValue((Object)TuplesKt.to((Object)composite.getFile(), (Object)composite));
        return (FileEditorComposite)composite;
    }

    public final void closeFile$intellij_rd_client(@NotNull EditorComposite composite) {
        Intrinsics.checkNotNullParameter((Object)composite, (String)"composite");
        EditorWindow editorWindow = this.getWindow(composite);
        if (editorWindow == null) {
            return;
        }
        EditorWindow window = editorWindow;
        this.closeFile(composite.getFile(), window);
    }

    private final EditorWindow getWindow(EditorComposite composite) {
        for (EditorsSplitters splitters : this.getAllSplitters()) {
            for (EditorWindow window : splitters.windows()) {
                if (!Intrinsics.areEqual((Object)window.getComposite(composite.getFile()), (Object)composite)) continue;
                return window;
            }
        }
        return null;
    }

    public boolean canOpenFile(@NotNull VirtualFile file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        return file instanceof IProtocolVirtualFile || super.canOpenFile(file);
    }

    @Nullable
    protected Object canOpenFileAsync(@NotNull VirtualFile file, @NotNull List<? extends FileEditorProvider> providers, @NotNull Continuation<? super Boolean> $completion) {
        return FrontendFileEditorManager.canOpenFileAsync$suspendImpl(this, file, providers, $completion);
    }

    static /* synthetic */ Object canOpenFileAsync$suspendImpl(FrontendFileEditorManager $this, VirtualFile file, List<? extends FileEditorProvider> providers, Continuation<? super Boolean> $completion) {
        if (!(file instanceof IProtocolVirtualFile)) {
            return super.canOpenFileAsync(file, providers, $completion);
        }
        return Boxing.boxBoolean((boolean)true);
    }

    private static final boolean isAsyncCreationAllowed$lambda$0(AsyncTabCreationVetoer it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it.isAsyncTabCreationForbidden();
    }

    private static final boolean isAsyncCreationAllowed$lambda$1(Function1 $tmp0, Object p0) {
        return (Boolean)$tmp0.invoke(p0);
    }

    private static final void openFrontendRequestedCompositeDeferred$lambda$0(Deferred $compositeIdDeferred, FrontendFileEditorManager this$0, VirtualFile $file) {
        RdFileEditorCompositeId rdFileEditorCompositeId = (RdFileEditorCompositeId)$compositeIdDeferred.getCompleted();
        if (rdFileEditorCompositeId == null) {
            FrontendFileEditorManager $this$openFrontendRequestedCompositeDeferred_u24lambda_u240_u240 = this$0;
            boolean bl = false;
            LOG.error("[file] createCompositeAndModel: Failed to get compositeId. file.name=" + ((IProtocolVirtualFile)$file).getFileId());
            return;
        }
        RdFileEditorCompositeId compositeId = rdFileEditorCompositeId;
        this$0.host.removeComposite$intellij_rd_client(compositeId);
    }

    private static final EditorComposite openFileFromBackendDeferred$lambda$0(FrontendFileEditorManager this$0, VirtualFile $file, Flow $model, CoroutineScope $coroutineScope, Function2 $initialize, RdFileEditorCompositeId $compositeId) {
        EditorComposite editorComposite = this$0.createCompositeByEditorWithModel($file, $model, $coroutineScope);
        if (editorComposite == null) {
            FrontendFileEditorManager $this$openFileFromBackendDeferred_u24lambda_u240_u240 = this$0;
            boolean bl = false;
            LOG.error("[file] failed to create composite by editor with model. file.name=" + $file.getName());
            return null;
        }
        EditorComposite currentComposite = editorComposite;
        if (currentComposite instanceof FrontendEditorComposite) {
            Disposer.register((Disposable)((Disposable)currentComposite), () -> FrontendFileEditorManager.openFileFromBackendDeferred$lambda$0$1(this$0, $compositeId));
            ((FrontendEditorComposite)currentComposite).scheduleBind((Function2<? super FrontendEditorComposite, ? super Continuation<? super Unit>, ? extends Object>)$initialize);
        }
        return currentComposite;
    }

    private static final void openFileFromBackendDeferred$lambda$0$1(FrontendFileEditorManager this$0, RdFileEditorCompositeId $compositeId) {
        this$0.host.removeComposite$intellij_rd_client($compositeId);
    }

    public static final /* synthetic */ Boxed access$getRequest$p(FrontendFileEditorManager $this) {
        return $this.request;
    }

    public static final /* synthetic */ void access$setRequest$p(FrontendFileEditorManager $this, Boxed boxed) {
        $this.request = boxed;
    }

    public static final /* synthetic */ Object access$getCompositeIdOrReopen(FrontendFileEditorManager $this, VirtualFile file, Continuation $completion) {
        return $this.getCompositeIdOrReopen(file, (Continuation<? super RdFileEditorCompositeId>)$completion);
    }

    public static final /* synthetic */ FrontendFileEditorHost access$getHost$p(FrontendFileEditorManager $this) {
        return $this.host;
    }

    public static final /* synthetic */ Object access$reopenCompositeIfFileNotFound(FrontendFileEditorManager $this, VirtualFile oldFile, RdFileId newFileId, Continuation $completion) {
        return $this.reopenCompositeIfFileNotFound(oldFile, newFileId, (Continuation<? super Unit>)$completion);
    }

    static {
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(FrontendFileEditorManager.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LOG = logger;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007J\u0016\u0010\b\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0086@\u00a2\u0006\u0002\u0010\tR\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lcom/jetbrains/rdclient/fileEditors/FrontendFileEditorManager$Companion;", "", "<init>", "()V", "getInstance", "Lcom/jetbrains/rdclient/fileEditors/FrontendFileEditorManager;", "project", "Lcom/intellij/openapi/project/Project;", "getInstanceAsync", "(Lcom/intellij/openapi/project/Project;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "intellij.rd.client"})
    @SourceDebugExtension(value={"SMAP\nFrontendFileEditorManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FrontendFileEditorManager.kt\ncom/jetbrains/rdclient/fileEditors/FrontendFileEditorManager$Companion\n+ 2 services.kt\ncom/intellij/openapi/components/ServicesKt\n*L\n1#1,346:1\n75#2:347\n*S KotlinDebug\n*F\n+ 1 FrontendFileEditorManager.kt\ncom/jetbrains/rdclient/fileEditors/FrontendFileEditorManager$Companion\n*L\n43#1:347\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final FrontendFileEditorManager getInstance(@NotNull Project project) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            FileEditorManager fileEditorManager = FileEditorManager.getInstance((Project)project);
            Intrinsics.checkNotNull((Object)fileEditorManager, (String)"null cannot be cast to non-null type com.jetbrains.rdclient.fileEditors.FrontendFileEditorManager");
            return (FrontendFileEditorManager)fileEditorManager;
        }

        /*
         * Unable to fully structure code
         */
        @Nullable
        public final Object getInstanceAsync(@NotNull Project project, @NotNull Continuation<? super FrontendFileEditorManager> $completion) {
            if (!($completion instanceof getInstanceAsync.1)) ** GOTO lbl-1000
            var6_3 = $completion;
            if ((var6_3.label & -2147483648) != 0) {
                var6_3.label -= -2147483648;
            } else lbl-1000:
            // 2 sources

            {
                $continuation = new ContinuationImpl(this, $completion){
                    Object L$0;
                    Object L$1;
                    int I$0;
                    /* synthetic */ Object result;
                    final /* synthetic */ Companion this$0;
                    int label;
                    {
                        this.this$0 = this$0;
                        super($completion);
                    }

                    @Nullable
                    public final Object invokeSuspend(@NotNull Object $result) {
                        this.result = $result;
                        this.label |= Integer.MIN_VALUE;
                        return this.this$0.getInstanceAsync(null, (Continuation<? super FrontendFileEditorManager>)((Continuation)this));
                    }
                };
            }
            $result = $continuation.result;
            var7_5 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
            switch ($continuation.label) {
                case 0: {
                    ResultKt.throwOnFailure((Object)$result);
                    $this$serviceAsync$iv = (ComponentManager)project;
                    $i$f$serviceAsync = 0;
                    Intrinsics.checkNotNull((Object)$this$serviceAsync$iv, (String)"null cannot be cast to non-null type com.intellij.openapi.components.ComponentManagerEx");
                    $continuation.L$0 = SpillingKt.nullOutSpilledVariable((Object)project);
                    $continuation.L$1 = SpillingKt.nullOutSpilledVariable((Object)$this$serviceAsync$iv);
                    $continuation.I$0 = $i$f$serviceAsync;
                    $continuation.label = 1;
                    v0 = ((ComponentManagerEx)$this$serviceAsync$iv).getServiceAsync(FileEditorManager.class, (Continuation)$continuation);
                    if (v0 == var7_5) {
                        return var7_5;
                    }
                    ** GOTO lbl30
                }
                case 1: {
                    $i$f$serviceAsync = $continuation.I$0;
                    $this$serviceAsync$iv = (ComponentManager)$continuation.L$1;
                    project = (Project)$continuation.L$0;
                    ResultKt.throwOnFailure((Object)$result);
                    v0 = $result;
lbl30:
                    // 2 sources

                    Intrinsics.checkNotNull((Object)v0, (String)"null cannot be cast to non-null type com.jetbrains.rdclient.fileEditors.FrontendFileEditorManager");
                    return (FrontendFileEditorManager)v0;
                }
            }
            throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

