/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rdclient.daemon.suppressors;

import com.intellij.codeInsight.lookup.Lookup;
import com.intellij.codeInsight.lookup.LookupManager;
import com.intellij.codeInsight.lookup.LookupManagerListener;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.client.ClientAppSession;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.rd.LifetimeDisposableExKt;
import com.intellij.openapi.util.Disposer;
import com.intellij.util.Alarm;
import com.intellij.util.ApplicationKt;
import com.intellij.util.messages.MessageBusConnection;
import com.intellij.util.messages.Topic;
import com.jetbrains.rd.ide.document.DocumentSynchronizer;
import com.jetbrains.rd.ide.document.PatchEngineDocumentSynchronizer;
import com.jetbrains.rd.ide.editor.EditorSynchronizer;
import com.jetbrains.rd.ide.model.AbstractDocumentVersion;
import com.jetbrains.rd.ide.model.DefaultHighlighterModel;
import com.jetbrains.rd.ide.model.HighlightInfoModel;
import com.jetbrains.rd.ide.model.HighlighterElement;
import com.jetbrains.rd.ide.model.HighlighterModel;
import com.jetbrains.rd.ide.model.RdDocumentId;
import com.jetbrains.rd.ide.model.RdDocumentVersion;
import com.jetbrains.rd.ide.model.RdResponse;
import com.jetbrains.rd.util.lifetime.Lifetime;
import com.jetbrains.rd.util.reactive.ISignal;
import com.jetbrains.rd.util.reactive.InterfacesKt;
import com.jetbrains.rd.util.reactive.Signal;
import com.jetbrains.rdclient.daemon.suppressors.HighlighterElementSuppressor;
import com.jetbrains.rdclient.document.DocumentExKt;
import com.jetbrains.rdclient.editorActions.cwm.FrontendTypeKeyRequestBase;
import com.jetbrains.rdclient.editors.FrontendTextControlHost;
import com.jetbrains.rdclient.requests.FrontendAsyncRequest;
import com.jetbrains.rdclient.requests.FrontendAsyncRequestListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.TestOnly;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u00002\u00020\u0001:\u0001\u001bB\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\b\u0010\u0013\u001a\u00020\u0014H\u0002J\u0010\u0010\u0015\u001a\u00020\u00142\u0006\u0010\u0016\u001a\u00020\u0017H\u0016J\b\u0010\u0018\u001a\u00020\u0010H\u0007J\u0010\u0010\u0019\u001a\u00020\u00102\u0006\u0010\u001a\u001a\u00020\u0014H\u0007R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000fX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012\u00a8\u0006\u001c"}, d2={"Lcom/jetbrains/rdclient/daemon/suppressors/PatchEngineSynchronizationMarkupSuppressor;", "Lcom/jetbrains/rdclient/daemon/suppressors/HighlighterElementSuppressor;", "lifetime", "Lcom/jetbrains/rd/util/lifetime/Lifetime;", "session", "Lcom/intellij/openapi/client/ClientAppSession;", "document", "Lcom/intellij/openapi/editor/Document;", "<init>", "(Lcom/jetbrains/rd/util/lifetime/Lifetime;Lcom/intellij/openapi/client/ClientAppSession;Lcom/intellij/openapi/editor/Document;)V", "synchronizer", "Lcom/jetbrains/rd/ide/document/PatchEngineDocumentSynchronizer;", "tracker", "Lcom/jetbrains/rdclient/daemon/suppressors/PatchEngineSynchronizationMarkupSuppressor$TimedMarkupSuppressionTracker;", "flush", "Lcom/jetbrains/rd/util/reactive/Signal;", "", "getFlush", "()Lcom/jetbrains/rd/util/reactive/Signal;", "isCompletionRunning", "", "shouldSuppress", "element", "Lcom/jetbrains/rd/ide/model/HighlighterElement;", "flushManually", "setSuppressionStopped", "value", "TimedMarkupSuppressionTracker", "intellij.rd.client"})
@SourceDebugExtension(value={"SMAP\nPatchEngineSynchronizationMarkupSuppressor.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PatchEngineSynchronizationMarkupSuppressor.kt\ncom/jetbrains/rdclient/daemon/suppressors/PatchEngineSynchronizationMarkupSuppressor\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,132:1\n774#2:133\n865#2,2:134\n1761#2,3:136\n*S KotlinDebug\n*F\n+ 1 PatchEngineSynchronizationMarkupSuppressor.kt\ncom/jetbrains/rdclient/daemon/suppressors/PatchEngineSynchronizationMarkupSuppressor\n*L\n80#1:133\n80#1:134,2\n80#1:136,3\n*E\n"})
public final class PatchEngineSynchronizationMarkupSuppressor
implements HighlighterElementSuppressor {
    @NotNull
    private final ClientAppSession session;
    @NotNull
    private final Document document;
    @NotNull
    private final PatchEngineDocumentSynchronizer synchronizer;
    @NotNull
    private final TimedMarkupSuppressionTracker tracker;
    @NotNull
    private final Signal<Unit> flush;

    public PatchEngineSynchronizationMarkupSuppressor(@NotNull Lifetime lifetime, @NotNull ClientAppSession session2, @NotNull Document document) {
        Intrinsics.checkNotNullParameter((Object)lifetime, (String)"lifetime");
        Intrinsics.checkNotNullParameter((Object)session2, (String)"session");
        Intrinsics.checkNotNullParameter((Object)document, (String)"document");
        this.session = session2;
        this.document = document;
        DocumentSynchronizer documentSynchronizer = DocumentExKt.getDocumentSynchronizer(this.document, this.session);
        Intrinsics.checkNotNull((Object)documentSynchronizer, (String)"null cannot be cast to non-null type com.jetbrains.rd.ide.document.PatchEngineDocumentSynchronizer");
        this.synchronizer = (PatchEngineDocumentSynchronizer)documentSynchronizer;
        this.tracker = new TimedMarkupSuppressionTracker();
        this.flush = new Signal();
        MessageBusConnection messageBus = ApplicationKt.getApplication().getMessageBus().connect(LifetimeDisposableExKt.createNestedDisposable((Lifetime)lifetime, (String)"PatchEngineSynchronizationMarkupSuppressorMessageBus"));
        messageBus.subscribe(FrontendAsyncRequestListener.Companion.getTOPIC(), (Object)new FrontendAsyncRequestListener(){

            @Override
            public void requestSubmitted(ClientAppSession session2, FrontendAsyncRequest request) {
                Intrinsics.checkNotNullParameter((Object)session2, (String)"session");
                Intrinsics.checkNotNullParameter((Object)request, (String)"request");
                if (request instanceof FrontendTypeKeyRequestBase) {
                    tracker.suppressFor500Ms();
                }
            }

            @Override
            public void requestCompleted(ClientAppSession session2, FrontendAsyncRequest request, RdResponse response) {
                Intrinsics.checkNotNullParameter((Object)session2, (String)"session");
                Intrinsics.checkNotNullParameter((Object)request, (String)"request");
                Intrinsics.checkNotNullParameter((Object)response, (String)"response");
            }

            @Override
            public void responsesExecuted(ClientAppSession session2, List<? extends RdResponse> responses) {
                Intrinsics.checkNotNullParameter((Object)session2, (String)"session");
                Intrinsics.checkNotNullParameter(responses, (String)"responses");
                InterfacesKt.fire((ISignal)((ISignal)this.getFlush()));
            }
        });
        Topic topic = LookupManagerListener.TOPIC;
        Intrinsics.checkNotNullExpressionValue((Object)topic, (String)"TOPIC");
        messageBus.subscribe(topic, (Object)new LookupManagerListener(){

            public void activeLookupChanged(Lookup oldLookup, Lookup newLookup) {
                InterfacesKt.fire((ISignal)((ISignal)this.getFlush()));
            }
        });
        lifetime.bracketIfAlive(() -> PatchEngineSynchronizationMarkupSuppressor._init_$lambda$0(this, lifetime), () -> PatchEngineSynchronizationMarkupSuppressor._init_$lambda$1(this));
    }

    @Override
    @NotNull
    public Signal<Unit> getFlush() {
        return this.flush;
    }

    /*
     * WARNING - void declaration
     */
    private final boolean isCompletionRunning() {
        boolean bl;
        block5: {
            void $this$filterTo$iv$iv;
            RdDocumentId rdDocumentId = DocumentExKt.getDocumentId(this.document, this.session);
            if (rdDocumentId == null) {
                return false;
            }
            RdDocumentId entityId = rdDocumentId;
            FrontendTextControlHost host = FrontendTextControlHost.Companion.getInstance(this.session);
            Iterable $this$filter$iv = host.getEditors();
            boolean $i$f$filter = false;
            Iterable iterable = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                Editor it = (Editor)element$iv$iv;
                boolean bl2 = false;
                EditorSynchronizer editorSynchronizer = DocumentExKt.getEditorSynchronizer(it);
                if (!Intrinsics.areEqual((Object)(editorSynchronizer != null && (editorSynchronizer = editorSynchronizer.getTextControlId()) != null ? editorSynchronizer.getDocumentId() : null), (Object)entityId)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            Iterable $this$any$iv = (List)destination$iv$iv;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    Editor it = (Editor)element$iv;
                    boolean bl3 = false;
                    if (!(LookupManager.getActiveLookup((Editor)it) != null)) continue;
                    bl = true;
                    break block5;
                }
                bl = false;
            }
        }
        return bl;
    }

    @Override
    public boolean shouldSuppress(@NotNull HighlighterElement element) {
        HighlighterModel highlighter;
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        AbstractDocumentVersion abstractDocumentVersion = element.getHighlighter().getDocumentVersion();
        Intrinsics.checkNotNull((Object)abstractDocumentVersion, (String)"null cannot be cast to non-null type com.jetbrains.rd.ide.model.RdDocumentVersion");
        if (((RdDocumentVersion)abstractDocumentVersion).getValue() > this.synchronizer.getLastKnownVersion().getValue()) {
            return true;
        }
        if ((this.isCompletionRunning() || this.tracker.isMarkupSuppressed()) && (highlighter = element.getHighlighter()) instanceof DefaultHighlighterModel) {
            HighlightInfoModel highlightInfoModel = ((DefaultHighlighterModel)highlighter).getInfo();
            return Intrinsics.areEqual((Object)(highlightInfoModel != null && (highlightInfoModel = highlightInfoModel.getType()) != null ? highlightInfoModel.getSeverityId() : null), (Object)"ERROR");
        }
        return false;
    }

    @TestOnly
    public final void flushManually() {
        this.tracker.flushManually();
    }

    @TestOnly
    public final void setSuppressionStopped(boolean value) {
        this.tracker.setSuppressionStopped(value);
    }

    private static final Unit _init_$lambda$0(PatchEngineSynchronizationMarkupSuppressor this$0, Lifetime $lifetime) {
        this$0.tracker.getSuppressionReleased().advise($lifetime, (Function1)new Function1<Unit, Unit>(this$0.getFlush()){

            public final void invoke(Unit p0) {
                Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                ((Signal)this.receiver).fire((Object)p0);
            }
        });
        return Unit.INSTANCE;
    }

    private static final Unit _init_$lambda$1(PatchEngineSynchronizationMarkupSuppressor this$0) {
        Disposer.dispose((Disposable)this$0.tracker);
        return Unit.INSTANCE;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\b\b\u0002\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0006\u0010\n\u001a\u00020\u000bJ\b\u0010\f\u001a\u00020\u000bH\u0002J\b\u0010\u0011\u001a\u00020\u000bH\u0016J\b\u0010\u0012\u001a\u00020\u000bH\u0007R\u001e\u0010\u0006\u001a\u00020\u00052\u0006\u0010\u0004\u001a\u00020\u0005@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000b0\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u001c\u0010\u0013\u001a\u00020\u0005@\u0007X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0013\u0010\u0007\"\u0004\b\u0014\u0010\u0015\u00a8\u0006\u0016"}, d2={"Lcom/jetbrains/rdclient/daemon/suppressors/PatchEngineSynchronizationMarkupSuppressor$TimedMarkupSuppressionTracker;", "Lcom/intellij/openapi/Disposable;", "<init>", "()V", "value", "", "isMarkupSuppressed", "()Z", "myAlarm", "Lcom/intellij/util/Alarm;", "suppressFor500Ms", "", "releaseMarkup", "suppressionReleased", "Lcom/jetbrains/rd/util/reactive/Signal;", "getSuppressionReleased", "()Lcom/jetbrains/rd/util/reactive/Signal;", "dispose", "flushManually", "isSuppressionStopped", "setSuppressionStopped", "(Z)V", "intellij.rd.client"})
    private static final class TimedMarkupSuppressionTracker
    implements Disposable {
        private boolean isMarkupSuppressed;
        @NotNull
        private final Alarm myAlarm = new Alarm(Alarm.ThreadToUse.SWING_THREAD, (Disposable)this);
        @NotNull
        private final Signal<Unit> suppressionReleased = new Signal();
        private boolean isSuppressionStopped;

        public final boolean isMarkupSuppressed() {
            return this.isMarkupSuppressed;
        }

        public final void suppressFor500Ms() {
            if (this.isSuppressionStopped) {
                return;
            }
            this.myAlarm.cancelAllRequests();
            this.isMarkupSuppressed = true;
            this.myAlarm.addRequest(this::releaseMarkup, 500);
        }

        private final void releaseMarkup() {
            this.isMarkupSuppressed = false;
            InterfacesKt.fire((ISignal)((ISignal)this.suppressionReleased));
        }

        @NotNull
        public final Signal<Unit> getSuppressionReleased() {
            return this.suppressionReleased;
        }

        public void dispose() {
        }

        @TestOnly
        public final void flushManually() {
            this.releaseMarkup();
        }

        public final boolean isSuppressionStopped() {
            return this.isSuppressionStopped;
        }

        @TestOnly
        public final void setSuppressionStopped(boolean bl) {
            this.isSuppressionStopped = bl;
        }
    }
}

