/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.rml.dfa.protobuf;

import com.intellij.rml.dfa.ir.ast.IrTopLevelDecl;
import com.intellij.rml.dfa.protobuf.IrProtoBuildersKt;
import com.intellij.rml.dfa.protobuf.ir.PtIrTopLevelDeclList;
import com.intellij.util.io.DataExternalizer;
import com.intellij.util.io.DataOutputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.OutputStream;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0012\n\u0002\b\u0004\b\u00c6\u0002\u0018\u00002\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00030\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u001e\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00030\u0002H\u0016J\u0016\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00030\u00022\u0006\u0010\f\u001a\u00020\rH\u0016J\u0014\u0010\u000e\u001a\u00020\u000f2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00030\u0002J\u0014\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00030\u00022\u0006\u0010\u0012\u001a\u00020\u000fJ\u0014\u0010\u0013\u001a\u00020\u00142\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00030\u0002J\u0014\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00030\u00022\u0006\u0010\u0016\u001a\u00020\u0014J\u0014\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00030\u00022\u0006\u0010\u0016\u001a\u00020\u0014\u00a8\u0006\u0018"}, d2={"Lcom/intellij/rml/dfa/protobuf/IrExternalizer;", "Lcom/intellij/util/io/DataExternalizer;", "", "Lcom/intellij/rml/dfa/ir/ast/IrTopLevelDecl;", "<init>", "()V", "save", "", "output", "Ljava/io/DataOutput;", "value", "read", "input", "Ljava/io/DataInput;", "serialize", "Lcom/intellij/rml/dfa/protobuf/ir/PtIrTopLevelDeclList;", "decls", "deserialize", "declList", "saveToByteArray", "", "readFromByteArray", "array", "readFromByteArrayWithoutSize", "intellij.rml.dfa.protobuf"})
public final class IrExternalizer
implements DataExternalizer<List<? extends IrTopLevelDecl>> {
    @NotNull
    public static final IrExternalizer INSTANCE = new IrExternalizer();

    private IrExternalizer() {
    }

    public void save(@NotNull DataOutput output, @NotNull List<? extends IrTopLevelDecl> value) {
        Intrinsics.checkNotNullParameter((Object)output, (String)"output");
        Intrinsics.checkNotNullParameter(value, (String)"value");
        byte[] declsInBytes = this.serialize(value).toByteArray();
        output.writeInt(declsInBytes.length);
        output.write(declsInBytes);
    }

    @NotNull
    public List<IrTopLevelDecl> read(@NotNull DataInput input) {
        Intrinsics.checkNotNullParameter((Object)input, (String)"input");
        int arraySize = input.readInt();
        byte[] declsInBytes = new byte[arraySize];
        input.readFully(declsInBytes);
        PtIrTopLevelDeclList parsedDecls = PtIrTopLevelDeclList.parseFrom(declsInBytes);
        Intrinsics.checkNotNull((Object)parsedDecls);
        return this.deserialize(parsedDecls);
    }

    @NotNull
    public final PtIrTopLevelDeclList serialize(@NotNull List<? extends IrTopLevelDecl> decls) {
        Intrinsics.checkNotNullParameter(decls, (String)"decls");
        PtIrTopLevelDeclList ptIrTopLevelDeclList = IrProtoBuildersKt.builder(decls).build();
        Intrinsics.checkNotNullExpressionValue((Object)ptIrTopLevelDeclList, (String)"build(...)");
        return ptIrTopLevelDeclList;
    }

    @NotNull
    public final List<IrTopLevelDecl> deserialize(@NotNull PtIrTopLevelDeclList declList) {
        Intrinsics.checkNotNullParameter((Object)declList, (String)"declList");
        return IrProtoBuildersKt.buildToIrTopLevelDeclList(declList);
    }

    @NotNull
    public final byte[] saveToByteArray(@NotNull List<? extends IrTopLevelDecl> decls) {
        Intrinsics.checkNotNullParameter(decls, (String)"decls");
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        this.save((DataOutput)new DataOutputStream((OutputStream)outputStream), decls);
        byte[] byArray = outputStream.toByteArray();
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"toByteArray(...)");
        return byArray;
    }

    @NotNull
    public final List<IrTopLevelDecl> readFromByteArray(@NotNull byte[] array2) {
        Intrinsics.checkNotNullParameter((Object)array2, (String)"array");
        return this.read(new DataInputStream(new ByteArrayInputStream(array2)));
    }

    @NotNull
    public final List<IrTopLevelDecl> readFromByteArrayWithoutSize(@NotNull byte[] array2) {
        Intrinsics.checkNotNullParameter((Object)array2, (String)"array");
        PtIrTopLevelDeclList ptIrTopLevelDeclList = PtIrTopLevelDeclList.parseFrom(array2);
        Intrinsics.checkNotNullExpressionValue((Object)ptIrTopLevelDeclList, (String)"parseFrom(...)");
        return this.deserialize(ptIrTopLevelDeclList);
    }
}

