/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.resharper.cpp.assist.utils;

import com.intellij.openapi.editor.Document;
import com.intellij.openapi.util.TextRange;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.CharsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0016\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tJ\u0016\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t\u00a8\u0006\f"}, d2={"Lcom/intellij/resharper/cpp/assist/utils/DocumentIndentUtils;", "", "<init>", "()V", "getLineIndent", "", "document", "Lcom/intellij/openapi/editor/Document;", "line", "", "getIndentRange", "Lcom/intellij/openapi/util/TextRange;", "intellij.resharper.cpp.assist"})
public final class DocumentIndentUtils {
    @NotNull
    public static final DocumentIndentUtils INSTANCE = new DocumentIndentUtils();

    private DocumentIndentUtils() {
    }

    @NotNull
    public final String getLineIndent(@NotNull Document document, int line) {
        Intrinsics.checkNotNullParameter((Object)document, (String)"document");
        TextRange range = this.getIndentRange(document, line);
        String string = document.getText(range);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
        return string;
    }

    @NotNull
    public final TextRange getIndentRange(@NotNull Document document, int line) {
        int startOffset;
        char c;
        int pos;
        Intrinsics.checkNotNullParameter((Object)document, (String)"document");
        CharSequence charSequence = document.getImmutableCharSequence();
        Intrinsics.checkNotNullExpressionValue((Object)charSequence, (String)"getImmutableCharSequence(...)");
        CharSequence documentBuffer = charSequence;
        int pos1 = document.getLineEndOffset(line);
        for (pos = startOffset = document.getLineStartOffset(line); pos < pos1 && CharsKt.isWhitespace((char)(c = documentBuffer.charAt(pos))); ++pos) {
        }
        return new TextRange(startOffset, pos);
    }
}

