/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.resharper.cpp.assist;

import com.intellij.lexer.Lexer;
import com.intellij.lexer.LexerPosition;
import com.intellij.psi.tree.IElementType;
import com.intellij.resharper.cpp.assist.CppLexerTokenUtilsKt;
import com.intellij.resharper.cpp.assist.CppTokenData;
import com.intellij.resharper.cpp.assist.CppTypingAssistTokenUtilKt;
import com.intellij.resharper.cpp.assist.CppWeakKeywords;
import com.intellij.resharper.cpp.assist.ICppWeakKeywordsProvider;
import com.intellij.resharper.cpp.lexer.CachingLexer;
import com.intellij.resharper.cpp.lexer.CppLexerPunctuatorTokenNodeType;
import com.intellij.resharper.cpp.lexer.CppLexerTokenNodeTypes;
import com.intellij.resharper.cpp.lexer.CppLexerTokenTypeUtil;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\r\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c0\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007J\u000e\u0010\b\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007J\u000e\u0010\t\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007J\u000e\u0010\n\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007J\u000e\u0010\u000b\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007J\u000e\u0010\f\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007J\u0016\u0010\r\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u000e\u001a\u00020\u000fJ\u0016\u0010\u0010\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u000e\u001a\u00020\u000fJ*\u0010\u0010\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0011\u001a\u00020\u00122\b\u0010\u0013\u001a\u0004\u0018\u00010\u0014H\u0002J\u0015\u0010\u0015\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\u0016J\u0015\u0010\u0017\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\u0016J\u001f\u0010\u0018\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u000e\u001a\u00020\u000fH\u0002\u00a2\u0006\u0002\u0010\u0019J\u000e\u0010\u001a\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007J\u000e\u0010\u001b\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007J\u000e\u0010\u001c\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007J&\u0010\u001c\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u001d\u001a\u00020\u00142\u0006\u0010\u001e\u001a\u00020\u00142\u0006\u0010\u001f\u001a\u00020\u000fJ\u000e\u0010 \u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007J(\u0010 \u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u001d\u001a\u00020\u00142\u0006\u0010\u001e\u001a\u00020\u00142\u0006\u0010\u001f\u001a\u00020\u000fH\u0002J\u0012\u0010!\u001a\u00020\u0012*\u00020\"2\u0006\u0010#\u001a\u00020$J\u0012\u0010%\u001a\u00020\u0012*\u00020\"2\u0006\u0010#\u001a\u00020$\u00a8\u0006&"}, d2={"Lcom/intellij/resharper/cpp/assist/CppTypingAssistUtil;", "", "<init>", "()V", "skipWhitespacesForwardUntilNewLine", "", "lexer", "Lcom/intellij/resharper/cpp/lexer/CachingLexer;", "skipWhitespacesBackwardUntilNewLine", "skipWhitespacesForward", "skipWhitespacesAndCommentsForward", "skipWhitespacesBack", "skipWhitespacesAndCommentsBack", "skipWhitespacesUntilEndOfLine", "direction", "", "skipWhitespaces", "skipComment", "", "stopToken", "Lcom/intellij/psi/tree/IElementType;", "findMatchingRBrace", "(Lcom/intellij/resharper/cpp/lexer/CachingLexer;)Ljava/lang/Integer;", "findMatchingLBrace", "findMatchingBrace", "(Lcom/intellij/resharper/cpp/lexer/CachingLexer;I)Ljava/lang/Integer;", "skipPPBlockForward", "skipPPBlockBack", "skipParensBack", "lpar", "rpar", "parensCount", "skipParensForward", "canRequireTemplateArguments", "Lcom/intellij/resharper/cpp/assist/CppTokenData;", "keywordsProvider", "Lcom/intellij/resharper/cpp/assist/ICppWeakKeywordsProvider;", "isLikelyIdentifier", "intellij.resharper.cpp.assist"})
@SourceDebugExtension(value={"SMAP\nCppTypingAssistUtil.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CppTypingAssistUtil.kt\ncom/intellij/resharper/cpp/assist/CppTypingAssistUtil\n+ 2 LanguageAgnosticHelpers.kt\ncom/intellij/resharper/cpp/assist/utils/LanguageAgnosticHelpersKt\n*L\n1#1,199:1\n15#2,6:200\n*S KotlinDebug\n*F\n+ 1 CppTypingAssistUtil.kt\ncom/intellij/resharper/cpp/assist/CppTypingAssistUtil\n*L\n64#1:200,6\n*E\n"})
public final class CppTypingAssistUtil {
    @NotNull
    public static final CppTypingAssistUtil INSTANCE = new CppTypingAssistUtil();

    private CppTypingAssistUtil() {
    }

    public final void skipWhitespacesForwardUntilNewLine(@NotNull CachingLexer lexer) {
        Intrinsics.checkNotNullParameter((Object)lexer, (String)"lexer");
        this.skipWhitespacesUntilEndOfLine(lexer, 1);
    }

    public final void skipWhitespacesBackwardUntilNewLine(@NotNull CachingLexer lexer) {
        Intrinsics.checkNotNullParameter((Object)lexer, (String)"lexer");
        this.skipWhitespacesUntilEndOfLine(lexer, -1);
    }

    public final void skipWhitespacesForward(@NotNull CachingLexer lexer) {
        Intrinsics.checkNotNullParameter((Object)lexer, (String)"lexer");
        this.skipWhitespaces(lexer, 1, false, null);
    }

    public final void skipWhitespacesAndCommentsForward(@NotNull CachingLexer lexer) {
        Intrinsics.checkNotNullParameter((Object)lexer, (String)"lexer");
        this.skipWhitespaces(lexer, 1, true, null);
    }

    public final void skipWhitespacesBack(@NotNull CachingLexer lexer) {
        Intrinsics.checkNotNullParameter((Object)lexer, (String)"lexer");
        this.skipWhitespaces(lexer, -1, false, null);
    }

    public final void skipWhitespacesAndCommentsBack(@NotNull CachingLexer lexer) {
        Intrinsics.checkNotNullParameter((Object)lexer, (String)"lexer");
        this.skipWhitespaces(lexer, -1, true, null);
    }

    public final void skipWhitespacesUntilEndOfLine(@NotNull CachingLexer lexer, int direction) {
        Intrinsics.checkNotNullParameter((Object)lexer, (String)"lexer");
        this.skipWhitespaces(lexer, direction, false, (IElementType)CppLexerTokenNodeTypes.Companion.getNEW_LINE());
    }

    public final void skipWhitespaces(@NotNull CachingLexer lexer, int direction) {
        Intrinsics.checkNotNullParameter((Object)lexer, (String)"lexer");
        this.skipWhitespaces(lexer, direction, false, null);
    }

    private final void skipWhitespaces(CachingLexer lexer, int direction, boolean skipComment, IElementType stopToken) {
        IElementType tt;
        do {
            lexer.advance(direction);
        } while (lexer.getTokenType() != null && !Intrinsics.areEqual((Object)tt, (Object)stopToken) && (CppLexerTokenUtilsKt.isWhitespace(tt) || skipComment && (CppLexerTokenUtilsKt.isComment(tt) || CppLexerTokenNodeTypes.Companion.getDIRECTIVES().contains(tt) || CppLexerTokenTypeUtil.INSTANCE.isDirectiveContent(tt))));
    }

    @Nullable
    public final Integer findMatchingRBrace(@NotNull CachingLexer lexer) {
        Intrinsics.checkNotNullParameter((Object)lexer, (String)"lexer");
        return this.findMatchingBrace(lexer, 1);
    }

    @Nullable
    public final Integer findMatchingLBrace(@NotNull CachingLexer lexer) {
        Intrinsics.checkNotNullParameter((Object)lexer, (String)"lexer");
        return this.findMatchingBrace(lexer, -1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final Integer findMatchingBrace(CachingLexer lexer, int direction) {
        lexer.advance(direction);
        int braceCount = 0;
        braceCount = direction;
        Lexer $this$use$iv = (Lexer)lexer;
        boolean $i$f$use = false;
        LexerPosition lexerPosition = $this$use$iv.getCurrentPosition();
        Intrinsics.checkNotNullExpressionValue((Object)lexerPosition, (String)"getCurrentPosition(...)");
        LexerPosition position$iv = lexerPosition;
        try {
            boolean bl = false;
            while (lexer.getTokenType() != null) {
                if (CppLexerTokenNodeTypes.Companion.getELSE_DIRECTIVES().contains(lexer.getTokenType())) {
                    if (direction == -1) {
                        INSTANCE.skipPPBlockBack(lexer);
                    } else {
                        INSTANCE.skipPPBlockForward(lexer);
                    }
                }
                if (lexer.getTokenType() == CppLexerTokenNodeTypes.Companion.getLBRACE()) {
                    if (++braceCount == 0) {
                        Integer n = lexer.getTokenStart();
                        return n;
                    }
                } else if (lexer.getTokenType() == CppLexerTokenNodeTypes.Companion.getRBRACE() && (braceCount += -1) == 0) {
                    Integer n = lexer.getTokenStart();
                    return n;
                }
                lexer.advance(direction);
            }
            Unit unit = Unit.INSTANCE;
        }
        finally {
            $this$use$iv.restore(position$iv);
        }
        return null;
    }

    public final void skipPPBlockForward(@NotNull CachingLexer lexer) {
        Intrinsics.checkNotNullParameter((Object)lexer, (String)"lexer");
        int parensCount = 1;
        this.skipWhitespacesForward(lexer);
        while (parensCount != 0 && lexer.getTokenType() != null) {
            if (Intrinsics.areEqual((Object)lexer.getTokenType(), (Object)CppLexerTokenNodeTypes.Companion.getENDIF_DIRECTIVE())) {
                --parensCount;
            } else if (!CppLexerTokenNodeTypes.Companion.getELIF_DIRECTIVES().contains(lexer.getTokenType()) && CppLexerTokenNodeTypes.Companion.getIF_DIRECTIVES().contains(lexer.getTokenType())) {
                ++parensCount;
            }
            this.skipWhitespacesForward(lexer);
        }
    }

    public final void skipPPBlockBack(@NotNull CachingLexer lexer) {
        Intrinsics.checkNotNullParameter((Object)lexer, (String)"lexer");
        int parensCount = 1;
        this.skipWhitespacesBack(lexer);
        while (parensCount != 0 && lexer.getTokenType() != null) {
            if (lexer.getTokenType() == CppLexerTokenNodeTypes.Companion.getENDIF_DIRECTIVE()) {
                ++parensCount;
            } else if (!CppLexerTokenNodeTypes.Companion.getELIF_DIRECTIVES().contains(lexer.getTokenType()) && CppLexerTokenNodeTypes.Companion.getIF_DIRECTIVES().contains(lexer.getTokenType())) {
                --parensCount;
            }
            this.skipWhitespacesBack(lexer);
        }
    }

    public final void skipParensBack(@NotNull CachingLexer lexer) {
        CppLexerPunctuatorTokenNodeType cppLexerPunctuatorTokenNodeType;
        IElementType rpar;
        Intrinsics.checkNotNullParameter((Object)lexer, (String)"lexer");
        IElementType iElementType = rpar = lexer.getTokenType();
        if (Intrinsics.areEqual((Object)iElementType, (Object)CppLexerTokenNodeTypes.Companion.getRPAR())) {
            cppLexerPunctuatorTokenNodeType = CppLexerTokenNodeTypes.Companion.getLPAR();
        } else if (Intrinsics.areEqual((Object)iElementType, (Object)CppLexerTokenNodeTypes.Companion.getRBRACE())) {
            cppLexerPunctuatorTokenNodeType = CppLexerTokenNodeTypes.Companion.getLBRACE();
        } else if (Intrinsics.areEqual((Object)iElementType, (Object)CppLexerTokenNodeTypes.Companion.getRBRACKET())) {
            cppLexerPunctuatorTokenNodeType = CppLexerTokenNodeTypes.Companion.getLBRACKET();
        } else if (Intrinsics.areEqual((Object)iElementType, (Object)CppLexerTokenNodeTypes.Companion.getGT())) {
            cppLexerPunctuatorTokenNodeType = CppLexerTokenNodeTypes.Companion.getLT();
        } else {
            throw new IllegalStateException(("Must be RPAR: " + rpar).toString());
        }
        CppLexerPunctuatorTokenNodeType lpar = cppLexerPunctuatorTokenNodeType;
        this.skipParensBack(lexer, (IElementType)lpar, rpar, 1);
    }

    public final void skipParensBack(@NotNull CachingLexer lexer, @NotNull IElementType lpar, @NotNull IElementType rpar, int parensCount) {
        Intrinsics.checkNotNullParameter((Object)lexer, (String)"lexer");
        Intrinsics.checkNotNullParameter((Object)lpar, (String)"lpar");
        Intrinsics.checkNotNullParameter((Object)rpar, (String)"rpar");
        int parensCount2 = parensCount;
        this.skipWhitespacesBack(lexer);
        while (parensCount2 != 0 && lexer.getTokenType() != null) {
            if (CppLexerTokenNodeTypes.Companion.getELSE_DIRECTIVES().contains(lexer.getTokenType())) {
                this.skipPPBlockBack(lexer);
                continue;
            }
            if (lexer.getTokenType() == rpar) {
                ++parensCount2;
            } else if (lexer.getTokenType() == lpar) {
                --parensCount2;
            }
            this.skipWhitespacesBack(lexer);
        }
    }

    public final void skipParensForward(@NotNull CachingLexer lexer) {
        CppLexerPunctuatorTokenNodeType cppLexerPunctuatorTokenNodeType;
        IElementType lpar;
        Intrinsics.checkNotNullParameter((Object)lexer, (String)"lexer");
        IElementType iElementType = lpar = lexer.getTokenType();
        if (Intrinsics.areEqual((Object)iElementType, (Object)CppLexerTokenNodeTypes.Companion.getLPAR())) {
            cppLexerPunctuatorTokenNodeType = CppLexerTokenNodeTypes.Companion.getRPAR();
        } else if (Intrinsics.areEqual((Object)iElementType, (Object)CppLexerTokenNodeTypes.Companion.getLBRACE())) {
            cppLexerPunctuatorTokenNodeType = CppLexerTokenNodeTypes.Companion.getRBRACE();
        } else if (Intrinsics.areEqual((Object)iElementType, (Object)CppLexerTokenNodeTypes.Companion.getLBRACKET())) {
            cppLexerPunctuatorTokenNodeType = CppLexerTokenNodeTypes.Companion.getRBRACKET();
        } else if (Intrinsics.areEqual((Object)iElementType, (Object)CppLexerTokenNodeTypes.Companion.getLT())) {
            cppLexerPunctuatorTokenNodeType = CppLexerTokenNodeTypes.Companion.getGT();
        } else {
            throw new AssertionError((Object)("Must be LPAR: " + lexer.getTokenType()));
        }
        CppLexerPunctuatorTokenNodeType rpar = cppLexerPunctuatorTokenNodeType;
        this.skipParensForward(lexer, lpar, (IElementType)rpar, 1);
    }

    private final void skipParensForward(CachingLexer lexer, IElementType lpar, IElementType rpar, int parensCount) {
        int parensCount2 = parensCount;
        this.skipWhitespacesForward(lexer);
        while (parensCount2 != 0 && lexer.getTokenType() != null) {
            if (lexer.getTokenType() == lpar) {
                ++parensCount2;
            } else if (lexer.getTokenType() == rpar) {
                --parensCount2;
            }
            this.skipWhitespacesForward(lexer);
        }
    }

    public final boolean canRequireTemplateArguments(@NotNull CppTokenData $this$canRequireTemplateArguments, @NotNull ICppWeakKeywordsProvider keywordsProvider) {
        Intrinsics.checkNotNullParameter((Object)$this$canRequireTemplateArguments, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)keywordsProvider, (String)"keywordsProvider");
        return CppTypingAssistTokenUtilKt.isWeakKeyword($this$canRequireTemplateArguments, CppWeakKeywords.INSTANCE.getDEFINITELY_WITH_TEMPLATE_ARGUMENTS_KEYWORDS2()) || this.isLikelyIdentifier($this$canRequireTemplateArguments, keywordsProvider);
    }

    public final boolean isLikelyIdentifier(@NotNull CppTokenData $this$isLikelyIdentifier, @NotNull ICppWeakKeywordsProvider keywordsProvider) {
        Intrinsics.checkNotNullParameter((Object)$this$isLikelyIdentifier, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)keywordsProvider, (String)"keywordsProvider");
        return Intrinsics.areEqual((Object)$this$isLikelyIdentifier.getTokenType(), (Object)CppLexerTokenNodeTypes.Companion.getIDENTIFIER()) && !CppTypingAssistTokenUtilKt.isWeakKeyword($this$isLikelyIdentifier, keywordsProvider.getAllKnownKeywords());
    }
}

