/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.resharper.cpp.assist;

import com.intellij.application.options.CodeStyle;
import com.intellij.lexer.Lexer;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiFile;
import com.intellij.psi.codeStyle.CommonCodeStyleSettings;
import com.intellij.resharper.cpp.assist.CppTypingAssistUtil;
import com.intellij.resharper.cpp.assist.CppWeakKeywordsProvider;
import com.intellij.resharper.cpp.assist.ICppWeakKeywordsProvider;
import com.intellij.resharper.cpp.assist.utils.TypingAssistOptionsProvider;
import com.intellij.resharper.cpp.lexer.CachingLexer;
import com.intellij.resharper.cpp.lexer.CppLexer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000j\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u000f\b\u0000\u0018\u00002\u00020\u0001:\u00018B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0006\u0010\b\u001a\u00020\tJ\u000e\u0010)\u001a\u00020*2\u0006\u0010+\u001a\u00020\tJ\u0016\u0010,\u001a\u00020*2\u0006\u0010-\u001a\u00020#2\u0006\u0010.\u001a\u00020#J&\u0010/\u001a\u00020*2\u0006\u0010-\u001a\u00020#2\u0006\u0010.\u001a\u00020#2\u0006\u00100\u001a\u00020#2\u0006\u00101\u001a\u00020%J\u0010\u00102\u001a\u0004\u0018\u00010%2\u0006\u00100\u001a\u00020#R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0011\u0010\n\u001a\u00020\u000b8F\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\fR\u0011\u0010\r\u001a\u00020\u000e8F\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0010R\u0011\u0010\u0011\u001a\u00020\u00128F\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u0014R\u0011\u0010\u0015\u001a\u00020\u00168F\u00a2\u0006\u0006\u001a\u0004\b\u0017\u0010\u0018R\u0011\u0010\u0019\u001a\u00020\u001a8F\u00a2\u0006\u0006\u001a\u0004\b\u001b\u0010\u001cR\u0016\u0010\u001d\u001a\u0004\u0018\u00010\u001e8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001f\u0010 R\u001c\u0010!\u001a\u0010\u0012\u0004\u0012\u00020#\u0012\u0004\u0012\u00020#\u0018\u00010\"X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001c\u0010$\u001a\u0010\u0012\u0004\u0012\u00020#\u0012\u0004\u0012\u00020%\u0018\u00010\"X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0016\u0010&\u001a\n\u0012\u0004\u0012\u00020(\u0018\u00010'X\u0082\u000e\u00a2\u0006\u0002\n\u0000R$\u00104\u001a\u00020\u000b2\u0006\u00103\u001a\u00020\u000b8F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b5\u0010\f\"\u0004\b6\u00107\u00a8\u00069"}, d2={"Lcom/intellij/resharper/cpp/assist/CppDummyFormatterContext;", "", "editor", "Lcom/intellij/openapi/editor/Editor;", "<init>", "(Lcom/intellij/openapi/editor/Editor;)V", "getEditor", "()Lcom/intellij/openapi/editor/Editor;", "getCachingLexer", "Lcom/intellij/resharper/cpp/lexer/CachingLexer;", "isBlockShader", "", "()Z", "keywordsProvider", "Lcom/intellij/resharper/cpp/assist/ICppWeakKeywordsProvider;", "getKeywordsProvider", "()Lcom/intellij/resharper/cpp/assist/ICppWeakKeywordsProvider;", "formatterSettings", "Lcom/intellij/psi/codeStyle/CommonCodeStyleSettings$IndentOptions;", "getFormatterSettings", "()Lcom/intellij/psi/codeStyle/CommonCodeStyleSettings$IndentOptions;", "optionsProvider", "Lcom/intellij/resharper/cpp/assist/utils/TypingAssistOptionsProvider;", "getOptionsProvider", "()Lcom/intellij/resharper/cpp/assist/utils/TypingAssistOptionsProvider;", "document", "Lcom/intellij/openapi/editor/Document;", "getDocument", "()Lcom/intellij/openapi/editor/Document;", "psiFile", "Lcom/intellij/psi/PsiFile;", "getPsiFile", "()Lcom/intellij/psi/PsiFile;", "mySkipParentsBack", "", "", "myChangedIndents", "", "myChangesAccumulator", "", "Lcom/intellij/resharper/cpp/assist/CppDummyFormatterContext$DocumentChange;", "skipParensBack", "", "lexer", "registerTrailingSpaces", "startOffset", "oldLength", "registerLineIndent", "lineIndex", "newText", "tryGetLineIndent", "value", "defferModeIndentingMode", "getDefferModeIndentingMode", "setDefferModeIndentingMode", "(Z)V", "DocumentChange", "intellij.resharper.cpp.assist"})
public final class CppDummyFormatterContext {
    @NotNull
    private final Editor editor;
    @Nullable
    private Map<Integer, Integer> mySkipParentsBack;
    @Nullable
    private Map<Integer, String> myChangedIndents;
    @Nullable
    private List<DocumentChange> myChangesAccumulator;

    public CppDummyFormatterContext(@NotNull Editor editor) {
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        this.editor = editor;
    }

    @NotNull
    public final Editor getEditor() {
        return this.editor;
    }

    @NotNull
    public final CachingLexer getCachingLexer() {
        CppLexer lexer = new CppLexer();
        CachingLexer cachingLexer = new CachingLexer((Lexer)lexer);
        cachingLexer.start(this.editor.getDocument().getImmutableCharSequence());
        return cachingLexer;
    }

    public final boolean isBlockShader() {
        return false;
    }

    @NotNull
    public final ICppWeakKeywordsProvider getKeywordsProvider() {
        return CppWeakKeywordsProvider.Cpp.INSTANCE;
    }

    @NotNull
    public final CommonCodeStyleSettings.IndentOptions getFormatterSettings() {
        CommonCodeStyleSettings.IndentOptions indentOptions = CodeStyle.getSettings((Editor)this.editor).getIndentOptionsByFile(this.getPsiFile());
        Intrinsics.checkNotNullExpressionValue((Object)indentOptions, (String)"getIndentOptionsByFile(...)");
        return indentOptions;
    }

    @NotNull
    public final TypingAssistOptionsProvider getOptionsProvider() {
        Project project = this.editor.getProject();
        Intrinsics.checkNotNull((Object)project);
        return TypingAssistOptionsProvider.Companion.getInstance(project);
    }

    @NotNull
    public final Document getDocument() {
        Document document = this.editor.getDocument();
        Intrinsics.checkNotNullExpressionValue((Object)document, (String)"getDocument(...)");
        return document;
    }

    private final PsiFile getPsiFile() {
        PsiFile psiFile;
        Project project = this.editor.getProject();
        if (project != null) {
            Project it = project;
            boolean bl = false;
            psiFile = PsiDocumentManager.getInstance((Project)it).getPsiFile(this.getDocument());
        } else {
            psiFile = null;
        }
        return psiFile;
    }

    public final void skipParensBack(@NotNull CachingLexer lexer) {
        block1: {
            Integer position;
            Intrinsics.checkNotNullParameter((Object)lexer, (String)"lexer");
            int startPosition = lexer.getCurrentRawPosition();
            Map<Integer, Integer> map = this.mySkipParentsBack;
            Integer n = position = map != null ? map.get(startPosition) : null;
            if (position != null) {
                lexer.setCurrentToken(position.intValue());
                return;
            }
            CppTypingAssistUtil.INSTANCE.skipParensBack(lexer);
            Map<Integer, Integer> map2 = this.mySkipParentsBack;
            if (map2 == null) break block1;
            map2.put(startPosition, lexer.getCurrentRawPosition());
        }
    }

    public final void registerTrailingSpaces(int startOffset, int oldLength) {
        boolean bl = this.getDefferModeIndentingMode();
        if (_Assertions.ENABLED && !bl) {
            String string = "Assertion failed";
            throw new AssertionError((Object)string);
        }
        List<DocumentChange> list2 = this.myChangesAccumulator;
        Intrinsics.checkNotNull(list2);
        list2.add(new DocumentChange(startOffset, oldLength, ""));
    }

    public final void registerLineIndent(int startOffset, int oldLength, int lineIndex, @NotNull String newText) {
        Intrinsics.checkNotNullParameter((Object)newText, (String)"newText");
        boolean bl = this.getDefferModeIndentingMode();
        if (_Assertions.ENABLED && !bl) {
            String string = "Assertion failed";
            throw new AssertionError((Object)string);
        }
        List<DocumentChange> list2 = this.myChangesAccumulator;
        Intrinsics.checkNotNull(list2);
        list2.add(new DocumentChange(startOffset, oldLength, newText));
        Map<Integer, String> map = this.myChangedIndents;
        Intrinsics.checkNotNull(map);
        map.put(lineIndex, newText);
    }

    @Nullable
    public final String tryGetLineIndent(int lineIndex) {
        Map<Integer, String> map = this.myChangedIndents;
        return map != null ? map.get(lineIndex) : null;
    }

    public final boolean getDefferModeIndentingMode() {
        return this.myChangesAccumulator != null;
    }

    public final void setDefferModeIndentingMode(boolean value) {
        if (value) {
            if (!(this.myChangesAccumulator == null)) {
                String string = "Failed requirement.";
                throw new IllegalArgumentException(string.toString());
            }
            this.myChangesAccumulator = new ArrayList();
            this.myChangedIndents = new LinkedHashMap();
            this.mySkipParentsBack = new LinkedHashMap();
        } else {
            List<DocumentChange> changesAccumulator = this.myChangesAccumulator;
            if (!(changesAccumulator != null)) {
                String string = "Failed requirement.";
                throw new IllegalArgumentException(string.toString());
            }
            if (!((Collection)changesAccumulator).isEmpty()) {
                StringBuffer buffer = new StringBuffer(this.getDocument().getImmutableCharSequence());
                int startOffset = ((DocumentChange)CollectionsKt.first(changesAccumulator)).getStartOffset();
                int endOffset = ((DocumentChange)CollectionsKt.last(changesAccumulator)).getStartOffset() + ((DocumentChange)CollectionsKt.last(changesAccumulator)).getOldLength();
                for (DocumentChange change : CollectionsKt.asReversedMutable(changesAccumulator)) {
                    buffer.replace(change.getStartOffset(), change.getStartOffset() + change.getOldLength(), change.getNewText());
                }
                int delta = buffer.length() - this.getDocument().getTextLength();
                this.getDocument().replaceString(startOffset, endOffset, buffer.subSequence(startOffset, endOffset + delta));
            }
            this.myChangesAccumulator = null;
            this.myChangedIndents = null;
            this.mySkipParentsBack = null;
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\f\n\u0002\u0010\u000b\n\u0002\b\u0004\b\u0086\b\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ\t\u0010\u000e\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u000f\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0010\u001a\u00020\u0006H\u00c6\u0003J'\u0010\u0011\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u0006H\u00c6\u0001J\u0013\u0010\u0012\u001a\u00020\u00132\b\u0010\u0014\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0015\u001a\u00020\u0003H\u00d6\u0001J\t\u0010\u0016\u001a\u00020\u0006H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\nR\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\r\u00a8\u0006\u0017"}, d2={"Lcom/intellij/resharper/cpp/assist/CppDummyFormatterContext$DocumentChange;", "", "startOffset", "", "oldLength", "newText", "", "<init>", "(IILjava/lang/String;)V", "getStartOffset", "()I", "getOldLength", "getNewText", "()Ljava/lang/String;", "component1", "component2", "component3", "copy", "equals", "", "other", "hashCode", "toString", "intellij.resharper.cpp.assist"})
    public static final class DocumentChange {
        private final int startOffset;
        private final int oldLength;
        @NotNull
        private final String newText;

        public DocumentChange(int startOffset, int oldLength, @NotNull String newText) {
            Intrinsics.checkNotNullParameter((Object)newText, (String)"newText");
            this.startOffset = startOffset;
            this.oldLength = oldLength;
            this.newText = newText;
        }

        public final int getStartOffset() {
            return this.startOffset;
        }

        public final int getOldLength() {
            return this.oldLength;
        }

        @NotNull
        public final String getNewText() {
            return this.newText;
        }

        public final int component1() {
            return this.startOffset;
        }

        public final int component2() {
            return this.oldLength;
        }

        @NotNull
        public final String component3() {
            return this.newText;
        }

        @NotNull
        public final DocumentChange copy(int startOffset, int oldLength, @NotNull String newText) {
            Intrinsics.checkNotNullParameter((Object)newText, (String)"newText");
            return new DocumentChange(startOffset, oldLength, newText);
        }

        public static /* synthetic */ DocumentChange copy$default(DocumentChange documentChange, int n, int n2, String string, int n3, Object object) {
            if ((n3 & 1) != 0) {
                n = documentChange.startOffset;
            }
            if ((n3 & 2) != 0) {
                n2 = documentChange.oldLength;
            }
            if ((n3 & 4) != 0) {
                string = documentChange.newText;
            }
            return documentChange.copy(n, n2, string);
        }

        @NotNull
        public String toString() {
            return "DocumentChange(startOffset=" + this.startOffset + ", oldLength=" + this.oldLength + ", newText=" + this.newText + ")";
        }

        public int hashCode() {
            int result2 = Integer.hashCode(this.startOffset);
            result2 = result2 * 31 + Integer.hashCode(this.oldLength);
            result2 = result2 * 31 + this.newText.hashCode();
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof DocumentChange)) {
                return false;
            }
            DocumentChange documentChange = (DocumentChange)other;
            if (this.startOffset != documentChange.startOffset) {
                return false;
            }
            if (this.oldLength != documentChange.oldLength) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.newText, (Object)documentChange.newText);
        }
    }
}

