/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.packagemanager.vcpkg.windows;

import com.intellij.openapi.observable.properties.AtomicProperty;
import com.intellij.openapi.observable.properties.ObservableMutableProperty;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.ui.components.JBTextField;
import com.intellij.ui.dsl.builder.Align;
import com.intellij.ui.dsl.builder.AlignX;
import com.intellij.ui.dsl.builder.BuilderKt;
import com.intellij.ui.dsl.builder.ButtonKt;
import com.intellij.ui.dsl.builder.Cell;
import com.intellij.ui.dsl.builder.Panel;
import com.intellij.ui.dsl.builder.Row;
import com.intellij.ui.dsl.builder.TextFieldKt;
import com.jetbrains.cidr.cpp.cmake.workspace.CMakeProfileInfo;
import com.jetbrains.cidr.packagemanager.bundle.PackageManagerBundle;
import com.jetbrains.cidr.packagemanager.fus.PackageManagerCollector;
import com.jetbrains.cidr.packagemanager.utils.PackageManagerUtils;
import com.jetbrains.cidr.packagemanager.vcpkg.VCPKGPackageManager;
import com.jetbrains.cidr.packagemanager.vcpkg.components.VcpkgPackageManagerContentUtils;
import com.jetbrains.cidr.packagemanager.vcpkg.service.VcpkgPackageManagerModelService;
import com.jetbrains.cidr.packagemanager.vcpkg.windows.VcpkgPackageManagerCommon;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import javax.swing.JComponent;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\"\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\b\u0010\u001b\u001a\u00020\u001cH\u0014J\b\u0010\u001d\u001a\u00020\u001eH\u0014R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u001c\u0010\f\u001a\r\u0012\t\u0012\u00070\u000e\u00a2\u0006\u0002\b\u000f0\r\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0014\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u000e0\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u000e0\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00160\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00180\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u00050\u001aX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001f"}, d2={"Lcom/jetbrains/cidr/packagemanager/vcpkg/windows/EditVcpkgPackageManagerWindow;", "Lcom/intellij/openapi/ui/DialogWrapper;", "project", "Lcom/intellij/openapi/project/Project;", "packageManager", "Lcom/jetbrains/cidr/packagemanager/vcpkg/VCPKGPackageManager;", "<init>", "(Lcom/intellij/openapi/project/Project;Lcom/jetbrains/cidr/packagemanager/vcpkg/VCPKGPackageManager;)V", "getProject", "()Lcom/intellij/openapi/project/Project;", "getPackageManager", "()Lcom/jetbrains/cidr/packagemanager/vcpkg/VCPKGPackageManager;", "name", "Lcom/intellij/openapi/observable/properties/AtomicProperty;", "", "Lorg/jetbrains/annotations/Nls;", "getName", "()Lcom/intellij/openapi/observable/properties/AtomicProperty;", "localPathToPackageManager", "urlOfOriginalPackageManager", "profileGet", "", "Lcom/jetbrains/cidr/packagemanager/utils/PackageManagerUtils$ProfilePackageManagerInfo;", "isForceUseSystemBinaries", "", "packageManagers", "", "createCenterPanel", "Ljavax/swing/JComponent;", "doOKAction", "", "intellij.clion.packageManager"})
@SourceDebugExtension(value={"SMAP\nEditVcpkgPackageManagerWindow.kt\nKotlin\n*S Kotlin\n*F\n+ 1 EditVcpkgPackageManagerWindow.kt\ncom/jetbrains/cidr/packagemanager/vcpkg/windows/EditVcpkgPackageManagerWindow\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,82:1\n1869#2,2:83\n1563#2:85\n1634#2,3:86\n*S KotlinDebug\n*F\n+ 1 EditVcpkgPackageManagerWindow.kt\ncom/jetbrains/cidr/packagemanager/vcpkg/windows/EditVcpkgPackageManagerWindow\n*L\n75#1:83,2\n39#1:85\n39#1:86,3\n*E\n"})
public final class EditVcpkgPackageManagerWindow
extends DialogWrapper {
    @NotNull
    private final Project project;
    @NotNull
    private final VCPKGPackageManager packageManager;
    @NotNull
    private final AtomicProperty<String> name;
    @NotNull
    private final AtomicProperty<String> localPathToPackageManager;
    @NotNull
    private final AtomicProperty<String> urlOfOriginalPackageManager;
    @NotNull
    private final List<PackageManagerUtils.ProfilePackageManagerInfo> profileGet;
    @NotNull
    private final AtomicProperty<Boolean> isForceUseSystemBinaries;
    @NotNull
    private final Set<VCPKGPackageManager> packageManagers;

    public EditVcpkgPackageManagerWindow(@NotNull Project project, @NotNull VCPKGPackageManager packageManager) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)packageManager, (String)"packageManager");
        super(project);
        this.project = project;
        this.packageManager = packageManager;
        this.name = new AtomicProperty((Object)this.packageManager.getName());
        this.localPathToPackageManager = new AtomicProperty((Object)((Object)this.packageManager.getPath()).toString());
        this.urlOfOriginalPackageManager = new AtomicProperty((Object)this.packageManager.getBaseUrl());
        this.profileGet = PackageManagerUtils.Companion.getProfilesPackageManagerWithLocks(this.project, (Function1<? super VCPKGPackageManager, Boolean>)((Function1)arg_0 -> EditVcpkgPackageManagerWindow.profileGet$lambda$0(this, arg_0)));
        this.isForceUseSystemBinaries = new AtomicProperty(this.packageManager.isForcedBundledNinjaCMake().get());
        this.packageManagers = SetsKt.minus(VcpkgPackageManagerModelService.Companion.getInstance().getPackages(), (Object)this.packageManager);
        this.setTitle(PackageManagerBundle.INSTANCE.message("vcpkg.edit.package.manager.window.name", new Object[0]));
        this.init();
    }

    @NotNull
    public final Project getProject() {
        return this.project;
    }

    @NotNull
    public final VCPKGPackageManager getPackageManager() {
        return this.packageManager;
    }

    @NotNull
    public final AtomicProperty<String> getName() {
        return this.name;
    }

    @NotNull
    protected JComponent createCenterPanel() {
        return (JComponent)BuilderKt.panel(arg_0 -> EditVcpkgPackageManagerWindow.createCenterPanel$lambda$0(this, arg_0));
    }

    protected void doOKAction() {
        super.doOKAction();
        VcpkgPackageManagerModelService.Companion.getInstance().rename(this.packageManager, this.packageManager.getName(), (String)this.name.get());
        boolean isForceUseSystemBinariesValue = (Boolean)this.isForceUseSystemBinaries.get();
        if (isForceUseSystemBinariesValue) {
            PackageManagerCollector.countForceUsingSystemBinaries.log(this.project);
        }
        this.packageManager.isForcedBundledNinjaCMake().set((Object)isForceUseSystemBinariesValue);
        Iterable $this$forEach$iv = this.profileGet;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Path path;
            PackageManagerUtils.ProfilePackageManagerInfo info = (PackageManagerUtils.ProfilePackageManagerInfo)element$iv;
            boolean bl = false;
            if (!(Intrinsics.areEqual((Object)info.getPackageManager(), (Object)this.packageManager) ^ (Boolean)info.isAdd().get())) continue;
            CMakeProfileInfo cMakeProfileInfo = info.getProfile();
            if (((Boolean)info.isAdd().get()).booleanValue()) {
                Path path2 = this.packageManager.getPath().toAbsolutePath();
                path = path2;
                Intrinsics.checkNotNullExpressionValue((Object)path2, (String)"toAbsolutePath(...)");
            } else {
                path = null;
            }
            PackageManagerUtils.Companion.setActiveToolchain(this.project, cMakeProfileInfo, path);
        }
    }

    private static final boolean profileGet$lambda$0(EditVcpkgPackageManagerWindow this$0, VCPKGPackageManager packageManager) {
        return Intrinsics.areEqual((Object)packageManager, (Object)this$0.packageManager);
    }

    private static final Unit createCenterPanel$lambda$0(EditVcpkgPackageManagerWindow this$0, Panel $this$panel) {
        Intrinsics.checkNotNullParameter((Object)$this$panel, (String)"$this$panel");
        $this$panel.row(PackageManagerBundle.INSTANCE.message("vcpkg.add.new.package.manager.field.name", new Object[0]), arg_0 -> EditVcpkgPackageManagerWindow.createCenterPanel$lambda$0$0(this$0, arg_0));
        $this$panel.row(PackageManagerBundle.INSTANCE.message("vcpkg.add.new.package.manager.field.url", new Object[0]), arg_0 -> EditVcpkgPackageManagerWindow.createCenterPanel$lambda$0$1(this$0, arg_0));
        $this$panel.row(PackageManagerBundle.INSTANCE.message("vcpkg.add.new.package.manager.field.local.path", new Object[0]), arg_0 -> EditVcpkgPackageManagerWindow.createCenterPanel$lambda$0$2(this$0, arg_0));
        VcpkgPackageManagerContentUtils.Companion.createProfileTable($this$panel, this$0.project, this$0.profileGet);
        Panel.collapsibleGroup$default((Panel)$this$panel, (String)PackageManagerBundle.INSTANCE.message("vcpkg.edit.package.manager.advanced.settings", new Object[0]), (boolean)false, arg_0 -> EditVcpkgPackageManagerWindow.createCenterPanel$lambda$0$3(this$0, arg_0), (int)2, null);
        return Unit.INSTANCE;
    }

    /*
     * WARNING - void declaration
     */
    private static final Unit createCenterPanel$lambda$0$0(EditVcpkgPackageManagerWindow this$0, Row $this$row) {
        Collection<String> collection;
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        Iterable iterable = this$0.packageManagers;
        AtomicProperty<String> atomicProperty = this$0.name;
        Row row = $this$row;
        VcpkgPackageManagerCommon.Companion companion = VcpkgPackageManagerCommon.Companion;
        boolean $i$f$map = false;
        void var4_7 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            VCPKGPackageManager vCPKGPackageManager = (VCPKGPackageManager)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.getName());
        }
        collection = (List)destination$iv$iv;
        VcpkgPackageManagerCommon.Companion.nameWithBindText$default(companion, row, atomicProperty, collection, null, 4, null);
        return Unit.INSTANCE;
    }

    private static final Unit createCenterPanel$lambda$0$1(EditVcpkgPackageManagerWindow this$0, Row $this$row) {
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        TextFieldKt.bindText((Cell)$this$row.textField(), (ObservableMutableProperty)((ObservableMutableProperty)this$0.urlOfOriginalPackageManager)).align((Align)AlignX.FILL.INSTANCE).applyToComponent(EditVcpkgPackageManagerWindow::createCenterPanel$lambda$0$1$0);
        return Unit.INSTANCE;
    }

    private static final Unit createCenterPanel$lambda$0$1$0(JBTextField $this$applyToComponent) {
        Intrinsics.checkNotNullParameter((Object)$this$applyToComponent, (String)"$this$applyToComponent");
        $this$applyToComponent.setEditable(false);
        return Unit.INSTANCE;
    }

    private static final Unit createCenterPanel$lambda$0$2(EditVcpkgPackageManagerWindow this$0, Row $this$row) {
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        TextFieldKt.bindText((Cell)$this$row.textField(), (ObservableMutableProperty)((ObservableMutableProperty)this$0.localPathToPackageManager)).align((Align)AlignX.FILL.INSTANCE).applyToComponent(EditVcpkgPackageManagerWindow::createCenterPanel$lambda$0$2$0);
        return Unit.INSTANCE;
    }

    private static final Unit createCenterPanel$lambda$0$2$0(JBTextField $this$applyToComponent) {
        Intrinsics.checkNotNullParameter((Object)$this$applyToComponent, (String)"$this$applyToComponent");
        $this$applyToComponent.setEditable(false);
        return Unit.INSTANCE;
    }

    private static final Unit createCenterPanel$lambda$0$3(EditVcpkgPackageManagerWindow this$0, Panel $this$collapsibleGroup) {
        Intrinsics.checkNotNullParameter((Object)$this$collapsibleGroup, (String)"$this$collapsibleGroup");
        Panel.row$default((Panel)$this$collapsibleGroup, null, arg_0 -> EditVcpkgPackageManagerWindow.createCenterPanel$lambda$0$3$0(this$0, arg_0), (int)1, null);
        return Unit.INSTANCE;
    }

    private static final Unit createCenterPanel$lambda$0$3$0(EditVcpkgPackageManagerWindow this$0, Row $this$row) {
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        Cell.comment$default((Cell)ButtonKt.bindSelected((Cell)$this$row.checkBox(PackageManagerBundle.INSTANCE.message("vcpkg.edit.package.manager.force.cmake.ninja.sources.name", new Object[0])), (ObservableMutableProperty)((ObservableMutableProperty)this$0.isForceUseSystemBinaries)), (String)PackageManagerBundle.INSTANCE.message("vcpkg.edit.package.manager.force.cmake.ninja.sources.description", new Object[0]), (int)0, null, (int)6, null);
        return Unit.INSTANCE;
    }
}

