/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.packagemanager.vcpkg;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.process.ProcessNotCreatedException;
import com.intellij.execution.process.ProcessOutput;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ActionsKt;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.observable.properties.AtomicProperty;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.util.io.PathKt;
import com.jetbrains.cidr.packagemanager.bundle.PackageManagerBundle;
import com.jetbrains.cidr.packagemanager.calling.CallEngineStatus;
import com.jetbrains.cidr.packagemanager.calling.CallerEngineBackgroundTask;
import com.jetbrains.cidr.packagemanager.calling.VcpkgExecutionFail;
import com.jetbrains.cidr.packagemanager.commandline.CommandLineProcessListener;
import com.jetbrains.cidr.packagemanager.commandline.GitProgressParser;
import com.jetbrains.cidr.packagemanager.commandline.NumericalRatioProgressParser;
import com.jetbrains.cidr.packagemanager.commandline.PackageProvidesTargetsStateMachine;
import com.jetbrains.cidr.packagemanager.fus.PackageManagerCollector;
import com.jetbrains.cidr.packagemanager.utils.JsonUtils;
import com.jetbrains.cidr.packagemanager.vcpkg.DisplayableDependencyPackage;
import com.jetbrains.cidr.packagemanager.vcpkg.PackageManagerEventListener;
import com.jetbrains.cidr.packagemanager.vcpkg.PackageNameWithTriplet;
import com.jetbrains.cidr.packagemanager.vcpkg.VCPKGDescriptionPackage;
import com.jetbrains.cidr.packagemanager.vcpkg.VCPKGTripletDescriptionPackage;
import com.jetbrains.cidr.packagemanager.vcpkg.VCPKGTripletPackage;
import com.jetbrains.cidr.packagemanager.vcpkg.VCPKGVersion;
import com.jetbrains.cidr.packagemanager.vcpkg.VCPKGVersionWithPort;
import com.jetbrains.cidr.packagemanager.vcpkg.VcpkgPackageManagerKt;
import com.jetbrains.cidr.packagemanager.vcpkg.execution.ProcessCommandLineBuilder;
import com.jetbrains.cidr.packagemanager.vcpkg.execution.ProcessCommandLineType;
import com.jetbrains.cidr.packagemanager.vcpkg.parser.VcpkgOutputParser;
import com.jetbrains.cidr.packagemanager.vcpkg.problemfinder.PackageProblemFinder;
import com.jetbrains.cidr.packagemanager.vcpkg.service.BundledPackageCacheHolder;
import com.jetbrains.cidr.packagemanager.vcpkg.service.TestPropertiesService;
import com.jetbrains.cidr.packagemanager.vcpkg.service.VcpkgExecutorService;
import com.jetbrains.cidr.packagemanager.vcpkg.service.VcpkgProjectSettings;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.ReentrantLock;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.io.CloseableKt;
import kotlin.io.path.PathsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function3;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.MatchGroup;
import kotlin.text.MatchResult;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u00d8\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\r\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0016\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u000e\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u000e\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\u0018\u0000 \u008a\u00012\u00020\u0001:\u0004\u008a\u0001\u008b\u0001B6\u0012\u000b\u0010\u0002\u001a\u00070\u0003\u00a2\u0006\u0002\b\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\b\b\u0002\u0010\u0007\u001a\u00020\u0003\u0012\u000e\b\u0002\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t\u00a2\u0006\u0004\b\u000b\u0010\fJ\"\u0010\u001d\u001a\u00020\n2\u0006\u0010\u001e\u001a\u00020\u00192\u0006\u0010\u001f\u001a\u00020\u00192\b\b\u0002\u0010 \u001a\u00020\nH\u0002J\f\u0010J\u001a\u00020K*\u00020KH\u0002J*\u0010L\u001a\b\u0012\u0004\u0012\u00020N0M2\u0006\u0010O\u001a\u00020K2\u0012\u0010P\u001a\u000e\u0012\u0004\u0012\u00020K\u0012\u0004\u0012\u00020N0QH\u0002J\u0006\u0010R\u001a\u00020SJ\u000e\u0010T\u001a\b\u0012\u0004\u0012\u00020U06H\u0002J\"\u0010A\u001a\b\u0012\u0004\u0012\u00020S0M2\u0012\u0010P\u001a\u000e\u0012\u0004\u0012\u00020K\u0012\u0004\u0012\u00020N0QH\u0002J(\u0010V\u001a\b\u0012\u0004\u0012\u00020S0M2\u0006\u0010W\u001a\u00020X2\u0012\u0010P\u001a\u000e\u0012\u0004\u0012\u00020K\u0012\u0004\u0012\u00020N0QJ0\u0010Y\u001a\b\u0012\u0004\u0012\u00020S0M2\u0006\u0010W\u001a\u00020X2\u0012\u0010P\u001a\u000e\u0012\u0004\u0012\u00020K\u0012\u0004\u0012\u00020N0Q2\u0006\u0010Z\u001a\u00020[JC\u0010\\\u001a\b\u0012\u0004\u0012\u0002H]06\"\u0004\b\u0000\u0010]2\u0006\u0010^\u001a\u00020\u00032%\u0010_\u001a!\u0012\u0004\u0012\u00020a\u0012\t\u0012\u00070\u0003\u00a2\u0006\u0002\b\u0004\u0012\u0006\u0012\u0004\u0018\u00010;\u0012\u0004\u0012\u0002H]0`H\u0002J\u0016\u0010b\u001a\b\u0012\u0004\u0012\u000207062\u0006\u0010^\u001a\u00020\u0003H\u0002J\u0016\u0010c\u001a\b\u0012\u0004\u0012\u00020>062\u0006\u0010^\u001a\u00020\u0003H\u0002J\u001c\u0010d\u001a\b\u0012\u0004\u0012\u00020>062\f\u0010e\u001a\b\u0012\u0004\u0012\u00020\u000306H\u0002J*\u0010f\u001a\b\u0012\u0004\u0012\u00020\n0M2\b\u0010g\u001a\u0004\u0018\u00010[2\u0012\u0010P\u001a\u000e\u0012\u0004\u0012\u00020K\u0012\u0004\u0012\u00020N0QJ\u000e\u0010h\u001a\b\u0012\u0004\u0012\u00020S0MH\u0007J,\u0010i\u001a\b\u0012\u0004\u0012\u00020\n0M2\b\u0010g\u001a\u0004\u0018\u00010[2\u0012\u0010P\u001a\u000e\u0012\u0004\u0012\u00020K\u0012\u0004\u0012\u00020N0QH\u0002J,\u0010j\u001a\b\u0012\u0004\u0012\u00020\n0M2\b\u0010g\u001a\u0004\u0018\u00010[2\u0012\u0010P\u001a\u000e\u0012\u0004\u0012\u00020K\u0012\u0004\u0012\u00020N0QH\u0002J \u0010k\u001a\b\u0012\u0004\u0012\u00020\u00030M2\u0012\u0010P\u001a\u000e\u0012\u0004\u0012\u00020K\u0012\u0004\u0012\u00020N0QJ&\u0010l\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u000207060M2\u0012\u0010P\u001a\u000e\u0012\u0004\u0012\u00020K\u0012\u0004\u0012\u00020N0QJ&\u0010m\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020>060M2\u0012\u0010P\u001a\u000e\u0012\u0004\u0012\u00020K\u0012\u0004\u0012\u00020N0QJ\u0012\u0010n\u001a\u0004\u0018\u00010\u00032\u0006\u0010o\u001a\u00020pH\u0002J\u0010\u0010q\u001a\u00020\u00032\u0006\u0010o\u001a\u00020pH\u0002J\u001c\u0010r\u001a\b\u0012\u0004\u0012\u00020\u0003062\f\u0010s\u001a\b\u0012\u0004\u0012\u00020p06H\u0002Ji\u0010t\u001a\u001f\u0012\u001b\u0012\u0019\u0012\n\u0012\b\u0012\u0004\u0012\u00020206\u0012\t\u0012\u00070\u0003\u00a2\u0006\u0002\b\u0004010M2\f\u0010s\u001a\b\u0012\u0004\u0012\u00020p062\u0006\u0010g\u001a\u00020[2\u0010\b\u0002\u0010u\u001a\n\u0012\u0004\u0012\u00020\u0003\u0018\u0001062\b\u0010v\u001a\u0004\u0018\u00010\u00032\u0012\u0010P\u001a\u000e\u0012\u0004\u0012\u00020K\u0012\u0004\u0012\u00020N0QJ<\u0010w\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020x060M2\f\u0010s\u001a\b\u0012\u0004\u0012\u00020p062\u0006\u0010y\u001a\u00020\n2\u0012\u0010P\u001a\u000e\u0012\u0004\u0012\u00020K\u0012\u0004\u0012\u00020N0QJ>\u0010z\u001a&\u0012\"\u0012 \u0012\u001c\u0012\u001a\u0012\u0004\u0012\u00020x\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020;\u0012\u0004\u0012\u00020;0101060M2\u0012\u0010P\u001a\u000e\u0012\u0004\u0012\u00020K\u0012\u0004\u0012\u00020N0QJ6\u0010{\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u000202060M2\f\u0010|\u001a\b\u0012\u0004\u0012\u00020\u0003062\u0012\u0010P\u001a\u000e\u0012\u0004\u0012\u00020K\u0012\u0004\u0012\u00020N0QH\u0002J4\u0010}\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u000202060M2\f\u0010s\u001a\b\u0012\u0004\u0012\u00020p062\u0012\u0010P\u001a\u000e\u0012\u0004\u0012\u00020K\u0012\u0004\u0012\u00020N0QJ&\u0010~\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u000202060M2\u0012\u0010P\u001a\u000e\u0012\u0004\u0012\u00020K\u0012\u0004\u0012\u00020N0QJ*\u0010\u007f\u001a\b\u0012\u0004\u0012\u00020S0M2\b\u0010g\u001a\u0004\u0018\u00010[2\u0012\u0010P\u001a\u000e\u0012\u0004\u0012\u00020K\u0012\u0004\u0012\u00020N0QJ/\u0010\u0080\u0001\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u0003060M2\u0006\u0010o\u001a\u00020p2\u0012\u0010P\u001a\u000e\u0012\u0004\u0012\u00020K\u0012\u0004\u0012\u00020N0QJG\u0010\u0081\u0001\u001a\u0010\u0012\f\u0012\n\u0012\u0006\u0012\u0004\u0018\u00010p060M2\b\u0010g\u001a\u0004\u0018\u00010[2\u0012\u0010\u0082\u0001\u001a\r\u0012\t\u0012\u00070\u0003\u00a2\u0006\u0002\b\u0004062\u0012\u0010P\u001a\u000e\u0012\u0004\u0012\u00020K\u0012\u0004\u0012\u00020N0QJ\u001e\u0010\u0083\u0001\u001a\b\u0012\u0004\u0012\u00020S0M2\u0006\u0010g\u001a\u00020[2\u0007\u0010\u0084\u0001\u001a\u00020\nJ\u0016\u0010\u0085\u0001\u001a\u00020\n2\n\u0010\u0086\u0001\u001a\u0005\u0018\u00010\u0087\u0001H\u0096\u0002J\n\u0010\u0088\u0001\u001a\u00030\u0089\u0001H\u0016R\u001f\u0010\u0002\u001a\u00070\u0003\u00a2\u0006\u0002\b\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\r\u0010\u000e\"\u0004\b\u000f\u0010\u0010R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0011\u0010\u0007\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u000eR \u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\b\u0010\u0014\"\u0004\b\u0015\u0010\u0016R\u001f\u0010\u0017\u001a\u0010\u0012\f\u0012\n \u001a*\u0004\u0018\u00010\u00190\u00190\u0018\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u001cR\u001e\u0010!\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00030\t8\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\"\u0010\u0014R&\u0010#\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00030\t8\u0006@\u0006X\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b$\u0010\u0014\"\u0004\b%\u0010\u0016R&\u0010&\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00030\t8\u0006@\u0006X\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b'\u0010\u0014\"\u0004\b(\u0010\u0016R&\u0010)\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00030\t8\u0006@\u0006X\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b*\u0010\u0014\"\u0004\b+\u0010\u0016R&\u0010,\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00030\t8\u0006@\u0006X\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b-\u0010\u0014\"\u0004\b.\u0010\u0016RU\u0010/\u001a=\u00129\u00127\u0012\t\u0012\u00070\u0003\u00a2\u0006\u0002\b\u0004\u0012&\u0012$\u0012\u0015\u0012\u0013\u0012\t\u0012\u00070\u0003\u00a2\u0006\u0002\b\u0004\u0012\u0004\u0012\u00020200\u0012\t\u0012\u00070\u0003\u00a2\u0006\u0002\b\u000401\u0018\u0001000\tX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b3\u0010\u0014\"\u0004\b4\u0010\u0016R\u001f\u00105\u001a\u0010\u0012\f\u0012\n\u0012\u0004\u0012\u000207\u0018\u0001060\t\u00a2\u0006\b\n\u0000\u001a\u0004\b8\u0010\u0014RA\u00109\u001a2\u0012.\u0012,\u0012\u0004\u0012\u00020\u0003\u0012 \u0012\u001e\u0012\u0004\u0012\u00020\u0003\u0012\u0014\u0012\u0012\u0012\u0006\u0012\u0004\u0018\u00010;\u0012\u0006\u0012\u0004\u0018\u00010;010:\u0018\u00010:0\t\u00a2\u0006\b\n\u0000\u001a\u0004\b<\u0010\u0014R\u001f\u0010=\u001a\u0010\u0012\f\u0012\n\u0012\u0004\u0012\u00020>\u0018\u0001060\t\u00a2\u0006\b\n\u0000\u001a\u0004\b?\u0010\u0014R(\u0010@\u001a\u0010\u0012\f\u0012\n\u0012\u0004\u0012\u00020\u0003\u0018\u0001060\tX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bA\u0010\u0014\"\u0004\bB\u0010\u0016R\u0019\u0010C\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010D0\t\u00a2\u0006\b\n\u0000\u001a\u0004\bE\u0010\u0014R\u000e\u0010F\u001a\u00020GX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010H\u001a\b\u0012\u0004\u0012\u00020I0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u008c\u0001"}, d2={"Lcom/jetbrains/cidr/packagemanager/vcpkg/VCPKGPackageManager;", "Lcom/intellij/openapi/Disposable$Default;", "name", "", "Lorg/jetbrains/annotations/Nls;", "path", "Ljava/nio/file/Path;", "baseUrl", "isForcedBundledNinjaCMake", "Lcom/intellij/openapi/observable/properties/AtomicProperty;", "", "<init>", "(Ljava/lang/String;Ljava/nio/file/Path;Ljava/lang/String;Lcom/intellij/openapi/observable/properties/AtomicProperty;)V", "getName", "()Ljava/lang/String;", "setName", "(Ljava/lang/String;)V", "getPath", "()Ljava/nio/file/Path;", "getBaseUrl", "()Lcom/intellij/openapi/observable/properties/AtomicProperty;", "setForcedBundledNinjaCMake", "(Lcom/intellij/openapi/observable/properties/AtomicProperty;)V", "state", "Ljava/util/concurrent/atomic/AtomicReference;", "Lcom/jetbrains/cidr/packagemanager/vcpkg/VCPKGPackageManager$VcpkgPackageManagerState;", "kotlin.jvm.PlatformType", "getState", "()Ljava/util/concurrent/atomic/AtomicReference;", "compareAndSetState", "previous", "next", "isThrowOnFalse", "downloadsRoot", "getDownloadsRoot", "buildtreesRoot", "getBuildtreesRoot", "setBuildtreesRoot", "installRoot", "getInstallRoot", "setInstallRoot", "packagesRoot", "getPackagesRoot", "setPackagesRoot", "binarySource", "getBinarySource", "setBinarySource", "installedPackages", "", "Lkotlin/Pair;", "Lcom/jetbrains/cidr/packagemanager/vcpkg/VCPKGTripletPackage;", "getInstalledPackages", "setInstalledPackages", "installedPackagesList", "", "Lcom/jetbrains/cidr/packagemanager/vcpkg/VCPKGTripletDescriptionPackage;", "getInstalledPackagesList", "upgradable", "", "Lcom/jetbrains/cidr/packagemanager/vcpkg/VCPKGVersionWithPort;", "getUpgradable", "packages", "Lcom/jetbrains/cidr/packagemanager/vcpkg/VCPKGDescriptionPackage;", "getPackages", "triplets", "getTriplets", "setTriplets", "problemFinder", "Lcom/jetbrains/cidr/packagemanager/vcpkg/problemfinder/PackageProblemFinder;", "getProblemFinder", "processLock", "Ljava/util/concurrent/locks/ReentrantLock;", "executionId", "", "addAdditionalVcpkgParameters", "Lcom/jetbrains/cidr/packagemanager/vcpkg/execution/ProcessCommandLineBuilder;", "runCommandLineProcess", "Lcom/jetbrains/cidr/packagemanager/calling/CallEngineStatus;", "Lcom/intellij/execution/process/ProcessOutput;", "processCommandLineBuilder", "runner", "Lkotlin/Function1;", "reloadProblemFinder", "", "parsePackagesCache", "Lcom/jetbrains/cidr/packagemanager/vcpkg/problemfinder/PackageProblemFinder$PackageManagerTriggerHint;", "start", "project", "Lcom/intellij/openapi/project/Project;", "safeStartWithInstall", "progressIndicator", "Lcom/intellij/openapi/progress/ProgressIndicator;", "parsePackagesJson", "T", "s", "convertFromNodeNameAndVersion", "Lkotlin/Function3;", "Lcom/fasterxml/jackson/databind/JsonNode;", "parseInstalledPackagesJson", "parseFullPackages", "parsePackages", "rows", "checkForUpdate", "indicator", "testInstall", "gitCloneRepository", "bootstrapManager", "getBuiltinBaseline", "installedList", "allPackages", "getTriplet", "pkg", "Lcom/jetbrains/cidr/packagemanager/vcpkg/DisplayableDependencyPackage;", "convertPackageToString", "convertPackagesToList", "pkgs", "installPackage", "additionalArguments", "forceDefaultTriplet", "removePackage", "Lcom/jetbrains/cidr/packagemanager/vcpkg/PackageNameWithTriplet;", "recursive", "updateManager", "abstractUpgradePackages", "parameters", "upgradePackages", "upgradeManager", "updateGitRepository", "getDependencies", "getPackagesByNames", "names", "safeRemove", "isRemoveFiles", "equals", "other", "", "hashCode", "", "Companion", "VcpkgPackageManagerState", "intellij.clion.packageManager"})
@SourceDebugExtension(value={"SMAP\nVcpkgPackageManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 VcpkgPackageManager.kt\ncom/jetbrains/cidr/packagemanager/vcpkg/VCPKGPackageManager\n+ 2 KtUtils.kt\ncom/intellij/util/KotlinUtils\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 5 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n*L\n1#1,678:1\n52#2:679\n52#2:680\n52#2:681\n52#2:682\n52#2:683\n52#2:684\n52#2:685\n1#3:686\n1#3:707\n1#3:766\n1#3:786\n1563#4:687\n1634#4,3:688\n1869#4,2:691\n1617#4,9:693\n1869#4:702\n1563#4:703\n1634#4,3:704\n1870#4:708\n1626#4:709\n1056#4:710\n1563#4:711\n1634#4,3:712\n1878#4,3:715\n774#4:718\n865#4,2:719\n1563#4:721\n1634#4,3:722\n1491#4:725\n1516#4,3:726\n1519#4,3:736\n1563#4:739\n1634#4,2:740\n1491#4:742\n1516#4,3:743\n1519#4,3:753\n1617#4,9:756\n1869#4:765\n1870#4:767\n1626#4:768\n1193#4,2:769\n1267#4,4:771\n1636#4:775\n1617#4,9:776\n1869#4:785\n1870#4:787\n1626#4:788\n1193#4,2:789\n1267#4,4:791\n774#4:795\n865#4,2:796\n1869#4,2:798\n1869#4,2:800\n774#4:802\n865#4,2:803\n295#4,2:805\n295#4,2:807\n382#5,7:729\n382#5,7:746\n*S KotlinDebug\n*F\n+ 1 VcpkgPackageManager.kt\ncom/jetbrains/cidr/packagemanager/vcpkg/VCPKGPackageManager\n*L\n114#1:679\n115#1:680\n116#1:681\n117#1:682\n118#1:683\n119#1:684\n134#1:685\n308#1:707\n416#1:766\n421#1:786\n267#1:687\n267#1:688,3\n300#1:691,2\n308#1:693,9\n308#1:702\n309#1:703\n309#1:704,3\n308#1:708\n308#1:709\n324#1:710\n461#1:711\n461#1:712,3\n615#1:715,3\n193#1:718\n193#1:719,2\n193#1:721\n193#1:722,3\n410#1:725\n410#1:726,3\n410#1:736,3\n410#1:739\n410#1:740,2\n414#1:742\n414#1:743,3\n414#1:753,3\n416#1:756,9\n416#1:765\n416#1:767\n416#1:768\n417#1:769,2\n417#1:771,4\n410#1:775\n421#1:776,9\n421#1:785\n421#1:787\n421#1:788\n422#1:789,2\n422#1:791,4\n442#1:795\n442#1:796,2\n499#1:798,2\n523#1:800,2\n629#1:802\n629#1:803,2\n630#1:805,2\n633#1:807,2\n410#1:729,7\n414#1:746,7\n*E\n"})
public final class VCPKGPackageManager
implements Disposable.Default {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private String name;
    @NotNull
    private final Path path;
    @NotNull
    private final String baseUrl;
    @NotNull
    private AtomicProperty<Boolean> isForcedBundledNinjaCMake;
    @NotNull
    private final AtomicReference<VcpkgPackageManagerState> state;
    @TestOnly
    @NotNull
    private final AtomicProperty<String> downloadsRoot;
    @TestOnly
    @NotNull
    private AtomicProperty<String> buildtreesRoot;
    @TestOnly
    @NotNull
    private AtomicProperty<String> installRoot;
    @TestOnly
    @NotNull
    private AtomicProperty<String> packagesRoot;
    @TestOnly
    @NotNull
    private AtomicProperty<String> binarySource;
    @NotNull
    private AtomicProperty<Map<String, Pair<Map<String, VCPKGTripletPackage>, String>>> installedPackages;
    @NotNull
    private final AtomicProperty<List<VCPKGTripletDescriptionPackage>> installedPackagesList;
    @NotNull
    private final AtomicProperty<Map<String, Map<String, Pair<VCPKGVersionWithPort, VCPKGVersionWithPort>>>> upgradable;
    @NotNull
    private final AtomicProperty<List<VCPKGDescriptionPackage>> packages;
    @NotNull
    private AtomicProperty<List<String>> triplets;
    @NotNull
    private final AtomicProperty<PackageProblemFinder> problemFinder;
    @NotNull
    private final ReentrantLock processLock;
    @NotNull
    private final AtomicProperty<Long> executionId;
    @NotNull
    private static final Regex DEPENDENCY_LINE_PATTERN = new Regex("\\(\\d+\\)([^:]+):.*");

    public VCPKGPackageManager(@NotNull String name, @NotNull Path path, @NotNull String baseUrl, @NotNull AtomicProperty<Boolean> isForcedBundledNinjaCMake) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        Intrinsics.checkNotNullParameter((Object)baseUrl, (String)"baseUrl");
        Intrinsics.checkNotNullParameter(isForcedBundledNinjaCMake, (String)"isForcedBundledNinjaCMake");
        this.name = name;
        this.path = path;
        this.baseUrl = baseUrl;
        this.isForcedBundledNinjaCMake = isForcedBundledNinjaCMake;
        this.state = new AtomicReference<VcpkgPackageManagerState>(VcpkgPackageManagerState.NOT_INITIALIZED);
        this.downloadsRoot = new AtomicProperty(null);
        this.buildtreesRoot = new AtomicProperty(null);
        this.installRoot = new AtomicProperty(null);
        this.packagesRoot = new AtomicProperty(null);
        this.binarySource = new AtomicProperty(null);
        this.installedPackages = new AtomicProperty(null);
        this.installedPackagesList = new AtomicProperty(null);
        this.upgradable = new AtomicProperty(null);
        this.packages = new AtomicProperty(null);
        this.triplets = new AtomicProperty(null);
        this.problemFinder = new AtomicProperty(null);
        this.processLock = new ReentrantLock();
        this.executionId = new AtomicProperty((Object)0L);
    }

    public /* synthetic */ VCPKGPackageManager(String string, Path path, String string2, AtomicProperty atomicProperty, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            string2 = "https://github.com/microsoft/vcpkg";
        }
        if ((n & 8) != 0) {
            atomicProperty = new AtomicProperty((Object)false);
        }
        this(string, path, string2, (AtomicProperty<Boolean>)atomicProperty);
    }

    @NotNull
    public final String getName() {
        return this.name;
    }

    public final void setName(@NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
        this.name = string;
    }

    @NotNull
    public final Path getPath() {
        return this.path;
    }

    @NotNull
    public final String getBaseUrl() {
        return this.baseUrl;
    }

    @NotNull
    public final AtomicProperty<Boolean> isForcedBundledNinjaCMake() {
        return this.isForcedBundledNinjaCMake;
    }

    public final void setForcedBundledNinjaCMake(@NotNull AtomicProperty<Boolean> atomicProperty) {
        Intrinsics.checkNotNullParameter(atomicProperty, (String)"<set-?>");
        this.isForcedBundledNinjaCMake = atomicProperty;
    }

    @NotNull
    public final AtomicReference<VcpkgPackageManagerState> getState() {
        return this.state;
    }

    private final boolean compareAndSetState(VcpkgPackageManagerState previous, VcpkgPackageManagerState next, boolean isThrowOnFalse) {
        if (this.state.compareAndSet(previous, next)) {
            VcpkgPackageManagerKt.getLogger().info("Change state of package manager " + this.name + ": " + previous + " -> " + next);
            ((PackageManagerEventListener)ApplicationManager.getApplication().getMessageBus().syncPublisher(PackageManagerEventListener.Companion.getTOPIC())).onPackageManagerChangeState(this);
            return true;
        }
        if (isThrowOnFalse) {
            VcpkgPackageManagerKt.getLogger().error("Can't change package manager state. Expected atomic operation: " + previous + " -> " + next + ". Found state: " + (Object)((Object)this.state.get()));
        }
        return false;
    }

    static /* synthetic */ boolean compareAndSetState$default(VCPKGPackageManager vCPKGPackageManager, VcpkgPackageManagerState vcpkgPackageManagerState, VcpkgPackageManagerState vcpkgPackageManagerState2, boolean bl, int n, Object object) {
        if ((n & 4) != 0) {
            bl = false;
        }
        return vCPKGPackageManager.compareAndSetState(vcpkgPackageManagerState, vcpkgPackageManagerState2, bl);
    }

    @NotNull
    public final AtomicProperty<String> getDownloadsRoot() {
        return this.downloadsRoot;
    }

    @NotNull
    public final AtomicProperty<String> getBuildtreesRoot() {
        return this.buildtreesRoot;
    }

    public final void setBuildtreesRoot(@NotNull AtomicProperty<String> atomicProperty) {
        Intrinsics.checkNotNullParameter(atomicProperty, (String)"<set-?>");
        this.buildtreesRoot = atomicProperty;
    }

    @NotNull
    public final AtomicProperty<String> getInstallRoot() {
        return this.installRoot;
    }

    public final void setInstallRoot(@NotNull AtomicProperty<String> atomicProperty) {
        Intrinsics.checkNotNullParameter(atomicProperty, (String)"<set-?>");
        this.installRoot = atomicProperty;
    }

    @NotNull
    public final AtomicProperty<String> getPackagesRoot() {
        return this.packagesRoot;
    }

    public final void setPackagesRoot(@NotNull AtomicProperty<String> atomicProperty) {
        Intrinsics.checkNotNullParameter(atomicProperty, (String)"<set-?>");
        this.packagesRoot = atomicProperty;
    }

    @NotNull
    public final AtomicProperty<String> getBinarySource() {
        return this.binarySource;
    }

    public final void setBinarySource(@NotNull AtomicProperty<String> atomicProperty) {
        Intrinsics.checkNotNullParameter(atomicProperty, (String)"<set-?>");
        this.binarySource = atomicProperty;
    }

    @NotNull
    public final AtomicProperty<Map<String, Pair<Map<String, VCPKGTripletPackage>, String>>> getInstalledPackages() {
        return this.installedPackages;
    }

    public final void setInstalledPackages(@NotNull AtomicProperty<Map<String, Pair<Map<String, VCPKGTripletPackage>, String>>> atomicProperty) {
        Intrinsics.checkNotNullParameter(atomicProperty, (String)"<set-?>");
        this.installedPackages = atomicProperty;
    }

    @NotNull
    public final AtomicProperty<List<VCPKGTripletDescriptionPackage>> getInstalledPackagesList() {
        return this.installedPackagesList;
    }

    @NotNull
    public final AtomicProperty<Map<String, Map<String, Pair<VCPKGVersionWithPort, VCPKGVersionWithPort>>>> getUpgradable() {
        return this.upgradable;
    }

    @NotNull
    public final AtomicProperty<List<VCPKGDescriptionPackage>> getPackages() {
        return this.packages;
    }

    @NotNull
    public final AtomicProperty<List<String>> getTriplets() {
        return this.triplets;
    }

    public final void setTriplets(@NotNull AtomicProperty<List<String>> atomicProperty) {
        Intrinsics.checkNotNullParameter(atomicProperty, (String)"<set-?>");
        this.triplets = atomicProperty;
    }

    @NotNull
    public final AtomicProperty<PackageProblemFinder> getProblemFinder() {
        return this.problemFinder;
    }

    /*
     * WARNING - void declaration
     */
    private final ProcessCommandLineBuilder addAdditionalVcpkgParameters(ProcessCommandLineBuilder $this$addAdditionalVcpkgParameters) {
        ProcessCommandLineBuilder processCommandLineBuilder;
        ProcessCommandLineBuilder processCommandLineBuilder2;
        ProcessCommandLineBuilder processCommandLineBuilder3;
        ProcessCommandLineBuilder processCommandLineBuilder4;
        ProcessCommandLineBuilder processCommandLineBuilder5;
        ProcessCommandLineBuilder processCommandLineBuilder6;
        String[] stringArray;
        void $this$applyIf$iv;
        ProcessCommandLineBuilder processCommandLineBuilder7 = $this$addAdditionalVcpkgParameters;
        boolean condition$iv = this.downloadsRoot.get() != null;
        boolean $i$f$applyIf = false;
        if (condition$iv) {
            void $this$addAdditionalVcpkgParameters_u24lambda_u240 = $this$applyIf$iv;
            boolean bl = false;
            stringArray = new String[]{"--downloads-root=" + this.downloadsRoot.get()};
            processCommandLineBuilder6 = $this$addAdditionalVcpkgParameters_u24lambda_u240.withAdditionalParameters(stringArray);
        } else {
            processCommandLineBuilder6 = $this$applyIf$iv;
        }
        $this$applyIf$iv = processCommandLineBuilder6;
        condition$iv = this.buildtreesRoot.get() != null;
        $i$f$applyIf = false;
        if (condition$iv) {
            void $this$addAdditionalVcpkgParameters_u24lambda_u241 = $this$applyIf$iv;
            boolean bl = false;
            stringArray = new String[]{"--x-buildtrees-root=" + this.buildtreesRoot.get()};
            processCommandLineBuilder5 = $this$addAdditionalVcpkgParameters_u24lambda_u241.withAdditionalParameters(stringArray);
        } else {
            processCommandLineBuilder5 = $this$applyIf$iv;
        }
        $this$applyIf$iv = processCommandLineBuilder5;
        condition$iv = this.installRoot.get() != null;
        $i$f$applyIf = false;
        if (condition$iv) {
            void $this$addAdditionalVcpkgParameters_u24lambda_u242 = $this$applyIf$iv;
            boolean bl = false;
            stringArray = new String[]{"--x-install-root=" + this.installRoot.get()};
            processCommandLineBuilder4 = $this$addAdditionalVcpkgParameters_u24lambda_u242.withAdditionalParameters(stringArray);
        } else {
            processCommandLineBuilder4 = $this$applyIf$iv;
        }
        $this$applyIf$iv = processCommandLineBuilder4;
        condition$iv = this.packagesRoot.get() != null;
        $i$f$applyIf = false;
        if (condition$iv) {
            void $this$addAdditionalVcpkgParameters_u24lambda_u243 = $this$applyIf$iv;
            boolean bl = false;
            stringArray = new String[]{"--x-packages-root=" + this.packagesRoot.get()};
            processCommandLineBuilder3 = $this$addAdditionalVcpkgParameters_u24lambda_u243.withAdditionalParameters(stringArray);
        } else {
            processCommandLineBuilder3 = $this$applyIf$iv;
        }
        $this$applyIf$iv = processCommandLineBuilder3;
        condition$iv = this.binarySource.get() != null;
        $i$f$applyIf = false;
        if (condition$iv) {
            void $this$addAdditionalVcpkgParameters_u24lambda_u244 = $this$applyIf$iv;
            boolean bl = false;
            stringArray = new String[]{"--binarysource=" + this.binarySource.get()};
            processCommandLineBuilder2 = $this$addAdditionalVcpkgParameters_u24lambda_u244.withAdditionalParameters(stringArray);
        } else {
            processCommandLineBuilder2 = $this$applyIf$iv;
        }
        $this$applyIf$iv = processCommandLineBuilder2;
        condition$iv = (Boolean)this.isForcedBundledNinjaCMake.get();
        $i$f$applyIf = false;
        if (condition$iv) {
            void $this$addAdditionalVcpkgParameters_u24lambda_u245 = $this$applyIf$iv;
            boolean bl = false;
            processCommandLineBuilder = $this$addAdditionalVcpkgParameters_u24lambda_u245.withForcedCMakeNinja(true);
        } else {
            processCommandLineBuilder = processCommandLineBuilder7;
        }
        return processCommandLineBuilder;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private final CallEngineStatus<ProcessOutput> runCommandLineProcess(ProcessCommandLineBuilder processCommandLineBuilder, Function1<? super ProcessCommandLineBuilder, ? extends ProcessOutput> runner) {
        CallEngineStatus callEngineStatus;
        ProcessOutput processOutput;
        Object[] objectArray;
        long localExecutionId;
        block12: {
            ProcessCommandLineBuilder processCommandLineBuilder2;
            localExecutionId = ((Number)this.executionId.updateAndGet(VCPKGPackageManager::runCommandLineProcess$lambda$0)).longValue();
            ProcessCommandLineBuilder processCommandLineBuilder3 = processCommandLineBuilder;
            boolean condition$iv = processCommandLineBuilder.getCommandLineType() == ProcessCommandLineType.VCPKG;
            boolean $i$f$applyIf = false;
            if (condition$iv) {
                void $this$runCommandLineProcess_u24lambda_u241 = $this$applyIf$iv;
                boolean bl = false;
                processCommandLineBuilder2 = this.addAdditionalVcpkgParameters((ProcessCommandLineBuilder)$this$runCommandLineProcess_u24lambda_u241);
            } else {
                processCommandLineBuilder2 = $this$applyIf$iv;
            }
            ProcessCommandLineBuilder runnedBuilder = processCommandLineBuilder2.withExecutionId(localExecutionId);
            objectArray = (Object[])this.processLock;
            objectArray.lock();
            try {
                ProcessOutput processOutput2;
                boolean bl = false;
                try {
                    processOutput2 = (ProcessOutput)runner.invoke((Object)runnedBuilder);
                }
                catch (ProcessNotCreatedException e) {
                    Object[] objectArray2 = new Object[]{((Object)this.path).toString()};
                    CallEngineStatus<ProcessOutput> callEngineStatus2 = new CallEngineStatus<ProcessOutput>(null, new VcpkgExecutionFail(PackageManagerBundle.INSTANCE.message("vcpkg.return.status.process.failed", objectArray2), null), localExecutionId, 1, null);
                    objectArray.unlock();
                    return callEngineStatus2;
                }
                catch (ExecutionException e) {
                    Object[] objectArray3 = new Object[]{((Object)this.path).toString()};
                    CallEngineStatus<ProcessOutput> callEngineStatus3 = new CallEngineStatus<ProcessOutput>(null, new VcpkgExecutionFail(PackageManagerBundle.INSTANCE.message("vcpkg.return.status.failed.on.execution", objectArray3), null), localExecutionId, 1, null);
                    objectArray.unlock();
                    return callEngineStatus3;
                }
                processOutput = processOutput2;
                break block12;
                {
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                }
            }
            finally {
                objectArray.unlock();
            }
        }
        ProcessOutput result = processOutput;
        if (result.getExitCode() != 0) {
            objectArray = new Object[]{result.getExitCode()};
            CallEngineStatus callEngineStatus4 = new CallEngineStatus(null, new VcpkgExecutionFail(PackageManagerBundle.INSTANCE.message("vcpkg.return.status.exit.code.is", objectArray), result.getStdout()), localExecutionId, 1, null);
            callEngineStatus = callEngineStatus4;
        } else {
            callEngineStatus = new CallEngineStatus(result, null, localExecutionId, 2, null);
        }
        return callEngineStatus;
    }

    public final void reloadProblemFinder() {
        this.problemFinder.set((Object)new PackageProblemFinder(this.parsePackagesCache()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final List<PackageProblemFinder.PackageManagerTriggerHint> parsePackagesCache() {
        Path cacheFile = this.path.resolve(".clion").resolve("cache.json");
        Intrinsics.checkNotNull((Object)cacheFile);
        if (Files.isReadable(cacheFile)) {
            try {
                List<PackageProblemFinder.PackageManagerTriggerHint> list;
                OpenOption[] openOptionArray = new OpenOption[]{};
                InputStream inputStream = Files.newInputStream(cacheFile, Arrays.copyOf(openOptionArray, openOptionArray.length));
                Intrinsics.checkNotNullExpressionValue((Object)inputStream, (String)"newInputStream(...)");
                Closeable closeable = inputStream;
                Throwable throwable = null;
                try {
                    InputStream it = (InputStream)closeable;
                    boolean bl = false;
                    list = PackageProblemFinder.Companion.createTriggerHintList(it);
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
                }
                return list;
            }
            catch (IOException e) {
                VcpkgPackageManagerKt.getLogger().warn("Mock cache was found for vcpkg, but failed when reading it", (Throwable)e);
            }
        }
        return BundledPackageCacheHolder.Companion.getInstance().getPackagesCache();
    }

    private final CallEngineStatus<Unit> getTriplets(Function1<? super ProcessCommandLineBuilder, ? extends ProcessOutput> runner) {
        Object[] objectArray = new String[]{"help", "triplet"};
        return this.runCommandLineProcess(new ProcessCommandLineBuilder(ProcessCommandLineType.VCPKG, this.path.toFile(), CollectionsKt.listOf((Object[])objectArray), null, null, null, false, null, 248, null), runner).withTransformResult(arg_0 -> VCPKGPackageManager.getTriplets$lambda$0(this, arg_0));
    }

    @NotNull
    public final CallEngineStatus<Unit> start(@NotNull Project project, @NotNull Function1<? super ProcessCommandLineBuilder, ? extends ProcessOutput> runner) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter(runner, (String)"runner");
        if (!VCPKGPackageManager.compareAndSetState$default(this, VcpkgPackageManagerState.NOT_INITIALIZED, VcpkgPackageManagerState.START_INITIALIZE, false, 4, null)) {
            return new CallEngineStatus<Unit>(Unit.INSTANCE, null, null, 6, null);
        }
        LinkOption[] linkOptionArray = new LinkOption[]{};
        if (Files.exists(this.path, Arrays.copyOf(linkOptionArray, linkOptionArray.length))) {
            LinkOption[] linkOptionArray2 = new LinkOption[]{};
            if (Files.isDirectory(this.path, Arrays.copyOf(linkOptionArray2, linkOptionArray2.length))) {
                CallEngineStatus isRunSuccess = this.getTriplets(runner).withTransformResult(arg_0 -> VCPKGPackageManager.start$lambda$0(this, arg_0));
                if (Intrinsics.areEqual(isRunSuccess.getResult(), (Object)true)) {
                    this.compareAndSetState(VcpkgPackageManagerState.START_INITIALIZE, VcpkgPackageManagerState.INITIALIZED, true);
                    if (VcpkgProjectSettings.Companion.getInstance(project).isAutomaticCheckingOnLaunch()) {
                        ActionsKt.invokeLater$default(null, () -> VCPKGPackageManager.start$lambda$1(project, this), (int)1, null);
                    }
                    return new CallEngineStatus<Unit>(Unit.INSTANCE, null, null, 6, null);
                }
                this.compareAndSetState(VcpkgPackageManagerState.START_INITIALIZE, VcpkgPackageManagerState.BROKEN, true);
                Object[] objectArray = new Object[]{((Object)this.path).toString()};
                return new CallEngineStatus<Unit>(null, new VcpkgExecutionFail(PackageManagerBundle.INSTANCE.message("vcpkg.toolwindow.task.start.check.folder.is.not.empty", objectArray), null), null, 5, null);
            }
        }
        this.compareAndSetState(VcpkgPackageManagerState.START_INITIALIZE, VcpkgPackageManagerState.BROKEN, true);
        Object[] objectArray = new Object[]{((Object)this.path).toString()};
        return new CallEngineStatus<Unit>(null, new VcpkgExecutionFail(PackageManagerBundle.INSTANCE.message("vcpkg.toolwindow.task.start.check.folder.is.not.exist.or.not.folder", objectArray), null), null, 5, null);
    }

    @NotNull
    public final CallEngineStatus<Unit> safeStartWithInstall(@NotNull Project project, @NotNull Function1<? super ProcessCommandLineBuilder, ? extends ProcessOutput> runner, @NotNull ProgressIndicator progressIndicator) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter(runner, (String)"runner");
        Intrinsics.checkNotNullParameter((Object)progressIndicator, (String)"progressIndicator");
        if (!VCPKGPackageManager.compareAndSetState$default(this, VcpkgPackageManagerState.NOT_INITIALIZED, VcpkgPackageManagerState.START_INITIALIZE, false, 4, null)) {
            return new CallEngineStatus<Unit>(Unit.INSTANCE, null, null, 6, null);
        }
        progressIndicator.setText(PackageManagerBundle.INSTANCE.message("progress.title.checking.for.install", new Object[0]));
        LinkOption[] linkOptionArray = new LinkOption[]{};
        if (Files.exists(this.path, Arrays.copyOf(linkOptionArray, linkOptionArray.length))) {
            LinkOption[] linkOptionArray2 = new LinkOption[]{};
            if (!Files.isDirectory(this.path, Arrays.copyOf(linkOptionArray2, linkOptionArray2.length))) {
                this.compareAndSetState(VcpkgPackageManagerState.START_INITIALIZE, VcpkgPackageManagerState.BROKEN, true);
                Object[] objectArray = new Object[]{((Object)this.path).toString()};
                return new CallEngineStatus<Unit>(null, new VcpkgExecutionFail(PackageManagerBundle.INSTANCE.message("vcpkg.toolwindow.task.start.check.folder.is.not.folder", objectArray), null), null, 5, null);
            }
            String[] stringArray = this.path.toFile().list();
            Intrinsics.checkNotNull((Object)stringArray);
            if (!(stringArray.length == 0)) {
                this.compareAndSetState(VcpkgPackageManagerState.START_INITIALIZE, VcpkgPackageManagerState.NOT_INITIALIZED, true);
                return this.start(project, runner);
            }
        }
        return this.gitCloneRepository(progressIndicator, runner).withTransformProblem((Function1<VcpkgExecutionFail, VcpkgExecutionFail>)((Function1)VCPKGPackageManager::safeStartWithInstall$lambda$0)).plus(() -> VCPKGPackageManager.safeStartWithInstall$lambda$1(this, progressIndicator, runner)).plus(() -> VCPKGPackageManager.safeStartWithInstall$lambda$2(this, runner)).withTransformResult(arg_0 -> VCPKGPackageManager.safeStartWithInstall$lambda$3(this, arg_0)).withTransformProblem((Function1<VcpkgExecutionFail, VcpkgExecutionFail>)((Function1)arg_0 -> VCPKGPackageManager.safeStartWithInstall$lambda$4(this, arg_0)));
    }

    /*
     * WARNING - void declaration
     */
    private final <T> List<T> parsePackagesJson(String s, Function3<? super JsonNode, ? super String, ? super VCPKGVersionWithPort, ? extends T> convertFromNodeNameAndVersion) {
        void $this$mapTo$iv$iv;
        ObjectMapper objectMapper = new ObjectMapper();
        JsonNode parsed = objectMapper.readTree(s);
        Intrinsics.checkNotNull((Object)parsed);
        Iterable $this$map$iv = (Iterable)parsed;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void pre;
            Object object;
            Object object2;
            Object packageName;
            void node;
            JsonNode jsonNode = (JsonNode)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            Object object3 = node.get("package_name");
            if (object3 == null || (object3 = JsonUtils.Companion.getNlsSafeTextNodeNullable((JsonNode)object3)) == null) {
                object3 = packageName = "";
            }
            if ((object2 = node.get("version")) == null || (object2 = object2.asText()) == null) {
                object2 = "";
            }
            if ((object = node.get("port_version")) == null || (object = object.asText()) == null) {
                object = "";
            }
            Object object4 = object;
            Object object5 = object2;
            boolean bl2 = false;
            String version = (String)object5 + (Intrinsics.areEqual((Object)pre, (Object)"0") ? "" : "#" + (String)pre);
            VCPKGVersionWithPort parsedVersion = VcpkgOutputParser.Companion.parseVersionWithPort(version);
            Intrinsics.checkNotNull((Object)node);
            collection.add(convertFromNodeNameAndVersion.invoke((Object)node, packageName, (Object)parsedVersion));
        }
        return (List)destination$iv$iv;
    }

    private final List<VCPKGTripletDescriptionPackage> parseInstalledPackagesJson(String s) {
        return this.parsePackagesJson(s, VCPKGPackageManager::parseInstalledPackagesJson$lambda$0);
    }

    private final List<VCPKGDescriptionPackage> parseFullPackages(String s) {
        return this.parsePackagesJson(s, VCPKGPackageManager::parseFullPackages$lambda$0);
    }

    /*
     * WARNING - void declaration
     */
    private final List<VCPKGDescriptionPackage> parsePackages(List<String> rows) {
        void $this$mapNotNullTo$iv$iv;
        Regex regex;
        List realRows = new ArrayList();
        Iterable $this$forEach$iv = rows;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            String it = (String)element$iv;
            boolean bl = false;
            if (StringsKt.startsWith$default((String)it, (String)" ", (boolean)false, (int)2, null)) {
                CharSequence charSequence = it;
                regex = new Regex("^\\w");
                String string = "";
                realRows.set(realRows.size() - 1, realRows.get(realRows.size() - 1) + " " + regex.replace(charSequence, string));
                continue;
            }
            realRows.add(it);
        }
        Iterable $this$mapNotNull$iv = realRows;
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach2 = false;
        regex = $this$forEach$iv$iv$iv.iterator();
        while (regex.hasNext()) {
            VCPKGDescriptionPackage vCPKGDescriptionPackage;
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = regex.next();
            boolean bl = false;
            String it = (String)element$iv$iv;
            boolean bl2 = false;
            Object object = it;
            Regex regex2 = new Regex("\\s+");
            int n = 0;
            object = regex2.split((CharSequence)object, n);
            boolean $i$f$map = false;
            void var18_23 = $this$map$iv;
            Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void line;
                String string = (String)item$iv$iv;
                Collection collection = destination$iv$iv2;
                boolean bl3 = false;
                collection.add(((Object)StringsKt.trim((CharSequence)((CharSequence)line))).toString());
            }
            List row = (List)destination$iv$iv2;
            if (!((Collection)row).isEmpty() && StringsKt.startsWith$default((String)((String)row.get(0)), (String)"<", (boolean)false, (int)2, null)) {
                row = CollectionsKt.emptyList();
            }
            switch (row.size()) {
                case 0: {
                    vCPKGDescriptionPackage = null;
                    break;
                }
                case 1: {
                    vCPKGDescriptionPackage = new VCPKGDescriptionPackage((String)row.get(0), null, "");
                    break;
                }
                default: {
                    VCPKGVersionWithPort version = VcpkgOutputParser.Companion.parseVersionWithPort((String)row.get(1));
                    if (version != null && !(version.getVcpkgVersion() instanceof VCPKGVersion.VCPKGStringVersion)) {
                        vCPKGDescriptionPackage = new VCPKGDescriptionPackage((String)row.get(0), version, CollectionsKt.joinToString$default((Iterable)CollectionsKt.drop((Iterable)row, (int)2), (CharSequence)" ", null, null, (int)0, null, null, (int)62, null));
                        break;
                    }
                    vCPKGDescriptionPackage = new VCPKGDescriptionPackage((String)row.get(0), null, CollectionsKt.joinToString$default((Iterable)CollectionsKt.drop((Iterable)row, (int)1), (CharSequence)" ", null, null, (int)0, null, null, (int)62, null));
                }
            }
            if (vCPKGDescriptionPackage == null) continue;
            VCPKGDescriptionPackage it$iv$iv = vCPKGDescriptionPackage;
            boolean bl4 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        Iterable $this$sortedBy$iv = (List)destination$iv$iv;
        boolean $i$f$sortedBy = false;
        return CollectionsKt.sortedWith((Iterable)$this$sortedBy$iv, (Comparator)new Comparator(){

            public final int compare(T a, T b) {
                VCPKGDescriptionPackage it = (VCPKGDescriptionPackage)a;
                boolean bl = false;
                Comparable comparable = (Comparable)((Object)it.getName());
                it = (VCPKGDescriptionPackage)b;
                Comparable comparable2 = comparable;
                bl = false;
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)((Comparable)((Object)it.getName())));
            }
        });
    }

    @NotNull
    public final CallEngineStatus<Boolean> checkForUpdate(@Nullable ProgressIndicator indicator, @NotNull Function1<? super ProcessCommandLineBuilder, ? extends ProcessOutput> runner) {
        Intrinsics.checkNotNullParameter(runner, (String)"runner");
        Object[] objectArray = new String[]{"remote", "update"};
        return this.runCommandLineProcess(new ProcessCommandLineBuilder(ProcessCommandLineType.GIT, this.path.toFile(), CollectionsKt.listOf((Object[])objectArray), null, indicator != null ? CollectionsKt.listOf((Object)new CommandLineProcessListener(new GitProgressParser(indicator))) : CollectionsKt.emptyList(), null, false, null, 232, null), runner).plus(() -> VCPKGPackageManager.checkForUpdate$lambda$0(this, runner));
    }

    @TestOnly
    @NotNull
    public final CallEngineStatus<Unit> testInstall() {
        VCPKGPackageManager originalVcpkg = TestPropertiesService.Companion.getInstance().getAndRemoveNotNullUserData(TestPropertiesService.Companion.getORIGINAL_PACKAGE_MANAGER());
        LinkOption[] linkOptionArray = new LinkOption[]{};
        if (Files.exists(this.path, Arrays.copyOf(linkOptionArray, linkOptionArray.length)) && PathsKt.listDirectoryEntries$default((Path)this.path, null, (int)1, null).isEmpty()) {
            PathKt.delete$default((Path)this.path, (boolean)false, (int)1, null);
        }
        PathKt.copyRecursively((Path)originalVcpkg.path, (Path)this.path);
        return new CallEngineStatus<Unit>(Unit.INSTANCE, null, null, 6, null);
    }

    private final CallEngineStatus<Boolean> gitCloneRepository(ProgressIndicator indicator, Function1<? super ProcessCommandLineBuilder, ? extends ProcessOutput> runner) {
        Object[] objectArray = new String[]{"clone", "--progress", this.baseUrl, PathsKt.getName((Path)this.path)};
        return this.runCommandLineProcess(new ProcessCommandLineBuilder(ProcessCommandLineType.GIT, this.path.getParent().toFile(), CollectionsKt.listOf((Object[])objectArray), null, indicator != null ? CollectionsKt.listOf((Object)new CommandLineProcessListener(new GitProgressParser(indicator))) : CollectionsKt.emptyList(), null, false, null, 232, null), runner).withTransformResult(VCPKGPackageManager::gitCloneRepository$lambda$0);
    }

    private final CallEngineStatus<Boolean> bootstrapManager(ProgressIndicator indicator, Function1<? super ProcessCommandLineBuilder, ? extends ProcessOutput> runner) {
        if (indicator != null) {
            indicator.setText(PackageManagerBundle.INSTANCE.message("vcpkg.toolwindow.task.bootstrap.vcpkg", new Object[0]));
        }
        return this.runCommandLineProcess(new ProcessCommandLineBuilder(ProcessCommandLineType.BOOTSTRAP, this.path.toFile(), null, null, null, null, false, null, 252, null), runner).withTransformResult(VCPKGPackageManager::bootstrapManager$lambda$0);
    }

    @NotNull
    public final CallEngineStatus<String> getBuiltinBaseline(@NotNull Function1<? super ProcessCommandLineBuilder, ? extends ProcessOutput> runner) {
        Intrinsics.checkNotNullParameter(runner, (String)"runner");
        Object[] objectArray = new String[]{"rev-parse", "HEAD"};
        return this.runCommandLineProcess(new ProcessCommandLineBuilder(ProcessCommandLineType.GIT, this.path.toFile(), CollectionsKt.listOf((Object[])objectArray), null, null, null, false, null, 248, null), runner).withTransformResult(VCPKGPackageManager::getBuiltinBaseline$lambda$0);
    }

    @NotNull
    public final CallEngineStatus<List<VCPKGTripletDescriptionPackage>> installedList(@NotNull Function1<? super ProcessCommandLineBuilder, ? extends ProcessOutput> runner) {
        Intrinsics.checkNotNullParameter(runner, (String)"runner");
        Object[] objectArray = new String[]{"list", "--x-json", "--vcpkg-root=" + this.path};
        return this.runCommandLineProcess(new ProcessCommandLineBuilder(ProcessCommandLineType.VCPKG, this.path.toFile(), CollectionsKt.listOf((Object[])objectArray), null, null, null, false, null, 248, null), runner).withTransformResult(arg_0 -> VCPKGPackageManager.installedList$lambda$0(this, arg_0));
    }

    @NotNull
    public final CallEngineStatus<List<VCPKGDescriptionPackage>> allPackages(@NotNull Function1<? super ProcessCommandLineBuilder, ? extends ProcessOutput> runner) {
        Intrinsics.checkNotNullParameter(runner, (String)"runner");
        Object[] objectArray = new String[]{"search", "--x-json", "--x-full-desc", "--vcpkg-root=" + this.path};
        return this.runCommandLineProcess(new ProcessCommandLineBuilder(ProcessCommandLineType.VCPKG, this.path.toFile(), CollectionsKt.listOf((Object[])objectArray), null, null, null, false, null, 248, null), runner).withTransformResult(arg_0 -> VCPKGPackageManager.allPackages$lambda$0(this, arg_0));
    }

    private final String getTriplet(DisplayableDependencyPackage pkg) {
        DisplayableDependencyPackage displayableDependencyPackage = pkg;
        return displayableDependencyPackage instanceof VCPKGTripletPackage ? ((VCPKGTripletPackage)pkg).getTriplet() : (displayableDependencyPackage instanceof VCPKGTripletDescriptionPackage ? ((VCPKGTripletDescriptionPackage)pkg).getTriplet() : null);
    }

    private final String convertPackageToString(DisplayableDependencyPackage pkg) {
        String triplet;
        String name = pkg.getName();
        String string = triplet = this.getTriplet(pkg);
        return string == null ? name : name + ":" + string;
    }

    /*
     * WARNING - void declaration
     */
    private final List<String> convertPackagesToList(List<? extends DisplayableDependencyPackage> pkgs) {
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv = pkgs;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void p0;
            DisplayableDependencyPackage displayableDependencyPackage = (DisplayableDependencyPackage)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(this.convertPackageToString((DisplayableDependencyPackage)p0));
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final CallEngineStatus<Pair<List<VCPKGTripletPackage>, String>> installPackage(@NotNull List<? extends DisplayableDependencyPackage> pkgs, @NotNull ProgressIndicator indicator, @Nullable List<String> additionalArguments, @Nullable String forceDefaultTriplet, @NotNull Function1<? super ProcessCommandLineBuilder, ? extends ProcessOutput> runner) {
        Map map;
        Object[] $this$installPackage_u24lambda_u240;
        Intrinsics.checkNotNullParameter(pkgs, (String)"pkgs");
        Intrinsics.checkNotNullParameter((Object)indicator, (String)"indicator");
        Intrinsics.checkNotNullParameter(runner, (String)"runner");
        PackageProvidesTargetsStateMachine machine = new PackageProvidesTargetsStateMachine();
        Object[] objectArray = new String[]{"install"};
        Object[] objectArray2 = objectArray = CollectionsKt.mutableListOf((Object[])objectArray);
        File file = this.path.toFile();
        ProcessCommandLineType processCommandLineType = ProcessCommandLineType.VCPKG;
        VCPKGPackageManager vCPKGPackageManager = this;
        boolean bl = false;
        $this$installPackage_u24lambda_u240.addAll((Collection)this.convertPackagesToList(pkgs));
        Unit unit = Unit.INSTANCE;
        $this$installPackage_u24lambda_u240 = objectArray;
        boolean bl2 = false;
        if (additionalArguments != null) {
            void $this$installPackage_u24lambda_u241;
            $this$installPackage_u24lambda_u241.addAll((Collection)additionalArguments);
        }
        unit = Unit.INSTANCE;
        Object[] objectArray3 = objectArray;
        objectArray = new CommandLineProcessListener[]{new CommandLineProcessListener(new NumericalRatioProgressParser(indicator)), new CommandLineProcessListener(machine)};
        List list = CollectionsKt.listOf((Object[])objectArray);
        if (forceDefaultTriplet != null) {
            objectArray = new Pair[]{TuplesKt.to((Object)"VCPKG_DEFAULT_TRIPLET", (Object)forceDefaultTriplet), TuplesKt.to((Object)"VCPKG_DEFAULT_HOST_TRIPLET", (Object)forceDefaultTriplet)};
            map = MapsKt.mapOf((Pair[])objectArray);
        } else {
            map = MapsKt.emptyMap();
        }
        DefaultConstructorMarker defaultConstructorMarker = null;
        int n = 200;
        Long l = null;
        boolean bl3 = false;
        Map map2 = map;
        List list2 = list;
        Integer n2 = null;
        Object[] objectArray4 = objectArray3;
        File file2 = file;
        ProcessCommandLineType processCommandLineType2 = processCommandLineType;
        return vCPKGPackageManager.runCommandLineProcess(new ProcessCommandLineBuilder(processCommandLineType2, file2, (List)objectArray4, n2, list2, map2, bl3, l, n, defaultConstructorMarker), runner).withTransformResult(arg_0 -> VCPKGPackageManager.installPackage$lambda$2(this, runner, pkgs, machine, arg_0));
    }

    public static /* synthetic */ CallEngineStatus installPackage$default(VCPKGPackageManager vCPKGPackageManager, List list, ProgressIndicator progressIndicator, List list2, String string, Function1 function1, int n, Object object) {
        if ((n & 4) != 0) {
            list2 = null;
        }
        return vCPKGPackageManager.installPackage(list, progressIndicator, list2, string, (Function1<? super ProcessCommandLineBuilder, ? extends ProcessOutput>)function1);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final CallEngineStatus<List<PackageNameWithTriplet>> removePackage(@NotNull List<? extends DisplayableDependencyPackage> pkgs, boolean recursive, @NotNull Function1<? super ProcessCommandLineBuilder, ? extends ProcessOutput> runner) {
        Object $this$removePackage_u24lambda_u240;
        Intrinsics.checkNotNullParameter(pkgs, (String)"pkgs");
        Intrinsics.checkNotNullParameter(runner, (String)"runner");
        Object object = new String[]{"remove"};
        Object object2 = object = CollectionsKt.mutableListOf((Object[])object);
        File file = this.path.toFile();
        ProcessCommandLineType processCommandLineType = ProcessCommandLineType.VCPKG;
        VCPKGPackageManager vCPKGPackageManager = this;
        boolean bl = false;
        $this$removePackage_u24lambda_u240.addAll((Collection)this.convertPackagesToList(pkgs));
        Unit unit = Unit.INSTANCE;
        $this$removePackage_u24lambda_u240 = object;
        boolean bl2 = false;
        if (recursive) {
            void $this$removePackage_u24lambda_u241;
            $this$removePackage_u24lambda_u241.add("--recurse");
        }
        unit = Unit.INSTANCE;
        DefaultConstructorMarker defaultConstructorMarker = null;
        int n = 248;
        Long l = null;
        boolean bl3 = false;
        Map map = null;
        List list = null;
        Integer n2 = null;
        Object object3 = object;
        File file2 = file;
        ProcessCommandLineType processCommandLineType2 = processCommandLineType;
        return vCPKGPackageManager.runCommandLineProcess(new ProcessCommandLineBuilder(processCommandLineType2, file2, (List)object3, n2, list, map, bl3, l, n, defaultConstructorMarker), runner).withTransformResult(arg_0 -> VCPKGPackageManager.removePackage$lambda$2(this, runner, pkgs, arg_0));
    }

    @NotNull
    public final CallEngineStatus<List<Pair<PackageNameWithTriplet, Pair<VCPKGVersionWithPort, VCPKGVersionWithPort>>>> updateManager(@NotNull Function1<? super ProcessCommandLineBuilder, ? extends ProcessOutput> runner) {
        Intrinsics.checkNotNullParameter(runner, (String)"runner");
        return this.runCommandLineProcess(new ProcessCommandLineBuilder(ProcessCommandLineType.VCPKG, this.path.toFile(), CollectionsKt.listOf((Object)"update"), null, null, null, false, null, 248, null), runner).withTransformResult(arg_0 -> VCPKGPackageManager.updateManager$lambda$0(this, arg_0));
    }

    private final CallEngineStatus<List<VCPKGTripletPackage>> abstractUpgradePackages(List<String> parameters, Function1<? super ProcessCommandLineBuilder, ? extends ProcessOutput> runner) {
        return this.runCommandLineProcess(new ProcessCommandLineBuilder(ProcessCommandLineType.VCPKG, this.path.toFile(), parameters, null, null, null, false, null, 248, null), runner).withTransformResult(arg_0 -> VCPKGPackageManager.abstractUpgradePackages$lambda$0(this, runner, arg_0));
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final CallEngineStatus<List<VCPKGTripletPackage>> upgradePackages(@NotNull List<? extends DisplayableDependencyPackage> pkgs, @NotNull Function1<? super ProcessCommandLineBuilder, ? extends ProcessOutput> runner) {
        void $this$upgradePackages_u24lambda_u240;
        Intrinsics.checkNotNullParameter(pkgs, (String)"pkgs");
        Intrinsics.checkNotNullParameter(runner, (String)"runner");
        Object object = new String[]{"upgrade"};
        Object object2 = object = CollectionsKt.mutableListOf((Object[])object);
        VCPKGPackageManager vCPKGPackageManager = this;
        boolean bl = false;
        $this$upgradePackages_u24lambda_u240.addAll((Collection)this.convertPackagesToList(pkgs));
        $this$upgradePackages_u24lambda_u240.add("--no-dry-run");
        return vCPKGPackageManager.abstractUpgradePackages((List<String>)object, runner);
    }

    @NotNull
    public final CallEngineStatus<List<VCPKGTripletPackage>> upgradeManager(@NotNull Function1<? super ProcessCommandLineBuilder, ? extends ProcessOutput> runner) {
        Intrinsics.checkNotNullParameter(runner, (String)"runner");
        Object[] objectArray = new String[]{"upgrade", "--no-dry-run"};
        return this.abstractUpgradePackages(CollectionsKt.listOf((Object[])objectArray), runner);
    }

    @NotNull
    public final CallEngineStatus<Unit> updateGitRepository(@Nullable ProgressIndicator indicator, @NotNull Function1<? super ProcessCommandLineBuilder, ? extends ProcessOutput> runner) {
        Intrinsics.checkNotNullParameter(runner, (String)"runner");
        return this.runCommandLineProcess(new ProcessCommandLineBuilder(ProcessCommandLineType.GIT, this.path.toFile(), CollectionsKt.listOf((Object)"pull"), null, indicator != null ? CollectionsKt.listOf((Object)new CommandLineProcessListener(new GitProgressParser(indicator))) : CollectionsKt.emptyList(), null, false, null, 232, null), runner).withTransformResult(VCPKGPackageManager::updateGitRepository$lambda$0);
    }

    @NotNull
    public final CallEngineStatus<List<String>> getDependencies(@NotNull DisplayableDependencyPackage pkg, @NotNull Function1<? super ProcessCommandLineBuilder, ? extends ProcessOutput> runner) {
        Intrinsics.checkNotNullParameter((Object)pkg, (String)"pkg");
        Intrinsics.checkNotNullParameter(runner, (String)"runner");
        Object[] objectArray = new String[]{"depend-info", "--show-depth", pkg.getName()};
        return this.runCommandLineProcess(new ProcessCommandLineBuilder(ProcessCommandLineType.VCPKG, this.path.toFile(), CollectionsKt.listOf((Object[])objectArray), null, null, null, false, null, 248, null), runner).withTransformResult(arg_0 -> VCPKGPackageManager.getDependencies$lambda$0(pkg, arg_0));
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final CallEngineStatus<List<DisplayableDependencyPackage>> getPackagesByNames(@Nullable ProgressIndicator indicator, @NotNull List<String> names, @NotNull Function1<? super ProcessCommandLineBuilder, ? extends ProcessOutput> runner) {
        Intrinsics.checkNotNullParameter(names, (String)"names");
        Intrinsics.checkNotNullParameter(runner, (String)"runner");
        CallEngineStatus<List<DisplayableDependencyPackage>> accumulator = null;
        accumulator = new CallEngineStatus<List<DisplayableDependencyPackage>>(CollectionsKt.emptyList(), null, null, 6, null);
        List cachePackages = (List)this.packages.get();
        Iterable $this$forEachIndexed$iv = names;
        boolean $i$f$forEachIndexed = false;
        int index$iv = 0;
        for (Object item$iv : $this$forEachIndexed$iv) {
            void name;
            int n;
            if ((n = index$iv++) < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            String string = (String)item$iv;
            int index = n;
            boolean bl = false;
            if (cachePackages == null) {
                ProgressIndicator progressIndicator = indicator;
                if (progressIndicator != null) {
                    progressIndicator.setFraction((double)index / (double)names.size());
                }
                Object[] objectArray = new String[]{"search", name, "--x-full-desc"};
                CallEngineStatus<ProcessOutput> outputQuery = this.runCommandLineProcess(new ProcessCommandLineBuilder(ProcessCommandLineType.VCPKG, this.path.toFile(), CollectionsKt.listOf((Object[])objectArray), null, null, null, false, null, 248, null), runner);
                if (outputQuery.getProblem() != null) {
                    return outputQuery.withResult(null);
                }
                accumulator = accumulator.plusAssign(() -> VCPKGPackageManager.getPackagesByNames$lambda$0$0(outputQuery), (arg_0, arg_1) -> VCPKGPackageManager.getPackagesByNames$lambda$0$1(this, (String)name, arg_0, arg_1));
                continue;
            }
            accumulator = accumulator.withTransformResult(arg_0 -> VCPKGPackageManager.getPackagesByNames$lambda$0$2(cachePackages, (String)name, arg_0));
        }
        return accumulator;
    }

    @NotNull
    public final CallEngineStatus<Unit> safeRemove(@NotNull ProgressIndicator indicator, boolean isRemoveFiles) {
        Intrinsics.checkNotNullParameter((Object)indicator, (String)"indicator");
        Object[] objectArray = new Object[]{this.name};
        indicator.setText(PackageManagerBundle.INSTANCE.message("vcpkg.toolwindow.task.remove.package.manager", objectArray));
        LinkOption[] linkOptionArray = new LinkOption[]{};
        if (Files.exists(this.path, Arrays.copyOf(linkOptionArray, linkOptionArray.length))) {
            if (isRemoveFiles) {
                Object object;
                VCPKGPackageManager vCPKGPackageManager = this;
                try {
                    VCPKGPackageManager $this$safeRemove_u24lambda_u240 = vCPKGPackageManager;
                    boolean bl = false;
                    PathKt.delete((Path)$this$safeRemove_u24lambda_u240.path, (boolean)true);
                    object = Result.constructor-impl((Object)Unit.INSTANCE);
                }
                catch (Throwable throwable) {
                    object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable));
                }
                Throwable exception = Result.exceptionOrNull-impl((Object)object);
                if (exception == null) {
                    return new CallEngineStatus<Unit>(Unit.INSTANCE, null, null, 6, null);
                }
                VcpkgPackageManagerKt.getLogger().info("Unknown error while deleting", exception);
                return new CallEngineStatus<Unit>(null, new VcpkgExecutionFail(PackageManagerBundle.INSTANCE.message("vcpkg.toolwindow.task.remove.package.manager.error.on.deleting", new Object[0]), null), null, 5, null);
            }
            return new CallEngineStatus<Unit>(Unit.INSTANCE, null, null, 6, null);
        }
        if (isRemoveFiles) {
            return new CallEngineStatus<Unit>(null, new VcpkgExecutionFail(PackageManagerBundle.INSTANCE.message("vcpkg.toolwindow.task.remove.package.manager.asked.to.delete.but.there.is.nothing.to.delete", new Object[0]), null), null, 5, null);
        }
        return new CallEngineStatus<Unit>(Unit.INSTANCE, null, null, 6, null);
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        Object object = other;
        if (!Intrinsics.areEqual(this.getClass(), object != null ? object.getClass() : null)) {
            return false;
        }
        Object object2 = other;
        Intrinsics.checkNotNull((Object)object2, (String)"null cannot be cast to non-null type com.jetbrains.cidr.packagemanager.vcpkg.VCPKGPackageManager");
        VCPKGPackageManager cfr_ignored_0 = (VCPKGPackageManager)object2;
        return Intrinsics.areEqual((Object)this.path, (Object)((VCPKGPackageManager)other).path);
    }

    public int hashCode() {
        return ((Object)this.path).hashCode();
    }

    private static final long runCommandLineProcess$lambda$0(long it) {
        return it + 1L;
    }

    /*
     * WARNING - void declaration
     */
    private static final Unit getTriplets$lambda$0(VCPKGPackageManager this$0, ProcessOutput processOutput) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        String line;
        void $this$filterTo$iv$iv;
        Iterable $this$filter$iv;
        Intrinsics.checkNotNullParameter((Object)processOutput, (String)"processOutput");
        AtomicProperty<List<String>> atomicProperty = this$0.triplets;
        String string = processOutput.getStdout();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getStdout(...)");
        Object object = string;
        Regex regex = new Regex("\n");
        int n = 0;
        object = regex.split((CharSequence)object, n);
        AtomicProperty<List<String>> atomicProperty2 = atomicProperty;
        boolean $i$f$filter = false;
        void var4_6 = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            line = (String)element$iv$iv;
            boolean bl = false;
            if (!StringsKt.startsWith$default((String)line, (String)" ", (boolean)false, (int)2, null)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$filter$iv = (List)destination$iv$iv;
        boolean $i$f$map = false;
        $this$filterTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            line = (String)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(((Object)StringsKt.trim((CharSequence)((CharSequence)it))).toString());
        }
        atomicProperty2.set((Object)((List)destination$iv$iv));
        return Unit.INSTANCE;
    }

    private static final boolean start$lambda$0(VCPKGPackageManager this$0, Unit it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        this$0.reloadProblemFinder();
        return true;
    }

    private static final Unit start$lambda$1(Project $project, VCPKGPackageManager this$0) {
        CallerEngineBackgroundTask.Companion.launchBackgroundEngineTask(VcpkgExecutorService.Companion.getInstance($project).getExecutor(this$0).gitAndVcpkgUpdate());
        return Unit.INSTANCE;
    }

    private static final VcpkgExecutionFail safeStartWithInstall$lambda$0(VcpkgExecutionFail current) {
        Intrinsics.checkNotNullParameter((Object)current, (String)"current");
        Object[] objectArray = new Object[]{current.getShortError()};
        return new VcpkgExecutionFail(PackageManagerBundle.INSTANCE.message("vcpkg.toolwindow.task.git.clone.failed", objectArray), current.getFullOutput());
    }

    private static final CallEngineStatus safeStartWithInstall$lambda$1(VCPKGPackageManager this$0, ProgressIndicator $progressIndicator, Function1 $runner) {
        return this$0.bootstrapManager($progressIndicator, (Function1<? super ProcessCommandLineBuilder, ? extends ProcessOutput>)$runner).withTransformProblem((Function1<VcpkgExecutionFail, VcpkgExecutionFail>)((Function1)VCPKGPackageManager::safeStartWithInstall$lambda$1$0));
    }

    private static final VcpkgExecutionFail safeStartWithInstall$lambda$1$0(VcpkgExecutionFail current) {
        Intrinsics.checkNotNullParameter((Object)current, (String)"current");
        Object[] objectArray = new Object[]{current.getShortError()};
        return new VcpkgExecutionFail(PackageManagerBundle.INSTANCE.message("vcpkg.toolwindow.task.bootstrap.failed", objectArray), current.getFullOutput());
    }

    private static final CallEngineStatus safeStartWithInstall$lambda$2(VCPKGPackageManager this$0, Function1 $runner) {
        return this$0.getTriplets((Function1<? super ProcessCommandLineBuilder, ? extends ProcessOutput>)$runner);
    }

    private static final Unit safeStartWithInstall$lambda$3(VCPKGPackageManager this$0, Unit it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        this$0.reloadProblemFinder();
        this$0.compareAndSetState(VcpkgPackageManagerState.START_INITIALIZE, VcpkgPackageManagerState.INITIALIZED, true);
        return Unit.INSTANCE;
    }

    private static final VcpkgExecutionFail safeStartWithInstall$lambda$4(VCPKGPackageManager this$0, VcpkgExecutionFail it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        this$0.compareAndSetState(VcpkgPackageManagerState.START_INITIALIZE, VcpkgPackageManagerState.BROKEN, true);
        return it;
    }

    private static final VCPKGTripletDescriptionPackage parseInstalledPackagesJson$lambda$0(JsonNode node, String packageName, VCPKGVersionWithPort version) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        Intrinsics.checkNotNullParameter((Object)packageName, (String)"packageName");
        Object object2 = node.get("triplet");
        if (object2 == null || (object2 = JsonUtils.Companion.getNlsSafeTextNodeNullable((JsonNode)object2)) == null) {
            object2 = "";
        }
        if ((object = node.get("desc")) == null || (object = CollectionsKt.joinToString$default((Iterable)((Iterable)object), (CharSequence)"\n", null, null, (int)0, null, VCPKGPackageManager::parseInstalledPackagesJson$lambda$0$0, (int)30, null)) == null) {
            object = "";
        }
        return new VCPKGTripletDescriptionPackage(packageName, version, (String)object2, (String)object);
    }

    private static final CharSequence parseInstalledPackagesJson$lambda$0$0(JsonNode it) {
        String string = JsonUtils.Companion.getNlsSafeTextNodeNullable(it);
        return string != null ? (CharSequence)string : (CharSequence)"";
    }

    private static final VCPKGDescriptionPackage parseFullPackages$lambda$0(JsonNode node, String packageName, VCPKGVersionWithPort version) {
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        Intrinsics.checkNotNullParameter((Object)packageName, (String)"packageName");
        Object object = node.get("description");
        if (object == null || (object = CollectionsKt.joinToString$default((Iterable)((Iterable)object), (CharSequence)"\n", null, null, (int)0, null, VCPKGPackageManager::parseFullPackages$lambda$0$0, (int)30, null)) == null) {
            object = "";
        }
        return new VCPKGDescriptionPackage(packageName, version, (String)object);
    }

    private static final CharSequence parseFullPackages$lambda$0$0(JsonNode it) {
        String string = JsonUtils.Companion.getNlsSafeTextNodeNullable(it);
        return string != null ? (CharSequence)string : (CharSequence)"";
    }

    private static final CallEngineStatus checkForUpdate$lambda$0(VCPKGPackageManager this$0, Function1 $runner) {
        Object[] objectArray = new String[]{"status", "-uno"};
        return this$0.runCommandLineProcess(new ProcessCommandLineBuilder(ProcessCommandLineType.GIT, this$0.path.toFile(), CollectionsKt.listOf((Object[])objectArray), null, null, null, false, null, 248, null), (Function1<? super ProcessCommandLineBuilder, ? extends ProcessOutput>)$runner).withTransformResult(VCPKGPackageManager::checkForUpdate$lambda$0$0);
    }

    private static final boolean checkForUpdate$lambda$0$0(ProcessOutput statusOutput) {
        Intrinsics.checkNotNullParameter((Object)statusOutput, (String)"statusOutput");
        String string = statusOutput.getStdout();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getStdout(...)");
        return StringsKt.contains$default((CharSequence)string, (CharSequence)"Your branch is up to date", (boolean)false, (int)2, null);
    }

    private static final boolean gitCloneRepository$lambda$0(ProcessOutput it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return true;
    }

    private static final boolean bootstrapManager$lambda$0(ProcessOutput it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        PackageManagerCollector.countOfInstallVCPKG.log();
        return true;
    }

    private static final String getBuiltinBaseline$lambda$0(ProcessOutput processOutput) {
        Intrinsics.checkNotNullParameter((Object)processOutput, (String)"processOutput");
        String string = processOutput.getStdout();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getStdout(...)");
        return ((Object)StringsKt.trim((CharSequence)string)).toString();
    }

    /*
     * WARNING - void declaration
     */
    private static final List installedList$lambda$0(VCPKGPackageManager this$0, ProcessOutput processOutput) {
        void $this$associateTo$iv$iv;
        void $this$associate$iv;
        void $this$mapNotNullTo$iv$iv;
        Iterable $this$mapNotNull$iv;
        Iterator nameAndPackage;
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv;
        Object list$iv$iv;
        Object key$iv$iv;
        void $this$groupByTo$iv$iv;
        Iterable $this$groupBy$iv;
        Intrinsics.checkNotNullParameter((Object)processOutput, (String)"processOutput");
        String string = processOutput.getStdout();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getStdout(...)");
        List<VCPKGTripletDescriptionPackage> result = this$0.parseInstalledPackagesJson(string);
        Iterable iterable = result;
        AtomicProperty<Map<String, Pair<Map<String, VCPKGTripletPackage>, String>>> atomicProperty = this$0.installedPackages;
        boolean $i$f$groupBy = false;
        void var5_6 = $this$groupBy$iv;
        Object destination$iv$iv = new LinkedHashMap();
        boolean $i$f$groupByTo = false;
        for (Object element$iv$iv : $this$groupByTo$iv$iv) {
            Object object;
            void $this$getOrPut$iv$iv$iv;
            VCPKGTripletDescriptionPackage pkg = (VCPKGTripletDescriptionPackage)element$iv$iv;
            boolean bl = false;
            key$iv$iv = pkg.getName();
            Map map = destination$iv$iv;
            String key$iv$iv$iv = key$iv$iv;
            boolean $i$f$getOrPut = false;
            Object value$iv$iv$iv = $this$getOrPut$iv$iv$iv.get(key$iv$iv$iv);
            if (value$iv$iv$iv == null) {
                boolean bl2 = false;
                List answer$iv$iv$iv = new ArrayList();
                $this$getOrPut$iv$iv$iv.put(key$iv$iv$iv, answer$iv$iv$iv);
                object = answer$iv$iv$iv;
            } else {
                object = value$iv$iv$iv;
            }
            list$iv$iv = (List)object;
            list$iv$iv.add(element$iv$iv);
        }
        $this$groupBy$iv = destination$iv$iv.entrySet();
        boolean $i$f$map = false;
        $this$groupByTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            Pair pair;
            void resultPair;
            Pair resultMap;
            void $this$associateTo$iv$iv2;
            void $this$associate$iv2;
            void $this$mapNotNullTo$iv$iv2;
            Iterable $this$mapNotNull$iv2;
            Object list$iv$iv2;
            void $this$groupByTo$iv$iv2;
            Iterable $this$groupBy$iv2;
            list$iv$iv = (Map.Entry)item$iv$iv;
            Object object = destination$iv$iv;
            boolean bl = false;
            key$iv$iv = (Iterable)nameAndPackage.getValue();
            Object $i$f$getOrPut = nameAndPackage.getKey();
            boolean $i$f$groupBy2 = false;
            void answer$iv$iv$iv = $this$groupBy$iv2;
            Object destination$iv$iv2 = new LinkedHashMap();
            boolean $i$f$groupByTo2 = false;
            for (Object element$iv$iv : $this$groupByTo$iv$iv2) {
                Object object2;
                void $this$getOrPut$iv$iv$iv;
                VCPKGTripletDescriptionPackage pkg = (VCPKGTripletDescriptionPackage)element$iv$iv;
                boolean bl3 = false;
                String key$iv$iv2 = pkg.getTriplet();
                Map map = destination$iv$iv2;
                String key$iv$iv$iv = key$iv$iv2;
                boolean $i$f$getOrPut2 = false;
                Object value$iv$iv$iv = $this$getOrPut$iv$iv$iv.get(key$iv$iv$iv);
                if (value$iv$iv$iv == null) {
                    boolean bl4 = false;
                    List answer$iv$iv$iv2 = new ArrayList();
                    $this$getOrPut$iv$iv$iv.put(key$iv$iv$iv, answer$iv$iv$iv2);
                    object2 = answer$iv$iv$iv2;
                } else {
                    object2 = value$iv$iv$iv;
                }
                list$iv$iv2 = (List)object2;
                list$iv$iv2.add(element$iv$iv);
            }
            $this$groupBy$iv2 = destination$iv$iv2.entrySet();
            boolean $i$f$mapNotNull = false;
            $this$groupByTo$iv$iv2 = $this$mapNotNull$iv2;
            destination$iv$iv2 = new ArrayList();
            boolean $i$f$mapNotNullTo = false;
            void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv2;
            boolean $i$f$forEach = false;
            list$iv$iv2 = $this$forEach$iv$iv$iv.iterator();
            while (list$iv$iv2.hasNext()) {
                Pair it$iv$iv;
                Object element$iv$iv$iv;
                Object element$iv$iv = element$iv$iv$iv = list$iv$iv2.next();
                boolean bl5 = false;
                Map.Entry pkg = (Map.Entry)element$iv$iv;
                boolean bl6 = false;
                if ((((List)pkg.getValue()).isEmpty() ? null : new Pair(pkg.getKey(), CollectionsKt.first((List)((List)pkg.getValue())))) == null) continue;
                it$iv$iv = it$iv$iv;
                boolean bl7 = false;
                destination$iv$iv2.add(it$iv$iv);
            }
            $this$mapNotNull$iv2 = (List)destination$iv$iv2;
            boolean $i$f$associate22 = false;
            int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associate$iv2, (int)10)), (int)16);
            destination$iv$iv2 = $this$associate$iv2;
            Map destination$iv$iv3 = new LinkedHashMap(capacity$iv);
            boolean $i$f$associateTo = false;
            for (Object element$iv$iv : $this$associateTo$iv$iv2) {
                Map map = destination$iv$iv3;
                Pair pkg = (Pair)element$iv$iv;
                boolean bl8 = false;
                Pair pair2 = TuplesKt.to((Object)pkg.getFirst(), (Object)((VCPKGTripletDescriptionPackage)pkg.getSecond()).toVcpkgTripletPackage());
                map.put(pair2.getFirst(), pair2.getSecond());
            }
            Map $i$f$associate22 = MapsKt.toMutableMap((Map)destination$iv$iv3);
            boolean bl9 = false;
            String string2 = ((VCPKGTripletDescriptionPackage)CollectionsKt.first((List)((List)nameAndPackage.getValue()))).getDescription();
            Object object3 = resultMap.isEmpty() ? null : resultMap;
            resultMap = new Pair(object3, (Object)string2);
            boolean bl10 = false;
            if (resultPair.getFirst() == null) {
                pair = null;
            } else {
                Object object4 = resultPair.getFirst();
                Intrinsics.checkNotNull((Object)object4);
                pair = new Pair(object4, resultPair.getSecond());
            }
            object.add(TuplesKt.to($i$f$getOrPut, (Object)pair));
        }
        $this$map$iv = (List)destination$iv$iv;
        boolean $i$f$mapNotNull = false;
        $this$mapTo$iv$iv = $this$mapNotNull$iv;
        destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        nameAndPackage = $this$forEach$iv$iv$iv.iterator();
        while (nameAndPackage.hasNext()) {
            Pair pair;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = nameAndPackage.next();
            boolean bl = false;
            Pair entry = (Pair)element$iv$iv;
            boolean bl11 = false;
            if (entry.getSecond() != null) {
                Object object = entry.getFirst();
                Object object5 = entry.getSecond();
                Intrinsics.checkNotNull((Object)object5);
                pair = TuplesKt.to((Object)object, (Object)object5);
            } else {
                pair = null;
            }
            if (pair == null) continue;
            Pair it$iv$iv = pair;
            boolean bl12 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        $this$mapNotNull$iv = (List)destination$iv$iv;
        boolean $i$f$associate = false;
        int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associate$iv, (int)10)), (int)16);
        destination$iv$iv = $this$associate$iv;
        Map destination$iv$iv4 = new LinkedHashMap(capacity$iv);
        boolean $i$f$associateTo = false;
        for (Object element$iv$iv : $this$associateTo$iv$iv) {
            Map map = destination$iv$iv4;
            Pair pair = (Pair)element$iv$iv;
            boolean bl = false;
            Pair pair3 = TuplesKt.to((Object)pair.getFirst(), (Object)pair.getSecond());
            map.put(pair3.getFirst(), pair3.getSecond());
        }
        atomicProperty.set((Object)MapsKt.toMutableMap((Map)destination$iv$iv4));
        this$0.installedPackagesList.set(result);
        return result;
    }

    /*
     * WARNING - void declaration
     */
    private static final List allPackages$lambda$0(VCPKGPackageManager this$0, ProcessOutput processOutput) {
        List<VCPKGDescriptionPackage> list;
        Intrinsics.checkNotNullParameter((Object)processOutput, (String)"processOutput");
        try {
            String string = processOutput.getStdout();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getStdout(...)");
            list = this$0.parseFullPackages(string);
        }
        catch (Exception exception) {
            void $this$filterTo$iv$iv;
            void $this$filter$iv;
            String string = processOutput.getStdout();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getStdout(...)");
            Object object = new String[]{"\n"};
            object = StringsKt.split$default((CharSequence)StringsKt.substringBefore$default((String)string, (String)"The result may be outdated. Run `git pull` to get the latest results", null, (int)2, null), (String[])object, (boolean)false, (int)0, (int)6, null);
            VCPKGPackageManager vCPKGPackageManager = this$0;
            boolean $i$f$filter = false;
            void var7_7 = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                String it = (String)element$iv$iv;
                boolean bl = false;
                boolean bl2 = !StringsKt.isBlank((CharSequence)it);
                if (!bl2) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            list = vCPKGPackageManager.parsePackages((List)destination$iv$iv);
        }
        List<VCPKGDescriptionPackage> result = list;
        this$0.packages.set(result);
        return result;
    }

    private static final Pair installPackage$lambda$2(VCPKGPackageManager this$0, Function1 $runner, List $pkgs, PackageProvidesTargetsStateMachine $machine, ProcessOutput processOutput) {
        Intrinsics.checkNotNullParameter((Object)processOutput, (String)"processOutput");
        String string = processOutput.getStdout();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getStdout(...)");
        List<VCPKGTripletPackage> packages = VcpkgOutputParser.Companion.parseInstallConsoleOutput(string);
        this$0.installedList((Function1<? super ProcessCommandLineBuilder, ? extends ProcessOutput>)$runner);
        Iterable $this$forEach$iv = $pkgs;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            DisplayableDependencyPackage pkg = (DisplayableDependencyPackage)element$iv;
            boolean bl = false;
            PackageManagerCollector.countOfInstallPackageVCPKG.log((Object)(this$0.getTriplet(pkg) != null ? 1 : 0));
        }
        return new Pair(packages, (Object)CollectionsKt.joinToString$default((Iterable)$machine.getLines(), (CharSequence)"\n", null, null, (int)0, null, null, (int)62, null));
    }

    private static final List removePackage$lambda$2(VCPKGPackageManager this$0, Function1 $runner, List $pkgs, ProcessOutput processOutput) {
        Intrinsics.checkNotNullParameter((Object)processOutput, (String)"processOutput");
        String string = processOutput.getStdout();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getStdout(...)");
        List<PackageNameWithTriplet> packages = VcpkgOutputParser.Companion.parseRemoveConsoleOutput(string);
        this$0.installedList((Function1<? super ProcessCommandLineBuilder, ? extends ProcessOutput>)$runner);
        Iterable $this$forEach$iv = $pkgs;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            DisplayableDependencyPackage cfr_ignored_0 = (DisplayableDependencyPackage)element$iv;
            boolean bl = false;
            PackageManagerCollector.countOfRemovePackageVCPKG.log();
        }
        return packages;
    }

    private static final List updateManager$lambda$0(VCPKGPackageManager this$0, ProcessOutput processOutput) {
        Intrinsics.checkNotNullParameter((Object)processOutput, (String)"processOutput");
        String string = processOutput.getStdout();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getStdout(...)");
        List<Pair<PackageNameWithTriplet, Pair<VCPKGVersionWithPort, VCPKGVersionWithPort>>> packages = VcpkgOutputParser.Companion.parseUpdateConsoleOutput(string);
        Map result = new LinkedHashMap();
        for (Pair<PackageNameWithTriplet, Pair<VCPKGVersionWithPort, VCPKGVersionWithPort>> pkg : packages) {
            if (!result.containsKey(((PackageNameWithTriplet)pkg.getFirst()).getName())) {
                result.put(((PackageNameWithTriplet)pkg.getFirst()).getName(), (Map)new LinkedHashMap());
            }
            Object v = result.get(((PackageNameWithTriplet)pkg.getFirst()).getName());
            Intrinsics.checkNotNull(v);
            ((Map)v).put(((PackageNameWithTriplet)pkg.getFirst()).getTriplet(), pkg.getSecond());
        }
        this$0.upgradable.set((Object)result);
        return packages;
    }

    private static final List abstractUpgradePackages$lambda$0(VCPKGPackageManager this$0, Function1 $runner, ProcessOutput processOutput) {
        Intrinsics.checkNotNullParameter((Object)processOutput, (String)"processOutput");
        String string = processOutput.getStdout();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getStdout(...)");
        List<VCPKGTripletPackage> packages = VcpkgOutputParser.Companion.parseUpgradeConsoleOutput(string);
        this$0.installedList((Function1<? super ProcessCommandLineBuilder, ? extends ProcessOutput>)$runner);
        return packages;
    }

    private static final Unit updateGitRepository$lambda$0(ProcessOutput it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return Unit.INSTANCE;
    }

    private static final List getDependencies$lambda$0(DisplayableDependencyPackage $pkg, ProcessOutput processOutput) {
        Intrinsics.checkNotNullParameter((Object)processOutput, (String)"processOutput");
        String string = processOutput.getStdout();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getStdout(...)");
        String[] stringArray = new String[]{"\n"};
        Collection collection = StringsKt.split$default((CharSequence)string, (String[])stringArray, (boolean)false, (int)0, (int)6, null);
        String string2 = processOutput.getStderr();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getStderr(...)");
        stringArray = new String[]{"\n"};
        return SequencesKt.toList((Sequence)SequencesKt.sorted((Sequence)SequencesKt.distinct((Sequence)SequencesKt.filter((Sequence)SequencesKt.flatten((Sequence)SequencesKt.map((Sequence)CollectionsKt.asSequence((Iterable)CollectionsKt.plus((Collection)collection, (Iterable)StringsKt.split$default((CharSequence)string2, (String[])stringArray, (boolean)false, (int)0, (int)6, null))), VCPKGPackageManager::getDependencies$lambda$0$0)), arg_0 -> VCPKGPackageManager.getDependencies$lambda$0$1($pkg, arg_0)))));
    }

    private static final Sequence getDependencies$lambda$0$0(String line) {
        Intrinsics.checkNotNullParameter((Object)line, (String)"line");
        return SequencesKt.mapNotNull((Sequence)Regex.findAll$default((Regex)DEPENDENCY_LINE_PATTERN, (CharSequence)line, (int)0, (int)2, null), VCPKGPackageManager::getDependencies$lambda$0$0$0);
    }

    private static final String getDependencies$lambda$0$0$0(MatchResult it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        MatchGroup matchGroup = it.getGroups().get(1);
        return matchGroup != null ? matchGroup.getValue() : null;
    }

    private static final boolean getDependencies$lambda$0$1(DisplayableDependencyPackage $pkg, String it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return !StringsKt.isBlank((CharSequence)it) && !StringsKt.equals((String)it, (String)$pkg.getName(), (boolean)true);
    }

    private static final CallEngineStatus getPackagesByNames$lambda$0$0(CallEngineStatus $outputQuery) {
        return $outputQuery;
    }

    /*
     * WARNING - void declaration
     */
    private static final List getPackagesByNames$lambda$0$1(VCPKGPackageManager this$0, String $name, List list, ProcessOutput output) {
        Object v2;
        Object object;
        block2: {
            void $this$firstOrNull$iv;
            void $this$filterTo$iv$iv;
            Iterable $this$filter$iv;
            Intrinsics.checkNotNullParameter((Object)list, (String)"list");
            Intrinsics.checkNotNullParameter((Object)output, (String)"output");
            String string = output.getStdout();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getStdout(...)");
            Object object2 = new String[]{"\n"};
            object2 = StringsKt.split$default((CharSequence)StringsKt.substringBefore$default((String)string, (String)"The result may be outdated. Run `git pull` to get the latest results", null, (int)2, null), (String[])object2, (boolean)false, (int)0, (int)6, null);
            object = this$0;
            boolean $i$f$filter = false;
            Iterator iterator = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                String it = (String)element$iv$iv;
                boolean bl = false;
                boolean bl2 = !StringsKt.isBlank((CharSequence)it);
                if (!bl2) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            List<VCPKGDescriptionPackage> packages = ((VCPKGPackageManager)object).parsePackages((List)destination$iv$iv);
            $this$filter$iv = packages;
            object = list;
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                VCPKGDescriptionPackage it = (VCPKGDescriptionPackage)element$iv;
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)it.getName(), (Object)$name)) continue;
                v2 = element$iv;
                break block2;
            }
            v2 = null;
        }
        return CollectionsKt.plus((Collection)object, v2);
    }

    /*
     * WARNING - void declaration
     */
    private static final List getPackagesByNames$lambda$0$2(List $cachePackages, String $name, List result) {
        Object v0;
        Collection collection;
        block1: {
            void $this$firstOrNull$iv;
            Intrinsics.checkNotNullParameter((Object)result, (String)"result");
            Iterable iterable = $cachePackages;
            collection = result;
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                VCPKGDescriptionPackage it = (VCPKGDescriptionPackage)element$iv;
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)it.getName(), (Object)$name)) continue;
                v0 = element$iv;
                break block1;
            }
            v0 = null;
        }
        return CollectionsKt.plus((Collection)collection, v0);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\b"}, d2={"Lcom/jetbrains/cidr/packagemanager/vcpkg/VCPKGPackageManager$Companion;", "", "<init>", "()V", "DEPENDENCY_LINE_PATTERN", "Lkotlin/text/Regex;", "getDEPENDENCY_LINE_PATTERN", "()Lkotlin/text/Regex;", "intellij.clion.packageManager"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Regex getDEPENDENCY_LINE_PATTERN() {
            return DEPENDENCY_LINE_PATTERN;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0007\b\u0086\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003j\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006j\u0002\b\u0007\u00a8\u0006\b"}, d2={"Lcom/jetbrains/cidr/packagemanager/vcpkg/VCPKGPackageManager$VcpkgPackageManagerState;", "", "<init>", "(Ljava/lang/String;I)V", "NOT_INITIALIZED", "START_INITIALIZE", "INITIALIZED", "BROKEN", "intellij.clion.packageManager"})
    public static final class VcpkgPackageManagerState
    extends Enum<VcpkgPackageManagerState> {
        public static final /* enum */ VcpkgPackageManagerState NOT_INITIALIZED = new VcpkgPackageManagerState();
        public static final /* enum */ VcpkgPackageManagerState START_INITIALIZE = new VcpkgPackageManagerState();
        public static final /* enum */ VcpkgPackageManagerState INITIALIZED = new VcpkgPackageManagerState();
        public static final /* enum */ VcpkgPackageManagerState BROKEN = new VcpkgPackageManagerState();
        private static final /* synthetic */ VcpkgPackageManagerState[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        public static VcpkgPackageManagerState[] values() {
            return (VcpkgPackageManagerState[])$VALUES.clone();
        }

        public static VcpkgPackageManagerState valueOf(String value) {
            return Enum.valueOf(VcpkgPackageManagerState.class, value);
        }

        @NotNull
        public static EnumEntries<VcpkgPackageManagerState> getEntries() {
            return $ENTRIES;
        }

        static {
            $VALUES = vcpkgPackageManagerStateArray = new VcpkgPackageManagerState[]{VcpkgPackageManagerState.NOT_INITIALIZED, VcpkgPackageManagerState.START_INITIALIZE, VcpkgPackageManagerState.INITIALIZED, VcpkgPackageManagerState.BROKEN};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }
}

