/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.clion.toolchains.debugger;

import com.intellij.clion.toolchains.debugger.CLionDapDebuggerSettings;
import com.intellij.clion.toolchains.debugger.CLionDapDebuggersState;
import com.intellij.clion.toolchains.debugger.CLionDapDebuggersStorage;
import com.intellij.clion.toolchains.debugger.CLionDapDebuggersStorageKt;
import com.intellij.clion.toolchains.debugger.CLionDapMacrosKt;
import com.intellij.clion.toolchains.debugger.DapDebuggerConfigurable;
import com.intellij.clion.toolchains.debugger.DapDebuggerTreeCellRenderer;
import com.intellij.clion.toolchains.debugger.ToolchainsDebuggerBundle;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonShortcuts;
import com.intellij.openapi.actionSystem.ShortcutSet;
import com.intellij.openapi.keymap.KeymapUtil;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.ui.MasterDetailsComponent;
import com.intellij.openapi.ui.NamedConfigurable;
import com.intellij.openapi.util.Disposer;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.ui.SimpleTextAttributes;
import java.awt.Component;
import java.awt.Container;
import java.awt.event.ActionEvent;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeCellRenderer;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000v\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\u0000\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000e\u0018\u00002\u00020\u0001:\u000556789B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u0010\u001a\u00020\u0011H\u0016J\r\u0010\u0012\u001a\u00070\r\u00a2\u0006\u0002\b\u0013H\u0016J\u0016\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00160\u00152\u0006\u0010\u0017\u001a\u00020\u0018H\u0014J\b\u0010\u0019\u001a\u00020\u001aH\u0016J\b\u0010\u001b\u001a\u00020\u001aH\u0016J\u0012\u0010\u001c\u001a\u00020\u00182\b\u0010\u001d\u001a\u0004\u0018\u00010\u001eH\u0014J\b\u0010\u001f\u001a\u00020\u001aH\u0016J\u0012\u0010 \u001a\u00020\u001a2\b\u0010!\u001a\u0004\u0018\u00010\u001eH\u0014J\b\u0010\"\u001a\u00020\u0018H\u0016J\u0018\u0010#\u001a\u00020\u001a2\u0006\u0010$\u001a\u00020%2\u0006\u0010&\u001a\u00020%H\u0014J\u0016\u0010'\u001a\u00020\u001a2\f\u0010(\u001a\b\u0012\u0004\u0012\u00020%0\u0015H\u0014J\u000e\u0010)\u001a\b\u0012\u0004\u0012\u00020%0*H\u0014J\u001a\u00102\u001a\u00020%2\u0006\u0010+\u001a\u00020,2\b\b\u0002\u00103\u001a\u00020\u0018H\u0002J\b\u00104\u001a\u00020\u001aH\u0002R\u0013\u0010\u0004\u001a\u00070\u0005\u00a2\u0006\u0002\b\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R*\u0010\u000b\u001a\u001e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\u000e0\fj\u000e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\u000e`\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0018\u0010+\u001a\u00020,*\u00020%8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b-\u0010.R\u0018\u0010/\u001a\u00020\r*\u00020,8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b0\u00101\u00a8\u0006:"}, d2={"Lcom/intellij/clion/toolchains/debugger/DapDebuggersMasterDetails;", "Lcom/intellij/openapi/ui/MasterDetailsComponent;", "<init>", "()V", "myDisposable", "Lcom/intellij/openapi/Disposable;", "Lorg/jetbrains/annotations/NotNull;", "myDebuggersState", "Lcom/intellij/clion/toolchains/debugger/CLionDapDebuggersState;", "myDebuggersModificationCount", "", "myDebuggerPositions", "Ljava/util/HashMap;", "", "", "Lkotlin/collections/HashMap;", "createComponent", "Ljavax/swing/JComponent;", "getDisplayName", "Lcom/intellij/openapi/util/NlsContexts$ConfigurableName;", "createActions", "", "Lcom/intellij/openapi/actionSystem/AnAction;", "fromPopup", "", "reset", "", "apply", "wasObjectStored", "editableObject", "", "disposeUIResources", "onItemDeleted", "item", "isModified", "addNode", "nodeToAdd", "Lcom/intellij/openapi/ui/MasterDetailsComponent$MyNode;", "parent", "removeNodes", "nodes", "getNodeComparator", "Ljava/util/Comparator;", "debugger", "Lcom/intellij/clion/toolchains/debugger/CLionDapDebuggerSettings;", "getDebugger", "(Lcom/intellij/openapi/ui/MasterDetailsComponent$MyNode;)Lcom/intellij/clion/toolchains/debugger/CLionDapDebuggerSettings;", "notNullId", "getNotNullId", "(Lcom/intellij/clion/toolchains/debugger/CLionDapDebuggerSettings;)Ljava/lang/String;", "createDebuggerNode", "isNewDebugger", "createNewDebugger", "AddDapDebuggerAction", "CopyDapDebuggerAction", "MoveUpDapDebuggerAction", "MoveDownDapDebuggerAction", "DebuggerComparator", "intellij.clion.toolchains.debugger"})
@SourceDebugExtension(value={"SMAP\nDapDebuggersConfigurable.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DapDebuggersConfigurable.kt\ncom/intellij/clion/toolchains/debugger/DapDebuggersMasterDetails\n+ 2 KtUtils.kt\ncom/intellij/util/KotlinUtils\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,625:1\n19#2:626\n19#2:629\n1869#3,2:627\n*S KotlinDebug\n*F\n+ 1 DapDebuggersConfigurable.kt\ncom/intellij/clion/toolchains/debugger/DapDebuggersMasterDetails\n*L\n143#1:626\n355#1:629\n326#1:627,2\n*E\n"})
public final class DapDebuggersMasterDetails
extends MasterDetailsComponent {
    @NotNull
    private final Disposable myDisposable;
    @NotNull
    private CLionDapDebuggersState myDebuggersState;
    private long myDebuggersModificationCount;
    @NotNull
    private final HashMap<String, Integer> myDebuggerPositions;

    public DapDebuggersMasterDetails() {
        Disposable disposable = Disposer.newDisposable();
        Intrinsics.checkNotNullExpressionValue((Object)disposable, (String)"newDisposable(...)");
        this.myDisposable = disposable;
        this.myDebuggersState = new CLionDapDebuggersState();
        this.myDebuggerPositions = new HashMap();
        this.initTree();
        this.myTree.setCellRenderer((TreeCellRenderer)((Object)new DapDebuggerTreeCellRenderer()));
        this.getTree().getEmptyText().setText(ToolchainsDebuggerBundle.INSTANCE.message("configurable.no.debuggers.configured", new Object[0]));
        this.getTree().getEmptyText().appendLine(ToolchainsDebuggerBundle.INSTANCE.message("configurable.add.new", new Object[0]), SimpleTextAttributes.LINK_PLAIN_ATTRIBUTES, arg_0 -> DapDebuggersMasterDetails._init_$lambda$0(this, arg_0));
        String string = KeymapUtil.getFirstKeyboardShortcutText((ShortcutSet)CommonShortcuts.getNew());
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getFirstKeyboardShortcutText(...)");
        String shortcut = string;
        if (((CharSequence)shortcut).length() > 0) {
            this.getTree().getEmptyText().appendText(" (" + shortcut + ")");
        }
    }

    @NotNull
    public JComponent createComponent() {
        JComponent component;
        block1: {
            JComponent jComponent = super.createComponent();
            Intrinsics.checkNotNullExpressionValue((Object)jComponent, (String)"createComponent(...)");
            component = jComponent;
            Container $this$asSafely$iv = SwingUtilities.getAncestorOfClass(JPanel.class, (Component)this.myTree);
            boolean $i$f$asSafely = false;
            Container container = $this$asSafely$iv;
            if (!(container instanceof JPanel)) {
                container = null;
            }
            JPanel jPanel = (JPanel)container;
            if (jPanel == null) break block1;
            JPanel it = jPanel;
            boolean bl = false;
            it.setBorder(IdeBorderFactory.createBorder((int)11));
        }
        return component;
    }

    @NotNull
    public String getDisplayName() {
        return "";
    }

    @NotNull
    protected List<AnAction> createActions(boolean fromPopup) {
        Object[] objectArray = new AnAction[]{new AddDapDebuggerAction(), new MasterDetailsComponent.MyDeleteAction((MasterDetailsComponent)this), new CopyDapDebuggerAction(), new MoveUpDapDebuggerAction(), new MoveDownDapDebuggerAction()};
        return CollectionsKt.listOf((Object[])objectArray);
    }

    public void reset() {
        this.clearChildren();
        this.myDebuggerPositions.clear();
        this.myDebuggersState = CLionDapDebuggersStorage.Companion.getInstance().getSnapshot();
        this.myDebuggersModificationCount = this.myDebuggersState.getModificationCount();
        for (CLionDapDebuggerSettings debugger : this.myDebuggersState.getDebuggers()) {
            MasterDetailsComponent.MyNode myNode = DapDebuggersMasterDetails.createDebuggerNode$default(this, debugger, false, 2, null);
            MasterDetailsComponent.MyNode myNode2 = this.myRoot;
            Intrinsics.checkNotNullExpressionValue((Object)myNode2, (String)"myRoot");
            this.addNode(myNode, myNode2);
        }
        super.reset();
    }

    public void apply() {
        super.apply();
        CollectionsKt.sortWith(this.myDebuggersState.getDebuggers(), (Comparator)new DebuggerComparator());
        CLionDapDebuggersStorage.Companion.getInstance().save(this.myDebuggersState);
        this.myDebuggersModificationCount = this.myDebuggersState.getModificationCount();
    }

    protected boolean wasObjectStored(@Nullable Object editableObject) {
        return true;
    }

    public void disposeUIResources() {
        super.disposeUIResources();
        Disposer.dispose((Disposable)this.myDisposable);
    }

    protected void onItemDeleted(@Nullable Object item) {
        CLionDapDebuggerSettings cLionDapDebuggerSettings = item instanceof CLionDapDebuggerSettings ? (CLionDapDebuggerSettings)((Object)item) : null;
        if (cLionDapDebuggerSettings == null) {
            return;
        }
        CLionDapDebuggerSettings deletedDebugger = cLionDapDebuggerSettings;
        CLionDapDebuggersStorageKt.deleteDebugger(this.myDebuggersState, deletedDebugger.getId());
    }

    public boolean isModified() {
        return super.isModified() || this.myDebuggersModificationCount != this.myDebuggersState.getModificationCount();
    }

    protected void addNode(@NotNull MasterDetailsComponent.MyNode nodeToAdd, @NotNull MasterDetailsComponent.MyNode parent) {
        Intrinsics.checkNotNullParameter((Object)nodeToAdd, (String)"nodeToAdd");
        Intrinsics.checkNotNullParameter((Object)parent, (String)"parent");
        ((Map)this.myDebuggerPositions).put(this.getNotNullId(this.getDebugger(nodeToAdd)), this.myDebuggerPositions.size());
        super.addNode(nodeToAdd, parent);
    }

    protected void removeNodes(@NotNull List<? extends MasterDetailsComponent.MyNode> nodes) {
        Intrinsics.checkNotNullParameter(nodes, (String)"nodes");
        super.removeNodes(nodes);
        Iterable $this$forEach$iv = nodes;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            MasterDetailsComponent.MyNode it = (MasterDetailsComponent.MyNode)element$iv;
            boolean bl = false;
            this.myDebuggerPositions.remove(this.getNotNullId(this.getDebugger(it)));
        }
        List sorted = CollectionsKt.sortedWith((Iterable)this.myDebuggersState.getDebuggers(), (Comparator)new DebuggerComparator());
        this.myDebuggerPositions.clear();
        for (CLionDapDebuggerSettings debugger : sorted) {
            ((Map)this.myDebuggerPositions).put(this.getNotNullId(debugger), this.myDebuggerPositions.size());
        }
    }

    @NotNull
    protected Comparator<MasterDetailsComponent.MyNode> getNodeComparator() {
        DebuggerComparator debuggerComparator = new DebuggerComparator();
        return (arg_0, arg_1) -> DapDebuggersMasterDetails.getNodeComparator$lambda$0(debuggerComparator, this, arg_0, arg_1);
    }

    private final CLionDapDebuggerSettings getDebugger(MasterDetailsComponent.MyNode $this$debugger) {
        NamedConfigurable $this$asSafely$iv = $this$debugger.getConfigurable();
        boolean $i$f$asSafely = false;
        NamedConfigurable namedConfigurable = $this$asSafely$iv;
        if (!(namedConfigurable instanceof DapDebuggerConfigurable)) {
            namedConfigurable = null;
        }
        DapDebuggerConfigurable dapDebuggerConfigurable = (DapDebuggerConfigurable)namedConfigurable;
        Intrinsics.checkNotNull((Object)((Object)dapDebuggerConfigurable));
        return dapDebuggerConfigurable.getEditableObject();
    }

    private final String getNotNullId(CLionDapDebuggerSettings $this$notNullId) {
        String string = $this$notNullId.getId();
        if (string == null) {
            string = "";
        }
        return string;
    }

    private final MasterDetailsComponent.MyNode createDebuggerNode(CLionDapDebuggerSettings debugger, boolean isNewDebugger) {
        Runnable runnable = this.TREE_UPDATER;
        Intrinsics.checkNotNullExpressionValue((Object)runnable, (String)"TREE_UPDATER");
        DapDebuggerConfigurable debuggerConfigurable = new DapDebuggerConfigurable(this.myDebuggersState, this.myDisposable, runnable, debugger, isNewDebugger);
        MasterDetailsComponent.MyNode node = new MasterDetailsComponent.MyNode((NamedConfigurable)debuggerConfigurable);
        return node;
    }

    static /* synthetic */ MasterDetailsComponent.MyNode createDebuggerNode$default(DapDebuggersMasterDetails dapDebuggersMasterDetails, CLionDapDebuggerSettings cLionDapDebuggerSettings, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            bl = false;
        }
        return dapDebuggersMasterDetails.createDebuggerNode(cLionDapDebuggerSettings, bl);
    }

    private final void createNewDebugger() {
        CLionDapDebuggerSettings newDebugger = CLionDapDebuggersStorageKt.createDebugger(this.myDebuggersState, (Function1<? super CLionDapDebuggerSettings, Unit>)((Function1)DapDebuggersMasterDetails::createNewDebugger$lambda$0));
        MasterDetailsComponent.MyNode node = this.createDebuggerNode(newDebugger, true);
        MasterDetailsComponent.MyNode myNode = this.myRoot;
        Intrinsics.checkNotNullExpressionValue((Object)myNode, (String)"myRoot");
        this.addNode(node, myNode);
        this.selectNodeInTree((DefaultMutableTreeNode)node);
    }

    private static final void _init_$lambda$0(DapDebuggersMasterDetails this$0, ActionEvent it) {
        this$0.createNewDebugger();
    }

    private static final int getNodeComparator$lambda$0(DebuggerComparator $debuggerComparator, DapDebuggersMasterDetails this$0, MasterDetailsComponent.MyNode o1, MasterDetailsComponent.MyNode o2) {
        Intrinsics.checkNotNull((Object)o1);
        CLionDapDebuggerSettings cLionDapDebuggerSettings = this$0.getDebugger(o1);
        Intrinsics.checkNotNull((Object)o2);
        return $debuggerComparator.compare(cLionDapDebuggerSettings, this$0.getDebugger(o2));
    }

    private static final Unit createNewDebugger$lambda$0(CLionDapDebuggerSettings $this$createDebugger) {
        Intrinsics.checkNotNullParameter((Object)((Object)$this$createDebugger), (String)"$this$createDebugger");
        $this$createDebugger.setLaunchParameters(StringsKt.trimIndent((String)("\n          {\n            \"program\": \"" + CLionDapMacrosKt.macroReference("Executable") + "\",\n            \"cwd\": \"" + CLionDapMacrosKt.macroReference("WorkingDir") + "\",\n            \"args\": " + CLionDapMacrosKt.macroReference("Arguments") + ",\n            \"env\": " + CLionDapMacrosKt.macroReference("Environment") + "\n          }\n        ")));
        $this$createDebugger.setAttachParameters(StringsKt.trimIndent((String)("\n          {\n            \"pid\": " + CLionDapMacrosKt.macroReference("Pid") + "\n          }\n        ")));
        return Unit.INSTANCE;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0004\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016\u00a8\u0006\b"}, d2={"Lcom/intellij/clion/toolchains/debugger/DapDebuggersMasterDetails$AddDapDebuggerAction;", "Lcom/intellij/openapi/project/DumbAwareAction;", "<init>", "(Lcom/intellij/clion/toolchains/debugger/DapDebuggersMasterDetails;)V", "actionPerformed", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "intellij.clion.toolchains.debugger"})
    public final class AddDapDebuggerAction
    extends DumbAwareAction {
        public AddDapDebuggerAction() {
            super(ToolchainsDebuggerBundle.INSTANCE.message("configurable.dap.debugger.add", new Object[0]), null, AllIcons.General.Add);
            this.registerCustomShortcutSet(CommonShortcuts.getNew(), (JComponent)DapDebuggersMasterDetails.this.myTree);
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            Intrinsics.checkNotNullParameter((Object)e, (String)"e");
            DapDebuggersMasterDetails.this.createNewDebugger();
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0004\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u0010\u0010\b\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\b\u0010\t\u001a\u00020\nH\u0016\u00a8\u0006\u000b"}, d2={"Lcom/intellij/clion/toolchains/debugger/DapDebuggersMasterDetails$CopyDapDebuggerAction;", "Lcom/intellij/openapi/project/DumbAwareAction;", "<init>", "(Lcom/intellij/clion/toolchains/debugger/DapDebuggersMasterDetails;)V", "actionPerformed", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "update", "getActionUpdateThread", "Lcom/intellij/openapi/actionSystem/ActionUpdateThread;", "intellij.clion.toolchains.debugger"})
    @SourceDebugExtension(value={"SMAP\nDapDebuggersConfigurable.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DapDebuggersConfigurable.kt\ncom/intellij/clion/toolchains/debugger/DapDebuggersMasterDetails$CopyDapDebuggerAction\n+ 2 KtUtils.kt\ncom/intellij/util/KotlinUtils\n*L\n1#1,625:1\n19#2:626\n19#2:627\n*S KotlinDebug\n*F\n+ 1 DapDebuggersConfigurable.kt\ncom/intellij/clion/toolchains/debugger/DapDebuggersMasterDetails$CopyDapDebuggerAction\n*L\n224#1:626\n234#1:627\n*E\n"})
    public final class CopyDapDebuggerAction
    extends DumbAwareAction {
        public CopyDapDebuggerAction() {
            super(ToolchainsDebuggerBundle.INSTANCE.message("configurable.dap.debugger.copy", new Object[0]), null, AllIcons.General.Copy);
            this.registerCustomShortcutSet(CommonShortcuts.getDuplicate(), (JComponent)DapDebuggersMasterDetails.this.myTree);
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            DapDebuggerConfigurable selectedConfigurable;
            Intrinsics.checkNotNullParameter((Object)e, (String)"e");
            MasterDetailsComponent.MyNode myNode = DapDebuggersMasterDetails.this.getSelectedNode();
            NamedConfigurable $this$asSafely$iv = myNode != null ? myNode.getConfigurable() : null;
            boolean $i$f$asSafely = false;
            NamedConfigurable namedConfigurable = $this$asSafely$iv;
            if (!(namedConfigurable instanceof DapDebuggerConfigurable)) {
                namedConfigurable = null;
            }
            DapDebuggerConfigurable dapDebuggerConfigurable = selectedConfigurable = (DapDebuggerConfigurable)namedConfigurable;
            boolean bl = dapDebuggerConfigurable != null ? dapDebuggerConfigurable.isValid() : false;
            if (bl) {
                CLionDapDebuggerSettings newDebugger = CLionDapDebuggersStorageKt.createDebugger(DapDebuggersMasterDetails.this.myDebuggersState, selectedConfigurable.getEditableObject());
                MasterDetailsComponent.MyNode node = DapDebuggersMasterDetails.createDebuggerNode$default(DapDebuggersMasterDetails.this, newDebugger, false, 2, null);
                MasterDetailsComponent.MyNode myNode2 = DapDebuggersMasterDetails.this.myRoot;
                Intrinsics.checkNotNullExpressionValue((Object)myNode2, (String)"access$getMyRoot$p$s785450369(...)");
                DapDebuggersMasterDetails.this.addNode(node, myNode2);
                DapDebuggersMasterDetails.this.selectNodeInTree((DefaultMutableTreeNode)node);
            }
        }

        public void update(@NotNull AnActionEvent e) {
            Intrinsics.checkNotNullParameter((Object)e, (String)"e");
            MasterDetailsComponent.MyNode myNode = DapDebuggersMasterDetails.this.getSelectedNode();
            NamedConfigurable $this$asSafely$iv = myNode != null ? myNode.getConfigurable() : null;
            boolean $i$f$asSafely = false;
            NamedConfigurable namedConfigurable = $this$asSafely$iv;
            if (!(namedConfigurable instanceof DapDebuggerConfigurable)) {
                namedConfigurable = null;
            }
            DapDebuggerConfigurable dapDebuggerConfigurable = (DapDebuggerConfigurable)namedConfigurable;
            boolean selectedDebuggerIsValid = dapDebuggerConfigurable != null ? dapDebuggerConfigurable.isValid() : false;
            e.getPresentation().setEnabled(selectedDebuggerIsValid);
        }

        @NotNull
        public ActionUpdateThread getActionUpdateThread() {
            return ActionUpdateThread.BGT;
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0003\b\u0086\u0004\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0018\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00022\u0006\u0010\b\u001a\u00020\u0002H\u0016\u00a8\u0006\t"}, d2={"Lcom/intellij/clion/toolchains/debugger/DapDebuggersMasterDetails$DebuggerComparator;", "Ljava/util/Comparator;", "Lcom/intellij/clion/toolchains/debugger/CLionDapDebuggerSettings;", "<init>", "(Lcom/intellij/clion/toolchains/debugger/DapDebuggersMasterDetails;)V", "compare", "", "o1", "o2", "intellij.clion.toolchains.debugger"})
    public final class DebuggerComparator
    implements Comparator<CLionDapDebuggerSettings> {
        @Override
        public int compare(@NotNull CLionDapDebuggerSettings o1, @NotNull CLionDapDebuggerSettings o2) {
            Intrinsics.checkNotNullParameter((Object)((Object)o1), (String)"o1");
            Intrinsics.checkNotNullParameter((Object)((Object)o2), (String)"o2");
            Integer n = (Integer)DapDebuggersMasterDetails.this.myDebuggerPositions.get(DapDebuggersMasterDetails.this.getNotNullId(o1));
            int index1 = n != null ? n : 0;
            Integer n2 = (Integer)DapDebuggersMasterDetails.this.myDebuggerPositions.get(DapDebuggersMasterDetails.this.getNotNullId(o2));
            int index2 = n2 != null ? n2 : 0;
            return Intrinsics.compare((int)index1, (int)index2);
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0004\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u0010\u0010\b\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\b\u0010\t\u001a\u00020\nH\u0016\u00a8\u0006\u000b"}, d2={"Lcom/intellij/clion/toolchains/debugger/DapDebuggersMasterDetails$MoveDownDapDebuggerAction;", "Lcom/intellij/openapi/project/DumbAwareAction;", "<init>", "(Lcom/intellij/clion/toolchains/debugger/DapDebuggersMasterDetails;)V", "actionPerformed", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "update", "getActionUpdateThread", "Lcom/intellij/openapi/actionSystem/ActionUpdateThread;", "intellij.clion.toolchains.debugger"})
    @SourceDebugExtension(value={"SMAP\nDapDebuggersConfigurable.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DapDebuggersConfigurable.kt\ncom/intellij/clion/toolchains/debugger/DapDebuggersMasterDetails$MoveDownDapDebuggerAction\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,625:1\n1#2:626\n*E\n"})
    public final class MoveDownDapDebuggerAction
    extends DumbAwareAction {
        public MoveDownDapDebuggerAction() {
            super(ToolchainsDebuggerBundle.INSTANCE.message("configurable.dap.debugger.move.down", new Object[0]), null, AllIcons.Actions.MoveDown);
            this.registerCustomShortcutSet(CommonShortcuts.MOVE_DOWN, (JComponent)DapDebuggersMasterDetails.this.myTree);
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            Object v5;
            int currentPosition;
            String selectedDebuggerId;
            MasterDetailsComponent.MyNode node;
            block4: {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                MasterDetailsComponent.MyNode myNode = DapDebuggersMasterDetails.this.getSelectedNode();
                if (myNode == null) {
                    return;
                }
                node = myNode;
                selectedDebuggerId = DapDebuggersMasterDetails.this.getNotNullId(DapDebuggersMasterDetails.this.getDebugger(node));
                int lastPosition = DapDebuggersMasterDetails.this.myDebuggerPositions.size() - 1;
                Integer n = (Integer)DapDebuggersMasterDetails.this.myDebuggerPositions.get(selectedDebuggerId);
                int n2 = currentPosition = n != null ? n : lastPosition;
                if (currentPosition == lastPosition) {
                    return;
                }
                Set set = DapDebuggersMasterDetails.this.myDebuggerPositions.keySet();
                Intrinsics.checkNotNullExpressionValue(set, (String)"<get-keys>(...)");
                Iterable iterable = set;
                DapDebuggersMasterDetails dapDebuggersMasterDetails = DapDebuggersMasterDetails.this;
                Iterable iterable2 = iterable;
                for (Object t : iterable2) {
                    String it = (String)t;
                    boolean bl = false;
                    Integer n3 = (Integer)dapDebuggersMasterDetails.myDebuggerPositions.get(it);
                    int n4 = currentPosition + 1;
                    if (!(n3 != null && n3 == n4)) continue;
                    v5 = t;
                    break block4;
                }
                v5 = null;
            }
            String string = v5;
            if (string == null) {
                return;
            }
            String nextDebuggerId = string;
            ((Map)DapDebuggersMasterDetails.this.myDebuggerPositions).put(selectedDebuggerId, currentPosition + 1);
            ((Map)DapDebuggersMasterDetails.this.myDebuggerPositions).put(nextDebuggerId, currentPosition);
            long l = DapDebuggersMasterDetails.this.myDebuggersModificationCount;
            DapDebuggersMasterDetails.this.myDebuggersModificationCount = l + 1L;
            DapDebuggersMasterDetails.this.sortDescendants(DapDebuggersMasterDetails.this.myRoot);
            DapDebuggersMasterDetails.this.selectNodeInTree((DefaultMutableTreeNode)node);
        }

        public void update(@NotNull AnActionEvent e) {
            int n;
            CLionDapDebuggerSettings cLionDapDebuggerSettings;
            Intrinsics.checkNotNullParameter((Object)e, (String)"e");
            MasterDetailsComponent.MyNode myNode = DapDebuggersMasterDetails.this.getSelectedNode();
            String debuggerId = myNode != null && (cLionDapDebuggerSettings = DapDebuggersMasterDetails.this.getDebugger(myNode)) != null ? DapDebuggersMasterDetails.this.getNotNullId(cLionDapDebuggerSettings) : null;
            int lastPosition = DapDebuggersMasterDetails.this.myDebuggerPositions.size() - 1;
            if (debuggerId != null) {
                Integer n2 = (Integer)DapDebuggersMasterDetails.this.myDebuggerPositions.get(debuggerId);
                n = n2 != null ? n2 : lastPosition;
            } else {
                n = lastPosition;
            }
            int position = n;
            e.getPresentation().setEnabled(position < lastPosition);
        }

        @NotNull
        public ActionUpdateThread getActionUpdateThread() {
            return ActionUpdateThread.EDT;
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0004\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u0010\u0010\b\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\b\u0010\t\u001a\u00020\nH\u0016\u00a8\u0006\u000b"}, d2={"Lcom/intellij/clion/toolchains/debugger/DapDebuggersMasterDetails$MoveUpDapDebuggerAction;", "Lcom/intellij/openapi/project/DumbAwareAction;", "<init>", "(Lcom/intellij/clion/toolchains/debugger/DapDebuggersMasterDetails;)V", "actionPerformed", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "update", "getActionUpdateThread", "Lcom/intellij/openapi/actionSystem/ActionUpdateThread;", "intellij.clion.toolchains.debugger"})
    @SourceDebugExtension(value={"SMAP\nDapDebuggersConfigurable.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DapDebuggersConfigurable.kt\ncom/intellij/clion/toolchains/debugger/DapDebuggersMasterDetails$MoveUpDapDebuggerAction\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,625:1\n1#2:626\n*E\n"})
    public final class MoveUpDapDebuggerAction
    extends DumbAwareAction {
        public MoveUpDapDebuggerAction() {
            super(ToolchainsDebuggerBundle.INSTANCE.message("configurable.dap.debugger.move.up", new Object[0]), null, AllIcons.Actions.MoveUp);
            this.registerCustomShortcutSet(CommonShortcuts.MOVE_UP, (JComponent)DapDebuggersMasterDetails.this.myTree);
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            Object v5;
            int currentPosition;
            String selectedDebuggerId;
            MasterDetailsComponent.MyNode node;
            block4: {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                MasterDetailsComponent.MyNode myNode = DapDebuggersMasterDetails.this.getSelectedNode();
                if (myNode == null) {
                    return;
                }
                node = myNode;
                selectedDebuggerId = DapDebuggersMasterDetails.this.getNotNullId(DapDebuggersMasterDetails.this.getDebugger(node));
                Integer n = (Integer)DapDebuggersMasterDetails.this.myDebuggerPositions.get(selectedDebuggerId);
                int n2 = currentPosition = n != null ? n : 0;
                if (currentPosition == 0) {
                    return;
                }
                Set set = DapDebuggersMasterDetails.this.myDebuggerPositions.keySet();
                Intrinsics.checkNotNullExpressionValue(set, (String)"<get-keys>(...)");
                Iterable iterable = set;
                DapDebuggersMasterDetails dapDebuggersMasterDetails = DapDebuggersMasterDetails.this;
                Iterable iterable2 = iterable;
                for (Object t : iterable2) {
                    String it = (String)t;
                    boolean bl = false;
                    Integer n3 = (Integer)dapDebuggersMasterDetails.myDebuggerPositions.get(it);
                    int n4 = currentPosition - 1;
                    if (!(n3 != null && n3 == n4)) continue;
                    v5 = t;
                    break block4;
                }
                v5 = null;
            }
            String string = v5;
            if (string == null) {
                return;
            }
            String previousDebuggerId = string;
            ((Map)DapDebuggersMasterDetails.this.myDebuggerPositions).put(selectedDebuggerId, currentPosition - 1);
            ((Map)DapDebuggersMasterDetails.this.myDebuggerPositions).put(previousDebuggerId, currentPosition);
            long l = DapDebuggersMasterDetails.this.myDebuggersModificationCount;
            DapDebuggersMasterDetails.this.myDebuggersModificationCount = l + 1L;
            DapDebuggersMasterDetails.this.sortDescendants(DapDebuggersMasterDetails.this.myRoot);
            DapDebuggersMasterDetails.this.selectNodeInTree((DefaultMutableTreeNode)node);
        }

        public void update(@NotNull AnActionEvent e) {
            int n;
            CLionDapDebuggerSettings cLionDapDebuggerSettings;
            Intrinsics.checkNotNullParameter((Object)e, (String)"e");
            MasterDetailsComponent.MyNode myNode = DapDebuggersMasterDetails.this.getSelectedNode();
            String debuggerId = myNode != null && (cLionDapDebuggerSettings = DapDebuggersMasterDetails.this.getDebugger(myNode)) != null ? DapDebuggersMasterDetails.this.getNotNullId(cLionDapDebuggerSettings) : null;
            if (debuggerId != null) {
                Integer n2 = (Integer)DapDebuggersMasterDetails.this.myDebuggerPositions.get(debuggerId);
                n = n2 != null ? n2 : 0;
            } else {
                n = 0;
            }
            int position = n;
            e.getPresentation().setEnabled(position > 0);
        }

        @NotNull
        public ActionUpdateThread getActionUpdateThread() {
            return ActionUpdateThread.EDT;
        }
    }
}

