/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.clion.toolchains.debugger;

import com.google.gson.Gson;
import com.google.gson.JsonParseException;
import com.google.gson.ToNumberPolicy;
import com.google.gson.ToNumberStrategy;
import com.intellij.clion.toolchains.debugger.ToolchainsDebuggerBundle;
import com.intellij.execution.ExecutionException;
import java.util.LinkedHashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u0000\u001c\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\u001a\u001a\u0010\u0000\u001a\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u00012\u0006\u0010\u0004\u001a\u00020\u0002\u001a\u0016\u0010\u0005\u001a\u0004\u0018\u00010\u00022\n\u0010\u0006\u001a\u00060\u0007j\u0002`\bH\u0002\u00a8\u0006\t"}, d2={"parseJson", "", "", "", "json", "extractJsonParsingError", "e", "Ljava/lang/Exception;", "Lkotlin/Exception;", "intellij.clion.toolchains.debugger"})
public final class CLionDapUtilKt {
    @NotNull
    public static final Map<String, Object> parseJson(@NotNull String json) throws ExecutionException {
        Map map;
        Intrinsics.checkNotNullParameter((Object)json, (String)"json");
        try {
            map = (Map)new Gson().newBuilder().setObjectToNumberStrategy((ToNumberStrategy)ToNumberPolicy.LONG_OR_DOUBLE).create().fromJson(json, Map.class);
        }
        catch (Exception e) {
            String string;
            block8: {
                block7: {
                    String parsingError = CLionDapUtilKt.extractJsonParsingError(e);
                    string = parsingError;
                    if (string == null) break block7;
                    String it = string;
                    boolean bl = false;
                    Object[] objectArray = new Object[]{it};
                    String string2 = ToolchainsDebuggerBundle.INSTANCE.message("error.invalid.launch.parameters.details", objectArray);
                    string = string2;
                    if (string2 != null) break block8;
                }
                string = ToolchainsDebuggerBundle.INSTANCE.message("error.invalid.launch.parameters", new Object[0]);
            }
            String message = string;
            throw new ExecutionException(message);
        }
        Map parsed = map;
        Map result2 = new LinkedHashMap();
        if (parsed == null) {
            return result2;
        }
        for (Map.Entry entry : parsed.entrySet()) {
            Object key = entry.getKey();
            Object value = entry.getValue();
            if (value == null) continue;
            result2.put(String.valueOf(key), value);
        }
        return result2;
    }

    private static final String extractJsonParsingError(Exception e) {
        if (e instanceof JsonParseException) {
            String rootCauseMessage = e.getMessage();
            for (Throwable cause = e.getCause(); cause != null; cause = cause.getCause()) {
                if (cause.getMessage() == null) continue;
                rootCauseMessage = cause.getMessage();
            }
            if (rootCauseMessage == null) {
                return null;
            }
            int linkIndex = StringsKt.indexOf$default((CharSequence)rootCauseMessage, (String)"See https://github.com/google", (int)0, (boolean)false, (int)6, null);
            if (linkIndex != -1) {
                rootCauseMessage = ((Object)StringsKt.trim((CharSequence)StringsKt.take((String)rootCauseMessage, (int)linkIndex))).toString();
            }
            return rootCauseMessage;
        }
        return e.getMessage();
    }
}

