/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.clion.toolchains.debugger;

import com.intellij.clion.toolchains.debugger.CLionDapDebuggerSettings;
import com.intellij.clion.toolchains.debugger.CLionDapDebuggersStorage;
import com.intellij.clion.toolchains.debugger.CLionDapUsagesCollector;
import com.intellij.clion.toolchains.debugger.CLionDapUsagesCollectorKt;
import com.intellij.internal.statistic.beans.MetricEvent;
import com.intellij.internal.statistic.eventLog.EventLogGroup;
import com.intellij.internal.statistic.service.fus.collectors.ApplicationUsagesCollector;
import java.nio.file.InvalidPathException;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.io.path.PathsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u0004\u001a\u00020\u0005H\u0016J\u000e\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007H\u0016J\u0012\u0010\t\u001a\u00020\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\nH\u0002\u00a8\u0006\f"}, d2={"Lcom/intellij/clion/toolchains/debugger/CLionDapUsagesCollector;", "Lcom/intellij/internal/statistic/service/fus/collectors/ApplicationUsagesCollector;", "<init>", "()V", "getGroup", "Lcom/intellij/internal/statistic/eventLog/EventLogGroup;", "getMetrics", "", "Lcom/intellij/internal/statistic/beans/MetricEvent;", "getDebuggerKind", "", "debuggerPath", "intellij.clion.toolchains.debugger"})
public final class CLionDapUsagesCollector
extends ApplicationUsagesCollector {
    @NotNull
    public EventLogGroup getGroup() {
        return CLionDapUsagesCollectorKt.getGROUP();
    }

    @NotNull
    public Set<MetricEvent> getMetrics() {
        HashSet<MetricEvent> result2 = new HashSet<MetricEvent>();
        List<CLionDapDebuggerSettings> dapDebuggers = CLionDapDebuggersStorage.Companion.getInstance().getDebuggers();
        result2.add(CLionDapUsagesCollectorKt.getDEBUGGERS().metric((Object)dapDebuggers.size()));
        HashMap<String, Integer> debuggerKindCount = new HashMap<String, Integer>();
        for (CLionDapDebuggerSettings entry : dapDebuggers) {
            String debuggerKind = this.getDebuggerKind(entry.getDebuggerExecutable());
            debuggerKindCount.merge(debuggerKind, 1, (arg_0, arg_1) -> CLionDapUsagesCollector.getMetrics$lambda$0(getMetrics.1.INSTANCE, arg_0, arg_1));
        }
        for (Map.Entry entry : ((Map)debuggerKindCount).entrySet()) {
            String kind = (String)entry.getKey();
            int count = ((Number)entry.getValue()).intValue();
            result2.add(CLionDapUsagesCollectorKt.getDEBUGGER().metric((Object)kind, (Object)count));
        }
        return result2;
    }

    private final String getDebuggerKind(String debuggerPath) {
        CharSequence charSequence = debuggerPath;
        if (charSequence == null || charSequence.length() == 0) {
            return "invalidPath";
        }
        try {
            Path path = Path.of(debuggerPath, new String[0]);
            Intrinsics.checkNotNull((Object)path);
            String executableName = StringsKt.removeSuffix((String)PathsKt.getName((Path)path), (CharSequence)".exe");
            String debuggerKind = Intrinsics.areEqual((Object)executableName, (Object)"gdb") || StringsKt.contains$default((CharSequence)executableName, (CharSequence)"-gdb", (boolean)false, (int)2, null) ? "gdb" : (StringsKt.contains$default((CharSequence)executableName, (CharSequence)"lldb-dap", (boolean)false, (int)2, null) ? "lldb-dap" : (Intrinsics.areEqual((Object)executableName, (Object)"codelldb") ? "codelldb" : "other"));
            return debuggerKind;
        }
        catch (InvalidPathException invalidPathException) {
            return "invalidPath";
        }
    }

    private static final Integer getMetrics$lambda$0(Function2 $tmp0, Object p0, Object p1) {
        return (Integer)$tmp0.invoke(p0, p1);
    }
}

