/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.clion.toolchains.debugger;

import com.intellij.clion.toolchains.debugger.CLionDapDebuggerSettings;
import com.intellij.clion.toolchains.debugger.CLionDapMacrosKt;
import com.intellij.clion.toolchains.debugger.CLionDapUtilKt;
import com.intellij.clion.toolchains.debugger.ToolchainsDebuggerBundle;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.openapi.project.Project;
import com.intellij.util.execution.ParametersListUtil;
import com.jetbrains.cidr.ArchitectureType;
import com.jetbrains.cidr.execution.debugger.CidrDebuggerLog;
import com.jetbrains.cidr.execution.debugger.backend.DebuggerDriver;
import com.jetbrains.cidr.execution.debugger.backend.dap.DapDriverConfiguration;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B'\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\u0007\u00a2\u0006\u0004\b\t\u0010\nJ\u001c\u0010\r\u001a\u000e\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020\u00100\u000e2\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J\u001c\u0010\u0013\u001a\u000e\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020\u00100\u000e2\u0006\u0010\u0014\u001a\u00020\u0015H\u0016J;\u0010\u0016\u001a\u000e\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020\u00100\u000e2\b\u0010\u0017\u001a\u0004\u0018\u00010\u000f2\n\b\u0002\u0010\u0011\u001a\u0004\u0018\u00010\u00122\n\b\u0002\u0010\u0014\u001a\u0004\u0018\u00010\u0015H\u0002\u00a2\u0006\u0002\u0010\u0018J\u0018\u0010\u0019\u001a\u00020\u00122\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001dH\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\u001e"}, d2={"Lcom/intellij/clion/toolchains/debugger/CLionDapDriverConfiguration;", "Lcom/jetbrains/cidr/execution/debugger/backend/dap/DapDriverConfiguration;", "settings", "Lcom/intellij/clion/toolchains/debugger/CLionDapDebuggerSettings;", "project", "Lcom/intellij/openapi/project/Project;", "isElevated", "", "isEmulateTerminal", "<init>", "(Lcom/intellij/clion/toolchains/debugger/CLionDapDebuggerSettings;Lcom/intellij/openapi/project/Project;ZZ)V", "getSettings", "()Lcom/intellij/clion/toolchains/debugger/CLionDapDebuggerSettings;", "getDapLaunchOptions", "", "", "", "inferiorCmd", "Lcom/intellij/execution/configurations/GeneralCommandLine;", "getDapAttachOptions", "pid", "", "getDapOptions", "jsonFromSettings", "(Ljava/lang/String;Lcom/intellij/execution/configurations/GeneralCommandLine;Ljava/lang/Integer;)Ljava/util/Map;", "createDriverCommandLine", "driver", "Lcom/jetbrains/cidr/execution/debugger/backend/DebuggerDriver;", "architectureType", "Lcom/jetbrains/cidr/ArchitectureType;", "intellij.clion.toolchains.debugger"})
public final class CLionDapDriverConfiguration
extends DapDriverConfiguration {
    @NotNull
    private final CLionDapDebuggerSettings settings;

    public CLionDapDriverConfiguration(@NotNull CLionDapDebuggerSettings settings, @NotNull Project project, boolean isElevated, boolean isEmulateTerminal) {
        Intrinsics.checkNotNullParameter((Object)((Object)settings), (String)"settings");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        super(project, "clion.dap.debugger", isElevated, isEmulateTerminal);
        this.settings = settings;
    }

    @NotNull
    public final CLionDapDebuggerSettings getSettings() {
        return this.settings;
    }

    @NotNull
    public Map<String, Object> getDapLaunchOptions(@NotNull GeneralCommandLine inferiorCmd) {
        Intrinsics.checkNotNullParameter((Object)inferiorCmd, (String)"inferiorCmd");
        return CLionDapDriverConfiguration.getDapOptions$default(this, this.settings.getLaunchParameters(), inferiorCmd, null, 4, null);
    }

    @NotNull
    public Map<String, Object> getDapAttachOptions(int pid) {
        return CLionDapDriverConfiguration.getDapOptions$default(this, this.settings.getAttachParameters(), null, pid, 2, null);
    }

    private final Map<String, Object> getDapOptions(String jsonFromSettings, GeneralCommandLine inferiorCmd, Integer pid) {
        String string = jsonFromSettings;
        if (string == null || (string = ((Object)StringsKt.trim((CharSequence)string)).toString()) == null) {
            string = "";
        }
        String json = string;
        String expandedJson = CLionDapMacrosKt.expandDapMacros(json, inferiorCmd, pid);
        CidrDebuggerLog.LOG.debug("DAP debugger parameters '" + json + "' are expanded to '" + expandedJson + "'");
        Map<String, Object> options = CLionDapUtilKt.parseJson(expandedJson);
        return options;
    }

    static /* synthetic */ Map getDapOptions$default(CLionDapDriverConfiguration cLionDapDriverConfiguration, String string, GeneralCommandLine generalCommandLine, Integer n, int n2, Object object) {
        if ((n2 & 2) != 0) {
            generalCommandLine = null;
        }
        if ((n2 & 4) != 0) {
            n = null;
        }
        return cLionDapDriverConfiguration.getDapOptions(string, generalCommandLine, n);
    }

    @NotNull
    public GeneralCommandLine createDriverCommandLine(@NotNull DebuggerDriver driver, @NotNull ArchitectureType architectureType) throws ExecutionException {
        Object object;
        String debuggerExecutable;
        block5: {
            block4: {
                Intrinsics.checkNotNullParameter((Object)driver, (String)"driver");
                Intrinsics.checkNotNullParameter((Object)architectureType, (String)"architectureType");
                String string = this.settings.getDebuggerExecutable();
                debuggerExecutable = string != null ? ((Object)StringsKt.trim((CharSequence)string)).toString() : null;
                CharSequence charSequence = debuggerExecutable;
                if (charSequence == null || charSequence.length() == 0) {
                    throw new ExecutionException(ToolchainsDebuggerBundle.INSTANCE.message("error.dap.debugger.command.is.missing", new Object[0]));
                }
                object = this.settings.getDebuggerArguments();
                if (object == null || (object = ((Object)StringsKt.trim((CharSequence)((CharSequence)object))).toString()) == null) break block4;
                Object it = object;
                boolean bl = false;
                List list = ParametersListUtil.parse((String)it);
                object = list;
                if (list != null) break block5;
            }
            object = CollectionsKt.emptyList();
        }
        Object debuggerArguments = object;
        GeneralCommandLine generalCommandLine = new GeneralCommandLine().withExePath(debuggerExecutable).withParameters((List)debuggerArguments);
        Intrinsics.checkNotNullExpressionValue((Object)generalCommandLine, (String)"withParameters(...)");
        return generalCommandLine;
    }
}

