/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.clion.toolchains.debugger;

import com.intellij.clion.toolchains.debugger.CLionDapDebuggerSettings;
import com.intellij.clion.toolchains.debugger.CLionDapDebuggersState;
import com.intellij.clion.toolchains.debugger.CLionDapDebuggersStorageKt;
import com.intellij.codeWithMe.ClientId;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.BaseState;
import com.intellij.openapi.components.RoamingType;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.components.SimplePersistentStateComponent;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.Storage;
import com.jetbrains.cidr.cpp.toolchains.CLionToolchainDebuggerListener;
import com.jetbrains.cidr.cpp.toolchains.CLionToolchainDebuggerProvider;
import java.util.List;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@Service
@State(name="CLion DAP Debuggers", storages={@Storage(value="clionDapDebuggers.xml", roamingType=RoamingType.PER_OS)})
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0007\u0018\u0000 \u000f2\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\u000fB\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0006\u0010\u0007\u001a\u00020\u0002J\u000e\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u0002J\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\fJ\b\u0010\u000e\u001a\u00020\tH\u0002R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lcom/intellij/clion/toolchains/debugger/CLionDapDebuggersStorage;", "Lcom/intellij/openapi/components/SimplePersistentStateComponent;", "Lcom/intellij/clion/toolchains/debugger/CLionDapDebuggersState;", "<init>", "()V", "myLock", "Ljava/util/concurrent/locks/ReentrantReadWriteLock;", "getSnapshot", "save", "", "newState", "getDebuggers", "", "Lcom/intellij/clion/toolchains/debugger/CLionDapDebuggerSettings;", "notifyDebuggersUpdated", "Companion", "intellij.clion.toolchains.debugger"})
@ApiStatus.Internal
@ApiStatus.Experimental
public final class CLionDapDebuggersStorage
extends SimplePersistentStateComponent<CLionDapDebuggersState> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final ReentrantReadWriteLock myLock = new ReentrantReadWriteLock();

    public CLionDapDebuggersStorage() {
        super((BaseState)new CLionDapDebuggersState());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public final CLionDapDebuggersState getSnapshot() {
        CLionDapDebuggersState cLionDapDebuggersState;
        ReentrantReadWriteLock.ReadLock readLock = this.myLock.readLock();
        readLock.lock();
        try {
            boolean bl = false;
            cLionDapDebuggersState = CLionDapDebuggersStorageKt.copy((CLionDapDebuggersState)this.getState());
        }
        finally {
            readLock.unlock();
        }
        return cLionDapDebuggersState;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void save(@NotNull CLionDapDebuggersState newState) {
        Intrinsics.checkNotNullParameter((Object)((Object)newState), (String)"newState");
        ReentrantReadWriteLock reentrantReadWriteLock = this.myLock;
        ReentrantReadWriteLock.ReadLock readLock = reentrantReadWriteLock.readLock();
        int n = reentrantReadWriteLock.getWriteHoldCount() == 0 ? reentrantReadWriteLock.getReadHoldCount() : 0;
        for (int i = 0; i < n; ++i) {
            readLock.unlock();
        }
        ReentrantReadWriteLock.WriteLock writeLock = reentrantReadWriteLock.writeLock();
        writeLock.lock();
        try {
            boolean bl = false;
            CLionDapDebuggersStorageKt.apply((CLionDapDebuggersState)this.getState(), newState);
            Unit unit = Unit.INSTANCE;
        }
        finally {
            for (int i = 0; i < n; ++i) {
                readLock.lock();
            }
            writeLock.unlock();
        }
        this.notifyDebuggersUpdated();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public final List<CLionDapDebuggerSettings> getDebuggers() {
        List list;
        ReentrantReadWriteLock.ReadLock readLock = this.myLock.readLock();
        readLock.lock();
        try {
            boolean bl = false;
            list = CollectionsKt.toList((Iterable)((CLionDapDebuggersState)this.getState()).getDebuggers());
        }
        finally {
            readLock.unlock();
        }
        return list;
    }

    private final void notifyDebuggersUpdated() {
        CLionToolchainDebuggerListener publisher = (CLionToolchainDebuggerListener)ApplicationManager.getApplication().getMessageBus().syncPublisher(CLionToolchainDebuggerProvider.TOPIC);
        publisher.debuggersUpdated();
    }

    @JvmStatic
    @NotNull
    public static final CLionDapDebuggersStorage getInstance() {
        return Companion.getInstance();
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u0004\u001a\u00020\u0005H\u0007\u00a8\u0006\u0006"}, d2={"Lcom/intellij/clion/toolchains/debugger/CLionDapDebuggersStorage$Companion;", "", "<init>", "()V", "getInstance", "Lcom/intellij/clion/toolchains/debugger/CLionDapDebuggersStorage;", "intellij.clion.toolchains.debugger"})
    @SourceDebugExtension(value={"SMAP\nCLionDapDebuggersStorage.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CLionDapDebuggersStorage.kt\ncom/intellij/clion/toolchains/debugger/CLionDapDebuggersStorage$Companion\n+ 2 service.kt\ncom/intellij/openapi/components/ServiceKt\n*L\n1#1,150:1\n42#2,3:151\n*S KotlinDebug\n*F\n+ 1 CLionDapDebuggersStorage.kt\ncom/intellij/clion/toolchains/debugger/CLionDapDebuggersStorage$Companion\n*L\n26#1:151,3\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @NotNull
        public final CLionDapDebuggersStorage getInstance() {
            boolean $i$f$service = false;
            Class<CLionDapDebuggersStorage> serviceClass$iv = CLionDapDebuggersStorage.class;
            Object object = ApplicationManager.getApplication().getService(serviceClass$iv);
            if (object == null) {
                throw new RuntimeException("Cannot find service " + serviceClass$iv.getName() + " (classloader=" + serviceClass$iv.getClassLoader() + ", client=" + ClientId.Companion.getCurrentOrNull() + ')');
            }
            return (CLionDapDebuggersStorage)((Object)object);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

