/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.qml.settings;

import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.qml.formatter.QmlFormatModificationTracker;
import com.intellij.lang.qml.psi.impl.QmlImportDeclarationImpl;
import com.intellij.lang.qml.settings.QmlSettingsListener;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.impl.EditorImpl;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.TextEditor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.codeStyle.CodeStyleSettingsManager;
import com.intellij.qt.common.settings.QtSettings;
import com.intellij.qt.common.settings.QtSettingsListener;
import com.intellij.util.FileContentUtilCore;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@State(name="QmlSettings", storages={@Storage(value="qmlSettings.xml")})
public class QmlSettings
implements PersistentStateComponent<StoredState> {
    private final Project myProject;
    private final HashMap<String, HashMap<String, QmlImportDeclarationImpl.QmlComponentTemplate>> myAllComponents;
    private final HashMap<String, HashMap<String, Ref<JSType>>> myAllTypesCache;
    @NotNull
    private final StoredState myState;

    public QmlSettings(@NotNull Project project) {
        if (project == null) {
            QmlSettings.$$$reportNull$$$0(0);
        }
        this.myAllComponents = new HashMap();
        this.myAllTypesCache = new HashMap();
        this.myState = new StoredState();
        this.myProject = project;
        project.getMessageBus().connect().subscribe(QtSettingsListener.TOPIC, (Object)new QtSettingsListener(){

            public void onLastQmlPathChanged(String newPath) {
                QmlSettings.this.resetCaches();
            }

            public void onCurrentProfileChanged(String newProfile) {
                QmlSettings.this.resetCaches();
            }
        });
    }

    private void resetCaches() {
        this.myAllComponents.clear();
        this.myAllTypesCache.clear();
        ((QmlSettingsListener)this.myProject.getMessageBus().syncPublisher(QmlSettingsListener.TOPIC)).onResetImports();
        ApplicationManager.getApplication().invokeLater(() -> {
            for (FileEditor fileEditor : FileEditorManager.getInstance((Project)this.myProject).getAllEditors()) {
                TextEditor textEditor;
                Editor patt0$temp;
                if (!(fileEditor instanceof TextEditor) || !((patt0$temp = (textEditor = (TextEditor)fileEditor).getEditor()) instanceof EditorImpl)) continue;
                EditorImpl editorImpl = (EditorImpl)patt0$temp;
                editorImpl.reinitSettings();
                FileContentUtilCore.reparseFiles((VirtualFile[])new VirtualFile[]{textEditor.getFile()});
            }
        });
    }

    @Nullable
    public StoredState getState() {
        return new StoredState(this.myState);
    }

    @Nullable
    public synchronized HashMap<String, QmlImportDeclarationImpl.QmlComponentTemplate> getComponents(@NotNull String importName) {
        if (importName == null) {
            QmlSettings.$$$reportNull$$$0(1);
        }
        return this.myAllComponents.get(importName);
    }

    @Nullable
    public synchronized HashMap<String, Ref<JSType>> getTypesCache(@NotNull String importName) {
        if (importName == null) {
            QmlSettings.$$$reportNull$$$0(2);
        }
        return this.myAllTypesCache.get(importName);
    }

    public synchronized void putComponents(@NotNull String importName, @NotNull HashMap<String, QmlImportDeclarationImpl.QmlComponentTemplate> components) {
        if (importName == null) {
            QmlSettings.$$$reportNull$$$0(3);
        }
        if (components == null) {
            QmlSettings.$$$reportNull$$$0(4);
        }
        this.myAllComponents.put(importName, components);
    }

    public synchronized void putTypesCache(@NotNull String importName, HashMap<String, Ref<JSType>> typesCache) {
        if (importName == null) {
            QmlSettings.$$$reportNull$$$0(5);
        }
        this.myAllTypesCache.put(importName, typesCache);
    }

    @NotNull
    public static String findQmlLanguageServerPath(@NotNull String binDir) {
        if (binDir == null) {
            QmlSettings.$$$reportNull$$$0(6);
        }
        if (binDir.isEmpty()) {
            return "";
        }
        String lsPath = binDir + "/qmlls" + (SystemInfo.isWindows ? ".exe" : "");
        if (!FileUtil.exists((String)lsPath) && SystemInfo.isWindows) {
            lsPath = binDir + "/qmlls";
        }
        return FileUtil.exists((String)lsPath) ? lsPath : "";
    }

    @NotNull
    public String findQmlLanguageServerPath() {
        QtSettings qtSettings = QtSettings.getInstance((Project)this.myProject);
        return QmlSettings.findQmlLanguageServerPath(qtSettings.getResultingQtBinDir());
    }

    @NotNull
    public static String findQmlFormatPath(@NotNull String binDir) {
        if (binDir == null) {
            QmlSettings.$$$reportNull$$$0(7);
        }
        if (binDir.isEmpty()) {
            return "";
        }
        String qmlFormatPath = binDir + "/qmlformat" + (SystemInfo.isWindows ? ".exe" : "");
        if (!FileUtil.exists((String)qmlFormatPath) && SystemInfo.isWindows) {
            qmlFormatPath = binDir + "/qmlformat";
        }
        return FileUtil.exists((String)qmlFormatPath) ? qmlFormatPath : "";
    }

    @NotNull
    public String findQmlFormatPath() {
        QtSettings qtSettings = QtSettings.getInstance((Project)this.myProject);
        return QmlSettings.findQmlFormatPath(qtSettings.getResultingQtBinDir());
    }

    public boolean isQmlFormatEnabledAndExists(@NotNull String profileName) {
        if (profileName == null) {
            QmlSettings.$$$reportNull$$$0(8);
        }
        return this.getPerProfileState((String)profileName).myQmlFormatEnabled && !this.findQmlFormatPath().isEmpty();
    }

    public boolean isQmlLSEnabledAndExists(@NotNull String profileName) {
        if (profileName == null) {
            QmlSettings.$$$reportNull$$$0(9);
        }
        return this.getPerProfileState((String)profileName).myLSPEnabled && !this.findQmlLanguageServerPath().isEmpty();
    }

    public void loadState(@NotNull StoredState state) {
        if (state == null) {
            QmlSettings.$$$reportNull$$$0(10);
        }
        this.myState.mySettingsPerProfile = state.mySettingsPerProfile;
    }

    private StoredState.PerProfileState getPerProfileState(@NotNull String profileName) {
        StoredState.PerProfileState state;
        if (profileName == null) {
            QmlSettings.$$$reportNull$$$0(11);
        }
        return (state = this.myState.mySettingsPerProfile.get(profileName)) != null ? state : new StoredState.PerProfileState();
    }

    @NotNull
    @NlsSafe
    public synchronized List<String> getExtraQmlPaths(@NotNull String profileName) {
        if (profileName == null) {
            QmlSettings.$$$reportNull$$$0(12);
        }
        List<String> list = this.getPerProfileState((String)profileName).myExtraQmlPaths;
        if (list == null) {
            QmlSettings.$$$reportNull$$$0(13);
        }
        return list;
    }

    public synchronized void setExtraQmlPaths(@NotNull String profileName, @NotNull @NlsSafe List<String> paths) {
        if (profileName == null) {
            QmlSettings.$$$reportNull$$$0(14);
        }
        if (paths == null) {
            QmlSettings.$$$reportNull$$$0(15);
        }
        this.checkForProfileAndAddWhenNeeded(profileName);
        StoredState.PerProfileState state = this.getPerProfileState(profileName);
        if (!state.myExtraQmlPaths.equals(paths)) {
            state.myExtraQmlPaths = paths;
            this.resetCaches();
        }
    }

    public synchronized boolean getAutomocJson(@NotNull String profileName) {
        if (profileName == null) {
            QmlSettings.$$$reportNull$$$0(16);
        }
        return this.getPerProfileState((String)profileName).myAddAutomocJsonFlag;
    }

    public synchronized void setAutomocJson(@NotNull String profileName, boolean enableAutomocJson) {
        if (profileName == null) {
            QmlSettings.$$$reportNull$$$0(17);
        }
        this.getPerProfileState((String)profileName).myAddAutomocJsonFlag = enableAutomocJson;
    }

    public synchronized boolean getLSPEnabled(@NotNull String profileName) {
        if (profileName == null) {
            QmlSettings.$$$reportNull$$$0(18);
        }
        return this.getPerProfileState((String)profileName).myLSPEnabled;
    }

    public synchronized boolean getLSPCompletionEnabled(@NotNull String profileName) {
        if (profileName == null) {
            QmlSettings.$$$reportNull$$$0(19);
        }
        return this.getPerProfileState((String)profileName).myLSPCompletionEnabled;
    }

    public synchronized boolean getQmlFormatEnabled(@NotNull String profileName) {
        if (profileName == null) {
            QmlSettings.$$$reportNull$$$0(20);
        }
        return this.getPerProfileState((String)profileName).myQmlFormatEnabled;
    }

    private synchronized void checkForProfileAndAddWhenNeeded(@NotNull String profileName) {
        if (profileName == null) {
            QmlSettings.$$$reportNull$$$0(21);
        }
        if (!this.myState.mySettingsPerProfile.containsKey(profileName)) {
            QtSettings.getInstance((Project)this.myProject).checkForDefaultProfileAndAddWhenNeeded(profileName);
            this.myState.mySettingsPerProfile.put(profileName, new StoredState.PerProfileState());
        }
    }

    public synchronized void setLSPEnabled(@NotNull String profileName, boolean enabled) {
        if (profileName == null) {
            QmlSettings.$$$reportNull$$$0(22);
        }
        this.checkForProfileAndAddWhenNeeded(profileName);
        if (!this.myState.mySettingsPerProfile.containsKey(profileName)) {
            return;
        }
        StoredState.PerProfileState state = this.getPerProfileState(profileName);
        boolean changed = state.myLSPEnabled != enabled;
        state.myLSPEnabled = enabled;
        if (changed && QtSettings.getInstance((Project)this.myProject).getCurrentProfile().equals(profileName)) {
            ((QmlSettingsListener)this.myProject.getMessageBus().syncPublisher(QmlSettingsListener.TOPIC)).onLSPEnabledChanged(enabled);
        }
    }

    public synchronized void setLSPCompletionEnabled(@NotNull String profileName, boolean enabled) {
        if (profileName == null) {
            QmlSettings.$$$reportNull$$$0(23);
        }
        this.checkForProfileAndAddWhenNeeded(profileName);
        this.getPerProfileState((String)profileName).myLSPCompletionEnabled = enabled;
    }

    private void forceUiUpdate() {
        QmlFormatModificationTracker.getInstance().incModificationCount();
        CodeStyleSettingsManager.getInstance((Project)this.myProject).fireCodeStyleSettingsChanged();
    }

    public synchronized void setQmlFormatEnabled(@NotNull String profileName, boolean enabled) {
        if (profileName == null) {
            QmlSettings.$$$reportNull$$$0(24);
        }
        this.checkForProfileAndAddWhenNeeded(profileName);
        this.getPerProfileState((String)profileName).myQmlFormatEnabled = enabled;
        this.forceUiUpdate();
    }

    public static QmlSettings getInstance(@NotNull Project project) {
        if (project == null) {
            QmlSettings.$$$reportNull$$$0(25);
        }
        return (QmlSettings)project.getService(QmlSettings.class);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 13 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "importName";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "components";
                break;
            }
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "binDir";
                break;
            }
            case 8: 
            case 9: 
            case 11: 
            case 12: 
            case 14: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "profileName";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/qml/settings/QmlSettings";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "paths";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/qml/settings/QmlSettings";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getExtraQmlPaths";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getComponents";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getTypesCache";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "putComponents";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "putTypesCache";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "findQmlLanguageServerPath";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "findQmlFormatPath";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "isQmlFormatEnabledAndExists";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "isQmlLSEnabledAndExists";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "loadState";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "getPerProfileState";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "getExtraQmlPaths";
                break;
            }
            case 13: {
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "setExtraQmlPaths";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "getAutomocJson";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "setAutomocJson";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "getLSPEnabled";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "getLSPCompletionEnabled";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "getQmlFormatEnabled";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "checkForProfileAndAddWhenNeeded";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "setLSPEnabled";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "setLSPCompletionEnabled";
                break;
            }
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "setQmlFormatEnabled";
                break;
            }
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "getInstance";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 13 -> new IllegalStateException(string);
        };
    }

    static class StoredState {
        @NotNull
        @NlsSafe
        public HashMap<String, PerProfileState> mySettingsPerProfile;

        StoredState() {
            this.mySettingsPerProfile = new HashMap();
        }

        StoredState(@NotNull StoredState other) {
            if (other == null) {
                StoredState.$$$reportNull$$$0(0);
            }
            this.mySettingsPerProfile = new HashMap();
            this.mySettingsPerProfile = other.mySettingsPerProfile;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "other", "com/intellij/lang/qml/settings/QmlSettings$StoredState", "<init>"));
        }

        static class PerProfileState {
            @NotNull
            @NlsSafe
            public List<String> myExtraQmlPaths = new ArrayList<String>();
            public boolean myLSPEnabled = false;
            public boolean myLSPCompletionEnabled = false;
            public boolean myQmlFormatEnabled = false;
            public boolean myAddAutomocJsonFlag = false;

            PerProfileState() {
            }
        }
    }
}

