/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.qml.refactoring.rename;

import com.intellij.lang.qml.QmlLanguageDialect;
import com.intellij.lang.qml.QmlUtils;
import com.intellij.lang.qml.search.usages.QmlFindUsagesHandler;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.search.LocalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.refactoring.rename.RenameDialog;
import com.intellij.refactoring.rename.RenamePsiElementProcessor;
import com.intellij.usageView.UsageInfo;
import java.awt.GridBagConstraints;
import java.util.Map;
import javax.swing.JComponent;
import javax.swing.JPanel;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010%\n\u0002\b\u0002\u0018\u00002\u00020\u0001:\u0001\u0015B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J,\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0006\u001a\u00020\u00072\b\u0010\f\u001a\u0004\u0018\u00010\u00072\b\u0010\r\u001a\u0004\u0018\u00010\u000eH\u0016J,\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u0011\u001a\u00020\u00122\u0012\u0010\u0013\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u00120\u0014H\u0016\u00a8\u0006\u0016"}, d2={"Lcom/intellij/lang/qml/refactoring/rename/QmlRenamePsiProcessor;", "Lcom/intellij/refactoring/rename/RenamePsiElementProcessor;", "<init>", "()V", "canProcessElement", "", "element", "Lcom/intellij/psi/PsiElement;", "createRenameDialog", "Lcom/intellij/refactoring/rename/RenameDialog;", "project", "Lcom/intellij/openapi/project/Project;", "nameSuggestionContext", "editor", "Lcom/intellij/openapi/editor/Editor;", "prepareRenaming", "", "newName", "", "allRenames", "", "QmlRenameDialog", "intellij.qml.common"})
public final class QmlRenamePsiProcessor
extends RenamePsiElementProcessor {
    public boolean canProcessElement(@NotNull PsiElement element) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        return element.getLanguage() instanceof QmlLanguageDialect && !QmlUtils.Companion.isInFunctionBlock(element);
    }

    @NotNull
    public RenameDialog createRenameDialog(@NotNull Project project, @NotNull PsiElement element, @Nullable PsiElement nameSuggestionContext, @Nullable Editor editor) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        return new QmlRenameDialog(project, element, nameSuggestionContext, editor);
    }

    public void prepareRenaming(@NotNull PsiElement element, @NotNull String newName, @NotNull Map<PsiElement, String> allRenames) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        Intrinsics.checkNotNullParameter((Object)newName, (String)"newName");
        Intrinsics.checkNotNullParameter(allRenames, (String)"allRenames");
        super.prepareRenaming(element, newName, allRenames);
        for (UsageInfo usage : QmlFindUsagesHandler.Companion.findUsages(element)) {
            PsiElement curElement = usage.getElement();
            if (curElement == null) continue;
            allRenames.put(curElement, newName);
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\u0018\u00002\u00020\u0001B+\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0005\u0012\b\u0010\u0007\u001a\u0004\u0018\u00010\b\u00a2\u0006\u0004\b\t\u0010\nJ\u001c\u0010\u000b\u001a\u00020\f2\b\u0010\r\u001a\u0004\u0018\u00010\u000e2\b\u0010\u000f\u001a\u0004\u0018\u00010\u0010H\u0014J\n\u0010\u0011\u001a\u0004\u0018\u00010\u0012H\u0014J\b\u0010\u0013\u001a\u00020\u0014H\u0016J\b\u0010\u0015\u001a\u00020\u0016H\u0014R\u0010\u0010\u0006\u001a\u0004\u0018\u00010\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lcom/intellij/lang/qml/refactoring/rename/QmlRenamePsiProcessor$QmlRenameDialog;", "Lcom/intellij/refactoring/rename/RenameDialog;", "project", "Lcom/intellij/openapi/project/Project;", "psiElement", "Lcom/intellij/psi/PsiElement;", "nameSuggestionContext", "editor", "Lcom/intellij/openapi/editor/Editor;", "<init>", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/psi/PsiElement;Lcom/intellij/psi/PsiElement;Lcom/intellij/openapi/editor/Editor;)V", "createCheckboxes", "", "panel", "Ljavax/swing/JPanel;", "gbConstraints", "Ljava/awt/GridBagConstraints;", "createSearchScopePanel", "Ljavax/swing/JComponent;", "getRefactoringScope", "Lcom/intellij/psi/search/SearchScope;", "hasPreviewButton", "", "intellij.qml.common"})
    public static final class QmlRenameDialog
    extends RenameDialog {
        @Nullable
        private final PsiElement nameSuggestionContext;

        public QmlRenameDialog(@NotNull Project project, @NotNull PsiElement psiElement, @Nullable PsiElement nameSuggestionContext, @Nullable Editor editor) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter((Object)psiElement, (String)"psiElement");
            super(project, psiElement, nameSuggestionContext, editor);
            this.nameSuggestionContext = nameSuggestionContext;
        }

        protected void createCheckboxes(@Nullable JPanel panel, @Nullable GridBagConstraints gbConstraints) {
            super.createCheckboxes(panel, gbConstraints);
            this.getCbSearchInComments().setVisible(false);
        }

        @Nullable
        protected JComponent createSearchScopePanel() {
            return null;
        }

        @NotNull
        public SearchScope getRefactoringScope() {
            return (SearchScope)new LocalSearchScope((PsiElement)this.getPsiElement().getContainingFile());
        }

        protected boolean hasPreviewButton() {
            return false;
        }
    }
}

