/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.qml.parsing;

import com.intellij.lang.PsiBuilder;
import com.intellij.lang.ecmascript6.parsing.ES6StatementParser;
import com.intellij.lang.javascript.JSElementTypes;
import com.intellij.lang.javascript.JSTokenTypes;
import com.intellij.lang.javascript.JavaScriptParserBundle;
import com.intellij.lang.javascript.parsing.ExpressionParser;
import com.intellij.lang.qml.QmlBundle;
import com.intellij.lang.qml.QmlElementTypes;
import com.intellij.lang.qml.parsing.QmlParser;
import com.intellij.psi.tree.IElementType;
import java.util.EnumSet;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.Nullable;

public class QmlStatementParser<P extends QmlParser>
extends ES6StatementParser<P> {
    private final boolean myUseQmlSpecifics;

    protected QmlStatementParser(P parser, boolean useQmlSpecifics) {
        super(parser);
        this.myUseQmlSpecifics = useQmlSpecifics;
    }

    public void parseStatement() {
        if (!this.myUseQmlSpecifics) {
            super.parseStatement();
            return;
        }
        IElementType firstToken = this.builder.getTokenType();
        if ((firstToken == JSTokenTypes.DEFAULT_KEYWORD || firstToken == JSTokenTypes.READONLY_KEYWORD || firstToken == JSTokenTypes.REQUIRED_KEYWORD || firstToken == JSTokenTypes.PROPERTY_KEYWORD) && this.builder.lookAhead(1) != JSTokenTypes.COLON) {
            if (!this.parseProperty()) {
                this.builder.advanceLexer();
                super.parseStatement();
            }
            return;
        }
        if (firstToken == JSTokenTypes.COMPONENT_KEYWORD) {
            if (!this.parseInlineComponent()) {
                this.builder.advanceLexer();
                super.parseStatement();
            }
            return;
        }
        if (firstToken == JSTokenTypes.PRAGMA_KEYWORD) {
            this.builder.advanceLexer();
            if (this.builder.getTokenType() == JSTokenTypes.SINGLETON_KEYWORD) {
                this.builder.advanceLexer();
            } else {
                this.builder.error(QmlBundle.message("qml.parser.message.expected.singleton", new Object[0]));
            }
            return;
        }
        if (firstToken == JSTokenTypes.SIGNAL_KEYWORD) {
            ((QmlParser)this.parser).getFunctionParser().parseSignal();
            return;
        }
        if (firstToken == JSTokenTypes.ENUM_KEYWORD) {
            this.parseEnum();
            return;
        }
        super.parseStatement();
    }

    protected boolean parseInlineComponent() {
        PsiBuilder.Marker marker = this.builder.mark();
        this.builder.advanceLexer();
        if (!this.markElementReference(marker)) {
            return false;
        }
        if (!QmlStatementParser.checkMatches((PsiBuilder)this.builder, (IElementType)JSTokenTypes.COLON, (String)JavaScriptParserBundle.message((String)"javascript.parser.message.expected.colon", (Object[])new Object[0]))) {
            marker.rollbackTo();
            return false;
        }
        if (!this.markElementReference(marker)) {
            return false;
        }
        if (this.builder.getTokenType() != JSTokenTypes.LBRACE) {
            this.builder.error(JavaScriptParserBundle.message((String)"javascript.parser.message.expected.lbrace", (Object[])new Object[0]));
            marker.rollbackTo();
            return false;
        }
        this.parseBlock();
        marker.done(QmlElementTypes.QML_ELEMENT_DECLARATION);
        return true;
    }

    @Contract(mutates="this")
    private boolean markElementReference(PsiBuilder.Marker marker) {
        if (!this.isIdentifierToken(this.builder.getTokenType())) {
            this.builder.error(JavaScriptParserBundle.message((String)"javascript.parser.message.expected.name", (Object[])new Object[0]));
            marker.rollbackTo();
            return false;
        }
        PsiBuilder.Marker newComponent = this.builder.mark();
        this.builder.advanceLexer();
        newComponent.done(QmlElementTypes.QML_ELEMENT_REFERENCE_EXPRESSION);
        return true;
    }

    protected void parseEnum() {
        PsiBuilder.Marker marker = this.builder.mark();
        this.builder.advanceLexer();
        if (this.isIdentifierToken(this.builder.getTokenType())) {
            PsiBuilder.Marker enumRef = this.builder.mark();
            this.builder.advanceLexer();
            enumRef.done(QmlElementTypes.QML_ELEMENT_REFERENCE_EXPRESSION);
        } else {
            this.builder.error(JavaScriptParserBundle.message((String)"javascript.parser.message.expected.name", (Object[])new Object[0]));
            if (this.builder.getTokenType() != JSTokenTypes.LBRACE) {
                marker.drop();
                return;
            }
        }
        if (!QmlStatementParser.checkMatches((PsiBuilder)this.builder, (IElementType)JSTokenTypes.LBRACE, (String)"javascript.parser.message.expected.lbrace")) {
            marker.drop();
            return;
        }
        boolean hasError = false;
        while (!this.builder.eof() && this.builder.getTokenType() != JSTokenTypes.RBRACE) {
            if (hasError) {
                this.builder.advanceLexer();
                continue;
            }
            if (this.builder.getTokenType() == JSTokenTypes.IDENTIFIER) {
                PsiBuilder.Marker var = this.builder.mark();
                this.builder.advanceLexer();
                var.done(QmlElementTypes.QML_ELEMENT_REFERENCE_EXPRESSION);
                if (this.builder.getTokenType() == JSTokenTypes.EQ) {
                    this.parseVariableInitializer(false);
                }
                if (this.builder.getTokenType() == JSTokenTypes.COMMA) {
                    this.builder.advanceLexer();
                    continue;
                }
                if (this.builder.getTokenType() == JSTokenTypes.RBRACE) continue;
                this.builder.advanceLexer();
                hasError = true;
                continue;
            }
            this.builder.error(JavaScriptParserBundle.message((String)"javascript.parser.message.expected.property.name", (Object[])new Object[0]));
            this.builder.advanceLexer();
            hasError = true;
        }
        QmlStatementParser.checkMatches((PsiBuilder)this.builder, (IElementType)JSTokenTypes.RBRACE, (String)"javascript.parser.message.expected.rbrace");
        marker.done(QmlElementTypes.QML_ENUM_DECLARATION);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean parseProperty() {
        PsiBuilder.Marker marker = this.builder.mark();
        IElementType curToken = this.builder.getTokenType();
        if (curToken == JSTokenTypes.REQUIRED_KEYWORD) {
            this.builder.advanceLexer();
            while (this.builder.getTokenType() == JSTokenTypes.WHITE_SPACE) {
                this.builder.advanceLexer();
            }
            curToken = this.builder.getTokenType();
            if (curToken != JSTokenTypes.DEFAULT_KEYWORD && curToken != JSTokenTypes.READONLY_KEYWORD && curToken != JSTokenTypes.PROPERTY_KEYWORD) {
                PsiBuilder.Marker var = this.builder.mark();
                if (!this.parseVarName(var)) {
                    marker.rollbackTo();
                    return false;
                }
                var.done(QmlElementTypes.QML_PROPERTY_DECLARATION);
                marker.done(JSElementTypes.VAR_STATEMENT);
                return true;
            }
        }
        if (curToken == JSTokenTypes.DEFAULT_KEYWORD) {
            this.builder.advanceLexer();
            while (this.builder.getTokenType() == JSTokenTypes.WHITE_SPACE) {
                this.builder.advanceLexer();
            }
            curToken = this.builder.getTokenType();
        }
        if (curToken == JSTokenTypes.READONLY_KEYWORD) {
            this.builder.advanceLexer();
            while (this.builder.getTokenType() == JSTokenTypes.WHITE_SPACE) {
                this.builder.advanceLexer();
            }
            curToken = this.builder.getTokenType();
        }
        if (curToken != JSTokenTypes.PROPERTY_KEYWORD) {
            marker.rollbackTo();
            return false;
        }
        this.builder.advanceLexer();
        if (!this.parseType()) {
            marker.rollbackTo();
            return false;
        }
        PsiBuilder.Marker possibleAssignment = this.builder.mark();
        PsiBuilder.Marker var = this.builder.mark();
        if (!this.parseVarName(var)) {
            possibleAssignment.drop();
            marker.rollbackTo();
            return false;
        }
        var.done(QmlElementTypes.QML_ELEMENT_REFERENCE_EXPRESSION);
        if (this.builder.getTokenType() == JSTokenTypes.COLON) {
            this.builder.advanceLexer();
            if (this.builder.getTokenType() == JSTokenTypes.LBRACE) {
                PsiBuilder.Marker funcMarker = this.builder.mark();
                if (((QmlParser)this.parser).getExpressionParser().isJSObject()) {
                    ((QmlParser)this.parser).increaseInsideJSFunctionCount();
                    try {
                        ((QmlParser)this.parser).getExpressionParser().parsePrimaryExpression();
                    }
                    finally {
                        ((QmlParser)this.parser).decreaseInsideJSFunctionCount();
                    }
                } else {
                    ((QmlParser)this.parser).getStatementParser().parseBlockBodyDeeply(true);
                }
                funcMarker.done(JSElementTypes.FUNCTION_EXPRESSION);
            } else if (!((QmlParser)this.parser).getExpressionParser().parseAssignmentExpression(true)) {
                possibleAssignment.drop();
                marker.rollbackTo();
                return false;
            }
            possibleAssignment.done(JSElementTypes.ASSIGNMENT_EXPRESSION);
        } else {
            possibleAssignment.drop();
        }
        marker.done(QmlElementTypes.QML_PROPERTY_DECLARATION);
        return true;
    }

    public boolean parseType() {
        PsiBuilder.Marker marker = this.builder.mark();
        IElementType firstToken = this.builder.getTokenType();
        if (firstToken == JSTokenTypes.ALIAS_KEYWORD || firstToken == JSTokenTypes.VAR_KEYWORD || firstToken == JSTokenTypes.REAL_KEYWORD || firstToken == JSTokenTypes.BOOL_KEYWORD || firstToken == JSTokenTypes.DOUBLE_KEYWORD || firstToken == JSTokenTypes.INT_KEYWORD || firstToken == JSTokenTypes.STRING_KEYWORD || firstToken == JSTokenTypes.URL_KEYWORD) {
            this.builder.advanceLexer();
            marker.done(QmlElementTypes.QML_TYPE_REFERENCE_EXPRESSION);
            return true;
        }
        if (firstToken == JSTokenTypes.IDENTIFIER) {
            this.builder.advanceLexer();
            marker.done(QmlElementTypes.QML_TYPE_REFERENCE_EXPRESSION);
            return true;
        }
        marker.drop();
        return false;
    }

    protected boolean parseDialectSpecificSourceElements(PsiBuilder.Marker marker) {
        if (!this.myUseQmlSpecifics) {
            return super.parseDialectSpecificSourceElements(marker);
        }
        if (this.builder.getTokenType() != JSTokenTypes.IDENTIFIER) {
            return false;
        }
        @Nullable String identifierText = this.builder.getTokenText();
        if (identifierText == null || identifierText.isEmpty()) {
            return false;
        }
        StringBuilder identifierName = new StringBuilder(identifierText);
        ((QmlParser)this.parser).getExpressionParser().parseLeftHandSideExpression(EnumSet.noneOf(ExpressionParser.ParseLeftHandSideExpressionOptions.class));
        if (this.builder.getTokenType() == JSTokenTypes.LBRACE) {
            this.parseBlock();
            marker.done(QmlElementTypes.QML_ELEMENT_DECLARATION);
        } else if (this.builder.getTokenType() == JSTokenTypes.ON_KEYWORD) {
            this.builder.advanceLexer();
            PsiBuilder.Marker propMarker = this.builder.mark();
            if (QmlStatementParser.checkMatches((PsiBuilder)this.builder, (IElementType)JSTokenTypes.IDENTIFIER, (String)"javascript.parser.message.expected.identifier")) {
                propMarker.done(QmlElementTypes.QML_ELEMENT_REFERENCE_EXPRESSION);
            } else {
                propMarker.drop();
            }
            if (this.builder.getTokenType() != JSTokenTypes.LBRACE) {
                this.builder.error(JavaScriptParserBundle.message((String)"javascript.parser.message.expected.lbrace", (Object[])new Object[0]));
            } else {
                this.parseBlock();
            }
            marker.done(QmlElementTypes.QML_ELEMENT_DECLARATION);
        } else if (this.builder.getTokenType() == JSTokenTypes.COLON) {
            this.builder.advanceLexer();
            if (this.builder.getTokenType() == JSTokenTypes.LBRACE) {
                ((QmlParser)this.parser).increaseInsideJSFunctionCount();
                ((QmlParser)this.parser).getStatementParser().parseBlockBodyDeeply(true);
                ((QmlParser)this.parser).decreaseInsideJSFunctionCount();
                marker.done(JSElementTypes.FUNCTION_EXPRESSION);
            } else if (this.builder.getTokenType() == JSTokenTypes.IF_KEYWORD) {
                ((QmlParser)this.parser).getStatementParser().parseStatement();
                marker.done(JSElementTypes.ASSIGNMENT_EXPRESSION);
            } else {
                if (identifierName.toString().equals("id")) {
                    PsiBuilder.Marker idVarStatement = this.builder.mark();
                    PsiBuilder.Marker idMarker = this.builder.mark();
                    PsiBuilder.Marker refMarker = this.builder.mark();
                    this.builder.advanceLexer();
                    refMarker.done(QmlElementTypes.QML_ELEMENT_REFERENCE_EXPRESSION);
                    idMarker.done(this.getVariableElementType());
                    idVarStatement.done(JSElementTypes.VAR_STATEMENT);
                } else if (this.builder.getTokenType() == JSTokenTypes.IDENTIFIER && this.builder.lookAhead(1) == JSTokenTypes.LBRACE) {
                    PsiBuilder.Marker elemMarker = this.builder.mark();
                    PsiBuilder.Marker refMarker = this.builder.mark();
                    this.builder.advanceLexer();
                    refMarker.done(QmlElementTypes.QML_ELEMENT_REFERENCE_EXPRESSION);
                    ((QmlParser)this.parser).getStatementParser().parseBlock();
                    elemMarker.done(QmlElementTypes.QML_ELEMENT_DECLARATION);
                } else {
                    ((QmlParser)this.parser).getExpressionParser().parseExpression();
                }
                marker.done(JSElementTypes.ASSIGNMENT_EXPRESSION);
            }
        } else {
            return false;
        }
        return true;
    }

    protected void parseES6ImportStatement() {
        if (!this.myUseQmlSpecifics) {
            super.parseES6ImportStatement();
            return;
        }
        PsiBuilder.Marker importStatement = this.builder.mark();
        try {
            this.builder.advanceLexer();
            if (this.isIdentifierToken(this.builder.getTokenType())) {
                PsiBuilder.Marker importReferenceExprMarker = this.builder.mark();
                ((QmlParser)this.parser).buildTokenElement(QmlElementTypes.QML_ELEMENT_REFERENCE_EXPRESSION);
                while (this.builder.getTokenType() == JSTokenTypes.DOT) {
                    this.builder.advanceLexer();
                    if (!this.isIdentifierToken(this.builder.getTokenType())) break;
                    ((QmlParser)this.parser).buildTokenElement(QmlElementTypes.QML_ELEMENT_REFERENCE_EXPRESSION);
                }
                importReferenceExprMarker.done(QmlElementTypes.QML_IMPORT_REFERENCE_EXPRESSION);
            } else {
                if (this.builder.getTokenType() != JSTokenTypes.STRING_LITERAL) {
                    this.builder.error(JavaScriptParserBundle.message((String)"javascript.parser.message.expected.typename.or.*", (Object[])new Object[0]));
                    return;
                }
                if (this.builder.eof()) {
                    return;
                }
                this.builder.advanceLexer();
            }
            if (this.builder.eof()) {
                return;
            }
            if (this.builder.getTokenType() == JSTokenTypes.NUMERIC_LITERAL) {
                PsiBuilder.Marker versionStatement = this.builder.mark();
                while (this.builder.rawLookup(1) != JSTokenTypes.WHITE_SPACE && !this.builder.eof()) {
                    this.builder.advanceLexer();
                }
                this.builder.advanceLexer();
                versionStatement.done(JSElementTypes.REFERENCE_EXPRESSION);
            }
            if (this.builder.getTokenType() == JSTokenTypes.AS_KEYWORD) {
                this.builder.advanceLexer();
                PsiBuilder.Marker alias = this.builder.mark();
                this.builder.advanceLexer();
                alias.done(QmlElementTypes.QML_IMPORT_ALIAS_EXPRESSION);
            }
        }
        finally {
            importStatement.done(this.getImportDeclarationType());
        }
    }

    protected IElementType getImportDeclarationType() {
        return QmlElementTypes.QML_IMPORT_DECLARATION;
    }

    public boolean parseFunctionBody() {
        if (!this.myUseQmlSpecifics) {
            return super.parseFunctionBody();
        }
        if (((QmlParser)this.parser).getFunctionParser().isParsingSignal()) {
            return true;
        }
        ((QmlParser)this.parser).increaseInsideJSFunctionCount();
        boolean result = this.parseBlock();
        ((QmlParser)this.parser).decreaseInsideJSFunctionCount();
        return result;
    }

    public boolean parseBlock() {
        PsiBuilder.Marker mark = this.builder.mark();
        this.parseBlockAndAttachStatementsDirectly();
        mark.done(JSElementTypes.BLOCK_STATEMENT_EAGER);
        return true;
    }
}

