/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.qml.parsing;

import com.intellij.lang.PsiBuilder;
import com.intellij.lang.ecmascript6.parsing.ES6Parser;
import com.intellij.lang.javascript.JSLanguageDialect;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.impl.JSFileImpl;
import com.intellij.lang.qml.QmlLanguageDialect;
import com.intellij.lang.qml.parsing.QmlExpressionParser;
import com.intellij.lang.qml.parsing.QmlFunctionParser;
import com.intellij.lang.qml.parsing.QmlParserKt;
import com.intellij.lang.qml.parsing.QmlStatementParser;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtil;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0016\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0006\u0010\u001f\u001a\u00020 J\u0006\u0010!\u001a\u00020 J\u0010\u0010\"\u001a\u00020 2\u0006\u0010#\u001a\u00020$H\u0016R\u0012\u0010\u0006\u001a\u0006\u0012\u0002\b\u00030\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\b\u001a\u0006\u0012\u0002\b\u00030\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0018\u0010\n\u001a\u0006\u0012\u0002\b\u00030\u0007X\u0094\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0018\u0010\r\u001a\u0006\u0012\u0002\b\u00030\tX\u0094\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0018\u0010\u0012\u001a\u0006\u0012\u0002\b\u00030\u00078VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\fR\u0018\u0010\u0014\u001a\u0006\u0012\u0002\b\u00030\t8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\u000fR\u001f\u0010\u0016\u001a\u0006\u0012\u0002\b\u00030\u00178VX\u0096\u0084\u0002\u00a2\u0006\f\n\u0004\b\u001a\u0010\u001b\u001a\u0004\b\u0018\u0010\u0019R\u0011\u0010\u001c\u001a\u00020\u001d8F\u00a2\u0006\u0006\u001a\u0004\b\u001c\u0010\u001e\u00a8\u0006%"}, d2={"Lcom/intellij/lang/qml/parsing/QmlParser;", "Lcom/intellij/lang/ecmascript6/parsing/ES6Parser;", "builder", "Lcom/intellij/lang/PsiBuilder;", "<init>", "(Lcom/intellij/lang/PsiBuilder;)V", "defaultExpressionParser", "Lcom/intellij/lang/qml/parsing/QmlExpressionParser;", "defaultStatementParser", "Lcom/intellij/lang/qml/parsing/QmlStatementParser;", "jsExpressionParser", "getJsExpressionParser", "()Lcom/intellij/lang/qml/parsing/QmlExpressionParser;", "jsStatementParser", "getJsStatementParser", "()Lcom/intellij/lang/qml/parsing/QmlStatementParser;", "insideJsFunctionCount", "", "expressionParser", "getExpressionParser", "statementParser", "getStatementParser", "functionParser", "Lcom/intellij/lang/qml/parsing/QmlFunctionParser;", "getFunctionParser", "()Lcom/intellij/lang/qml/parsing/QmlFunctionParser;", "functionParser$delegate", "Lkotlin/Lazy;", "isInsideJsFunction", "", "()Z", "increaseInsideJSFunctionCount", "", "decreaseInsideJSFunctionCount", "fillBuilderDataFromContext", "context", "Lcom/intellij/psi/PsiElement;", "intellij.qml.common"})
@SourceDebugExtension(value={"SMAP\nQmlParser.kt\nKotlin\n*S Kotlin\n*F\n+ 1 QmlParser.kt\ncom/intellij/lang/qml/parsing/QmlParser\n+ 2 psiTreeUtil.kt\ncom/intellij/psi/util/PsiTreeUtilKt\n*L\n1#1,71:1\n67#2:72\n*S KotlinDebug\n*F\n+ 1 QmlParser.kt\ncom/intellij/lang/qml/parsing/QmlParser\n*L\n64#1:72\n*E\n"})
public class QmlParser
extends ES6Parser {
    @NotNull
    private final QmlExpressionParser<?> defaultExpressionParser;
    @NotNull
    private final QmlStatementParser<?> defaultStatementParser;
    @NotNull
    private final QmlExpressionParser<?> jsExpressionParser;
    @NotNull
    private final QmlStatementParser<?> jsStatementParser;
    private int insideJsFunctionCount;
    @NotNull
    private final Lazy functionParser$delegate;

    public QmlParser(@NotNull PsiBuilder builder) {
        Intrinsics.checkNotNullParameter((Object)builder, (String)"builder");
        QmlLanguageDialect qmlLanguageDialect = QmlLanguageDialect.getInstance();
        Intrinsics.checkNotNullExpressionValue((Object)((Object)qmlLanguageDialect), (String)"getInstance(...)");
        super((JSLanguageDialect)qmlLanguageDialect, builder);
        this.defaultExpressionParser = new QmlExpressionParser<QmlParser>(this, true);
        this.defaultStatementParser = new QmlStatementParser<QmlParser>(this, true);
        this.jsExpressionParser = new QmlExpressionParser<QmlParser>(this, false);
        this.jsStatementParser = new QmlStatementParser<QmlParser>(this, false);
        this.functionParser$delegate = LazyKt.lazy(() -> QmlParser.functionParser_delegate$lambda$0(this));
    }

    @NotNull
    protected QmlExpressionParser<?> getJsExpressionParser() {
        return this.jsExpressionParser;
    }

    @NotNull
    protected QmlStatementParser<?> getJsStatementParser() {
        return this.jsStatementParser;
    }

    @NotNull
    public QmlExpressionParser<?> getExpressionParser() {
        return this.isInsideJsFunction() ? this.getJsExpressionParser() : this.defaultExpressionParser;
    }

    @NotNull
    public QmlStatementParser<?> getStatementParser() {
        return this.isInsideJsFunction() ? this.getJsStatementParser() : this.defaultStatementParser;
    }

    @NotNull
    public QmlFunctionParser<?> getFunctionParser() {
        Lazy lazy = this.functionParser$delegate;
        return (QmlFunctionParser)((Object)lazy.getValue());
    }

    public final boolean isInsideJsFunction() {
        return this.insideJsFunctionCount > 0;
    }

    public final void increaseInsideJSFunctionCount() {
        int n = this.insideJsFunctionCount;
        this.insideJsFunctionCount = n + 1;
    }

    public final void decreaseInsideJSFunctionCount() {
        int n = this.insideJsFunctionCount;
        this.insideJsFunctionCount = n + -1;
    }

    /*
     * WARNING - void declaration
     */
    public void fillBuilderDataFromContext(@NotNull PsiElement context) {
        void $this$parentOfType$iv;
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        super.fillBuilderDataFromContext(context);
        PsiFile psiFile = context.getContainingFile();
        PsiFile psiFile2 = psiFile != null ? psiFile.getOriginalFile() : null;
        JSFileImpl jSFileImpl = psiFile2 instanceof JSFileImpl ? (JSFileImpl)psiFile2 : null;
        if (jSFileImpl == null) {
            return;
        }
        JSFileImpl originalFile = jSFileImpl;
        if (originalFile.getTreeElement() == null) {
            return;
        }
        PsiElement psiElement = (PsiElement)QmlParserKt.access$getOurGuard$p().doPreventingRecursion((Object)originalFile, false, () -> QmlParser.fillBuilderDataFromContext$lambda$0(originalFile, context));
        if (psiElement == null) {
            return;
        }
        PsiElement elementAtOffset = psiElement;
        psiFile2 = elementAtOffset;
        boolean withSelf$iv = true;
        boolean $i$f$parentOfType = false;
        if (PsiTreeUtil.getParentOfType((PsiElement)$this$parentOfType$iv, JSFunction.class, (boolean)false) == null) {
            return;
        }
        int n = this.insideJsFunctionCount;
        this.insideJsFunctionCount = n + 1;
    }

    private static final QmlFunctionParser functionParser_delegate$lambda$0(QmlParser this$0) {
        return new QmlFunctionParser<QmlParser>(this$0);
    }

    private static final PsiElement fillBuilderDataFromContext$lambda$0(JSFileImpl $originalFile, PsiElement $context) {
        return $originalFile.findElementAt($context.getTextOffset());
    }
}

