/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.qml.completion;

import com.intellij.codeInsight.completion.CompletionContributor;
import com.intellij.codeInsight.completion.CompletionParameters;
import com.intellij.codeInsight.completion.CompletionProvider;
import com.intellij.codeInsight.completion.CompletionResultSet;
import com.intellij.codeInsight.completion.CompletionType;
import com.intellij.lang.javascript.JSTokenTypes;
import com.intellij.lang.javascript.completion.JSKeywordsCompletionProvider;
import com.intellij.lang.javascript.completion.JSReferenceCompletionProvider;
import com.intellij.lang.javascript.completion.ml.JSMLTrackingCompletionProvider;
import com.intellij.lang.javascript.psi.JSProperty;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.qml.QmlUtils;
import com.intellij.lang.qml.completion.QmlImportCompletionProvider;
import com.intellij.lang.qml.psi.impl.QmlElementReferenceExpressionImpl;
import com.intellij.lang.qml.psi.impl.QmlImportReferenceExpressionImpl;
import com.intellij.lang.qml.settings.QmlSettings;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.patterns.ElementPattern;
import com.intellij.patterns.PlatformPatterns;
import com.intellij.patterns.PsiElementPattern;
import com.intellij.psi.PsiElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.psi.xml.XmlTokenType;
import com.intellij.qt.common.settings.QtSettings;
import com.intellij.util.ProcessingContext;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class QmlCompletionContributor
extends CompletionContributor
implements DumbAware {
    public QmlCompletionContributor() {
        PsiElementPattern.Capture importPattern = (PsiElementPattern.Capture)((PsiElementPattern.Capture)PlatformPatterns.psiElement().withElementType(TokenSet.create((IElementType[])new IElementType[]{JSTokenTypes.IDENTIFIER, JSTokenTypes.PRIVATE_IDENTIFIER}))).withParent((ElementPattern)new PsiElementPattern.Capture<QmlElementReferenceExpressionImpl>(this, QmlElementReferenceExpressionImpl.class){

            public boolean accepts(@Nullable Object o, ProcessingContext context) {
                if (!super.accepts(o, context)) {
                    return false;
                }
                assert (o instanceof QmlElementReferenceExpressionImpl);
                PsiElement parent = ((QmlElementReferenceExpressionImpl)((Object)o)).getParent();
                return parent instanceof QmlImportReferenceExpressionImpl;
            }
        });
        this.extendWrapper(null, (ElementPattern<? extends PsiElement>)importPattern, new QmlImportCompletionProvider());
        this.extendWrapper(null, (ElementPattern<? extends PsiElement>)((PsiElementPattern.Capture)PlatformPatterns.psiElement().andNot((ElementPattern)PlatformPatterns.psiElement((IElementType)XmlTokenType.XML_DATA_CHARACTERS))).andNot((ElementPattern)importPattern), (CompletionProvider<CompletionParameters>)new JSKeywordsCompletionProvider());
        PsiElementPattern.Capture referencePattern = (PsiElementPattern.Capture)((PsiElementPattern.Capture)PlatformPatterns.psiElement().withElementType(TokenSet.create((IElementType[])new IElementType[]{JSTokenTypes.IDENTIFIER, JSTokenTypes.PRIVATE_IDENTIFIER}))).withParent((ElementPattern)new PsiElementPattern.Capture<JSReferenceExpression>(this, JSReferenceExpression.class){

            public boolean accepts(@Nullable Object o, ProcessingContext context) {
                if (!super.accepts(o, context)) {
                    return false;
                }
                assert (o instanceof JSReferenceExpression);
                PsiElement parent = ((JSReferenceExpression)o).getParent();
                return !(parent instanceof JSProperty) || !((JSProperty)parent).isShorthanded();
            }
        });
        this.extendWrapper(null, (ElementPattern<? extends PsiElement>)referencePattern.andNot((ElementPattern)importPattern), (CompletionProvider<CompletionParameters>)new JSReferenceCompletionProvider(this){

            protected void addCompletions(@NotNull CompletionParameters parameters, @NotNull ProcessingContext context, @NotNull CompletionResultSet result) {
                PsiElement parent;
                if (parameters == null) {
                    3.$$$reportNull$$$0(0);
                }
                if (context == null) {
                    3.$$$reportNull$$$0(1);
                }
                if (result == null) {
                    3.$$$reportNull$$$0(2);
                }
                if ((parent = parameters.getPosition().getParent()) != null && parent.getParent() instanceof QmlElementReferenceExpressionImpl) {
                    parameters = new CompletionParameters(parent, parameters.getOriginalFile(), parameters.getCompletionType(), parameters.getOffset(), parameters.getInvocationCount(), parameters.getEditor(), parameters.getProcess());
                }
                super.addCompletions(parameters, context, result);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "parameters";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "context";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[0] = "result";
                        break;
                    }
                }
                objectArray[1] = "com/intellij/lang/qml/completion/QmlCompletionContributor$3";
                objectArray[2] = "addCompletions";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
    }

    public void fillCompletionVariants(@NotNull CompletionParameters parameters, @NotNull CompletionResultSet result) {
        QtSettings qtSettings;
        QmlSettings qmlSettings;
        if (parameters == null) {
            QmlCompletionContributor.$$$reportNull$$$0(0);
        }
        if (result == null) {
            QmlCompletionContributor.$$$reportNull$$$0(1);
        }
        if ((qmlSettings = QmlSettings.getInstance(parameters.getPosition().getProject())).isQmlLSEnabledAndExists((qtSettings = QtSettings.getInstance((Project)parameters.getPosition().getProject())).getCurrentProfile()) && qmlSettings.getLSPCompletionEnabled(qtSettings.getCurrentProfile())) {
            List contributors = CompletionContributor.forParameters((CompletionParameters)parameters);
            List<CompletionContributor> lspContributor = contributors.stream().filter(contributor -> contributor.getClass().getSimpleName().equals("LspCompletionContributor")).toList();
            if (!lspContributor.isEmpty()) {
                lspContributor.get(0).fillCompletionVariants(parameters, result);
            }
            result.stopHere();
            return;
        }
        PsiElement parent = parameters.getPosition().getParent();
        boolean isInFunctionBlock = QmlUtils.Companion.isInFunctionBlock(parent);
        if (!isInFunctionBlock) {
            super.fillCompletionVariants(parameters, result);
            result.stopHere();
        } else {
            List contributors = CompletionContributor.forParameters((CompletionParameters)parameters);
            List<CompletionContributor> nonLspContributors = contributors.stream().filter(contributor -> !contributor.getClass().getSimpleName().equals("LspCompletionContributor")).toList();
            if (contributors.size() != nonLspContributors.size()) {
                int from = nonLspContributors.indexOf((Object)this);
                for (int i = from + 1; i < nonLspContributors.size(); ++i) {
                    nonLspContributors.get(i).fillCompletionVariants(parameters, result);
                }
                result.stopHere();
            }
        }
    }

    private void extendWrapper(@Nullable CompletionType type, @NotNull ElementPattern<? extends PsiElement> place, @NotNull CompletionProvider<CompletionParameters> provider) {
        JSMLTrackingCompletionProvider.Kind kind;
        if (place == null) {
            QmlCompletionContributor.$$$reportNull$$$0(2);
        }
        if (provider == null) {
            QmlCompletionContributor.$$$reportNull$$$0(3);
        }
        if ((kind = JSMLTrackingCompletionProvider.Kind.ofProvider(provider)) == null) {
            Logger.getInstance(QmlCompletionContributor.class).warn("ML kind for class " + String.valueOf(((Object)((Object)provider)).getClass()) + " not found");
        }
        if (!DumbService.isDumbAware(provider)) {
            provider = new SkipDumbModeProvider(provider);
        }
        if (kind != null) {
            provider = new JSMLTrackingCompletionProvider(kind, (CompletionProvider)provider);
        }
        this.extend(type, place, provider);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameters";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "place";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "provider";
                break;
            }
        }
        objectArray2[1] = "com/intellij/lang/qml/completion/QmlCompletionContributor";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "fillCompletionVariants";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "extendWrapper";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static final class SkipDumbModeProvider
    extends CompletionProvider<CompletionParameters> {
        @NotNull
        private final CompletionProvider<CompletionParameters> myOriginal;

        private SkipDumbModeProvider(@NotNull CompletionProvider<CompletionParameters> original) {
            if (original == null) {
                SkipDumbModeProvider.$$$reportNull$$$0(0);
            }
            this.myOriginal = original;
        }

        protected void addCompletions(@NotNull CompletionParameters parameters, @NotNull ProcessingContext context, @NotNull CompletionResultSet result) {
            PsiElement position;
            if (parameters == null) {
                SkipDumbModeProvider.$$$reportNull$$$0(1);
            }
            if (context == null) {
                SkipDumbModeProvider.$$$reportNull$$$0(2);
            }
            if (result == null) {
                SkipDumbModeProvider.$$$reportNull$$$0(3);
            }
            if (DumbService.isDumb((Project)(position = parameters.getPosition()).getProject())) {
                return;
            }
            this.myOriginal.addCompletionVariants(parameters, context, result);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "original";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "parameters";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "context";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "result";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/lang/qml/completion/QmlCompletionContributor$SkipDumbModeProvider";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "addCompletions";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

