/*
 * Decompiled with CFR 0.152.
 */
package com.pastdev.jsch.nio.file;

import java.io.IOException;
import java.net.URI;
import java.nio.file.DirectoryStream;
import java.nio.file.Path;
import java.nio.file.spi.FileSystemProvider;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;

public abstract class AbstractSshFileSystemProvider
extends FileSystemProvider {
    @Override
    public Path getPath(URI uri) {
        return this.getFileSystem(uri).getPath(uri.getPath(), new String[0]);
    }

    public static class StandardDirectoryStream
    implements DirectoryStream<Path> {
        private List<Path> accepted;

        public StandardDirectoryStream(Path parent, String[] entries, DirectoryStream.Filter<? super Path> filter) throws IOException {
            if (entries == null) {
                this.accepted = Collections.emptyList();
            } else {
                this.accepted = new ArrayList<Path>();
                for (String entry : entries) {
                    Path path = parent.resolve(entry);
                    if (filter != null && !filter.accept(path)) continue;
                    this.accepted.add(path);
                }
            }
        }

        @Override
        public void close() throws IOException {
        }

        @Override
        public Iterator<Path> iterator() {
            return Collections.unmodifiableList(this.accepted).iterator();
        }
    }
}

