/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.workspace.compiler.custom;

import com.intellij.execution.ExecutionException;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.util.text.Strings;
import com.intellij.util.SystemProperties;
import com.jetbrains.cidr.lang.OCLanguageKind;
import com.jetbrains.cidr.lang.toolchains.CidrCompilerSwitches;
import com.jetbrains.cidr.lang.workspace.compiler.CompilerInfo;
import com.jetbrains.cidr.lang.workspace.compiler.CompilerSplitArgs;
import com.jetbrains.cidr.lang.workspace.compiler.FeatureParseUtil;
import com.jetbrains.cidr.lang.workspace.compiler.OCCompilerFeatures;
import com.jetbrains.cidr.lang.workspace.compiler.custom.CidrCustomCompilerBundle;
import com.jetbrains.cidr.lang.workspace.compiler.custom.CidrCustomCompilerDefinition;
import com.jetbrains.cidr.lang.workspace.headerRoots.HeadersSearchPath;
import java.io.InputStream;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.PatternSyntaxException;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.yaml.snakeyaml.Yaml;
import org.yaml.snakeyaml.error.YAMLException;

public abstract class CidrCustomCompilerServiceBase {
    @NotNull
    protected static final Logger LOGGER = Logger.getInstance(CidrCustomCompilerServiceBase.class);

    @NotNull
    protected abstract List<CidrCustomCompilerDefinition> loadDefinitions();

    @NotNull
    protected List<CidrCustomCompilerDefinition> loadDefinitions(@NotNull String fileName, @NotNull InputStream inputStream) throws ClassCastException, YAMLException, PatternSyntaxException {
        Object loadObject;
        if (fileName == null) {
            CidrCustomCompilerServiceBase.$$$reportNull$$$0(0);
        }
        if (inputStream == null) {
            CidrCustomCompilerServiceBase.$$$reportNull$$$0(1);
        }
        if (!((loadObject = new Yaml().load(inputStream)) instanceof Map)) {
            List<CidrCustomCompilerDefinition> list = Collections.emptyList();
            if (list == null) {
                CidrCustomCompilerServiceBase.$$$reportNull$$$0(2);
            }
            return list;
        }
        @Nullable Map load = (Map)loadObject;
        ArrayList<CidrCustomCompilerDefinition> definitions = new ArrayList<CidrCustomCompilerDefinition>();
        List compilers = (List)load.get("compilers");
        if (compilers == null) {
            throw new YAMLException("compilers section is not found");
        }
        for (Map compiler : compilers) {
            definitions.add(CidrCustomCompilerDefinition.loadFromYamlFragment(compiler, fileName));
        }
        ArrayList<CidrCustomCompilerDefinition> arrayList = definitions;
        if (arrayList == null) {
            CidrCustomCompilerServiceBase.$$$reportNull$$$0(3);
        }
        return arrayList;
    }

    @NotNull
    public CompilerInfo collectInfo(@NotNull Path executable, boolean isWindows, @NotNull OCLanguageKind languageKind, @NotNull CidrCompilerSwitches switches, @Nullable String projectPath) {
        if (executable == null) {
            CidrCustomCompilerServiceBase.$$$reportNull$$$0(4);
        }
        if (languageKind == null) {
            CidrCustomCompilerServiceBase.$$$reportNull$$$0(5);
        }
        if (switches == null) {
            CidrCustomCompilerServiceBase.$$$reportNull$$$0(6);
        }
        CompilerSplitArgs splitArgs = CompilerSplitArgs.parse((List)switches.getList(CidrCompilerSwitches.Format.RAW), (boolean)isWindows);
        try {
            CidrCustomCompilerDefinition foundDefinition = this.findDefinition(executable, languageKind, splitArgs);
            ArrayList<@Nls String> allWarnings = new ArrayList<String>();
            HashMap<String, String> definesMap = new HashMap<String, String>(splitArgs.getDefines());
            ArrayList defines = new ArrayList(definesMap.size());
            ArrayList incSearchPaths = new ArrayList();
            String compilerExeName = FileUtil.toSystemIndependentName((String)executable.toString());
            Map<String, String> macroMap = Map.of("${compiler-exe}", compilerExeName, "${compiler-exe-dir}", FileUtil.toSystemIndependentName((String)executable.getParent().toString()), "${user-home}", FileUtil.toSystemIndependentName((String)SystemProperties.getUserHome()), "${project-path}", FileUtil.toSystemIndependentName((String)Strings.notNullize((String)projectPath, (String)"")));
            String targetName = null;
            if (foundDefinition != null) {
                definesMap.putAll(foundDefinition.getDefines());
                foundDefinition.getIncludeDirs().forEach(s -> {
                    String expanded = CidrCustomCompilerServiceBase.expandMacros(s, macroMap);
                    if (!Strings.isEmpty((String)expanded)) {
                        incSearchPaths.add(HeadersSearchPath.builtInIncludes((String)expanded));
                    }
                });
                targetName = foundDefinition.getCodeInsightTargetName();
            } else {
                allWarnings.add(CidrCustomCompilerBundle.message("custom.compiler.definition.not.found", compilerExeName, switches.toString()));
            }
            definesMap.forEach((k, v) -> defines.add("#define " + k + (String)(Strings.isEmpty((String)v) ? "" : " " + v)));
            splitArgs.getIncludes().forEach(s -> incSearchPaths.add(HeadersSearchPath.includes((String)s)));
            Map<OCCompilerFeatures.Type<?>, Object> features = CidrCustomCompilerServiceBase.collectFeatures(definesMap, allWarnings);
            if (!Strings.isEmpty((String)targetName)) {
                features.put(OCCompilerFeatures.CLANG_TARGET, targetName);
            }
            return new CompilerInfo(switches, defines, features, incSearchPaths, Collections.emptyList(), Collections.emptyList(), allWarnings);
        }
        catch (Throwable e) {
            return new CompilerInfo(switches, Collections.emptyList(), Collections.emptyMap(), Collections.emptyList(), Collections.emptyList(), Collections.emptyList(), Collections.singletonList(e.getLocalizedMessage()), -1);
        }
    }

    @Nullable
    CidrCustomCompilerDefinition findDefinition(@NotNull Path executable, @NotNull OCLanguageKind languageKind, CompilerSplitArgs splitArgs) {
        if (executable == null) {
            CidrCustomCompilerServiceBase.$$$reportNull$$$0(7);
        }
        if (languageKind == null) {
            CidrCustomCompilerServiceBase.$$$reportNull$$$0(8);
        }
        List<CidrCustomCompilerDefinition> definitions = this.loadDefinitions();
        for (CidrCustomCompilerDefinition definition : definitions) {
            if (!definition.matchesExe(executable.toString()) || !definition.matchDetectedLanguage(languageKind) || !definition.matchesArgs(splitArgs) || !definition.matchesSources(splitArgs)) continue;
            if (LOGGER.isTraceEnabled()) {
                LOGGER.trace("Found definition " + definition.getDescription() + " for " + String.valueOf(languageKind) + " file " + String.valueOf(executable) + " compiler args " + String.valueOf(splitArgs));
            }
            return definition;
        }
        return null;
    }

    private static String expandMacros(String s, Map<String, String> macroMap) {
        for (Map.Entry<String, String> entry : macroMap.entrySet()) {
            s = StringUtil.replace((String)s, (String)entry.getKey(), (String)entry.getValue());
        }
        return s;
    }

    public static Map<OCCompilerFeatures.Type<?>, Object> collectFeatures(Map<String, String> defines, List<String> warnings) {
        LinkedHashMap features = new LinkedHashMap();
        try {
            FeatureParseUtil.collectGccSizes(defines, features::put);
            FeatureParseUtil.collectStandardFeatures(defines, features::put);
        }
        catch (ExecutionException e) {
            warnings.add(e.getMessage());
        }
        return features;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 3 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileName";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "inputStream";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cidr/lang/workspace/compiler/custom/CidrCustomCompilerServiceBase";
                break;
            }
            case 4: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "executable";
                break;
            }
            case 5: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "languageKind";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "switches";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cidr/lang/workspace/compiler/custom/CidrCustomCompilerServiceBase";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "loadDefinitions";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "loadDefinitions";
                break;
            }
            case 2: 
            case 3: {
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "collectInfo";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "findDefinition";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 3 -> new IllegalStateException(string);
        };
    }
}

