/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.workspace.compiler.custom;

import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.Strings;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.cidr.lang.CLanguageKind;
import com.jetbrains.cidr.lang.OCLanguageKind;
import com.jetbrains.cidr.lang.workspace.compiler.CompilerSplitArgs;
import com.jetbrains.cidr.lang.workspace.compiler.custom.CidrCustomCompilerBundle;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.Unmodifiable;

public class CidrCustomCompilerDefinition {
    private static final Pattern DEFINE_REGEX = Pattern.compile("\\s*#\\s*define\\s+(\\S+)(?:\\s+([^\\s#]+))?");
    @Nullable
    private final Pattern myMatchCompilerExe;
    @Nullable
    private final Pattern myMatchSource;
    @NotNull
    private final OCLanguageKind myMatchLanguageKind;
    private String myDescription;
    private Map<String, String> myDefines;
    private List<String> myIncludeDirs;
    private List<List<String>> myMatchArgs;
    private String myCodeInsightTargetName;

    public CidrCustomCompilerDefinition(@Nullable Pattern matchCompilerExe, @Nullable Pattern matchSource, @NotNull OCLanguageKind matchLanguageKind) {
        if (matchLanguageKind == null) {
            CidrCustomCompilerDefinition.$$$reportNull$$$0(0);
        }
        this.myDefines = Collections.emptyMap();
        this.myMatchArgs = Collections.emptyList();
        this.myMatchCompilerExe = matchCompilerExe;
        this.myMatchSource = matchSource;
        this.myMatchLanguageKind = matchLanguageKind;
    }

    public boolean matchesExe(String exePath) {
        if (exePath.isEmpty()) {
            return false;
        }
        if (this.myMatchCompilerExe == null) {
            return true;
        }
        String executablePath = FileUtil.toSystemIndependentName((String)exePath);
        return this.myMatchCompilerExe.matcher(executablePath).matches();
    }

    public boolean matchesSources(CompilerSplitArgs splitArgs) {
        if (this.myMatchSource == null || splitArgs.getSources().isEmpty()) {
            return true;
        }
        for (String source : splitArgs.getSources()) {
            if (!this.myMatchSource.matcher(source).matches()) continue;
            return true;
        }
        return false;
    }

    public String toString() {
        return this.myDescription + "{compilerExePattern=" + (this.myMatchCompilerExe == null ? "" : this.myMatchCompilerExe.pattern()) + ", match sources=" + this.getMatchSource() + ", compiler=" + this.getMatchCompilerExe() + ", description='" + this.myDescription + "', defines=" + String.valueOf(this.myDefines) + ", includeDirs=" + String.valueOf(this.myIncludeDirs) + "}";
    }

    @NotNull
    public String getMatchSource() {
        String string = this.myMatchSource == null ? "" : this.myMatchSource.pattern();
        if (string == null) {
            CidrCustomCompilerDefinition.$$$reportNull$$$0(1);
        }
        return string;
    }

    @NotNull
    public String getMatchCompilerExe() {
        String string = this.myMatchCompilerExe == null ? "" : this.myMatchCompilerExe.pattern();
        if (string == null) {
            CidrCustomCompilerDefinition.$$$reportNull$$$0(2);
        }
        return string;
    }

    public boolean matchDetectedLanguage(@Nullable OCLanguageKind kind) {
        return Objects.equals(kind, this.myMatchLanguageKind);
    }

    @Nullable
    public String getDescription() {
        return this.myDescription;
    }

    @NotNull
    public @NotNull Map<@NotNull String, @NotNull String> getDefines() {
        Map<String, String> map = this.myDefines;
        if (map == null) {
            CidrCustomCompilerDefinition.$$$reportNull$$$0(3);
        }
        return map;
    }

    @NotNull
    public @NotNull List<@NotNull String> getIncludeDirs() {
        List<String> list = this.myIncludeDirs;
        if (list == null) {
            CidrCustomCompilerDefinition.$$$reportNull$$$0(4);
        }
        return list;
    }

    public List<List<String>> getMatchArgs() {
        return this.myMatchArgs;
    }

    public boolean matchesArgs(CompilerSplitArgs splitArgs) {
        if (this.myMatchArgs.isEmpty()) {
            return true;
        }
        ArrayList<List<String>> matchesToFind = new ArrayList<List<String>>(this.myMatchArgs);
        List unrecognizedArgs = splitArgs.getUnrecognizedArgs();
        int i = 0;
        while (i < unrecognizedArgs.size()) {
            boolean match = false;
            Iterator<List<String>> argsIterator = matchesToFind.iterator();
            while (argsIterator.hasNext()) {
                List<String> args = argsIterator.next();
                int compareUntilIdx = i + args.size();
                match = compareUntilIdx <= unrecognizedArgs.size() && args.equals(unrecognizedArgs.subList(i, compareUntilIdx));
                if (!match) continue;
                argsIterator.remove();
                i += args.size();
                break;
            }
            if (match) continue;
            ++i;
        }
        return matchesToFind.isEmpty();
    }

    public static CidrCustomCompilerDefinition loadFromYamlFragment(Map<String, Object> compilerYaml, String fileName) {
        String matchLanguageStr;
        Pattern matchCompilerExe = CidrCustomCompilerDefinition.readPattern(compilerYaml, "match-compiler-exe");
        Pattern matchSources = CidrCustomCompilerDefinition.readPattern(compilerYaml, "match-sources");
        CLanguageKind matchLanguage = switch (matchLanguageStr = CidrCustomCompilerDefinition.normalizeLanguageName(compilerYaml.getOrDefault("match-language", "C"))) {
            case "C" -> CLanguageKind.C;
            case "CPP" -> CLanguageKind.CPP;
            default -> {
                @Nls String message = CidrCustomCompilerBundle.message("custom.compiler.unknown.language", fileName, matchLanguageStr);
                throw new RuntimeException(message);
            }
        };
        CidrCustomCompilerDefinition definition = new CidrCustomCompilerDefinition(matchCompilerExe, matchSources, (OCLanguageKind)matchLanguage);
        definition.myDescription = Objects.toString(compilerYaml.get("description"), "");
        definition.myMatchArgs = new ArrayList<List<String>>();
        CidrCustomCompilerDefinition.readList(compilerYaml, "match-args").forEach(s -> {
            String[] split = s.split("\\s+");
            definition.myMatchArgs.add(Arrays.asList(split));
        });
        definition.myDefines = CidrCustomCompilerDefinition.readDefinesMap(compilerYaml);
        definition.myIncludeDirs = CidrCustomCompilerDefinition.readList(compilerYaml, "include-dirs");
        definition.myCodeInsightTargetName = (String)compilerYaml.getOrDefault("code-insight-target-name", "");
        return definition;
    }

    @NotNull
    public OCLanguageKind getMatchLanguageKind() {
        OCLanguageKind oCLanguageKind = this.myMatchLanguageKind;
        if (oCLanguageKind == null) {
            CidrCustomCompilerDefinition.$$$reportNull$$$0(5);
        }
        return oCLanguageKind;
    }

    private static String normalizeLanguageName(Object value) {
        return value.toString().toUpperCase(Locale.ROOT).replace('X', 'P').replace('+', 'P');
    }

    private static Pattern readPattern(Map<String, Object> yaml, String key) {
        Object value = yaml.get(key);
        if (value == null) {
            return null;
        }
        return Pattern.compile(value.toString(), 2);
    }

    private static Map<String, String> readDefinesMap(Map<String, Object> yaml) {
        Object val = yaml.get("defines");
        LinkedHashMap<String, String> result = new LinkedHashMap<String, String>();
        if (val instanceof List) {
            ((List)val).forEach(v -> {
                String s = Objects.toString(v, "");
                if (!s.isEmpty()) {
                    result.put(s, null);
                }
            });
        } else if (val instanceof Map) {
            ((Map)val).forEach((k, v) -> {
                if (!Strings.isEmpty((String)k.toString())) {
                    result.put(k.toString(), Objects.toString(v, ""));
                }
            });
        } else {
            String s = Objects.toString(val, null);
            if (val != null) {
                result.put(s, "");
            }
        }
        String definesText = Objects.toString(yaml.get("defines-text"), "");
        if (!definesText.isBlank()) {
            Matcher matcher = DEFINE_REGEX.matcher(definesText);
            while (matcher.find()) {
                result.put(matcher.group(1), Strings.notNullize((String)matcher.group(2), (String)""));
            }
        }
        return Collections.unmodifiableMap(result);
    }

    private static @Unmodifiable List<String> readList(Map<String, Object> yaml, String name) {
        Object val = yaml.get(name);
        if (val == null) {
            return Collections.emptyList();
        }
        if (val instanceof List) {
            return ContainerUtil.map((Collection)((List)val), v -> Objects.toString(v, ""));
        }
        return Collections.singletonList(Objects.toString(val, ""));
    }

    @Nullable
    public String getCodeInsightTargetName() {
        return this.myCodeInsightTargetName;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 2, 3, 4, 5 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "matchLanguageKind";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cidr/lang/workspace/compiler/custom/CidrCustomCompilerDefinition";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cidr/lang/workspace/compiler/custom/CidrCustomCompilerDefinition";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getMatchSource";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getMatchCompilerExe";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getDefines";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getIncludeDirs";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getMatchLanguageKind";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 2, 3, 4, 5 -> new IllegalStateException(string);
        };
    }
}

