/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.workspace.compiler.custom;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.ServicesKt;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.fileChooser.FileChooserDescriptorFactory;
import com.intellij.openapi.observable.properties.GraphProperty;
import com.intellij.openapi.observable.properties.ObservableMutableProperty;
import com.intellij.openapi.observable.properties.PropertyGraph;
import com.intellij.openapi.options.SearchableConfigurable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.ComponentValidator;
import com.intellij.openapi.ui.TextFieldWithBrowseButton;
import com.intellij.openapi.ui.ValidationInfo;
import com.intellij.openapi.util.Disposer;
import com.intellij.ui.dsl.builder.Align;
import com.intellij.ui.dsl.builder.AlignX;
import com.intellij.ui.dsl.builder.BuilderKt;
import com.intellij.ui.dsl.builder.ButtonKt;
import com.intellij.ui.dsl.builder.Cell;
import com.intellij.ui.dsl.builder.Panel;
import com.intellij.ui.dsl.builder.Row;
import com.intellij.ui.dsl.builder.TextFieldWithBrowseButtonKt;
import com.intellij.ui.layout.ValidationInfoBuilder;
import com.jetbrains.cidr.lang.workspace.compiler.custom.CidrCustomCompilerBundle;
import com.jetbrains.cidr.lang.workspace.compiler.custom.CidrCustomCompilerService;
import java.io.File;
import javax.swing.JComponent;
import javax.swing.JTextField;
import javax.swing.text.JTextComponent;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0007\b\u0000\u0018\u00002\u00020\u00012\u00020\u0002B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J\b\u0010\u0010\u001a\u00020\u000fH\u0016J\b\u0010\u0011\u001a\u00020\u0012H\u0016J\b\u0010\u0013\u001a\u00020\u0014H\u0016J\b\u0010\u0015\u001a\u00020\u000fH\u0016J\b\u0010\u0016\u001a\u00020\u000fH\u0016J\b\u0010\u0017\u001a\u00020\rH\u0016J\b\u0010\u0018\u001a\u00020\u0014H\u0016J\b\u0010\u0019\u001a\u00020\u0014H\u0016J\b\u0010\u001a\u001a\u00020\u0014H\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u000f0\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Lcom/jetbrains/cidr/lang/workspace/compiler/custom/CidrCustomCompilerConfigurable;", "Lcom/intellij/openapi/options/SearchableConfigurable;", "Lcom/intellij/openapi/Disposable;", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/openapi/project/Project;)V", "myCompilerService", "Lcom/jetbrains/cidr/lang/workspace/compiler/custom/CidrCustomCompilerService;", "propertyGraph", "Lcom/intellij/openapi/observable/properties/PropertyGraph;", "myEnabled", "Lcom/intellij/openapi/observable/properties/GraphProperty;", "", "myPath", "", "getHelpTopic", "createComponent", "Ljavax/swing/JComponent;", "dispose", "", "getDisplayName", "getId", "isModified", "apply", "reset", "disposeUIResources", "intellij.cidr.compiler.custom"})
@SourceDebugExtension(value={"SMAP\nCidrCustomCompilerConfigurable.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CidrCustomCompilerConfigurable.kt\ncom/jetbrains/cidr/lang/workspace/compiler/custom/CidrCustomCompilerConfigurable\n+ 2 services.kt\ncom/intellij/openapi/components/ServicesKt\n*L\n1#1,76:1\n30#2,2:77\n*S KotlinDebug\n*F\n+ 1 CidrCustomCompilerConfigurable.kt\ncom/jetbrains/cidr/lang/workspace/compiler/custom/CidrCustomCompilerConfigurable\n*L\n18#1:77,2\n*E\n"})
public final class CidrCustomCompilerConfigurable
implements SearchableConfigurable,
Disposable {
    @NotNull
    private final Project project;
    @NotNull
    private final CidrCustomCompilerService myCompilerService;
    @NotNull
    private final PropertyGraph propertyGraph;
    @NotNull
    private GraphProperty<Boolean> myEnabled;
    @NotNull
    private GraphProperty<String> myPath;

    public CidrCustomCompilerConfigurable(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.project = project;
        ComponentManager $this$service$iv = (ComponentManager)this.project;
        boolean $i$f$service = false;
        Class<CidrCustomCompilerService> serviceClass$iv = CidrCustomCompilerService.class;
        Object object = $this$service$iv.getService(serviceClass$iv);
        if (object == null) {
            throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
        }
        this.myCompilerService = (CidrCustomCompilerService)object;
        this.propertyGraph = new PropertyGraph(null, false, 3, null);
        this.myEnabled = this.propertyGraph.property((Object)false);
        this.myPath = this.propertyGraph.property((Object)"");
    }

    @NotNull
    public String getHelpTopic() {
        return "settings.compiler.custom";
    }

    @NotNull
    public JComponent createComponent() {
        return (JComponent)BuilderKt.panel(arg_0 -> CidrCustomCompilerConfigurable.createComponent$lambda$0(this, arg_0));
    }

    public void dispose() {
    }

    @NotNull
    public String getDisplayName() {
        String string = CidrCustomCompilerBundle.message("custom.compiler.configurable", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        return string;
    }

    @NotNull
    public String getId() {
        return "cidr.custom.compiler";
    }

    public boolean isModified() {
        return ((Boolean)this.myEnabled.get()).booleanValue() != this.myCompilerService.isEnabled() || !Intrinsics.areEqual((Object)this.myPath.get(), (Object)this.myCompilerService.getCustomDefinitionPath());
    }

    public void apply() {
        this.myCompilerService.setParameters((Boolean)this.myEnabled.get(), (String)this.myPath.get());
    }

    public void reset() {
        this.myEnabled.set((Object)this.myCompilerService.isEnabled());
        String string = this.myCompilerService.getCustomDefinitionPath();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getCustomDefinitionPath(...)");
        this.myPath.set((Object)string);
    }

    public void disposeUIResources() {
        super.disposeUIResources();
        Disposer.dispose((Disposable)this);
    }

    private static final Unit createComponent$lambda$0(CidrCustomCompilerConfigurable this$0, Panel $this$panel) {
        Intrinsics.checkNotNullParameter((Object)$this$panel, (String)"$this$panel");
        Ref.ObjectRef enabledCheckBox = new Ref.ObjectRef();
        Panel.row$default((Panel)$this$panel, null, arg_0 -> CidrCustomCompilerConfigurable.createComponent$lambda$0$0(enabledCheckBox, this$0, arg_0), (int)1, null);
        $this$panel.indent(arg_0 -> CidrCustomCompilerConfigurable.createComponent$lambda$0$1(this$0, enabledCheckBox, arg_0));
        return Unit.INSTANCE;
    }

    private static final Unit createComponent$lambda$0$0(Ref.ObjectRef $enabledCheckBox, CidrCustomCompilerConfigurable this$0, Row $this$row) {
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        String string = CidrCustomCompilerBundle.message("custom.compiler.use.definition.checkbox", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        $enabledCheckBox.element = ButtonKt.bindSelected((Cell)$this$row.checkBox(string), (ObservableMutableProperty)((ObservableMutableProperty)this$0.myEnabled));
        return Unit.INSTANCE;
    }

    private static final Unit createComponent$lambda$0$1(CidrCustomCompilerConfigurable this$0, Ref.ObjectRef $enabledCheckBox, Panel $this$indent) {
        Intrinsics.checkNotNullParameter((Object)$this$indent, (String)"$this$indent");
        Panel.row$default((Panel)$this$indent, null, arg_0 -> CidrCustomCompilerConfigurable.createComponent$lambda$0$1$0(this$0, $enabledCheckBox, arg_0), (int)1, null);
        return Unit.INSTANCE;
    }

    private static final Unit createComponent$lambda$0$1$0(CidrCustomCompilerConfigurable this$0, Ref.ObjectRef $enabledCheckBox, Row $this$row) {
        Cell cell;
        Cell cell2;
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        FileChooserDescriptor descriptor = FileChooserDescriptorFactory.createSingleFileDescriptor((String)"yaml").withTitle(CidrCustomCompilerBundle.message("custom.compiler.dialog.title.definition.path.yaml", new Object[0]));
        Intrinsics.checkNotNull((Object)descriptor);
        Cell cell3 = TextFieldWithBrowseButtonKt.bindText((Cell)Row.textFieldWithBrowseButton$default((Row)$this$row, (FileChooserDescriptor)descriptor, (Project)this$0.project, null, (int)4, null).align((Align)AlignX.FILL.INSTANCE), (ObservableMutableProperty)((ObservableMutableProperty)this$0.myPath));
        if ($enabledCheckBox.element == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"enabledCheckBox");
            cell2 = null;
        } else {
            cell2 = (Cell)$enabledCheckBox.element;
        }
        Cell $this$createComponent_u24lambda_u240_u241_u240_u240 = cell = cell3.enabledIf(ButtonKt.getSelected((Cell)cell2));
        boolean bl = false;
        JTextField jTextField = ((TextFieldWithBrowseButton)$this$createComponent_u24lambda_u240_u241_u240_u240.getComponent()).getTextField();
        Intrinsics.checkNotNullExpressionValue((Object)jTextField, (String)"getTextField(...)");
        JTextField textField = jTextField;
        new ComponentValidator((Disposable)this$0).andRegisterOnDocumentListener((JTextComponent)textField).withValidator(() -> CidrCustomCompilerConfigurable.createComponent$lambda$0$1$0$0$0(textField)).installOn((JComponent)textField);
        return Unit.INSTANCE;
    }

    private static final ValidationInfo createComponent$lambda$0$1$0$0$0(JTextField $textField) {
        ValidationInfo validationInfo;
        File file = new File($textField.getText());
        if (file.isFile()) {
            validationInfo = null;
        } else {
            ValidationInfoBuilder validationInfoBuilder = new ValidationInfoBuilder((JComponent)$textField);
            String string = CidrCustomCompilerBundle.message("dialog.message.file.not.found", new Object[0]);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
            validationInfo = validationInfoBuilder.error(string);
        }
        return validationInfo;
    }
}

