/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.cidr.cpp.lexer;

import com.intellij.lexer.LexerBase;
import com.intellij.lexer.StringLiteralLexer;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.psi.tree.IElementType;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\r\n\u0002\b\n\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\u000b\b\u0016\u0018\u0000 %2\u00020\u0001:\u0001%B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ(\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\n2\u0006\u0010\u0017\u001a\u00020\u00062\u0006\u0010\u0018\u001a\u00020\u00062\u0006\u0010\u0019\u001a\u00020\u0006H\u0016J\b\u0010\u001e\u001a\u00020\u0006H\u0016J\n\u0010\u001f\u001a\u0004\u0018\u00010\u0003H\u0016J\b\u0010 \u001a\u00020\u0006H\u0016J\b\u0010!\u001a\u00020\u0006H\u0016J\b\u0010\"\u001a\u00020\u0015H\u0016J\b\u0010#\u001a\u00020\nH\u0016J\b\u0010$\u001a\u00020\u0006H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\t\u001a\u0004\u0018\u00010\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u001a\u001a\u00020\u001b8F\u00a2\u0006\u0006\u001a\u0004\b\u001c\u0010\u001d\u00a8\u0006&"}, d2={"Lcom/intellij/cidr/cpp/lexer/CidrRawStringLexerBase;", "Lcom/intellij/lexer/LexerBase;", "myMarkerLiteralToken", "Lcom/intellij/psi/tree/IElementType;", "myContentLiteralToken", "myMaxRawStringPrefixLength", "", "<init>", "(Lcom/intellij/psi/tree/IElementType;Lcom/intellij/psi/tree/IElementType;I)V", "myBuffer", "", "myStart", "myEnd", "myState", "myPrefixStart", "myPrefixEnd", "mySuffixStart", "mySuffixEnd", "myLastState", "myBufferEnd", "start", "", "buffer", "startOffset", "endOffset", "initialState", "rawText", "", "getRawText", "()Ljava/lang/String;", "getState", "getTokenType", "getTokenStart", "getTokenEnd", "advance", "getBufferSequence", "getBufferEnd", "Companion", "intellij.cidr.psi.base"})
@SourceDebugExtension(value={"SMAP\nCidrRawStringLexerBase.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CidrRawStringLexerBase.kt\ncom/intellij/cidr/cpp/lexer/CidrRawStringLexerBase\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,152:1\n13#2:153\n*S KotlinDebug\n*F\n+ 1 CidrRawStringLexerBase.kt\ncom/intellij/cidr/cpp/lexer/CidrRawStringLexerBase\n*L\n135#1:153\n*E\n"})
public class CidrRawStringLexerBase
extends LexerBase {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final IElementType myMarkerLiteralToken;
    @NotNull
    private final IElementType myContentLiteralToken;
    private final int myMaxRawStringPrefixLength;
    @Nullable
    private CharSequence myBuffer;
    private int myStart;
    private int myEnd;
    private int myState;
    private int myPrefixStart;
    private int myPrefixEnd;
    private int mySuffixStart;
    private int mySuffixEnd;
    private int myLastState;
    private int myBufferEnd;
    @NotNull
    private static final Logger LOG;
    private static final int LQUOTE = 100;
    private static final int PREFIX = 101;
    private static final int INSIDE = 102;
    private static final int SUFFIX = 103;
    private static final int RQUOTE = 104;

    public CidrRawStringLexerBase(@NotNull IElementType myMarkerLiteralToken, @NotNull IElementType myContentLiteralToken, int myMaxRawStringPrefixLength) {
        Intrinsics.checkNotNullParameter((Object)myMarkerLiteralToken, (String)"myMarkerLiteralToken");
        Intrinsics.checkNotNullParameter((Object)myContentLiteralToken, (String)"myContentLiteralToken");
        this.myMarkerLiteralToken = myMarkerLiteralToken;
        this.myContentLiteralToken = myContentLiteralToken;
        this.myMaxRawStringPrefixLength = myMaxRawStringPrefixLength;
    }

    public void start(@NotNull CharSequence buffer, int startOffset, int endOffset, int initialState) {
        Intrinsics.checkNotNullParameter((Object)buffer, (String)"buffer");
        if (buffer.length() < endOffset) {
            LOG.error("buffer Length: " + buffer.length() + ", endOffset: " + endOffset, new Throwable());
        }
        this.myBuffer = buffer;
        this.myStart = startOffset;
        this.myBufferEnd = endOffset;
        this.myLastState = initialState;
        int textEnd = 0;
        if (!(buffer.length() == 0) && buffer.charAt(startOffset) == '\"') {
            this.myEnd = this.myStart + 1;
            this.myState = 100;
            textEnd = buffer.charAt(this.myBufferEnd - 1) == '\"' ? this.myBufferEnd - 1 : this.myBufferEnd;
        } else {
            this.myEnd = this.myStart;
            this.myState = 101;
            textEnd = this.myBufferEnd;
        }
        this.myPrefixEnd = this.myPrefixStart = this.myEnd;
        int prefixLength = 0;
        while (this.myPrefixEnd < textEnd) {
            CharSequence charSequence = this.myBuffer;
            Intrinsics.checkNotNull((Object)charSequence);
            if (!CidrRawStringLexerBase.Companion.isQChar(charSequence.charAt(this.myPrefixEnd)) || prefixLength >= this.myMaxRawStringPrefixLength) break;
            ++this.myPrefixEnd;
            ++prefixLength;
        }
        this.mySuffixStart = this.mySuffixEnd = textEnd;
        if (this.myPrefixEnd < this.myBufferEnd && prefixLength < this.myMaxRawStringPrefixLength) {
            CharSequence charSequence = this.myBuffer;
            Intrinsics.checkNotNull((Object)charSequence);
            if (charSequence.charAt(this.myPrefixEnd) == '(') {
                String string;
                if (this.myPrefixEnd == this.myPrefixStart) {
                    string = "";
                } else {
                    CharSequence charSequence2 = this.myBuffer;
                    Intrinsics.checkNotNull((Object)charSequence2);
                    string = ((Object)charSequence2.subSequence(this.myPrefixStart, this.myPrefixEnd)).toString();
                }
                String prefix = string;
                ++this.myPrefixEnd;
                String terminator = ")" + prefix;
                int suffixStart = textEnd - terminator.length();
                CharSequence charSequence3 = this.myBuffer;
                Intrinsics.checkNotNull((Object)charSequence3);
                String beforeRQuote = ((Object)charSequence3.subSequence(suffixStart, textEnd)).toString();
                if (Intrinsics.areEqual((Object)beforeRQuote, (Object)terminator)) {
                    this.mySuffixStart = suffixStart;
                    this.mySuffixEnd = textEnd;
                }
            }
        }
    }

    @NotNull
    public final String getRawText() {
        CharSequence charSequence = this.myBuffer;
        Intrinsics.checkNotNull((Object)charSequence);
        return ((Object)charSequence.subSequence(this.myPrefixEnd, this.mySuffixStart)).toString();
    }

    public int getState() {
        return this.myLastState;
    }

    @Nullable
    public IElementType getTokenType() {
        if (this.myStart >= this.myEnd) {
            return null;
        }
        return switch (this.myState) {
            case 101, 103 -> this.myMarkerLiteralToken;
            case 100, 102, 104 -> this.myContentLiteralToken;
            default -> null;
        };
    }

    public int getTokenStart() {
        return this.myStart;
    }

    public int getTokenEnd() {
        return this.myEnd;
    }

    public void advance() {
        this.myLastState = this.myState;
        this.myStart = this.myEnd;
        int n = this.myEnd;
        if (n == this.myBufferEnd - 1) {
            CharSequence charSequence = this.myBuffer;
            Intrinsics.checkNotNull((Object)charSequence);
            this.myState = charSequence.charAt(this.myEnd) == '\"' ? 104 : 101;
            this.myEnd = this.myBufferEnd;
        } else if (n == this.myPrefixStart) {
            this.myEnd = this.myPrefixEnd;
            this.myState = 101;
        } else if (n == this.mySuffixStart) {
            this.myEnd = this.mySuffixEnd;
            this.myState = 103;
        } else if (n == this.myPrefixEnd) {
            this.myEnd = this.mySuffixStart;
            this.myState = 102;
        }
    }

    @NotNull
    public CharSequence getBufferSequence() {
        CharSequence charSequence = this.myBuffer;
        Intrinsics.checkNotNull((Object)charSequence);
        return charSequence;
    }

    public int getBufferEnd() {
        return this.myBufferEnd;
    }

    static {
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(StringLiteralLexer.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LOG = logger;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\f\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lcom/intellij/cidr/cpp/lexer/CidrRawStringLexerBase$Companion;", "", "<init>", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "LQUOTE", "", "PREFIX", "INSIDE", "SUFFIX", "RQUOTE", "isQChar", "", "c", "", "intellij.cidr.psi.base"})
    public static final class Companion {
        private Companion() {
        }

        @Contract(pure=true)
        private final boolean isQChar(char c) {
            return StringsKt.indexOf$default((CharSequence)"\\\t\f\r\n\u000b ()", (char)c, (int)0, (boolean)false, (int)6, null) == -1;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

