/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dataSource.connection.statements;

import com.intellij.database.dataSource.connection.statements.SmartStatementsUtil;
import com.intellij.database.dbimport.ImportUtilCore;
import java.util.ArrayList;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0006\u0018\u0000 \u00102\u00020\u0001:\u0001\u0010B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u0006J\u0006\u0010\r\u001a\u00020\u000bJ\u0006\u0010\u000e\u001a\u00020\u0006J\b\u0010\u000f\u001a\u00020\u0006H\u0002R\u001e\u0010\u0004\u001a\u0012\u0012\u0004\u0012\u00020\u00060\u0005j\b\u0012\u0004\u0012\u00020\u0006`\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lcom/intellij/database/dataSource/connection/statements/BatchesContainer;", "", "<init>", "()V", "batches", "Ljava/util/ArrayList;", "", "Lkotlin/collections/ArrayList;", "count", "", "add", "", "sql", "clear", "getSql", "getOverflowSuffix", "Companion", "intellij.database.core.impl"})
public final class BatchesContainer {
    @NotNull
    private static final Companion Companion = new Companion(null);
    @NotNull
    private final ArrayList<String> batches = new ArrayList();
    private long count;
    private static final int MAX_BATCHES = 30;
    private static final int MAX_CHARACTERS = 300;

    public final void add(@NotNull String sql) {
        Intrinsics.checkNotNullParameter((Object)sql, (String)"sql");
        if (this.batches.size() < 30) {
            ((Collection)this.batches).add(SmartStatementsUtil.trimSql(sql, 300));
        } else {
            long l = this.count;
            this.count = l + 1L;
        }
    }

    public final void clear() {
        this.batches.clear();
        this.count = 0L;
    }

    @NotNull
    public final String getSql() {
        String joint = CollectionsKt.joinToString$default((Iterable)this.batches, (CharSequence)"\n", null, null, (int)0, null, null, (int)62, null);
        return "-- batch\n" + joint + this.getOverflowSuffix();
    }

    private final String getOverflowSuffix() {
        return this.count == 0L ? "" : "\n-- and " + this.count + " " + ImportUtilCore.pluralize("statement", this.count) + " more";
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0002\b\u0082\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lcom/intellij/database/dataSource/connection/statements/BatchesContainer$Companion;", "", "<init>", "()V", "MAX_BATCHES", "", "MAX_CHARACTERS", "intellij.database.core.impl"})
    private static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

