/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dataSource;

import com.intellij.database.dataSource.LocalDataSource;
import com.intellij.database.model.DasModel;
import com.intellij.database.model.serialization.ModelImporter;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.util.messages.Topic;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.concurrency.Promise;

public interface DataSourceModelStorage {
    public static final Topic<Listener> TOPIC = new Topic(Listener.class, Topic.BroadcastDirection.NONE);

    public static DataSourceModelStorage getStorage(@Nullable Project project) {
        return (DataSourceModelStorage)(project == null ? ApplicationManager.getApplication() : project).getService(DataSourceModelStorage.class);
    }

    @NotNull
    public Promise<?> getLoadedPromise();

    @NotNull
    public Promise<?> getLoadingPromise(@NotNull LocalDataSource var1);

    default public boolean isLoading(@NotNull LocalDataSource dataSource) {
        if (dataSource == null) {
            DataSourceModelStorage.$$$reportNull$$$0(0);
        }
        return this.getLoadingPromise(dataSource).getState() == Promise.State.PENDING;
    }

    public void loadModels(@NotNull List<LocalDataSource> var1);

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataSource", "com/intellij/database/dataSource/DataSourceModelStorage", "isLoading"));
    }

    public static interface Listener {
        public void started(@Nullable Project var1);

        public void finished(@Nullable Project var1);

        public void started(@Nullable Project var1, @NotNull LocalDataSource var2);

        public void finished(@Nullable Project var1, @NotNull LocalDataSource var2, @NotNull DasModel var3, @NotNull ModelImporter var4);

        public void failed(@Nullable Project var1, @NotNull LocalDataSource var2, @Nullable Throwable var3);
    }
}

