/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.cpp.toolchains.docker.host;

import com.github.dockerjava.api.command.CreateContainerCmd;
import com.github.dockerjava.api.model.AccessMode;
import com.github.dockerjava.api.model.Bind;
import com.intellij.codeWithMe.ClientId;
import com.intellij.docker.DockerCloudConfiguration;
import com.intellij.docker.DockerCloudType;
import com.intellij.docker.agent.settings.DockerVolumeBinding;
import com.intellij.docker.agent.settings.DockerVolumeBindingImpl;
import com.intellij.docker.remote.DockerContainerSettings;
import com.intellij.docker.remote.DockerCredentialsHolder;
import com.intellij.docker.remote.run.common.VolumesBuilder;
import com.intellij.docker.remote.run.runtime.DockerExecProcess;
import com.intellij.docker.remoteRunRuntime.RemoteDockerApplicationRuntime;
import com.intellij.docker.utils.DockerUtils;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.process.BaseProcessHandler;
import com.intellij.execution.process.ProcessInfo;
import com.intellij.execution.process.ProcessOutput;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.options.advanced.AdvancedSettings;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.io.OSAgnosticPathUtil;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.remoteServer.ServerType;
import com.intellij.remoteServer.configuration.RemoteServer;
import com.intellij.remoteServer.configuration.RemoteServersManager;
import com.intellij.util.PathMapper;
import com.intellij.util.PathMappingSettings;
import com.intellij.util.io.PathKt;
import com.intellij.util.system.OS;
import com.jetbrains.cidr.NamedPipe;
import com.jetbrains.cidr.cpp.toolchains.docker.CidrDockerBundle;
import com.jetbrains.cidr.cpp.toolchains.docker.CidrDockerOptions;
import com.jetbrains.cidr.cpp.toolchains.docker.CidrDockerUtil;
import com.jetbrains.cidr.cpp.toolchains.docker.DockerDownloader;
import com.jetbrains.cidr.cpp.toolchains.docker.DockerExecutor;
import com.jetbrains.cidr.cpp.toolchains.docker.DockerProcessBuilder;
import com.jetbrains.cidr.system.CidrProcessBuilder;
import com.jetbrains.cidr.system.HostMachine;
import com.jetbrains.cidr.system.MappedHost;
import com.jetbrains.cidr.system.PathMapperWithRemoteFSCacheLookup;
import com.jetbrains.cidr.system.RemoteFSCache;
import com.jetbrains.cidr.system.RemoteUnixPipe;
import com.jetbrains.cidr.system.downloading.Downloader;
import com.jetbrains.cidr.toolchains.OSType;
import java.io.Closeable;
import java.io.File;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u00cc\u0001\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\r\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u000e\n\u0002\u0010\u000b\n\u0002\b\n\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b&\u0018\u0000 |*\b\b\u0000\u0010\u0001*\u00020\u00022\u00020\u00022\u00020\u0003:\u0001|B3\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u0012\b\u0010\b\u001a\u0004\u0018\u00010\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00028\u0000\u00a2\u0006\u0004\b\r\u0010\u000eJ\u0010\u0010-\u001a\u00020.2\u0006\u0010/\u001a\u00020.H\u0014J$\u00106\u001a\u0002072\f\u00108\u001a\b\u0012\u0004\u0012\u00020%0$2\f\u00109\u001a\b\u0012\u0004\u0012\u0002020$H\u0002J\u0010\u0010G\u001a\u00020.2\u0006\u0010H\u001a\u00020.H$J\u000e\u0010I\u001a\u00020J2\u0006\u0010\b\u001a\u00020\u0019J\u000e\u0010K\u001a\u00020.2\u0006\u0010L\u001a\u00020.J\b\u0010M\u001a\u000207H&J\u0010\u0010N\u001a\u00020J2\u0006\u0010L\u001a\u00020.H\u0002J\b\u0010O\u001a\u00020 H\u0016J\b\u0010P\u001a\u000207H\u0016J\b\u0010Q\u001a\u000207H\u0016J\b\u0010R\u001a\u00020JH\u0016J\b\u0010S\u001a\u00020JH\u0016J\b\u0010T\u001a\u00020UH\u0016J\"\u0010V\u001a\u00020W2\u0006\u0010X\u001a\u00020Y2\b\u0010Z\u001a\u0004\u0018\u00010[2\u0006\u0010\\\u001a\u00020]H\u0016J\b\u0010^\u001a\u00020_H\u0016J\u0014\u0010`\u001a\u0002072\n\u0010a\u001a\u0006\u0012\u0002\b\u00030bH\u0016J\u0014\u0010c\u001a\u0002072\n\u0010a\u001a\u0006\u0012\u0002\b\u00030bH\u0016J\u0010\u0010d\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010e0$H\u0016J \u0010f\u001a\u00020]2\u0006\u0010g\u001a\u00020]2\u0006\u0010h\u001a\u00020.2\u0006\u0010i\u001a\u00020jH\u0016J\u0018\u0010f\u001a\u00020]2\u0006\u0010g\u001a\u00020]2\u0006\u0010h\u001a\u00020.H\u0016J2\u0010k\u001a\n\u0012\u0006\b\u0001\u0012\u00020.0l2\u0013\u0010m\u001a\u000f\u0012\u000b\u0012\t\u0018\u00010.\u00a2\u0006\u0002\bn0$2\u0006\u0010o\u001a\u00020JH\u0016\u00a2\u0006\u0002\u0010pJ\b\u0010q\u001a\u00020\u0019H\u0016J$\u0010r\u001a\u00020\u00192\u000b\u0010s\u001a\u00070.\u00a2\u0006\u0002\bn2\r\u0010t\u001a\t\u0018\u00010.\u00a2\u0006\u0002\bnH\u0016J\b\u0010u\u001a\u00020vH\u0016J\u0010\u0010w\u001a\u00020\t2\u0006\u0010x\u001a\u00020\u0019H\u0016J\u0010\u0010w\u001a\u00020\t2\u0006\u0010x\u001a\u00020\tH\u0016J%\u0010y\u001a\u000f\u0012\u0006\u0012\u0004\u0018\u00010.0$\u00a2\u0006\u0002\bz2\u000e\u0010m\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010.0$H\u0016J\r\u0010{\u001a\u00070.\u00a2\u0006\u0002\bnH\u0016R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0013\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0011\u0010\n\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u0013\u0010\f\u001a\u00028\u0000\u00a2\u0006\n\n\u0002\u0010\u0017\u001a\u0004\b\u0015\u0010\u0016R\u0012\u0010\u0018\u001a\u00020\u0019X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001a\u0010\u001bR\u0012\u0010\u001c\u001a\u00020\tX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001d\u0010\u001eR\u0012\u0010\u001f\u001a\u00020 X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b!\u0010\"R!\u0010#\u001a\b\u0012\u0004\u0012\u00020%0$8FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b(\u0010)\u001a\u0004\b&\u0010'R\u001b\u0010*\u001a\u00020 8DX\u0084\u0084\u0002\u00a2\u0006\f\n\u0004\b,\u0010)\u001a\u0004\b+\u0010\"R3\u00100\u001a\u001a\u0012\n\u0012\b\u0012\u0004\u0012\u00020%0$\u0012\n\u0012\b\u0012\u0004\u0012\u0002020$018BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b5\u0010)\u001a\u0004\b3\u00104R\u001b\u0010:\u001a\u00020;8DX\u0084\u0084\u0002\u00a2\u0006\f\n\u0004\b>\u0010)\u001a\u0004\b<\u0010=R\u0012\u0010?\u001a\u00020\u0019X\u00a4\u0004\u00a2\u0006\u0006\u001a\u0004\b@\u0010\u001bR\u0012\u0010A\u001a\u00020\u0019X\u00a4\u0004\u00a2\u0006\u0006\u001a\u0004\bB\u0010\u001bR\u0012\u0010C\u001a\u00020\u0019X\u00a4\u0004\u00a2\u0006\u0006\u001a\u0004\bD\u0010\u001bR\u0012\u0010E\u001a\u00020\u0019X\u00a4\u0004\u00a2\u0006\u0006\u001a\u0004\bF\u0010\u001b\u00a8\u0006}"}, d2={"Lcom/jetbrains/cidr/cpp/toolchains/docker/host/DockerHostBase;", "T", "Lcom/jetbrains/cidr/system/HostMachine;", "Lcom/jetbrains/cidr/system/MappedHost;", "credentialsHolder", "Lcom/intellij/docker/remote/DockerCredentialsHolder;", "containerSettings", "Lcom/intellij/docker/remote/DockerContainerSettings;", "projectDir", "Ljava/io/File;", "cidrDockerOptions", "Lcom/jetbrains/cidr/cpp/toolchains/docker/CidrDockerOptions;", "underlyingHost", "<init>", "(Lcom/intellij/docker/remote/DockerCredentialsHolder;Lcom/intellij/docker/remote/DockerContainerSettings;Ljava/io/File;Lcom/jetbrains/cidr/cpp/toolchains/docker/CidrDockerOptions;Lcom/jetbrains/cidr/system/HostMachine;)V", "getCredentialsHolder", "()Lcom/intellij/docker/remote/DockerCredentialsHolder;", "getContainerSettings", "()Lcom/intellij/docker/remote/DockerContainerSettings;", "getCidrDockerOptions", "()Lcom/jetbrains/cidr/cpp/toolchains/docker/CidrDockerOptions;", "getUnderlyingHost", "()Lcom/jetbrains/cidr/system/HostMachine;", "Lcom/jetbrains/cidr/system/HostMachine;", "hostTemporaryDirectory", "Ljava/nio/file/Path;", "getHostTemporaryDirectory", "()Ljava/nio/file/Path;", "cacheDirectory", "getCacheDirectory", "()Ljava/io/File;", "totalMapper", "Lcom/intellij/util/PathMapper;", "getTotalMapper", "()Lcom/intellij/util/PathMapper;", "bindVolumes", "", "Lcom/intellij/docker/agent/settings/DockerVolumeBinding;", "getBindVolumes", "()Ljava/util/List;", "bindVolumes$delegate", "Lkotlin/Lazy;", "dockerMapper", "getDockerMapper", "dockerMapper$delegate", "mapServerToLocal", "", "path", "userDefinedMappings", "Lkotlin/Pair;", "Lcom/github/dockerjava/api/model/Bind;", "getUserDefinedMappings", "()Lkotlin/Pair;", "userDefinedMappings$delegate", "checkAndCreateMissingVolumes", "", "volumeBindingsFromTable", "volumeBindingsFromCLIOptions", "fsCache", "Lcom/jetbrains/cidr/system/RemoteFSCache;", "getFsCache", "()Lcom/jetbrains/cidr/system/RemoteFSCache;", "fsCache$delegate", "hostStlPrettyPrintersDirectory", "getHostStlPrettyPrintersDirectory", "hostStlPrettyPrintersDirectoryToMount", "getHostStlPrettyPrintersDirectoryToMount", "hostQtPrettyPrintersDirectory", "getHostQtPrettyPrintersDirectory", "hostQtPrettyPrintersDirectoryToMount", "getHostQtPrettyPrintersDirectoryToMount", "convertToHostPath", "localPath", "volumeBindingsContainProjectDir", "", "convertToHostPathIfNeeded", "hostPath", "setupPrettyPrinters", "isPathOnHost", "getPathMapper", "invalidateCache", "markCacheInvalid", "isRemote", "hasRemoteFS", "getOSType", "Lcom/jetbrains/cidr/toolchains/OSType;", "runProcess", "Lcom/intellij/execution/process/ProcessOutput;", "cl", "Lcom/intellij/execution/configurations/GeneralCommandLine;", "indicator", "Lcom/intellij/openapi/progress/ProgressIndicator;", "timeout", "", "createProcessBuilder", "Lcom/jetbrains/cidr/system/CidrProcessBuilder;", "destroyProcess", "handler", "Lcom/intellij/execution/process/BaseProcessHandler;", "killProcessTree", "getProcessList", "Lcom/intellij/execution/process/ProcessInfo;", "sendSignal", "pid", "signalName", "mainProcess", "Ljava/lang/Process;", "toCanonicalPath", "", "paths", "Lorg/jetbrains/annotations/NonNls;", "resolveSymlink", "(Ljava/util/List;Z)[Ljava/lang/String;", "getTempDirectory", "createTempDirectory", "prefix", "suffix", "openNamedPipe", "Lcom/jetbrains/cidr/NamedPipe;", "resolvePath", "file", "resolveAndCache", "Lorg/jetbrains/annotations/Unmodifiable;", "getName", "Companion", "intellij.clion.docker"})
@SourceDebugExtension(value={"SMAP\nDockerHostBase.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DockerHostBase.kt\ncom/jetbrains/cidr/cpp/toolchains/docker/host/DockerHostBase\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 service.kt\ncom/intellij/openapi/components/ServiceKt\n+ 4 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 5 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,321:1\n1563#2:322\n1634#2,3:323\n1761#2,3:326\n1761#2,3:329\n1563#2:335\n1634#2,3:336\n1563#2:339\n1634#2,3:340\n1563#2:343\n1634#2,3:344\n774#2:347\n865#2,2:348\n42#3,3:332\n3919#4:350\n4434#4,2:351\n13#5:353\n*S KotlinDebug\n*F\n+ 1 DockerHostBase.kt\ncom/jetbrains/cidr/cpp/toolchains/docker/host/DockerHostBase\n*L\n131#1:322\n131#1:323,3\n177#1:326,3\n182#1:329,3\n83#1:335\n83#1:336,3\n87#1:339\n87#1:340,3\n88#1:343\n88#1:344,3\n112#1:347\n112#1:348,2\n244#1:332,3\n117#1:350\n117#1:351,2\n314#1:353\n*E\n"})
public abstract class DockerHostBase<T extends HostMachine>
implements HostMachine,
MappedHost {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final DockerCredentialsHolder credentialsHolder;
    @Nullable
    private final DockerContainerSettings containerSettings;
    @NotNull
    private final CidrDockerOptions cidrDockerOptions;
    @NotNull
    private final T underlyingHost;
    @NotNull
    private final Lazy bindVolumes$delegate;
    @NotNull
    private final Lazy dockerMapper$delegate;
    @NotNull
    private final Lazy userDefinedMappings$delegate;
    @NotNull
    private final Lazy fsCache$delegate;
    @NotNull
    private static final Logger LOG;
    @NotNull
    private static final String containerStlPrettyPrintersMount = "/.clion-stl-pretty-printers";
    @NotNull
    private static final String containerQtPrettyPrintersMount = "/.clion-qt-pretty-printers";

    public DockerHostBase(@NotNull DockerCredentialsHolder credentialsHolder, @Nullable DockerContainerSettings containerSettings, @Nullable File projectDir, @NotNull CidrDockerOptions cidrDockerOptions, @NotNull T underlyingHost) {
        Intrinsics.checkNotNullParameter((Object)credentialsHolder, (String)"credentialsHolder");
        Intrinsics.checkNotNullParameter((Object)cidrDockerOptions, (String)"cidrDockerOptions");
        Intrinsics.checkNotNullParameter(underlyingHost, (String)"underlyingHost");
        this.credentialsHolder = credentialsHolder;
        this.containerSettings = containerSettings;
        this.cidrDockerOptions = cidrDockerOptions;
        this.underlyingHost = underlyingHost;
        this.bindVolumes$delegate = LazyKt.lazy(() -> DockerHostBase.bindVolumes_delegate$lambda$0(this, projectDir));
        this.dockerMapper$delegate = LazyKt.lazy(() -> DockerHostBase.dockerMapper_delegate$lambda$0(this));
        this.userDefinedMappings$delegate = LazyKt.lazy(() -> DockerHostBase.userDefinedMappings_delegate$lambda$0(this));
        this.fsCache$delegate = LazyKt.lazy(() -> DockerHostBase.fsCache_delegate$lambda$0(this));
    }

    @NotNull
    public final DockerCredentialsHolder getCredentialsHolder() {
        return this.credentialsHolder;
    }

    @Nullable
    public final DockerContainerSettings getContainerSettings() {
        return this.containerSettings;
    }

    @NotNull
    public final CidrDockerOptions getCidrDockerOptions() {
        return this.cidrDockerOptions;
    }

    @NotNull
    public final T getUnderlyingHost() {
        return this.underlyingHost;
    }

    @NotNull
    public abstract Path getHostTemporaryDirectory();

    @NotNull
    public abstract File getCacheDirectory();

    @NotNull
    public abstract PathMapper getTotalMapper();

    @NotNull
    public final List<DockerVolumeBinding> getBindVolumes() {
        Lazy lazy = this.bindVolumes$delegate;
        return (List)lazy.getValue();
    }

    @NotNull
    protected final PathMapper getDockerMapper() {
        Lazy lazy = this.dockerMapper$delegate;
        return (PathMapper)lazy.getValue();
    }

    @NotNull
    protected String mapServerToLocal(@NotNull String path) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        return path;
    }

    private final Pair<List<DockerVolumeBinding>, List<Bind>> getUserDefinedMappings() {
        Lazy lazy = this.userDefinedMappings$delegate;
        return (Pair)lazy.getValue();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void checkAndCreateMissingVolumes(List<? extends DockerVolumeBinding> volumeBindingsFromTable, List<? extends Bind> volumeBindingsFromCLIOptions) {
        Bind it;
        Collection collection;
        Iterable $this$mapTo$iv$iv;
        Iterable $this$map$iv = volumeBindingsFromTable;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            DockerVolumeBinding dockerVolumeBinding = (DockerVolumeBinding)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.getHostPath());
        }
        $this$map$iv = volumeBindingsFromCLIOptions;
        collection = (List)destination$iv$iv;
        $i$f$map = false;
        $this$mapTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            it = (Bind)item$iv$iv;
            Collection collection2 = destination$iv$iv;
            boolean bl = false;
            collection2.add(it.getPath());
        }
        List pathsToCheck = CollectionsKt.plus((Collection)collection, (Iterable)((List)destination$iv$iv));
        for (String serverPath : pathsToCheck) {
            Intrinsics.checkNotNull((Object)serverPath);
            Intrinsics.checkNotNullExpressionValue((Object)this.underlyingHost.getPath(this.mapServerToLocal(serverPath), new String[0]), (String)"getPath(...)");
            DockerHostBase dockerHostBase = this;
            synchronized (dockerHostBase) {
                Path path;
                boolean bl = false;
                if (!Files.exists(path, new LinkOption[0])) {
                    Files.createDirectories(path, new FileAttribute[0]);
                }
                Unit unit = Unit.INSTANCE;
            }
        }
    }

    @NotNull
    protected final RemoteFSCache getFsCache() {
        Lazy lazy = this.fsCache$delegate;
        return (RemoteFSCache)lazy.getValue();
    }

    @NotNull
    protected abstract Path getHostStlPrettyPrintersDirectory();

    @NotNull
    protected abstract Path getHostStlPrettyPrintersDirectoryToMount();

    @NotNull
    protected abstract Path getHostQtPrettyPrintersDirectory();

    @NotNull
    protected abstract Path getHostQtPrettyPrintersDirectoryToMount();

    @NotNull
    protected abstract String convertToHostPath(@NotNull String var1);

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final boolean volumeBindingsContainProjectDir(@NotNull Path projectDir) {
        boolean bl;
        boolean bl2;
        Intrinsics.checkNotNullParameter((Object)projectDir, (String)"projectDir");
        if (!CidrDockerUtil.isContainerOptionsEnabled()) return false;
        if (this.containerSettings == null) {
            return false;
        }
        Path path = projectDir.toAbsolutePath();
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"toAbsolutePath(...)");
        String canonicalProjectPath = FileUtil.toCanonicalPath((String)((Object)path).toString(), (boolean)true);
        Pair<List<DockerVolumeBinding>, List<Bind>> pair = this.getUserDefinedMappings();
        List bindings = (List)pair.component1();
        List binds = (List)pair.component2();
        Iterable $this$any$iv = bindings;
        boolean $i$f$any = false;
        if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
            bl2 = false;
        } else {
            for (Object element$iv : $this$any$iv) {
                boolean bl3;
                DockerVolumeBinding binding = (DockerVolumeBinding)element$iv;
                boolean bl4 = false;
                if (binding.isReadOnly()) {
                    bl3 = false;
                } else {
                    String string = binding.getHostPath();
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getHostPath(...)");
                    bl3 = DockerHostBase.volumeBindingsContainProjectDir$containsProjectDir(this, canonicalProjectPath, string);
                }
                if (!bl3) continue;
                return true;
            }
            bl2 = false;
        }
        if (bl2) return true;
        $this$any$iv = binds;
        $i$f$any = false;
        if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
            return false;
        }
        Iterator iterator = $this$any$iv.iterator();
        do {
            Object element$iv;
            if (!iterator.hasNext()) return false;
            element$iv = iterator.next();
            Bind bind = (Bind)element$iv;
            boolean bl5 = false;
            if (bind.getAccessMode() == AccessMode.ro) {
                bl = false;
                continue;
            }
            String string = bind.getPath();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getPath(...)");
            bl = DockerHostBase.volumeBindingsContainProjectDir$containsProjectDir(this, canonicalProjectPath, string);
        } while (!bl);
        return true;
    }

    @NotNull
    public final String convertToHostPathIfNeeded(@NotNull String hostPath) {
        String string;
        String string2;
        Intrinsics.checkNotNullParameter((Object)hostPath, (String)"hostPath");
        if (this.underlyingHost.getOS() == OS.Windows && StringsKt.startsWith$default((String)hostPath, (String)"/", (boolean)false, (int)2, null)) {
            DockerCloudConfiguration dockerCloudConfiguration;
            RemoteServer remoteServer = RemoteServersManager.getInstance().findByName(this.credentialsHolder.getAccountName(), (ServerType)DockerCloudType.getInstance());
            if (remoteServer != null && (dockerCloudConfiguration = (DockerCloudConfiguration)remoteServer.getConfiguration()) != null) {
                DockerCloudConfiguration it = dockerCloudConfiguration;
                boolean bl = false;
                string2 = DockerUtils.convertDockerMachinePathToLocalPath((DockerCloudConfiguration)it, (String)hostPath);
            } else {
                string2 = null;
            }
        } else {
            string2 = string = null;
        }
        if (string2 == null) {
            string = hostPath;
        }
        return string;
    }

    public abstract void setupPrettyPrinters();

    private final boolean isPathOnHost(String hostPath) {
        return this.underlyingHost.getOS() == OS.Windows ? OSAgnosticPathUtil.isAbsolute((String)hostPath) : FileUtil.isAbsolute((String)hostPath);
    }

    @NotNull
    public PathMapper getPathMapper() {
        return (PathMapper)new PathMapperWithRemoteFSCacheLookup(this.getTotalMapper(), this.getFsCache());
    }

    public void invalidateCache() {
        this.getFsCache().invalidateCache();
    }

    public void markCacheInvalid() {
        this.getFsCache().markInvalidated();
    }

    public boolean isRemote() {
        return true;
    }

    public boolean hasRemoteFS() {
        return this.underlyingHost.hasRemoteFS();
    }

    @NotNull
    public OSType getOSType() {
        return OSType.LINUX;
    }

    @NotNull
    public ProcessOutput runProcess(@NotNull GeneralCommandLine cl, @Nullable ProgressIndicator indicator, int timeout) {
        Intrinsics.checkNotNullParameter((Object)cl, (String)"cl");
        ProgressIndicator progressIndicator = indicator;
        if (progressIndicator != null) {
            progressIndicator.checkCanceled();
        }
        if (AdvancedSettings.Companion.getBoolean("clion.docker.use.exec.for.short-lived.processes")) {
            boolean $i$f$service = false;
            Class<DockerExecutor> serviceClass$iv = DockerExecutor.class;
            Object object = ApplicationManager.getApplication().getService(serviceClass$iv);
            if (object == null) {
                throw new RuntimeException("Cannot find service " + serviceClass$iv.getName() + " (classloader=" + serviceClass$iv.getClassLoader() + ", client=" + ClientId.Companion.getCurrentOrNull() + ')');
            }
            return ((DockerExecutor)object).exec(cl, this);
        }
        ProcessOutput processOutput = super.runProcess(cl, indicator, timeout);
        Intrinsics.checkNotNullExpressionValue((Object)processOutput, (String)"runProcess(...)");
        return processOutput;
    }

    @NotNull
    public CidrProcessBuilder createProcessBuilder() {
        return new DockerProcessBuilder(this);
    }

    public void destroyProcess(@NotNull BaseProcessHandler<?> handler) {
        Intrinsics.checkNotNullParameter(handler, (String)"handler");
        this.underlyingHost.destroyProcess(handler);
    }

    public void killProcessTree(@NotNull BaseProcessHandler<?> handler) {
        Intrinsics.checkNotNullParameter(handler, (String)"handler");
        this.underlyingHost.killProcessTree(handler);
    }

    @NotNull
    public List<ProcessInfo> getProcessList() {
        List list = this.underlyingHost.getProcessList();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getProcessList(...)");
        return list;
    }

    public int sendSignal(int pid, @NotNull String signalName, @NotNull Process mainProcess) {
        Intrinsics.checkNotNullParameter((Object)signalName, (String)"signalName");
        Intrinsics.checkNotNullParameter((Object)mainProcess, (String)"mainProcess");
        if (mainProcess instanceof DockerExecProcess) {
            RemoteDockerApplicationRuntime runtime = ((DockerExecProcess)mainProcess).getApplicationRuntime();
            String[] stringArray = new String[]{"kill", "-s", signalName, String.valueOf(pid)};
            ProcessOutput processOutput = runtime.exec(stringArray);
            Intrinsics.checkNotNullExpressionValue((Object)processOutput, (String)"exec(...)");
            ProcessOutput output = processOutput;
            return output.getExitCode();
        }
        LOG.error("Cannot cast init process to DockerExecProcess");
        return -1;
    }

    public int sendSignal(int pid, @NotNull String signalName) {
        Intrinsics.checkNotNullParameter((Object)signalName, (String)"signalName");
        throw new UnsupportedOperationException();
    }

    @NotNull
    public String[] toCanonicalPath(@NotNull List<String> paths, boolean resolveSymlink) {
        Intrinsics.checkNotNullParameter(paths, (String)"paths");
        String[] stringArray = this.getFsCache().toCanonicalPathAndResolveSymlink(paths);
        Intrinsics.checkNotNullExpressionValue((Object)stringArray, (String)"toCanonicalPathAndResolveSymlink(...)");
        return stringArray;
    }

    @NotNull
    public Path getTempDirectory() {
        return this.getHostTemporaryDirectory();
    }

    @NotNull
    public Path createTempDirectory(@NotNull String prefix, @Nullable String suffix) {
        Intrinsics.checkNotNullParameter((Object)prefix, (String)"prefix");
        String string = suffix;
        if (string == null) {
            string = "";
        }
        String prefixAndSuffix = prefix + string;
        Path path = Files.createTempDirectory(this.getTempDirectory(), prefixAndSuffix, new FileAttribute[0]);
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"createTempDirectory(...)");
        return path;
    }

    @NotNull
    public NamedPipe openNamedPipe() {
        String string = this.getPathMapper().convertToRemote(((Object)PathKt.generateRandomPath((Path)this.getTempDirectory())).toString());
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"convertToRemote(...)");
        String pipeName = string;
        return (NamedPipe)new RemoteUnixPipe((HostMachine)this, pipeName);
    }

    @NotNull
    public File resolvePath(@NotNull Path file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        File file2 = this.underlyingHost.resolvePath(file);
        Intrinsics.checkNotNullExpressionValue((Object)file2, (String)"resolvePath(...)");
        return file2;
    }

    @NotNull
    public File resolvePath(@NotNull File file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        File file2 = this.underlyingHost.resolvePath(file);
        Intrinsics.checkNotNullExpressionValue((Object)file2, (String)"resolvePath(...)");
        return file2;
    }

    @NotNull
    public List<String> resolveAndCache(@NotNull List<String> paths) {
        Intrinsics.checkNotNullParameter(paths, (String)"paths");
        List list = this.getFsCache().resolveAndCache(paths);
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"resolveAndCache(...)");
        return list;
    }

    @NotNull
    public String getName() {
        return "Docker (" + this.credentialsHolder.getImageName() + ")";
    }

    private static final List bindVolumes_delegate$lambda$0(DockerHostBase this$0, File $projectDir) {
        VolumesBuilder builder;
        block5: {
            block6: {
                VolumesBuilder volumesBuilder = VolumesBuilder.builder();
                Intrinsics.checkNotNullExpressionValue((Object)volumesBuilder, (String)"builder(...)");
                builder = volumesBuilder;
                builder.addBoundVolume("/tmp/misc", ((Object)this$0.getTempDirectory()).toString());
                if ($projectDir == null) break block5;
                if (Registry.Companion.is("clion.docker.force.project.mount")) break block6;
                Object t = this$0.underlyingHost;
                String string = $projectDir.getPath();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getPath(...)");
                Path path = t.getPath(this$0.convertToHostPath(string), new String[0]);
                Intrinsics.checkNotNullExpressionValue((Object)path, (String)"getPath(...)");
                if (this$0.volumeBindingsContainProjectDir(path)) break block5;
            }
            String string = "/tmp/" + $projectDir.getName();
            String string2 = $projectDir.getAbsolutePath();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getAbsolutePath(...)");
            builder.addBoundVolume(string, this$0.convertToHostPath(string2));
        }
        if (!Files.exists(this$0.getHostStlPrettyPrintersDirectoryToMount(), new LinkOption[0])) {
            Files.createDirectories(this$0.getHostStlPrettyPrintersDirectoryToMount(), new FileAttribute[0]);
        }
        builder.addBoundVolume(containerStlPrettyPrintersMount, ((Object)this$0.getHostStlPrettyPrintersDirectoryToMount()).toString(), true);
        if (!Files.exists(this$0.getHostQtPrettyPrintersDirectoryToMount(), new LinkOption[0])) {
            Files.createDirectories(this$0.getHostQtPrettyPrintersDirectoryToMount(), new FileAttribute[0]);
        }
        builder.addBoundVolume(containerQtPrettyPrintersMount, ((Object)this$0.getHostQtPrettyPrintersDirectoryToMount()).toString(), true);
        DockerVolumeBinding[] dockerVolumeBindingArray = builder.build();
        Intrinsics.checkNotNullExpressionValue((Object)dockerVolumeBindingArray, (String)"build(...)");
        return ArraysKt.asList((Object[])dockerVolumeBindingArray);
    }

    /*
     * WARNING - void declaration
     */
    private static final PathMappingSettings dockerMapper_delegate$lambda$0(DockerHostBase this$0) {
        String bundledQtPrettyPrinters;
        String bundledGDBSTLPrettyPrinters;
        void $this$mapTo$iv$iv;
        Pair<List<DockerVolumeBinding>, List<Bind>> $this$map$iv = (Pair<List<DockerVolumeBinding>, List<Bind>>)this$0.getBindVolumes();
        boolean $i$f$map = false;
        Pair<List<DockerVolumeBinding>, List<Bind>> pair = $this$map$iv;
        Iterable destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            DockerVolumeBinding dockerVolumeBinding = (DockerVolumeBinding)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(new PathMappingSettings.PathMapping(it.getHostPath(), it.getContainerPath()));
        }
        List list = (List)destination$iv$iv;
        PathMappingSettings result = new PathMappingSettings(list);
        if (CidrDockerUtil.isContainerOptionsEnabled()) {
            Bind it;
            Collection collection;
            Iterable $this$mapTo$iv$iv2;
            Iterable $this$map$iv2;
            $this$map$iv = this$0.getUserDefinedMappings();
            List bindings = (List)$this$map$iv.component1();
            List binds = (List)$this$map$iv.component2();
            destination$iv$iv = bindings;
            PathMappingSettings pathMappingSettings = result;
            boolean $i$f$map2 = false;
            Iterator iterator = $this$map$iv2;
            Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
            boolean $i$f$mapTo2 = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv2) {
                DockerVolumeBinding dockerVolumeBinding = (DockerVolumeBinding)item$iv$iv;
                collection = destination$iv$iv2;
                boolean bl = false;
                String string = it.getHostPath();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getHostPath(...)");
                collection.add(new PathMappingSettings.PathMapping(this$0.convertToHostPathIfNeeded(string), it.getContainerPath()));
            }
            pathMappingSettings.addAll((List)destination$iv$iv2);
            $this$map$iv2 = binds;
            pathMappingSettings = result;
            $i$f$map2 = false;
            $this$mapTo$iv$iv2 = $this$map$iv2;
            destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
            $i$f$mapTo2 = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv2) {
                it = (Bind)item$iv$iv;
                collection = destination$iv$iv2;
                boolean bl = false;
                String string = it.getPath();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getPath(...)");
                collection.add(new PathMappingSettings.PathMapping(this$0.convertToHostPathIfNeeded(string), it.getVolume().getPath()));
            }
            pathMappingSettings.addAll((List)destination$iv$iv2);
        }
        if (!result.canReplaceLocal(bundledGDBSTLPrettyPrinters = ((Object)this$0.getHostStlPrettyPrintersDirectory()).toString())) {
            result.add(new PathMappingSettings.PathMapping(bundledGDBSTLPrettyPrinters, containerStlPrettyPrintersMount));
        }
        if (!result.canReplaceLocal(bundledQtPrettyPrinters = ((Object)this$0.getHostQtPrettyPrintersDirectory()).toString())) {
            result.add(new PathMappingSettings.PathMapping(bundledQtPrettyPrinters, containerQtPrettyPrintersMount));
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private static final Pair userDefinedMappings_delegate$lambda$0(DockerHostBase this$0) {
        List list;
        CreateContainerCmd createContainerCmd;
        Object object;
        List volumeBindingsFromTable;
        Object object2 = this$0.containerSettings;
        if (object2 != null && (object2 = object2.getVolumeBindings()) != null) {
            void $this$filterTo$iv$iv;
            Iterable $this$filter$iv = (Iterable)object2;
            boolean $i$f$filter = false;
            Iterable iterable = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                DockerVolumeBindingImpl it = (DockerVolumeBindingImpl)element$iv$iv;
                boolean bl = false;
                String string = it.getHostPath();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getHostPath(...)");
                if (!this$0.isPathOnHost(string)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            v2 = (List)destination$iv$iv;
        } else {
            v2 = volumeBindingsFromTable = CollectionsKt.emptyList();
        }
        if ((object = this$0.containerSettings) != null && (object = object.getRunCliOptions()) != null) {
            Object it = object;
            boolean bl = false;
            createContainerCmd = CidrDockerUtil.tryParseContainerCmd((String)it);
        } else {
            createContainerCmd = null;
        }
        Closeable closeable = (Closeable)createContainerCmd;
        Throwable throwable = null;
        try {
            List list2;
            Bind[] cmd = (Bind[])closeable;
            boolean bl = false;
            Bind[] bindArray = cmd;
            if (cmd != null && (bindArray = bindArray.getHostConfig()) != null && (bindArray = bindArray.getBinds()) != null) {
                void $this$filterTo$iv$iv;
                Bind[] $this$filter$iv = bindArray;
                boolean $i$f$filter = false;
                Bind[] bindArray2 = $this$filter$iv;
                Collection destination$iv$iv = new ArrayList();
                boolean $i$f$filterTo = false;
                int n = ((void)$this$filterTo$iv$iv).length;
                for (int i = 0; i < n; ++i) {
                    void element$iv$iv;
                    void it = element$iv$iv = $this$filterTo$iv$iv[i];
                    boolean bl2 = false;
                    String string = it.getPath();
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getPath(...)");
                    if (!this$0.isPathOnHost(string)) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                list2 = (List)destination$iv$iv;
            } else {
                list2 = null;
            }
            List list3 = list2;
            list = list3;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
        List list4 = list;
        if (list == null) {
            list4 = CollectionsKt.emptyList();
        }
        List volumeBindingsFromCLIOptions = list4;
        this$0.checkAndCreateMissingVolumes(volumeBindingsFromTable, volumeBindingsFromCLIOptions);
        return TuplesKt.to((Object)volumeBindingsFromTable, (Object)volumeBindingsFromCLIOptions);
    }

    private static final RemoteFSCache fsCache_delegate$lambda$0(DockerHostBase this$0) {
        if (!CidrDockerUtil.isValid(this$0.credentialsHolder)) {
            throw new ExecutionException(CidrDockerBundle.message("dialog.message.docker.configuration.is.not.valid", new Object[0]));
        }
        return new RemoteFSCache(this$0.getCacheDirectory(), this$0.getTotalMapper(), (Downloader)new DockerDownloader(this$0), (HostMachine)this$0);
    }

    private static final <T extends HostMachine> boolean volumeBindingsContainProjectDir$containsProjectDir(DockerHostBase<T> this$0, String canonicalProjectPath, String bindingHostPath) {
        String hostPath = this$0.convertToHostPathIfNeeded(bindingHostPath);
        String canonicalVolumePath = FileUtil.toCanonicalPath((String)hostPath, (boolean)true);
        return FileUtil.startsWith((String)canonicalProjectPath, (String)canonicalVolumePath);
    }

    static {
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(DockerHostBase.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LOG = logger;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lcom/jetbrains/cidr/cpp/toolchains/docker/host/DockerHostBase$Companion;", "", "<init>", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "containerStlPrettyPrintersMount", "", "containerQtPrettyPrintersMount", "intellij.clion.docker"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

