/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.cpp.toolchains.docker.host;

import com.intellij.util.PathMapper;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.VisibleForTesting;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010 \n\u0000\n\u0002\u0010\u001e\n\u0000\b\u0007\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0001\u0012\u0006\u0010\u0003\u001a\u00020\u0001\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\u0006\u001a\u00020\u0007H\u0016J\u0010\u0010\b\u001a\u00020\u00072\u0006\u0010\t\u001a\u00020\nH\u0016J\u0010\u0010\u000b\u001a\u00020\n2\u0006\u0010\f\u001a\u00020\nH\u0016J\u0010\u0010\r\u001a\u00020\u00072\u0006\u0010\f\u001a\u00020\nH\u0016J\u0010\u0010\u000e\u001a\u00020\n2\u0006\u0010\t\u001a\u00020\nH\u0016J \u0010\u000e\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\n0\u000f2\u000e\u0010\u0010\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\n0\u0011H\u0016R\u000e\u0010\u0002\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0003\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lcom/jetbrains/cidr/cpp/toolchains/docker/host/ChainedMapper;", "Lcom/intellij/util/PathMapper;", "mapper1", "mapper2", "<init>", "(Lcom/intellij/util/PathMapper;Lcom/intellij/util/PathMapper;)V", "isEmpty", "", "canReplaceLocal", "localPath", "", "convertToLocal", "remotePath", "canReplaceRemote", "convertToRemote", "", "paths", "", "intellij.clion.docker"})
@VisibleForTesting
public final class ChainedMapper
implements PathMapper {
    @NotNull
    private final PathMapper mapper1;
    @NotNull
    private final PathMapper mapper2;

    public ChainedMapper(@NotNull PathMapper mapper1, @NotNull PathMapper mapper2) {
        Intrinsics.checkNotNullParameter((Object)mapper1, (String)"mapper1");
        Intrinsics.checkNotNullParameter((Object)mapper2, (String)"mapper2");
        this.mapper1 = mapper1;
        this.mapper2 = mapper2;
    }

    public boolean isEmpty() {
        return this.mapper1.isEmpty() || this.mapper2.isEmpty();
    }

    public boolean canReplaceLocal(@NotNull String localPath) {
        Intrinsics.checkNotNullParameter((Object)localPath, (String)"localPath");
        boolean canReplaceBoth = this.mapper1.canReplaceLocal(localPath) && this.mapper2.canReplaceLocal(this.mapper1.convertToRemote(localPath));
        boolean canReplaceSecond = this.mapper2.canReplaceLocal(localPath);
        return canReplaceBoth || canReplaceSecond;
    }

    @NotNull
    public String convertToLocal(@NotNull String remotePath) {
        Intrinsics.checkNotNullParameter((Object)remotePath, (String)"remotePath");
        String string = this.mapper1.convertToLocal(this.mapper2.convertToLocal(remotePath));
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"convertToLocal(...)");
        return string;
    }

    public boolean canReplaceRemote(@NotNull String remotePath) {
        Intrinsics.checkNotNullParameter((Object)remotePath, (String)"remotePath");
        boolean canReplaceBoth = this.mapper2.canReplaceRemote(remotePath) && this.mapper1.canReplaceRemote(this.mapper2.convertToLocal(remotePath));
        boolean canReplaceFirst = this.mapper1.canReplaceRemote(remotePath);
        return canReplaceBoth || canReplaceFirst;
    }

    @NotNull
    public String convertToRemote(@NotNull String localPath) {
        Intrinsics.checkNotNullParameter((Object)localPath, (String)"localPath");
        String string = this.mapper2.convertToRemote(this.mapper1.convertToRemote(localPath));
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"convertToRemote(...)");
        return string;
    }

    @NotNull
    public List<String> convertToRemote(@NotNull Collection<String> paths) {
        Intrinsics.checkNotNullParameter(paths, (String)"paths");
        List list = this.mapper2.convertToRemote((Collection)this.mapper1.convertToRemote(paths));
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"convertToRemote(...)");
        return list;
    }
}

