/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.cpp.toolchains.docker;

import com.intellij.execution.ExecutionException;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.util.system.CpuArch;
import com.intellij.util.system.OS;
import com.jetbrains.cidr.ToolVersion;
import com.jetbrains.cidr.cpp.toolchains.CPPDebugger;
import com.jetbrains.cidr.cpp.toolchains.CPPToolSet;
import com.jetbrains.cidr.cpp.toolchains.CPPToolchainsUtil;
import com.jetbrains.cidr.cpp.toolchains.EnvironmentReader;
import com.jetbrains.cidr.cpp.toolchains.LinuxEnvironmentReader;
import com.jetbrains.cidr.cpp.toolchains.docker.host.DockerHostBase;
import com.jetbrains.cidr.execution.Installer;
import com.jetbrains.cidr.execution.TrivialInstaller;
import com.jetbrains.cidr.lang.toolchains.CidrFileSeparators;
import com.jetbrains.cidr.system.HostMachine;
import com.jetbrains.cidr.toolchains.PathSeparator;
import java.io.File;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DockerToolSet
extends CPPToolSet {
    public DockerToolSet(@NotNull CPPToolSet.Kind kind) {
        if (kind == null) {
            DockerToolSet.$$$reportNull$$$0(0);
        }
        super(kind);
    }

    @Nullable
    public String readVersion() {
        return "1.0";
    }

    @Nullable
    public ToolVersion readToolVersion() {
        String string = this.readVersion();
        return string == null ? null : ToolVersion.parse((String)string, (Pattern[])new Pattern[]{CPPToolchainsUtil.VERSION_PATTERN});
    }

    public String checkVersion(@NotNull String version) {
        if (version == null) {
            DockerToolSet.$$$reportNull$$$0(1);
        }
        return null;
    }

    @NotNull
    public CidrFileSeparators getSupportedFileSeparators() {
        CidrFileSeparators cidrFileSeparators = CidrFileSeparators.UNIX;
        if (cidrFileSeparators == null) {
            DockerToolSet.$$$reportNull$$$0(2);
        }
        return cidrFileSeparators;
    }

    @NotNull
    public File getGDBPath() {
        return new File("/usr/bin/gdb");
    }

    public boolean supportsDebugger(@NotNull CPPDebugger.Kind debuggerKind) {
        if (debuggerKind == null) {
            DockerToolSet.$$$reportNull$$$0(3);
        }
        return debuggerKind == CPPDebugger.Kind.CUSTOM_GDB || debuggerKind == CPPDebugger.Kind.BUNDLED_GDB && OS.CURRENT == OS.macOS && CpuArch.isArm64();
    }

    protected EnvironmentReader createEnvironmentReader(@NotNull HostMachine hostMachine) {
        if (hostMachine == null) {
            DockerToolSet.$$$reportNull$$$0(4);
        }
        return new LinuxEnvironmentReader(hostMachine);
    }

    @NotNull
    public PathSeparator getPathSeparator() {
        PathSeparator pathSeparator = PathSeparator.UNIX;
        if (pathSeparator == null) {
            DockerToolSet.$$$reportNull$$$0(5);
        }
        return pathSeparator;
    }

    public Installer createInstaller(@NotNull GeneralCommandLine cl, @NotNull HostMachine hostMachine) {
        if (cl == null) {
            DockerToolSet.$$$reportNull$$$0(6);
        }
        if (hostMachine == null) {
            DockerToolSet.$$$reportNull$$$0(7);
        }
        if (hostMachine instanceof DockerHostBase) {
            final DockerHostBase dockerHost = (DockerHostBase)hostMachine;
            return new TrivialInstaller(this, cl){

                @NotNull
                public GeneralCommandLine install() throws ExecutionException {
                    dockerHost.setupPrettyPrinters();
                    GeneralCommandLine generalCommandLine = super.install();
                    if (generalCommandLine == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    return generalCommandLine;
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/cpp/toolchains/docker/DockerToolSet$1", "install"));
                }
            };
        }
        return super.createInstaller(cl, hostMachine);
    }

    protected boolean supportsPathVariableModification() {
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 5 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "kind";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "version";
                break;
            }
            case 2: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cidr/cpp/toolchains/docker/DockerToolSet";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "debuggerKind";
                break;
            }
            case 4: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "hostMachine";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "cl";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cidr/cpp/toolchains/docker/DockerToolSet";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getSupportedFileSeparators";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getPathSeparator";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "checkVersion";
                break;
            }
            case 2: 
            case 5: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "supportsDebugger";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "createEnvironmentReader";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "createInstaller";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 5 -> new IllegalStateException(string);
        };
    }
}

