/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.cpp.toolchains.docker;

import com.intellij.docker.agent.settings.DockerEnvVarImpl;
import com.intellij.docker.agent.settings.DockerPortBindingImpl;
import com.intellij.docker.remote.DockerContainerSettings;
import com.intellij.docker.remote.run.runtime.DockerExecProcess;
import com.intellij.docker.remoteRunRuntime.RemoteDockerRuntime;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.process.BaseProcessHandler;
import com.intellij.execution.process.OSProcessHandler;
import com.jetbrains.cidr.cpp.toolchains.docker.CidrDockerUtil;
import com.jetbrains.cidr.cpp.toolchains.docker.host.DockerHostBase;
import com.jetbrains.cidr.system.CidrProcessBuilder;
import com.jetbrains.cidr.system.LocalHost;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0013\u0012\n\u0010\u0002\u001a\u0006\u0012\u0002\b\u00030\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u000e\u0010\u000b\u001a\u00020\u00002\u0006\u0010\f\u001a\u00020\rJ\u0016\u0010\u000e\u001a\u00020\u00002\u0006\u0010\u000f\u001a\u00020\r2\u0006\u0010\u0010\u001a\u00020\rJ\u001c\u0010\u0011\u001a\u0006\u0012\u0002\b\u00030\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0014R\u0012\u0010\u0002\u001a\u0006\u0012\u0002\b\u00030\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\t\u001a\b\u0012\u0004\u0012\u00020\n0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lcom/jetbrains/cidr/cpp/toolchains/docker/DockerProcessBuilder;", "Lcom/jetbrains/cidr/system/CidrProcessBuilder;", "machine", "Lcom/jetbrains/cidr/cpp/toolchains/docker/host/DockerHostBase;", "<init>", "(Lcom/jetbrains/cidr/cpp/toolchains/docker/host/DockerHostBase;)V", "extraPortBindings", "", "Lcom/intellij/docker/agent/settings/DockerPortBindingImpl;", "extraEnvVars", "Lcom/intellij/docker/agent/settings/DockerEnvVarImpl;", "withPortBinding", "serialized", "", "withEnvVar", "name", "value", "build", "Lcom/intellij/execution/process/BaseProcessHandler;", "cl", "Lcom/intellij/execution/configurations/GeneralCommandLine;", "params", "Lcom/jetbrains/cidr/system/CidrProcessBuilder$Parameters;", "intellij.clion.docker"})
public final class DockerProcessBuilder
extends CidrProcessBuilder {
    @NotNull
    private final DockerHostBase<?> machine;
    @NotNull
    private final List<DockerPortBindingImpl> extraPortBindings;
    @NotNull
    private final List<DockerEnvVarImpl> extraEnvVars;

    public DockerProcessBuilder(@NotNull DockerHostBase<?> machine) {
        Intrinsics.checkNotNullParameter(machine, (String)"machine");
        this.machine = machine;
        this.extraPortBindings = new ArrayList();
        this.extraEnvVars = new ArrayList();
    }

    @NotNull
    public final DockerProcessBuilder withPortBinding(@NotNull String serialized) throws IllegalArgumentException {
        Intrinsics.checkNotNullParameter((Object)serialized, (String)"serialized");
        DockerPortBindingImpl dockerPortBindingImpl = DockerPortBindingImpl.fromString((String)serialized);
        Intrinsics.checkNotNullExpressionValue((Object)dockerPortBindingImpl, (String)"fromString(...)");
        this.extraPortBindings.add(dockerPortBindingImpl);
        return this;
    }

    @NotNull
    public final DockerProcessBuilder withEnvVar(@NotNull String name, @NotNull String value) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        this.extraEnvVars.add(new DockerEnvVarImpl(name, value));
        return this;
    }

    @NotNull
    protected BaseProcessHandler<?> build(@NotNull GeneralCommandLine cl, @NotNull CidrProcessBuilder.Parameters params) {
        Intrinsics.checkNotNullParameter((Object)cl, (String)"cl");
        Intrinsics.checkNotNullParameter((Object)params, (String)"params");
        DockerContainerSettings dockerContainerSettings = this.machine.getContainerSettings();
        if (dockerContainerSettings == null || (dockerContainerSettings = dockerContainerSettings.clone()) == null) {
            dockerContainerSettings = new DockerContainerSettings();
        }
        DockerContainerSettings settings = dockerContainerSettings;
        List list = settings.getPortBindings();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getPortBindings(...)");
        settings.setPortBindings(CollectionsKt.plus((Collection)list, (Iterable)this.extraPortBindings));
        List list2 = settings.getEnvVars();
        Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"getEnvVars(...)");
        settings.setEnvVars(CollectionsKt.plus((Collection)list2, (Iterable)this.extraEnvVars));
        RemoteDockerRuntime dockerRuntime = CidrDockerUtil.getDockerRuntime(this.machine.getCredentialsHolder());
        DockerExecProcess dockerExecProcess = CidrDockerUtil.createDockerProcess(this.machine.getCredentialsHolder(), settings, dockerRuntime, this.machine.getBindVolumes(), this.machine.getPathMapper(), cl, params, this.machine.getCidrDockerOptions(), this.machine.getUnderlyingHost());
        Intrinsics.checkNotNullExpressionValue((Object)dockerExecProcess, (String)"createDockerProcess(...)");
        DockerExecProcess process = dockerExecProcess;
        OSProcessHandler processHandler = params.isEmulateTerminal() ? (OSProcessHandler)new LocalHost.TerminalEmulatorOSProcessHandler((Process)process, cl) : (params.isColored() ? (OSProcessHandler)new LocalHost.ParameterizedColoredProcessHandler((Process)process, cl, params) : (params.isCapturedOutput() ? (OSProcessHandler)new LocalHost.ParameterizedCapturingProcessHandler((Process)process, cl, params) : (OSProcessHandler)new LocalHost.ParameterizedOSProcessHandler((Process)process, cl, params)));
        return (BaseProcessHandler)processHandler;
    }
}

