/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.cpp.toolchains.docker;

import com.github.benmanes.caffeine.cache.AsyncCache;
import com.github.benmanes.caffeine.cache.Caffeine;
import com.github.benmanes.caffeine.cache.RemovalCause;
import com.github.benmanes.caffeine.cache.RemovalListener;
import com.github.benmanes.caffeine.cache.Scheduler;
import com.intellij.concurrency.ThreadContext;
import com.intellij.docker.agent.DockerAgentDeploymentConfig;
import com.intellij.docker.agent.settings.DockerEnvVar;
import com.intellij.docker.remote.DockerContainerSettings;
import com.intellij.docker.remote.run.common.EnvsBuilder;
import com.intellij.docker.remote.run.runtime.DockerAgentDeploymentConfigImpl;
import com.intellij.docker.remoteRunRuntime.RemoteDockerApplicationRuntime;
import com.intellij.docker.remoteRunRuntime.RemoteDockerRuntime;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.process.ProcessOutput;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.remoteServer.util.ServerRuntimeException;
import com.intellij.util.ArrayUtilRt;
import com.intellij.util.concurrency.ChildContext;
import com.intellij.util.concurrency.Propagation;
import com.jetbrains.cidr.cpp.toolchains.docker.CidrDockerUtil;
import com.jetbrains.cidr.cpp.toolchains.docker.host.DockerHostBase;
import com.jetbrains.cidr.execution.CidrCoroutineHelper;
import com.jetbrains.cidr.system.RemoteHostUtil;
import java.io.IOException;
import java.nio.file.Path;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CancellationException;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.coroutines.CoroutineContext;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import kotlinx.coroutines.CoroutineDispatcher;
import kotlinx.coroutines.Dispatchers;
import kotlinx.coroutines.ExecutorsKt;
import kotlinx.coroutines.Job;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Service
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0006\b\u0007\u0018\u0000 \u001c2\u00020\u0001:\u0002\u001b\u001cB\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\n\u001a\u00020\u000bH\u0016J\u001a\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\n\u0010\u0010\u001a\u0006\u0012\u0002\b\u00030\bJ:\u0010\u0011\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0012\u001a\u0004\u0018\u00010\u00132\u0006\u0010\u0014\u001a\u00020\t2\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00170\u00162\b\u0010\u0018\u001a\u0004\u0018\u00010\u0017H\u0002J\u0014\u0010\u0019\u001a\u00020\t2\n\u0010\u001a\u001a\u0006\u0012\u0002\b\u00030\bH\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u0006\u001a\u0012\u0012\b\u0012\u0006\u0012\u0002\b\u00030\b\u0012\u0004\u0012\u00020\t0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001d"}, d2={"Lcom/jetbrains/cidr/cpp/toolchains/docker/DockerExecutor;", "Lcom/intellij/openapi/Disposable;", "<init>", "()V", "EXEC_POOL_SIZE", "", "applicationRuntime", "Lcom/github/benmanes/caffeine/cache/AsyncCache;", "Lcom/jetbrains/cidr/cpp/toolchains/docker/host/DockerHostBase;", "Lcom/jetbrains/cidr/cpp/toolchains/docker/DockerExecutor$DockerApplicationRuntimeWrapper;", "dispose", "", "exec", "Lcom/intellij/execution/process/ProcessOutput;", "commandLine", "Lcom/intellij/execution/configurations/GeneralCommandLine;", "machine", "execInRuntime", "containerSettings", "Lcom/intellij/docker/remote/DockerContainerSettings;", "appRuntime", "command", "", "", "wd", "getAppRuntime", "key", "DockerApplicationRuntimeWrapper", "Companion", "intellij.clion.docker"})
@SourceDebugExtension(value={"SMAP\nDockerExecutor.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DockerExecutor.kt\ncom/jetbrains/cidr/cpp/toolchains/docker/DockerExecutor\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 3 Strings.kt\nkotlin/text/StringsKt__StringsKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 5 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,233:1\n11561#2:234\n11896#2,3:235\n106#3:238\n78#3,22:239\n1#4:261\n13#5:262\n*S KotlinDebug\n*F\n+ 1 DockerExecutor.kt\ncom/jetbrains/cidr/cpp/toolchains/docker/DockerExecutor\n*L\n107#1:234\n107#1:235,3\n118#1:238\n118#1:239,22\n209#1:262\n*E\n"})
public final class DockerExecutor
implements Disposable {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final long EXEC_POOL_SIZE = Registry.Companion.intValue("clion.docker.exec.pool.size", 20);
    @NotNull
    private final AsyncCache<DockerHostBase<?>, DockerApplicationRuntimeWrapper> applicationRuntime;
    @NotNull
    private static final Logger LOG;

    public DockerExecutor() {
        AsyncCache asyncCache = Caffeine.newBuilder().maximumSize(this.EXEC_POOL_SIZE).expireAfterAccess(Duration.ofSeconds(3L)).removalListener(DockerExecutor.Companion.getRemovalListener()).scheduler(Scheduler.systemScheduler()).executor(ExecutorsKt.asExecutor((CoroutineDispatcher)Dispatchers.getIO())).buildAsync();
        Intrinsics.checkNotNullExpressionValue((Object)asyncCache, (String)"buildAsync(...)");
        this.applicationRuntime = asyncCache;
    }

    public void dispose() {
        this.applicationRuntime.asMap().values().forEach(DockerExecutor::dispose$lambda$0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public final ProcessOutput exec(@NotNull GeneralCommandLine commandLine, @NotNull DockerHostBase<?> machine) throws com.intellij.execution.ExecutionException {
        Intrinsics.checkNotNullParameter((Object)commandLine, (String)"commandLine");
        Intrinsics.checkNotNullParameter(machine, (String)"machine");
        Map map = commandLine.getEnvironment();
        Intrinsics.checkNotNullExpressionValue((Object)map, (String)"getEnvironment(...)");
        Map map2 = map;
        String string = "JETBRAINS_REMOTE_RUN";
        String string2 = "1";
        map2.put(string, string2);
        String string3 = FileUtil.toSystemIndependentName((String)machine.getPathMapper().convertToRemote(commandLine.getExePath()));
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"toSystemIndependentName(...)");
        String exe = string3;
        List list = machine.getPathMapper().convertToRemote((Collection)commandLine.getCommandLineList(exe));
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"convertToRemote(...)");
        List command = list;
        commandLine.setExePath(exe);
        Path wdFile = commandLine.getWorkingDirectory();
        String wd = wdFile != null ? machine.getPathMapper().convertToRemote(((Object)wdFile.normalize()).toString()) : null;
        try {
            DockerApplicationRuntimeWrapper appRuntime = null;
            boolean lockAcquired = false;
            try {
                while (!(lockAcquired = (appRuntime = this.getAppRuntime(machine)).acquire())) {
                }
                ProcessOutput processOutput = this.execInRuntime(commandLine, machine.getContainerSettings(), appRuntime, command, wd);
                return processOutput;
            }
            finally {
                if (lockAcquired) {
                    DockerApplicationRuntimeWrapper dockerApplicationRuntimeWrapper = appRuntime;
                    Intrinsics.checkNotNull((Object)dockerApplicationRuntimeWrapper);
                    dockerApplicationRuntimeWrapper.release();
                }
            }
        }
        catch (IOException e) {
            throw new com.intellij.execution.ExecutionException((Throwable)e);
        }
        catch (ServerRuntimeException e) {
            throw new com.intellij.execution.ExecutionException((Throwable)e);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final ProcessOutput execInRuntime(GeneralCommandLine commandLine, DockerContainerSettings containerSettings, DockerApplicationRuntimeWrapper appRuntime, List<String> command, String wd) {
        void $this$mapTo$iv$iv;
        EnvsBuilder envsBuilder = EnvsBuilder.builder().addEnvs(commandLine.getEnvironment());
        Intrinsics.checkNotNullExpressionValue((Object)envsBuilder, (String)"addEnvs(...)");
        EnvsBuilder envsBuilder2 = envsBuilder;
        if (CidrDockerUtil.isContainerOptionsEnabled() && containerSettings != null) {
            envsBuilder2.addEnvs(containerSettings.getEnvVars());
        }
        DockerEnvVar[] vars = envsBuilder2.withPassParentEnvironment(true).buildEnvs();
        Intrinsics.checkNotNull((Object)vars);
        DockerEnvVar[] $this$map$iv = vars;
        boolean $i$f$map = false;
        DockerEnvVar[] dockerEnvVarArray = $this$map$iv;
        Collection destination$iv$iv = new ArrayList($this$map$iv.length);
        boolean $i$f$mapTo = false;
        int n = ((void)$this$mapTo$iv$iv).length;
        for (int i = 0; i < n; ++i) {
            void variable;
            void item$iv$iv;
            void var17_20 = item$iv$iv = $this$mapTo$iv$iv[i];
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(variable.getName() + "=" + variable.getValue());
        }
        List envVars = (List)destination$iv$iv;
        String[] stringArray = ArrayUtilRt.toStringArray((Collection)command);
        Intrinsics.checkNotNullExpressionValue((Object)stringArray, (String)"toStringArray(...)");
        ProcessOutput result = appRuntime.exec(stringArray, wd, envVars);
        String string = result.getStdout();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getStdout(...)");
        String message = string;
        if (result.getExitCode() != 0 && StringsKt.contains$default((CharSequence)message, (CharSequence)"OCI runtime exec failed: exec failed:", (boolean)false, (int)2, null)) {
            String $this$trim$iv = message;
            boolean $i$f$trim = false;
            CharSequence $this$trim$iv$iv = $this$trim$iv;
            boolean $i$f$trim2 = false;
            int startIndex$iv$iv = 0;
            int endIndex$iv$iv = $this$trim$iv$iv.length() - 1;
            boolean startFound$iv$iv = false;
            while (startIndex$iv$iv <= endIndex$iv$iv) {
                boolean match$iv$iv;
                int index$iv$iv = !startFound$iv$iv ? startIndex$iv$iv : endIndex$iv$iv;
                char it = $this$trim$iv$iv.charAt(index$iv$iv);
                boolean bl = false;
                boolean bl2 = match$iv$iv = Intrinsics.compare((int)it, (int)32) <= 0;
                if (!startFound$iv$iv) {
                    if (!match$iv$iv) {
                        startFound$iv$iv = true;
                        continue;
                    }
                    ++startIndex$iv$iv;
                    continue;
                }
                if (!match$iv$iv) break;
                --endIndex$iv$iv;
            }
            String string2 = ((Object)$this$trim$iv$iv.subSequence(startIndex$iv$iv, endIndex$iv$iv + 1)).toString();
            throw new IOException(string2);
        }
        return result;
    }

    private final DockerApplicationRuntimeWrapper getAppRuntime(DockerHostBase<?> key) {
        return (DockerApplicationRuntimeWrapper)CidrCoroutineHelper.runWithContextPropagationAndIndicator(() -> DockerExecutor.getAppRuntime$lambda$0(this, key));
    }

    private static final void dispose$lambda$0(CompletableFuture future) {
        Intrinsics.checkNotNullParameter((Object)future, (String)"future");
        future.thenAccept(arg_0 -> DockerExecutor.dispose$lambda$0$1(DockerExecutor::dispose$lambda$0$0, arg_0));
    }

    private static final Unit dispose$lambda$0$0(DockerApplicationRuntimeWrapper wrapper) {
        Intrinsics.checkNotNullParameter((Object)wrapper, (String)"wrapper");
        wrapper.removeContainer();
        return Unit.INSTANCE;
    }

    private static final void dispose$lambda$0$1(Function1 $tmp0, Object p0) {
        $tmp0.invoke(p0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final DockerApplicationRuntimeWrapper getAppRuntime$lambda$0(DockerExecutor this$0, DockerHostBase $key) {
        ChildContext childContext = Propagation.createChildContext((String)"create docker container");
        try {
            DockerApplicationRuntimeWrapper wrapper = (DockerApplicationRuntimeWrapper)this$0.applicationRuntime.get((Object)$key, arg_0 -> DockerExecutor.getAppRuntime$lambda$0$1(arg_0 -> DockerExecutor.getAppRuntime$lambda$0$0(childContext, arg_0), arg_0)).get();
            Intrinsics.checkNotNull((Object)wrapper);
            DockerApplicationRuntimeWrapper dockerApplicationRuntimeWrapper = wrapper;
            return dockerApplicationRuntimeWrapper;
        }
        catch (ExecutionException e) {
            Throwable throwable = e.getCause();
            if (throwable == null) {
                throwable = e;
            }
            throw throwable;
        }
        finally {
            Job job = childContext.getJob();
            if (job == null) {
                boolean bl = false;
                String string = "childContext must have a job for a proper cancellation";
                throw new IllegalStateException(string.toString());
            }
            job.cancel(new CancellationException());
        }
    }

    private static final DockerApplicationRuntimeWrapper getAppRuntime$lambda$0$0(ChildContext $childContext, DockerHostBase machine) {
        Intrinsics.checkNotNullParameter((Object)machine, (String)"machine");
        return (DockerApplicationRuntimeWrapper)ThreadContext.installThreadContext((CoroutineContext)$childContext.getContext(), (boolean)false, () -> DockerExecutor.getAppRuntime$lambda$0$0$0(machine));
    }

    private static final DockerApplicationRuntimeWrapper getAppRuntime$lambda$0$0$0(DockerHostBase $machine) {
        return DockerExecutor.Companion.getDockerApplicationRuntime($machine);
    }

    private static final DockerApplicationRuntimeWrapper getAppRuntime$lambda$0$1(Function1 $tmp0, Object p0) {
        return (DockerApplicationRuntimeWrapper)$tmp0.invoke(p0);
    }

    static {
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(DockerExecutor.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LOG = logger;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0014\u0010\u000b\u001a\u00020\b2\n\u0010\f\u001a\u0006\u0012\u0002\b\u00030\rH\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\u0001\u0012\u0004\u0012\u00020\b0\u00078BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\n\u00a8\u0006\u000e"}, d2={"Lcom/jetbrains/cidr/cpp/toolchains/docker/DockerExecutor$Companion;", "", "<init>", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "removalListener", "Lcom/github/benmanes/caffeine/cache/RemovalListener;", "Lcom/jetbrains/cidr/cpp/toolchains/docker/DockerExecutor$DockerApplicationRuntimeWrapper;", "getRemovalListener", "()Lcom/github/benmanes/caffeine/cache/RemovalListener;", "getDockerApplicationRuntime", "machine", "Lcom/jetbrains/cidr/cpp/toolchains/docker/host/DockerHostBase;", "intellij.clion.docker"})
    public static final class Companion {
        private Companion() {
        }

        private final RemovalListener<Object, DockerApplicationRuntimeWrapper> getRemovalListener() {
            return Companion::_get_removalListener_$lambda$0;
        }

        private final DockerApplicationRuntimeWrapper getDockerApplicationRuntime(DockerHostBase<?> machine) {
            RemoteDockerRuntime dockerRuntime = CidrDockerUtil.getDockerRuntime(machine.getCredentialsHolder());
            DockerAgentDeploymentConfigImpl dockerAgentDeploymentConfigImpl = CidrDockerUtil.getConfig(dockerRuntime, null, machine);
            Intrinsics.checkNotNullExpressionValue((Object)dockerAgentDeploymentConfigImpl, (String)"getConfig(...)");
            DockerAgentDeploymentConfigImpl config = dockerAgentDeploymentConfigImpl;
            String[] stringArray = new String[]{RemoteHostUtil.remoteShell()};
            config.withCommand(stringArray);
            RemoteDockerApplicationRuntime runtime = RemoteDockerApplicationRuntime.createWithPullImage((RemoteDockerRuntime)dockerRuntime, (DockerAgentDeploymentConfig)((DockerAgentDeploymentConfig)config));
            runtime.startAndAttach();
            if (LOG.isDebugEnabled()) {
                LOG.debug("init cache: " + runtime.getContainerId());
            }
            Intrinsics.checkNotNull((Object)runtime);
            return new DockerApplicationRuntimeWrapper(runtime);
        }

        private static final void _get_removalListener_$lambda$0(Object key, DockerApplicationRuntimeWrapper value, RemovalCause cause) {
            block0: {
                DockerApplicationRuntimeWrapper dockerApplicationRuntimeWrapper = value;
                if (dockerApplicationRuntimeWrapper == null) break block0;
                dockerApplicationRuntimeWrapper.removeContainer();
            }
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J3\u0010\n\u001a\u00020\u000b2\u000e\u0010\f\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u000e0\r2\b\u0010\u000f\u001a\u0004\u0018\u00010\u000e2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u000e0\u0011\u00a2\u0006\u0002\u0010\u0012J\u0006\u0010\u0015\u001a\u00020\u0016J\u0006\u0010\u0017\u001a\u00020\tJ\u0006\u0010\u0018\u001a\u00020\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lcom/jetbrains/cidr/cpp/toolchains/docker/DockerExecutor$DockerApplicationRuntimeWrapper;", "", "runtime", "Lcom/intellij/docker/remoteRunRuntime/RemoteDockerApplicationRuntime;", "<init>", "(Lcom/intellij/docker/remoteRunRuntime/RemoteDockerApplicationRuntime;)V", "rwLock", "Ljava/util/concurrent/locks/ReadWriteLock;", "isDestroyed", "", "exec", "Lcom/intellij/execution/process/ProcessOutput;", "command", "", "", "workingDir", "envVars", "", "([Ljava/lang/String;Ljava/lang/String;Ljava/util/List;)Lcom/intellij/execution/process/ProcessOutput;", "shutdownTimeout", "", "removeContainer", "", "acquire", "release", "intellij.clion.docker"})
    private static final class DockerApplicationRuntimeWrapper {
        @NotNull
        private final RemoteDockerApplicationRuntime runtime;
        @NotNull
        private final ReadWriteLock rwLock;
        private volatile boolean isDestroyed;
        private final long shutdownTimeout;

        public DockerApplicationRuntimeWrapper(@NotNull RemoteDockerApplicationRuntime runtime) {
            Intrinsics.checkNotNullParameter((Object)runtime, (String)"runtime");
            this.runtime = runtime;
            this.rwLock = new ReentrantReadWriteLock();
            this.shutdownTimeout = Registry.Companion.intValue("clion.docker.exec.container.shutdown.timeout");
        }

        @NotNull
        public final ProcessOutput exec(@NotNull String[] command, @Nullable String workingDir, @NotNull List<String> envVars) throws IOException, ServerRuntimeException {
            Intrinsics.checkNotNullParameter((Object)command, (String)"command");
            Intrinsics.checkNotNullParameter(envVars, (String)"envVars");
            LOG.assertTrue(!this.isDestroyed, (Object)"Attempt to exec in destroyed container");
            ProcessOutput processOutput = this.runtime.execWithoutTty(command, workingDir, envVars);
            Intrinsics.checkNotNullExpressionValue((Object)processOutput, (String)"execWithoutTty(...)");
            return processOutput;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public final void removeContainer() {
            boolean isLockAcquired = false;
            try {
                isLockAcquired = this.rwLock.writeLock().tryLock(this.shutdownTimeout, TimeUnit.MILLISECONDS);
                if (!isLockAcquired) {
                    LOG.error("Cannot wait for finish process(es): " + this.runtime.getContainerId());
                }
                this.isDestroyed = true;
                this.runtime.removeContainer();
                if (LOG.isDebugEnabled()) {
                    LOG.debug("remove container: " + this.runtime.getContainerId());
                }
            }
            catch (InterruptedException e) {
                LOG.error((Throwable)e);
            }
            finally {
                if (isLockAcquired) {
                    this.rwLock.writeLock().unlock();
                }
            }
        }

        public final boolean acquire() {
            this.rwLock.readLock().lock();
            if (this.isDestroyed) {
                this.rwLock.readLock().unlock();
                return false;
            }
            return true;
        }

        public final void release() {
            this.rwLock.readLock().unlock();
        }
    }
}

